/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor;

import org.eclipse.jface.util.DelegatingDropAdapter;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wst.common.ui.internal.dnd.ObjectTransfer;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeContentProvider;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeLabelProvider;
import org.jboss.tools.common.model.ui.dnd.ModelTransfer;
import org.jboss.tools.common.model.ui.editors.dnd.context.DropContext;
import org.jboss.tools.jst.jsp.editor.IJSPTextEditor;
import org.jboss.tools.vpe.editor.dnd.context.JSPViewerDropAdapter;
import org.w3c.dom.Node;

public class VpeDropWindow
extends Window {
    static final Color BACKGROUND_COLOR = new Color(null, 255, 255, 205);
    IJSPTextEditor editor;
    boolean active = false;
    TreeViewer treeViewer;
    Tree tree;
    int screenX;
    int screenY;
    String flavor;
    Node initialTargetNode;
    Node rootNode;
    private DelegatingDropAdapter fDropAdapter;
    private DropTarget fDropTarget;

    public VpeDropWindow(Shell shell) {
        super(shell);
        this.setShellStyle(0);
    }

    public void setEditor(IJSPTextEditor editor) {
        this.editor = editor;
    }

    public void setEventPosition(int screenX, int screenY) {
        this.screenX = screenX;
        this.screenY = screenY;
    }

    public void setInitialTargetNode(Node n) {
        this.rootNode = this.initialTargetNode = n;
        int i = 0;
        while (i < 3) {
            Node p = this.rootNode.getParentNode();
            if (p != null) {
                this.rootNode = p;
            }
            ++i;
        }
    }

    protected Control createContents(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        this.tree = new Tree(parent, 768);
        this.treeViewer = new TreeViewer(this.tree);
        IDOMModel model = (IDOMModel)this.editor.getVPEController().getModel();
        FactoryRegistry factoryRegistry = model.getFactoryRegistry();
        factoryRegistry.getFactoryFor(IJFaceNodeAdapter.class);
        JFaceNodeContentProvider contentProvider = new JFaceNodeContentProvider();
        this.treeViewer.setContentProvider((IContentProvider)contentProvider);
        JFaceNodeLabelProvider labelProvider = new JFaceNodeLabelProvider();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.treeViewer.setInput((Object)this.rootNode);
        this.tree.setBackground(BACKGROUND_COLOR);
        GridData data = new GridData(1808);
        data.verticalIndent = 0;
        data.horizontalIndent = 0;
        data.widthHint = 150;
        data.heightHint = 150;
        this.tree.setLayoutData((Object)data);
        this.treeViewer.setExpandedState((Object)this.initialTargetNode, true);
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.initialTargetNode), true);
        KeyListener listener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                VpeDropWindow.this.close();
            }
        };
        this.getShell().addKeyListener(listener);
        this.tree.addKeyListener(listener);
        this.initDrop();
        return this.tree;
    }

    public int open() {
        this.active = true;
        return super.open();
    }

    public boolean close() {
        this.active = false;
        return super.close();
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Rectangle r = this.getShell().getBounds();
        TreeItem item = this.findItem(this.tree.getItems());
        if (item != null) {
            Rectangle ri = item.getBounds();
            int x = this.screenX - ri.x - ri.width / 2;
            int y = this.screenY - ri.y - ri.height / 2;
            this.getShell().setBounds(this.getConstrainedShellBounds(new Rectangle(x, y, r.width, r.height)));
        }
    }

    private TreeItem findItem(TreeItem[] is) {
        int i = 0;
        while (i < is.length) {
            if (is[i].getData() == this.initialTargetNode) {
                return is[i];
            }
            ++i;
        }
        i = 0;
        while (i < is.length) {
            TreeItem[] iss = is[i].getItems();
            TreeItem result = this.findItem(iss);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    void initDrop() {
        this.fDropAdapter = new DelegatingDropAdapter();
        this.fDropTarget = new DropTarget(this.treeViewer.getControl(), 7);
        TransferDropTargetListener[] dropListeners = this.getTransferDropTargetListeners();
        if (dropListeners != null) {
            int i = 0;
            while (i < dropListeners.length) {
                this.fDropAdapter.addDropTargetListener(dropListeners[i]);
                ++i;
            }
        }
        this.fDropTarget.addDropListener((DropTargetListener)this.fDropAdapter);
        this.fDropTarget.setTransfer(this.fDropAdapter.getTransfers());
    }

    public TransferDropTargetListener[] getTransferDropTargetListeners() {
        TransferDropTargetListener[] fTransferDropTargetListeners = null;
        if (fTransferDropTargetListeners == null) {
            Transfer[] transfers = new Transfer[]{ModelTransfer.getInstance(), TextTransfer.getInstance(), HTMLTransfer.getInstance(), ObjectTransfer.getInstance(), FileTransfer.getInstance()};
            fTransferDropTargetListeners = new TransferDropTargetListener[transfers.length];
            int i = 0;
            while (i < transfers.length) {
                final Transfer transfer = transfers[i];
                DropContext dropContext = new DropContext();
                final JSPViewerDropAdapter dropAdapter = new JSPViewerDropAdapter(transfer, (Viewer)this.treeViewer, this.editor, transfer, dropContext);
                fTransferDropTargetListeners[i] = new TransferDropTargetListener(){

                    public void dragEnter(DropTargetEvent event) {
                        dropAdapter.dragEnter(event);
                    }

                    public void dragLeave(DropTargetEvent event) {
                        dropAdapter.dragLeave(event);
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                VpeDropWindow.this.close();
                            }
                        });
                    }

                    public void dragOperationChanged(DropTargetEvent event) {
                        dropAdapter.dragOperationChanged(event);
                    }

                    public void dragOver(DropTargetEvent event) {
                        dropAdapter.dragOver(event);
                    }

                    public void drop(DropTargetEvent event) {
                        dropAdapter.drop(event);
                    }

                    public void dropAccept(DropTargetEvent event) {
                        dropAdapter.dropAccept(event);
                    }

                    public Transfer getTransfer() {
                        return transfer;
                    }

                    public boolean isEnabled(DropTargetEvent event) {
                        return this.getTransfer().isSupportedType(event.currentDataType);
                    }
                };
                ++i;
            }
        }
        return fTransferDropTargetListeners;
    }
}

