/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor;

import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.jst.jsp.jspeditor.JSPTextEditor;
import org.jboss.tools.vpe.editor.VpeDomBuilder;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mapping.VpeElementMapping;
import org.jboss.tools.vpe.editor.mapping.VpeNodeMapping;
import org.jboss.tools.vpe.editor.selection.VpeSelectionHelper;
import org.jboss.tools.vpe.editor.template.VpeTemplate;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.jboss.tools.vpe.editor.util.NodesManagingUtil;
import org.jboss.tools.vpe.editor.util.TextUtil;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class VpeSourceDomBuilder
extends VpeDomBuilder {
    private StructuredTextViewer structuredTextViewer;
    private ISelectionProvider selectionManager;
    IDOMModel model;
    private Document sourceDocument;
    private VpePageContext pageContext;
    private StructuredTextEditor sourceEditor;

    public VpeSourceDomBuilder(VpeDomMapping domMapping, INodeAdapter sorceAdapter, VpeTemplateManager templateManager, StructuredTextEditor sourceEditor, VpePageContext pageContext) {
        super(domMapping, sorceAdapter);
        this.sourceEditor = sourceEditor;
        this.structuredTextViewer = sourceEditor.getTextViewer();
        this.selectionManager = sourceEditor.getSelectionProvider();
        this.model = (IDOMModel)sourceEditor.getModel();
        if (this.model != null) {
            this.sourceDocument = this.model.getDocument();
        }
        this.pageContext = pageContext;
    }

    public void addNode(nsIDOMNode visualNode) {
        nsIDOMNode visualContainer = visualNode.getParentNode();
        Node sourceContainer = this.domMapping.getSourceNode(visualContainer);
        if (sourceContainer != null && (sourceContainer.getNodeType() == 1 || sourceContainer.getNodeType() == 9)) {
            nsIDOMNode visualNextNode = visualNode.getNextSibling();
            Node sourceNextNode = this.domMapping.getSourceNode(visualNextNode);
            this.addNode(visualNode, sourceNextNode, sourceContainer);
        }
    }

    public void removeNode(nsIDOMNode visualNode) {
        Node sourceNode = this.domMapping.getSourceNode(visualNode);
        if (sourceNode != null) {
            Node sourceContainer = sourceNode.getParentNode();
            if (sourceContainer != null) {
                sourceContainer.removeChild(sourceNode);
                this.getSourceNodes().remove(sourceNode);
                if (sourceNode instanceof INodeNotifier) {
                    ((INodeNotifier)sourceNode).removeAdapter(this.getSorceAdapter());
                }
                this.domMapping.remove(sourceNode);
            }
        } else {
            sourceNode = this.domMapping.getNearSourceNode(visualNode);
            if (sourceNode != null && sourceNode.getNodeType() == 8) {
                sourceNode.setNodeValue("");
            }
        }
    }

    public void setText(nsIDOMNode visualText) {
        Node sourceText = this.domMapping.getSourceNode(visualText);
        if (sourceText != null) {
            sourceText.setNodeValue(TextUtil.sourceText(visualText.getNodeValue()));
        } else {
            Node sourceParent;
            nsIDOMNode visualParent = visualText.getParentNode();
            if (visualParent != null && (sourceParent = this.domMapping.getNearSourceNode(visualText)) != null) {
                if (sourceParent.getNodeType() == 1) {
                    VpeElementMapping elementMapping = (VpeElementMapping)this.domMapping.getNodeMapping(sourceParent);
                    if (elementMapping != null) {
                        VpeTemplate template = elementMapping.getTemplate();
                        template.setSourceAttributeValue(this.pageContext, (Element)sourceParent, elementMapping.getData());
                    }
                } else if (sourceParent.getNodeType() == 8) {
                    this.setComment(sourceParent, visualParent);
                }
            }
        }
    }

    public void setSelectedRange(Node sourceNode, int start, int length) {
        this.structuredTextViewer.setSelectedRange(start, length);
        this.structuredTextViewer.revealRange(start, length);
    }

    public void setSelectChanged(Node sourceNode) {
        if (sourceNode instanceof IDOMNode) {
            IDOMNode n = (IDOMNode)sourceNode;
            int start = n.getStartOffset();
            int length = n.getLength();
            this.selectionManager.setSelection((ISelection)new TextSelection(start, length));
        }
    }

    void setSelectionAtDocumentEnd() {
        if (this.sourceDocument == null) {
            return;
        }
        int offset = ((IndexedRegion)this.sourceDocument).getEndOffset();
        this.structuredTextViewer.setSelectedRange(offset, 0);
        this.structuredTextViewer.revealRange(offset, 0);
    }

    public void setSelection(Node sourceNode, int offset, int length) {
        this.setSelection(sourceNode, offset, length, false);
    }

    void setSelection(Node sourceNode, int offset, int length, boolean innerFlag) {
        if (sourceNode != null) {
            int start = ((IndexedRegion)sourceNode).getStartOffset() + offset;
            if (innerFlag && offset == 0 && sourceNode instanceof ElementImpl) {
                ElementImpl element = (ElementImpl)sourceNode;
                if (element.isContainer()) {
                    start = element.getStartEndOffset();
                    length = 0;
                }
            } else if (sourceNode.getNodeType() == 8) {
                start += 4;
            }
            this.structuredTextViewer.setSelectedRange(start, length);
            this.structuredTextViewer.revealRange(start, length);
        }
    }

    Node getSelectedNode() {
        List nodes = VpeSelectionHelper.getTextWidgetSelectedNodes((IStructuredModel)this.model, this.selectionManager);
        if (nodes != null && nodes.size() > 0) {
            return (Node)nodes.get(0);
        }
        return null;
    }

    int getCaretPosition() {
        StructuredTextViewer v = this.sourceEditor == null ? null : this.sourceEditor.getTextViewer();
        StyledText t = v == null ? null : v.getTextWidget();
        return t == null ? 0 : t.getCaretOffset();
    }

    private void addNode(nsIDOMNode visualNewNode, Node sourceNextNode, Node sourceContainer) {
        Node sourceNewNode = this.createNode(visualNewNode);
        if (sourceNewNode != null) {
            if (sourceNextNode == null) {
                sourceContainer.appendChild(sourceNewNode);
            } else {
                sourceContainer.insertBefore(sourceNewNode, sourceNextNode);
            }
        }
    }

    private Node createNode(nsIDOMNode visualNewNode) {
        if (this.sourceDocument != null) {
            switch (visualNewNode.getNodeType()) {
                case 1: {
                    Element sourceNewElement = this.sourceDocument.createElement(visualNewNode.getNodeName());
                    HashSet ifDependencySet = new HashSet();
                    this.pageContext.getVisualBuilder();
                    VpeTemplate template = this.getTemplateManager().getTemplate(this.pageContext, sourceNewElement, ifDependencySet);
                    this.registerNodes(new VpeElementMapping(sourceNewElement, (nsIDOMElement)visualNewNode, null, template, ifDependencySet, null));
                    this.addChildren(visualNewNode, sourceNewElement);
                    return sourceNewElement;
                }
                case 3: {
                    Text sourceTextNode = this.sourceDocument.createTextNode(visualNewNode.getNodeValue());
                    this.registerNodes(new VpeNodeMapping(sourceTextNode, visualNewNode));
                    return sourceTextNode;
                }
            }
        }
        return null;
    }

    private void addChildren(nsIDOMNode visualContainer, Element sourceContainer) {
        nsIDOMNodeList visualNodes = visualContainer.getChildNodes();
        long len = visualNodes.getLength();
        long i = 0L;
        while (i < len) {
            nsIDOMNode visualNode = visualNodes.item(i);
            this.addNode(visualNode, null, sourceContainer);
            ++i;
        }
    }

    public void openOn(nsIDOMNode visualNode) {
        if (!this.openOnOnVisualNode(visualNode)) {
            nsIDOMNode node = visualNode.getParentNode();
            while (node != null) {
                if ("a".equalsIgnoreCase(node.getNodeName())) {
                    this.openOnOnVisualNode(node);
                    break;
                }
                node = node.getParentNode();
            }
        }
    }

    private boolean openOnOnVisualNode(nsIDOMNode visualNode) {
        VpeNodeMapping nodeMapping = NodesManagingUtil.getNodeMapping(this.domMapping, visualNode);
        if (nodeMapping != null && nodeMapping instanceof VpeElementMapping) {
            VpeElementMapping elementMapping = (VpeElementMapping)nodeMapping;
            VpeTemplate template = elementMapping.getTemplate();
            IRegion regionForOpenOn = template.getSourceRegionForOpenOn(this.pageContext, elementMapping.getSourceNode(), visualNode);
            IHyperlinkDetector[] hyperlinkDetectors = ((JSPTextEditor)this.sourceEditor).getHyperlinkDetectors();
            IHyperlink[] hyperLinks = null;
            IHyperlinkDetector[] iHyperlinkDetectorArray = hyperlinkDetectors;
            int n = hyperlinkDetectors.length;
            int n2 = 0;
            while (n2 < n) {
                IHyperlinkDetector iHyperlinkDetector = iHyperlinkDetectorArray[n2];
                hyperLinks = iHyperlinkDetector.detectHyperlinks((ITextViewer)this.sourceEditor.getTextViewer(), regionForOpenOn, true);
                if (hyperLinks != null && hyperLinks.length > 0 && hyperLinks[0] instanceof AbstractHyperlink) {
                    AbstractHyperlink abstractHyperlink = (AbstractHyperlink)hyperLinks[0];
                    abstractHyperlink.open();
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    boolean isEmptyDocument() {
        Node sourceNode;
        if (this.sourceDocument == null) {
            return true;
        }
        boolean empty = false;
        NodeList sourceNodes = this.sourceDocument.getChildNodes();
        int len = sourceNodes.getLength();
        if (len == 0) {
            empty = true;
        } else if (len == 1 && (sourceNode = sourceNodes.item(0)).getNodeType() == 3 && sourceNode.getNodeValue().trim().length() == 0) {
            empty = true;
        }
        return empty;
    }

    int getPosition(Node sourceNode, int offset, boolean innerFlag) {
        int start = 0;
        if (sourceNode != null) {
            ElementImpl element;
            start = ((IndexedRegion)sourceNode).getStartOffset() + offset;
            if (innerFlag && offset == 0 && sourceNode instanceof ElementImpl && (element = (ElementImpl)sourceNode).isContainer()) {
                start = element.getStartEndOffset();
            }
        }
        return start;
    }

    void setAttributeSelection(nsIDOMNode visualText, int offset, int length) {
        Node sourceParent;
        nsIDOMNode visualParent = visualText.getParentNode();
        if (visualParent != null && (sourceParent = this.domMapping.getNearSourceNode(visualText)) != null) {
            if (sourceParent.getNodeType() == 1) {
                VpeElementMapping elementMapping = (VpeElementMapping)this.domMapping.getNodeMapping(sourceParent);
                if (elementMapping != null) {
                    VpeTemplate template = elementMapping.getTemplate();
                    template.setSourceAttributeSelection(this.pageContext, (Element)sourceParent, offset, length, elementMapping.getData());
                }
            } else if (sourceParent.getNodeType() != 8) {
                String text = sourceParent.getNodeValue();
                int start = TextUtil.sourcePosition(text, visualText.getNodeValue(), offset);
                int end = TextUtil.sourcePosition(text, visualText.getNodeValue(), offset + length);
                offset = start;
                length = end - start;
                this.setSelection(sourceParent, offset, length);
            }
        }
    }

    public void setAttributeSelection(Attr sourceAttr, int offset, int length) {
        int end;
        IDOMAttr xmlAttr = (IDOMAttr)sourceAttr;
        int start = xmlAttr.getValueRegionStartOffset() + offset;
        String value = xmlAttr.getValueRegionText();
        if (value.startsWith("\"") || value.startsWith("'")) {
            ++start;
        }
        if (start > (end = xmlAttr.getEndOffset())) {
            start = end;
        }
        if (start + length > end) {
            length = end - start;
        }
        this.structuredTextViewer.setSelectedRange(start, length);
        this.structuredTextViewer.revealRange(start, length);
    }

    Point getOutputAttributesPositions(Element sourceElement) {
        VpeTemplate template;
        VpeElementMapping elementMapping = (VpeElementMapping)this.domMapping.getNodeMapping(sourceElement);
        if (elementMapping != null && (template = elementMapping.getTemplate()).isOutputAttributes()) {
            int start = ((IndexedRegion)sourceElement).getStartOffset();
            int end = ((IndexedRegion)sourceElement).getEndOffset();
            return new Point(start, end);
        }
        return null;
    }

    public Point getSelectionRange() {
        return this.sourceEditor.getTextViewer().getSelectedRange();
    }

    public void setComment(Node sourceComment, nsIDOMNode visualElement) {
        nsIDOMNodeList visualNodes = visualElement.getChildNodes();
        long len = visualNodes.getLength();
        if (len > 0L) {
            nsIDOMNode visualText = visualNodes.item(0L);
            sourceComment.setNodeValue(visualText.getNodeValue());
        }
    }

    public StructuredTextViewer getStructuredTextViewer() {
        return this.structuredTextViewer;
    }

    public Document getSourceDocument() {
        return this.sourceDocument;
    }
}

