/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.jboss.tools.common.resref.core.ResourceReference;
import org.jboss.tools.jst.jsp.JspEditorPlugin;
import org.jboss.tools.jst.jsp.preferences.VpePreference;
import org.jboss.tools.jst.web.tld.TaglibData;
import org.jboss.tools.vpe.VpeDebug;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.dnd.VpeDnD;
import org.jboss.tools.vpe.editor.VpeDisposeException;
import org.jboss.tools.vpe.editor.VpeDomBuilder;
import org.jboss.tools.vpe.editor.VpeIncludeInfo;
import org.jboss.tools.vpe.editor.VpeSourceDomBuilder;
import org.jboss.tools.vpe.editor.VpeSourceInnerDragInfo;
import org.jboss.tools.vpe.editor.VpeSourceInnerDropInfo;
import org.jboss.tools.vpe.editor.VpeVisualInnerDragInfo;
import org.jboss.tools.vpe.editor.VpeVisualInnerDropInfo;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.NodeData;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mapping.VpeElementData;
import org.jboss.tools.vpe.editor.mapping.VpeElementMapping;
import org.jboss.tools.vpe.editor.mapping.VpeNodeMapping;
import org.jboss.tools.vpe.editor.mozilla.MozillaEditor;
import org.jboss.tools.vpe.editor.proxy.VpeProxyUtil;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.template.VpeCreatorUtil;
import org.jboss.tools.vpe.editor.template.VpeDefaultPseudoContentCreator;
import org.jboss.tools.vpe.editor.template.VpeTemplate;
import org.jboss.tools.vpe.editor.template.VpeToggableTemplate;
import org.jboss.tools.vpe.editor.template.dnd.VpeDnd;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionException;
import org.jboss.tools.vpe.editor.util.ElService;
import org.jboss.tools.vpe.editor.util.FaceletUtil;
import org.jboss.tools.vpe.editor.util.TextUtil;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.jboss.tools.vpe.editor.util.VpeStyleUtil;
import org.jboss.tools.vpe.editor.util.XmlUtil;
import org.jboss.tools.vpe.resref.core.CSSReferenceList;
import org.jboss.tools.vpe.xulrunner.editor.XulRunnerEditor;
import org.jboss.tools.vpe.xulrunner.editor.XulRunnerVpeUtils;
import org.mozilla.interfaces.nsIDOMAttr;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMHTMLDocument;
import org.mozilla.interfaces.nsIDOMMouseEvent;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsIDOMRange;
import org.mozilla.interfaces.nsIDOMText;
import org.mozilla.xpcom.XPCOMException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VpeVisualDomBuilder
extends VpeDomBuilder {
    private static final String CURSOR_MOVE_STYLE_ID = "vpeCursorMoveStyle";
    private static final String CURSOR_MOVE_SELECTOR = "*{cursor: move !important}";
    public static final String SRC_NODE = "SRC_NODE";
    public static final String PARENT = "PARENT";
    public static final String VPE_USER_TOGGLE_ID = "vpe-user-toggle-id";
    public static final String VPE_USER_TOGGLE_LOOKUP_PARENT = "vpe-user-toggle-lookup-parent";
    private static final String PSEUDO_ELEMENT = "br";
    private static final String PSEUDO_ELEMENT_ATTR = "vpe:pseudo-element";
    private static final String INIT_ELEMENT_ATTR = "vpe:init-element";
    private static final String MOZ_ANONCLASS_ATTR = "_MOZ_ANONCLASS";
    private static final String INCLUDE_ELEMENT_ATTR = "vpe:include-element";
    private static final int DRAG_AREA_WIDTH = 10;
    private static final int DRAG_AREA_HEIGHT = 10;
    private static String DOTTED_BORDER = "border: 1px dotted #FF6600; padding: 5px;";
    private static final String CSS_STYLE_FOR_BORDER_FOR_UNKNOWN_TAGS = ";border: 1px solid green;";
    private MozillaEditor visualEditor;
    private XulRunnerEditor xulRunnerEditor;
    private VpePageContext pageContext;
    private VpeDnD dnd;
    private List includeStack;
    private static final String ATTR_VPE = "vpe";
    private static final String ATTR_VPE_INLINE_LINK_VALUE = "inlinelink";
    private static final String ATTR_REL_STYLESHEET_VALUE = "stylesheet";
    private static final String YES_STRING = "yes";
    private static final String ZERO_STRING = "0";
    private static final String EMPTY_STRING = "";
    private static final String ATRIBUTE_BORDER = "border";
    private static final String ATRIBUTE_CELLSPACING = "cellspacing";
    private static final String ATRIBUTE_CELLPADDING = "cellpadding";
    private static final String DOTTED_BORDER_STYLE = "border : 1px dotted #808080";
    private static final String DOTTED_BORDER_STYLE_FOR_IMG = "1px dotted #808080";
    private static final String DOTTED_BORDER_STYLE_FOR_TD = "border-left : 1px dotted #808080; border-right : 1px dotted #808080; border-top : 1px dotted #808080; border-bottom : 0px; color:#0051DD; background-color:#ECF3FF; padding-left: 3px;  padding-right: 3px;  line-height : 10px; font-family : arial; font-size : 10px; text-align:top; margin : 1px; -moz-user-modify : read-only";
    private static final String DOTTED_BORDER_STYLE_FOR_SPAN = "border : 1px solid #0051DD; color:#0051DD; background-color:#ECF3FF; padding-left: 3px;  padding-right: 3px;  line-height : 10px; font-family : arial; font-size : 10px; text-align:top; margin : 1px; -moz-user-modify : read-only";
    private static HashSet<String> unborderedSourceNodes = new HashSet();
    private static HashSet<String> unborderedVisualNodes;
    private VpeDnd dropper;
    private Map<IStorage, Document> includeDocuments = new HashMap<IStorage, Document>();
    private boolean showInvisibleTags;
    private boolean showBorderForUnknownTags;

    static {
        unborderedSourceNodes.add("html");
        unborderedSourceNodes.add("head");
        unborderedSourceNodes.add("body");
        unborderedVisualNodes = new HashSet();
        unborderedVisualNodes.add("tbody");
        unborderedVisualNodes.add("thead");
        unborderedVisualNodes.add("tr");
        unborderedVisualNodes.add("td");
        unborderedVisualNodes.add("col");
        unborderedVisualNodes.add("cols");
        unborderedVisualNodes.add("colgroup");
        unborderedVisualNodes.add("li");
        unborderedVisualNodes.add(PSEUDO_ELEMENT);
    }

    public VpeVisualDomBuilder(VpeDomMapping domMapping, INodeAdapter sorceAdapter, MozillaEditor visualEditor, VpePageContext pageContext) {
        super(domMapping, sorceAdapter);
        this.visualEditor = visualEditor;
        this.xulRunnerEditor = visualEditor.getXulRunnerEditor();
        this.dnd = new VpeDnD();
        this.pageContext = pageContext;
        this.dropper = new VpeDnd();
        this.dropper.setDndData(false, true);
        this.showInvisibleTags = JspEditorPlugin.getDefault().getPreferenceStore().getBoolean("Show non-visual tags");
        this.showBorderForUnknownTags = JspEditorPlugin.getDefault().getPreferenceStore().getBoolean("Show Border for Unknown Tags");
    }

    public void buildDom(Document sourceDocument) {
        IFile file;
        nsIDOMNodeList children = this.getContentArea().getChildNodes();
        long len = children.getLength();
        long i = len - 1L;
        while (i >= 0L) {
            this.getContentArea().removeChild(children.item(i));
            --i;
        }
        VpeSourceDomBuilder sourceBuilder = this.pageContext.getSourceBuilder();
        IDocument document = sourceBuilder.getStructuredTextViewer().getDocument();
        if (document == null) {
            return;
        }
        this.includeStack = new ArrayList();
        IEditorInput input = this.pageContext.getEditPart().getEditorInput();
        if (input instanceof IFileEditorInput && (file = ((IFileEditorInput)input).getFile()) != null) {
            this.includeStack.add(new VpeIncludeInfo(null, (IStorage)file, this.pageContext.getSourceBuilder().getSourceDocument()));
        }
        this.pageContext.refreshConnector();
        this.refreshExternalLinks();
        Element root = FaceletUtil.findComponentElement(sourceDocument.getDocumentElement());
        if (root != null && this.isFacelet(root)) {
            this.addNode(root, null, (nsIDOMNode)this.getContentArea());
        } else {
            this.addChildren(null, sourceDocument, (nsIDOMNode)this.getContentArea());
        }
        this.registerNodes(new VpeNodeMapping(sourceDocument, (nsIDOMNode)this.getContentArea()));
    }

    public void rebuildDom(Document sourceDocument) {
        this.cleanHead();
        this.domMapping.clear((nsIDOMNode)this.getContentArea());
        super.dispose();
        this.pageContext.clearAll();
        this.pageContext.getBundle().refreshRegisteredBundles();
        if (sourceDocument != null) {
            this.buildDom(sourceDocument);
        }
    }

    private boolean addNode(Node sourceNode, nsIDOMNode visualNextNode, nsIDOMNode visualContainer) {
        try {
            nsIDOMNode visualNewNode = this.createNode(sourceNode, visualContainer);
            if (visualNewNode != null) {
                if (visualNextNode == null) {
                    visualContainer.appendChild(visualNewNode);
                } else {
                    visualContainer.insertBefore(visualNewNode, visualNextNode);
                }
                return true;
            }
        }
        catch (XPCOMException xpcomException) {
            VpePlugin.reportProblem((Exception)((Object)xpcomException));
        }
        return false;
    }

    private nsIDOMElement createBorder(Node sourceNode, nsIDOMElement visualNode, boolean block) {
        nsIDOMElement border = null;
        if (visualNode == null) {
            return null;
        }
        if (unborderedSourceNodes.contains(sourceNode.getNodeName().toLowerCase())) {
            return null;
        }
        if (unborderedVisualNodes.contains(visualNode.getNodeName().toLowerCase())) {
            return null;
        }
        if ("img".equalsIgnoreCase(visualNode.getNodeName())) {
            String width = visualNode.getAttribute(ATRIBUTE_BORDER);
            if (width == null || ZERO_STRING.equalsIgnoreCase(width) || EMPTY_STRING.equalsIgnoreCase(width)) {
                String style = visualNode.getAttribute("style");
                style = VpeStyleUtil.setParameterInStyle(style, ATRIBUTE_BORDER, DOTTED_BORDER_STYLE_FOR_IMG);
                visualNode.setAttribute("style", style);
            }
            return null;
        }
        if (block) {
            if (YES_STRING.equals(VpePreference.USE_DETAIL_BORDER.getValue())) {
                border = this.getVisualDocument().createElement("table");
                border.setAttribute(ATRIBUTE_CELLSPACING, ZERO_STRING);
                border.setAttribute(ATRIBUTE_CELLPADDING, ZERO_STRING);
                nsIDOMElement tr1 = this.getVisualDocument().createElement("tr");
                border.appendChild((nsIDOMNode)tr1);
                nsIDOMElement td1 = this.getVisualDocument().createElement("td");
                td1.setAttribute("style", DOTTED_BORDER_STYLE_FOR_TD);
                nsIDOMText text = this.getVisualDocument().createTextNode(sourceNode.getNodeName());
                td1.appendChild((nsIDOMNode)text);
                tr1.appendChild((nsIDOMNode)td1);
                nsIDOMElement tr2 = this.getVisualDocument().createElement("tr");
                border.appendChild((nsIDOMNode)tr2);
                nsIDOMElement td2 = this.getVisualDocument().createElement("td");
                tr2.appendChild((nsIDOMNode)td2);
                nsIDOMElement p = this.getVisualDocument().createElement("p");
                p.setAttribute("style", DOTTED_BORDER_STYLE);
                td2.appendChild((nsIDOMNode)p);
                p.appendChild((nsIDOMNode)visualNode);
            } else {
                border = this.getVisualDocument().createElement("table");
                border.setAttribute(ATRIBUTE_CELLSPACING, ZERO_STRING);
                border.setAttribute(ATRIBUTE_CELLPADDING, ZERO_STRING);
                nsIDOMElement tr2 = this.getVisualDocument().createElement("tr");
                border.appendChild((nsIDOMNode)tr2);
                nsIDOMElement td2 = this.getVisualDocument().createElement("td");
                tr2.appendChild((nsIDOMNode)td2);
                nsIDOMElement p = this.getVisualDocument().createElement("p");
                p.setAttribute("style", DOTTED_BORDER_STYLE);
                td2.appendChild((nsIDOMNode)p);
                p.appendChild((nsIDOMNode)visualNode);
            }
        } else {
            border = this.getVisualDocument().createElement("span");
            border.setAttribute("style", DOTTED_BORDER_STYLE);
            if (YES_STRING.equals(VpePreference.USE_DETAIL_BORDER.getValue())) {
                nsIDOMElement name = this.getVisualDocument().createElement("span");
                name.setAttribute("style", DOTTED_BORDER_STYLE_FOR_SPAN);
                nsIDOMText text = this.getVisualDocument().createTextNode(sourceNode.getNodeName());
                name.appendChild((nsIDOMNode)text);
                border.appendChild((nsIDOMNode)name);
            }
            border.appendChild((nsIDOMNode)visualNode);
        }
        if (VpeStyleUtil.getAbsolute((Element)sourceNode)) {
            int top = VpeStyleUtil.getSizeFromStyle((Element)sourceNode, "style.top");
            int left = VpeStyleUtil.getSizeFromStyle((Element)sourceNode, "style.left");
            String style = visualNode.getAttribute("style");
            style = VpeStyleUtil.deleteFromString(style, "position", ";");
            style = VpeStyleUtil.deleteFromString(style, "top", ";");
            style = VpeStyleUtil.deleteFromString(style, "left", ";");
            visualNode.setAttribute("style", style);
            style = border.getAttribute("style");
            style = VpeStyleUtil.setAbsolute(style);
            if (top != -1) {
                style = VpeStyleUtil.setSizeInStyle(style, "top", top);
            }
            if (left != -1) {
                style = VpeStyleUtil.setSizeInStyle(style, "left", left);
            }
            border.setAttribute("style", style);
        }
        return border;
    }

    protected nsIDOMNode createNode(Node sourceNode, nsIDOMNode visualOldContainer) {
        boolean registerFlag = this.isCurrentMainDocument();
        if (this.visualEditor.getController().getSelectionManager() != null) {
            this.getPageContext().processDisplayEvents();
        }
        if (this.getPageContext().getSourceBuilder() == null || this.includeDocuments == null) {
            throw new VpeDisposeException();
        }
        if (sourceNode == null || sourceNode.getNodeType() != 3 && sourceNode.getNodeType() != 1 && sourceNode.getNodeType() != 8) {
            return null;
        }
        HashSet ifDependencySet = new HashSet();
        this.pageContext.setCurrentVisualNode(visualOldContainer);
        VpeTemplate template = this.getTemplateManager().getTemplate(this.pageContext, sourceNode, ifDependencySet);
        VpeCreationData creationData = null;
        Node sourceNodeProxy = null;
        try {
            if (ElService.getInstance().isELNode(this.getPageContext(), sourceNode)) {
                sourceNodeProxy = VpeProxyUtil.createProxyForELExpressionNode(this.getPageContext(), sourceNode);
                try {
                    creationData = template.create(this.getPageContext(), sourceNodeProxy, this.getVisualDocument());
                }
                catch (ClassCastException ex) {
                    VpePlugin.reportProblem(ex);
                    sourceNodeProxy = null;
                    creationData = template.create(this.getPageContext(), sourceNode, this.getVisualDocument());
                }
            } else {
                creationData = template.create(this.getPageContext(), sourceNode, this.getVisualDocument());
            }
        }
        catch (XPCOMException ex) {
            VpePlugin.getPluginLog().logError((Throwable)ex);
            VpeTemplate defTemplate = this.getTemplateManager().getDefTemplate();
            creationData = defTemplate.create(this.getPageContext(), sourceNode, this.getVisualDocument());
        }
        this.getPageContext().setCurrentVisualNode(null);
        nsIDOMNode visualNewNode = creationData.getNode();
        if (sourceNode.getNodeType() == 1 && visualNewNode == null && this.isShowInvisibleTags()) {
            visualNewNode = this.createInvisbleElementLabel(sourceNode);
        }
        nsIDOMNode border = null;
        if (visualNewNode != null && visualNewNode.getNodeType() == 1) {
            nsIDOMElement visualNewElement = (nsIDOMElement)visualNewNode.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
            if (visualNewElement != null && template.hasImaginaryBorder()) {
                visualNewElement.setAttribute("style", String.valueOf(visualNewElement.getAttribute("style")) + ";" + DOTTED_BORDER);
            }
            if (visualNewElement != null) {
                this.correctVisualAttribute(visualNewElement);
            }
            if (template.getType() == 4 && this.showBorderForUnknownTags) {
                String style = visualNewElement.getAttribute("style");
                style = String.valueOf(style) + CSS_STYLE_FOR_BORDER_FOR_UNKNOWN_TAGS;
                visualNewElement.setAttribute("style", style);
            }
            if (!this.isCurrentMainDocument() && visualNewElement != null) {
                this.setReadOnlyElement(visualNewElement);
            }
        }
        if (sourceNode instanceof Element && visualNewNode != null && visualNewNode.getNodeType() == 1) {
            this.setTooltip((Element)sourceNode, (nsIDOMElement)visualNewNode.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}"));
        }
        if (registerFlag) {
            VpeElementData data = creationData.getElementData();
            if (sourceNodeProxy != null && data != null && data.getNodesData() != null && data.getNodesData().size() > 0) {
                for (NodeData nodeData : data.getNodesData()) {
                    if (nodeData.getSourceNode() == null) continue;
                    Node attr = null;
                    attr = sourceNode.getAttributes() != null ? sourceNode.getAttributes().getNamedItem(nodeData.getSourceNode().getNodeName()) : sourceNode;
                    nodeData.setSourceNode(attr);
                    nodeData.setEditable(false);
                }
            }
            VpeElementMapping elementMapping = new VpeElementMapping(sourceNode, visualNewNode, (nsIDOMElement)border, template, ifDependencySet, creationData.getData(), data);
            this.registerNodes(elementMapping);
        }
        if (template.hasChildren()) {
            List<VpeChildrenInfo> childrenInfoList = creationData.getChildrenInfoList();
            if (childrenInfoList == null) {
                this.addChildren(template, sourceNode, visualNewNode != null ? visualNewNode : visualOldContainer);
            } else {
                this.addChildren(template, sourceNode, visualOldContainer, childrenInfoList);
            }
        } else if (sourceNode.getNodeType() == 1 && visualNewNode != null && this.isShowInvisibleTags()) {
            nsIDOMElement span = this.getVisualDocument().createElement("span");
            span.appendChild(visualNewNode);
            this.addChildren(template, sourceNode, (nsIDOMNode)span);
            visualNewNode = span;
        }
        this.getPageContext().setCurrentVisualNode(visualOldContainer);
        template.validate(this.getPageContext(), sourceNode, this.getVisualDocument(), creationData);
        this.getPageContext().setCurrentVisualNode(null);
        if (border != null) {
            return border;
        }
        return visualNewNode;
    }

    protected void correctVisualAttribute(nsIDOMElement element) {
        String styleValue = element.getAttribute("style");
        String backgroundValue = element.getAttribute("background");
        if (styleValue != null) {
            styleValue = VpeStyleUtil.addFullPathIntoURLValue(styleValue, this.pageContext);
            element.setAttribute("style", styleValue);
        }
        if (backgroundValue != null) {
            backgroundValue = VpeStyleUtil.addFullPathIntoBackgroundValue(backgroundValue, this.pageContext.getEditPart().getEditorInput());
            element.setAttribute("background", backgroundValue);
        }
        if (element.hasAttribute("dir")) {
            element.removeAttribute("dir");
        }
    }

    protected void addChildren(VpeTemplate containerTemplate, Node sourceContainer, nsIDOMNode visualContainer) {
        NodeList sourceNodes = sourceContainer.getChildNodes();
        int len = sourceNodes.getLength();
        int childrenCount = 0;
        int i = 0;
        while (i < len) {
            Node sourceNode = sourceNodes.item(i);
            if (this.addNode(sourceNode, null, visualContainer)) {
                sourceNode.getNodeType();
                ++childrenCount;
            }
            ++i;
        }
        if (childrenCount == 0) {
            this.setPseudoContent(containerTemplate, sourceContainer, visualContainer);
        }
    }

    protected void addChildren(VpeTemplate containerTemplate, Node sourceContainer, nsIDOMNode visualOldContainer, List<?> childrenInfoList) {
        int i = 0;
        while (i < childrenInfoList.size()) {
            VpeChildrenInfo info = (VpeChildrenInfo)childrenInfoList.get(i);
            nsIDOMElement visualParent = info.getVisualParent();
            if (visualParent == null) {
                visualParent = visualOldContainer;
            }
            List<Node> sourceChildren = info.getSourceChildren();
            int childrenCount = 0;
            if (sourceChildren != null) {
                int j = 0;
                while (j < sourceChildren.size()) {
                    Node child = sourceChildren.get(j);
                    if (!this.isInvisibleNode(child) && this.addNode(sourceChildren.get(j), null, (nsIDOMNode)visualParent)) {
                        ++childrenCount;
                    }
                    ++j;
                }
            }
            if (childrenCount == 0 && childrenInfoList.size() == 0) {
                this.setPseudoContent(containerTemplate, sourceContainer, (nsIDOMNode)visualParent);
            }
            ++i;
        }
    }

    protected nsIDOMNode addInvisibleChildren(Node sourceContainer, nsIDOMNode visualContainer) {
        nsIDOMNode wrapper = null;
        int count = 0;
        if (visualContainer != null) {
            wrapper = this.getVisualDocument().createElement("span");
            wrapper.appendChild(visualContainer);
            NodeList sourceNodes = sourceContainer.getChildNodes();
            int i = 0;
            while (i < sourceNodes.getLength()) {
                Node child = sourceNodes.item(i);
                if (this.isInvisibleNode(child)) {
                    this.addNode(child, null, wrapper);
                    ++count;
                }
                ++i;
            }
        }
        return count > 0 ? wrapper : visualContainer;
    }

    private boolean isInvisibleNode(Node node) {
        HashSet ifDependencySet = new HashSet();
        VpeTemplate template = this.getTemplateManager().getTemplate(this.pageContext, node, ifDependencySet);
        return template.isInvisible();
    }

    public nsIDOMNode addStyleNodeToHead(String styleText) {
        nsIDOMElement newStyle = this.getVisualDocument().createElement("style");
        if (styleText != null) {
            nsIDOMText newText = this.getVisualDocument().createTextNode(styleText);
            newStyle.appendChild((nsIDOMNode)newText);
        }
        this.getHeadNode().appendChild((nsIDOMNode)newStyle);
        return newStyle;
    }

    public nsIDOMNode replaceStyleNodeToHead(nsIDOMNode oldStyleNode, String styleText) {
        nsIDOMElement newStyle = this.getVisualDocument().createElement("style");
        if (styleText != null) {
            nsIDOMText newText = this.getVisualDocument().createTextNode(styleText);
            newStyle.appendChild((nsIDOMNode)newText);
        }
        this.getHeadNode().replaceChild((nsIDOMNode)newStyle, oldStyleNode);
        return newStyle;
    }

    public void removeStyleNodeFromHead(nsIDOMNode oldStyleNode) {
        this.getHeadNode().removeChild(oldStyleNode);
    }

    void addExternalLinks() {
        IEditorInput input = this.pageContext.getEditPart().getEditorInput();
        IFile file = null;
        if (input instanceof IFileEditorInput) {
            file = ((IFileEditorInput)input).getFile();
        }
        ResourceReference[] l = null;
        if (file != null) {
            l = CSSReferenceList.getInstance().getAllResources(file);
        }
        if (l != null) {
            int i = 0;
            while (i < l.length) {
                ResourceReference item = l[i];
                this.addLinkNodeToHead("file:///" + item.getLocation(), YES_STRING, false);
                ++i;
            }
        }
    }

    void removeExternalLinks() {
        nsIDOMNodeList childs = this.getHeadNode().getChildNodes();
        long length = childs.getLength();
        long i = length - 1L;
        while (i >= 0L) {
            nsIDOMNode node = childs.item(i);
            if (node.getNodeType() == 1) {
                boolean isLink = false;
                boolean isStyle = false;
                isLink = "link".equalsIgnoreCase(node.getNodeName());
                if (isLink || (isStyle = "style".equalsIgnoreCase(node.getNodeName()))) {
                    nsIDOMElement element = (nsIDOMElement)node.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
                    if ((isLink || isStyle && ATTR_VPE_INLINE_LINK_VALUE.equalsIgnoreCase(element.getAttribute(ATTR_VPE))) && YES_STRING.equalsIgnoreCase(element.getAttribute("ext"))) {
                        this.getHeadNode().removeChild(node);
                    }
                }
            }
            --i;
        }
    }

    void refreshExternalLinks() {
        this.removeExternalLinks();
        this.addExternalLinks();
    }

    void resetPseudoElement(nsIDOMNode visualNode) {
        nsIDOMNode visualParent;
        if (visualNode != null && (visualParent = visualNode.getParentNode()) != null) {
            PseudoInfo info = this.getPseudoInfo(visualParent);
            if (info.pseudoNode == null && !info.isElements) {
                this.addPseudoElementImpl(visualParent);
            } else if (info.pseudoNode != null && info.isElements) {
                visualParent.removeChild(info.pseudoNode);
            }
        }
    }

    private PseudoInfo getPseudoInfo(nsIDOMNode visualParent) {
        nsIDOMNode pseudoNode = null;
        boolean isElements = false;
        if (visualParent == null) {
            return new PseudoInfo();
        }
        nsIDOMNodeList visualNodes = visualParent.getChildNodes();
        if (visualNodes == null) {
            return new PseudoInfo();
        }
        long length = visualNodes.getLength();
        long i = 0L;
        while (i < length) {
            nsIDOMNode visualNode = visualNodes.item(i);
            if (pseudoNode == null && VpeVisualDomBuilder.isPseudoElement(visualNode)) {
                pseudoNode = visualNode;
            } else if (!this.isEmptyText(visualNode)) {
                isElements = true;
            }
            if (pseudoNode != null && isElements) break;
            ++i;
        }
        return new PseudoInfo(pseudoNode, isElements);
    }

    static boolean isInitElement(nsIDOMNode visualNode) {
        if (visualNode == null) {
            return false;
        }
        if (visualNode.getNodeType() != 1) {
            return false;
        }
        return YES_STRING.equalsIgnoreCase(((nsIDOMElement)visualNode).getAttribute(INIT_ELEMENT_ATTR));
    }

    static boolean isPseudoElement(nsIDOMNode visualNode) {
        if (visualNode == null) {
            return false;
        }
        if (visualNode.getNodeType() != 1) {
            return false;
        }
        return YES_STRING.equalsIgnoreCase(((nsIDOMElement)visualNode.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}")).getAttribute(PSEUDO_ELEMENT_ATTR));
    }

    private void setPseudoContent(VpeTemplate containerTemplate, Node sourceContainer, nsIDOMNode visualContainer) {
        if (containerTemplate != null) {
            containerTemplate.setPseudoContent(this.pageContext, sourceContainer, visualContainer, this.getVisualDocument());
        } else {
            try {
                VpeDefaultPseudoContentCreator.getInstance().setPseudoContent(this.pageContext, sourceContainer, visualContainer, this.getVisualDocument());
            }
            catch (VpeExpressionException ex) {
                VpeExpressionException exception = new VpeExpressionException("Error for source node" + sourceContainer.toString(), ex);
                VpePlugin.reportProblem(exception);
            }
        }
    }

    private void addPseudoElementImpl(nsIDOMNode visualParent) {
        if (!this.getTemplateManager().isWithoutPseudoElementContainer(visualParent.getNodeName())) {
            if (VpeDebug.VISUAL_ADD_PSEUDO_ELEMENT) {
                System.out.println("-------------------- addPseudoElement: " + visualParent.getNodeName());
            }
            nsIDOMElement visualPseudoElement = this.getVisualDocument().createElement(PSEUDO_ELEMENT);
            visualPseudoElement.setAttribute(PSEUDO_ELEMENT_ATTR, YES_STRING);
            visualParent.appendChild((nsIDOMNode)visualPseudoElement);
        }
    }

    public boolean isEmptyElement(nsIDOMNode visualParent) {
        nsIDOMNodeList visualNodes = visualParent.getChildNodes();
        long len = visualNodes.getLength();
        return len == 0L || len == 1L && this.isEmptyText(visualNodes.item(0L));
    }

    public boolean isEmptyDocument() {
        nsIDOMNodeList visualNodes = this.getContentArea().getChildNodes();
        long len = visualNodes.getLength();
        return len == 0L || len == 1L && (this.isEmptyText(visualNodes.item(0L)) || VpeVisualDomBuilder.isPseudoElement(visualNodes.item(0L)));
    }

    private boolean isEmptyText(nsIDOMNode visualNode) {
        if (visualNode == null || visualNode.getNodeType() != 3) {
            return false;
        }
        return visualNode.getNodeValue().trim().length() == 0;
    }

    public void updateNode(Node sourceNode) {
        if (sourceNode == null) {
            return;
        }
        switch (sourceNode.getNodeType()) {
            case 9: {
                this.rebuildDom((Document)sourceNode);
                break;
            }
            default: {
                this.updateElement(this.getNodeForUpdate(sourceNode));
            }
        }
    }

    private Node getNodeForUpdate(Node sourceNode) {
        Node sourceTable = this.getParentTable(sourceNode, 2);
        if (sourceTable != null) {
            return sourceTable;
        }
        Node sourceSelect = this.getParentSelect(sourceNode);
        if (sourceSelect != null) {
            return sourceSelect;
        }
        return sourceNode;
    }

    private void updateElement(Node sourceNode) {
        VpeElementMapping elementMapping = null;
        VpeNodeMapping nodeMapping = this.domMapping.getNodeMapping(sourceNode);
        if (nodeMapping instanceof VpeElementMapping && (elementMapping = (VpeElementMapping)nodeMapping) != null && elementMapping.getTemplate() != null) {
            Node updateNode = elementMapping.getTemplate().getNodeForUpdate(this.pageContext, elementMapping.getSourceNode(), elementMapping.getVisualNode(), elementMapping.getData());
            if ("style".equalsIgnoreCase(sourceNode.getNodeName())) {
                VpeStyleUtil.refreshStyleElement(this, elementMapping);
                return;
            }
            if (updateNode != null && updateNode != sourceNode) {
                this.updateNode(updateNode);
                return;
            }
        }
        nsIDOMNode visualOldNode = this.domMapping.remove(sourceNode);
        this.getSourceNodes().remove(sourceNode);
        if (sourceNode instanceof INodeNotifier) {
            ((INodeNotifier)sourceNode).removeAdapter(this.getSorceAdapter());
        }
        if (visualOldNode != null) {
            nsIDOMElement border;
            if (elementMapping != null && (border = elementMapping.getBorder()) != null) {
                visualOldNode = border;
            }
            nsIDOMNode visualContainer = visualOldNode.getParentNode();
            nsIDOMNode visualNextNode = visualOldNode.getNextSibling();
            if (visualContainer != null) {
                this.addNode(sourceNode, visualNextNode, visualContainer);
                visualContainer.removeChild(visualOldNode);
            }
        } else if (sourceNode.getNodeType() == 3) {
            this.updateNode(sourceNode.getParentNode());
        } else if ("link".equalsIgnoreCase(sourceNode.getNodeName())) {
            this.addNode(sourceNode, null, this.getHeadNode());
        }
    }

    public void removeNode(Node sourceNode) {
        this.domMapping.remove(sourceNode);
        this.getSourceNodes().remove(sourceNode);
        if (sourceNode instanceof INodeNotifier) {
            ((INodeNotifier)sourceNode).removeAdapter(this.getSorceAdapter());
        }
    }

    private Node getParentTable(Node sourceNode, int depth) {
        Node parentNode = sourceNode.getParentNode();
        int i = 0;
        while (parentNode != null && i < depth) {
            if ("table".equalsIgnoreCase(parentNode.getNodeName())) {
                return parentNode;
            }
            parentNode = parentNode.getParentNode();
            ++i;
        }
        return null;
    }

    private Node getParentSelect(Node sourceNode) {
        Node parentNode;
        if ("option".equalsIgnoreCase(sourceNode.getNodeName()) && "select".equalsIgnoreCase((parentNode = sourceNode.getParentNode()).getNodeName())) {
            return parentNode;
        }
        return null;
    }

    public boolean setText(Node sourceText) {
        String sourceParentName;
        Node sourceParent = sourceText.getParentNode();
        if (sourceParent != null && sourceParent.getLocalName() != null && ("textarea".equalsIgnoreCase(sourceParentName = sourceParent.getLocalName()) || "option".equalsIgnoreCase(sourceParentName) || "style".equalsIgnoreCase(sourceParentName))) {
            this.updateNode(sourceText.getParentNode());
            return true;
        }
        nsIDOMNode visualText = this.domMapping.getVisualNode(sourceText);
        if (visualText == null) {
            VpeTemplate template;
            VpeNodeMapping nodeMapping = this.domMapping.getNodeMapping(sourceParent);
            if (nodeMapping != null && nodeMapping instanceof VpeElementMapping && (template = ((VpeElementMapping)nodeMapping).getTemplate()) != null && !template.containsText()) {
                return false;
            }
            this.updateNode(sourceText);
            return true;
        }
        String visualValue = TextUtil.visualText(sourceText.getNodeValue());
        visualText.setNodeValue(visualValue);
        return false;
    }

    public void setAttribute(Element sourceElement, String name, String value) {
        VpeElementMapping elementMapping = (VpeElementMapping)this.domMapping.getNodeMapping(sourceElement);
        if (elementMapping != null) {
            this.updateElement(sourceElement);
        }
    }

    public void stopToggle(Node sourceNode) {
        VpeTemplate template;
        if (!(sourceNode instanceof Element)) {
            return;
        }
        Element sourceElement = (Element)sourceNode;
        VpeElementMapping elementMapping = (VpeElementMapping)this.domMapping.getNodeMapping(sourceElement);
        if (elementMapping != null && (template = elementMapping.getTemplate()) instanceof VpeToggableTemplate) {
            ((VpeToggableTemplate)((Object)template)).stopToggling(sourceElement);
        }
    }

    public boolean doToggle(nsIDOMNode visualNode) {
        Node sourceNode;
        nsIDOMElement selectedElem;
        if (visualNode == null) {
            return false;
        }
        nsIDOMElement visualElement = null;
        try {
            visualElement = (nsIDOMElement)visualNode.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
        }
        catch (XPCOMException xPCOMException) {
            visualElement = (nsIDOMElement)visualNode.getParentNode().queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
        }
        if (visualElement == null) {
            return false;
        }
        nsIDOMAttr toggleIdAttr = visualElement.getAttributeNode(VPE_USER_TOGGLE_ID);
        if (toggleIdAttr == null) {
            return false;
        }
        String toggleId = toggleIdAttr.getNodeValue();
        if (toggleId == null) {
            return false;
        }
        boolean toggleLookup = false;
        nsIDOMAttr toggleLookupAttr = visualElement.getAttributeNode(VPE_USER_TOGGLE_LOOKUP_PARENT);
        if (toggleLookupAttr != null) {
            toggleLookup = "true".equals(toggleLookupAttr.getNodeValue());
        }
        if ((selectedElem = this.getLastSelectedElement()) == null) {
            return false;
        }
        VpeElementMapping elementMapping = null;
        VpeNodeMapping nodeMapping = this.domMapping.getNodeMapping((nsIDOMNode)selectedElem);
        if (nodeMapping instanceof VpeElementMapping) {
            elementMapping = (VpeElementMapping)nodeMapping;
        }
        if (elementMapping == null) {
            while (!selectedElem.getNodeName().equals("table")) {
                selectedElem = (nsIDOMElement)selectedElem.getParentNode().queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
            }
            nodeMapping = this.domMapping.getNodeMapping((nsIDOMNode)selectedElem);
            if (nodeMapping instanceof VpeElementMapping) {
                elementMapping = (VpeElementMapping)nodeMapping;
            }
        }
        if ((sourceNode = this.domMapping.getSourceNode((nsIDOMNode)selectedElem)) == null) {
            return false;
        }
        Element sourceElement = (Element)(sourceNode instanceof Element ? sourceNode : sourceNode.getParentNode());
        toggleLookupAttr = selectedElem.getAttributeNode(VPE_USER_TOGGLE_LOOKUP_PARENT);
        if (toggleLookupAttr != null) {
            toggleLookup = "true".equals(toggleLookupAttr.getNodeValue());
        }
        if (elementMapping != null) {
            VpeTemplate template = elementMapping.getTemplate();
            while (toggleLookup && sourceElement != null && !(template instanceof VpeToggableTemplate)) {
                if ((sourceElement = (Element)sourceElement.getParentNode()) == null) break;
                nodeMapping = this.domMapping.getNodeMapping(sourceElement);
                if (nodeMapping instanceof VpeElementMapping) {
                    elementMapping = (VpeElementMapping)nodeMapping;
                }
                if (elementMapping == null) continue;
                template = elementMapping.getTemplate();
            }
            if (template instanceof VpeToggableTemplate) {
                ((VpeToggableTemplate)((Object)template)).toggle(this, sourceElement, toggleId);
                this.updateElement(sourceElement);
                return true;
            }
        }
        return false;
    }

    public void removeAttribute(Element sourceElement, String name) {
        VpeElementMapping elementMapping = (VpeElementMapping)this.domMapping.getNodeMapping(sourceElement);
        if (elementMapping != null) {
            this.updateElement(sourceElement);
        }
    }

    public void refreshBundleValues(Element sourceElement) {
        VpeElementMapping elementMapping = (VpeElementMapping)this.domMapping.getNodeMapping(sourceElement);
        if (elementMapping != null) {
            VpeTemplate template = elementMapping.getTemplate();
            template.refreshBundleValues(this.pageContext, sourceElement, elementMapping.getData());
        }
    }

    boolean isContentArea(nsIDOMNode visualNode) {
        return this.getContentArea().equals(visualNode);
    }

    public nsIDOMElement getContentArea() {
        return this.visualEditor.getContentArea();
    }

    public void setSelectionRectangle(nsIDOMNode visualElement) {
        this.setSelectionRectangle(visualElement, true);
    }

    void setSelectionRectangle(nsIDOMNode visualElement, boolean scroll) {
        int resizerConstrains = this.getResizerConstrains(visualElement);
        this.visualEditor.setSelectionRectangle(visualElement, resizerConstrains, scroll);
    }

    public nsIDOMNode addLinkNodeToHead(String href_val, String ext_val, boolean firstElement) {
        nsIDOMElement newNode = this.createLinkNode(href_val, ATTR_REL_STYLESHEET_VALUE, ext_val);
        if (firstElement) {
            nsIDOMNode firstNode = this.getHeadNode().getFirstChild();
            this.getHeadNode().insertBefore((nsIDOMNode)newNode, firstNode);
        } else {
            this.getHeadNode().appendChild((nsIDOMNode)newNode);
        }
        return newNode;
    }

    public nsIDOMNode replaceLinkNodeToHead(nsIDOMNode oldNode, String href_val, String ext_val) {
        nsIDOMElement newNode = this.createLinkNode(href_val, ATTR_REL_STYLESHEET_VALUE, ext_val);
        this.getHeadNode().replaceChild((nsIDOMNode)newNode, oldNode);
        return newNode;
    }

    public nsIDOMNode replaceLinkNodeToHead(String href_val, String ext_val, boolean firstElement) {
        nsIDOMNode newNode = null;
        nsIDOMNode oldNode = this.getLinkNode(href_val, ext_val);
        if (oldNode == null) {
            newNode = this.addLinkNodeToHead(href_val, ext_val, firstElement);
        }
        return newNode;
    }

    public void removeLinkNodeFromHead(nsIDOMNode node) {
        this.getHeadNode().removeChild(node);
    }

    private nsIDOMElement createLinkNode(String href_val, String rel_val, String ext_val) {
        nsIDOMElement linkNode = null;
        if (ATTR_REL_STYLESHEET_VALUE.equalsIgnoreCase(rel_val) && href_val.startsWith("file:")) {
            linkNode = this.getVisualDocument().createElement("style");
            linkNode.setAttribute(ATTR_VPE, ATTR_VPE_INLINE_LINK_VALUE);
            linkNode.setAttribute("href", href_val);
            linkNode.setAttribute("ext", ext_val);
            BufferedReader in = null;
            try {
                StringBuffer styleText = new StringBuffer(EMPTY_STRING);
                URL url = new URL(new Path(href_val).toOSString());
                String fileName = url.getFile();
                in = new BufferedReader(new FileReader(fileName));
                String str = EMPTY_STRING;
                while ((str = in.readLine()) != null) {
                    styleText.append(str);
                }
                String styleForParse = styleText.toString();
                styleForParse = VpeStyleUtil.addFullPathIntoURLValue(styleForParse, href_val);
                in.close();
                nsIDOMText textNode = this.getVisualDocument().createTextNode(styleForParse);
                linkNode.appendChild((nsIDOMNode)textNode);
                nsIDOMElement nsIDOMElement2 = linkNode;
                return nsIDOMElement2;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException ioe) {
                VpePlugin.getPluginLog().logError(ioe.getMessage(), (Throwable)ioe);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        VpePlugin.getPluginLog().logError((Throwable)e);
                    }
                }
            }
        }
        linkNode = this.getVisualDocument().createElement("link");
        linkNode.setAttribute("rel", rel_val);
        linkNode.setAttribute("href", href_val);
        linkNode.setAttribute("ext", ext_val);
        return linkNode;
    }

    private boolean isLinkReplacer(nsIDOMNode node) {
        return "style".equalsIgnoreCase(node.getNodeName()) && ATTR_VPE_INLINE_LINK_VALUE.equalsIgnoreCase(((nsIDOMElement)node.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}")).getAttribute(ATTR_VPE));
    }

    private nsIDOMNode getLinkNode(String href_val, String ext_val) {
        nsIDOMNodeList children = this.getHeadNode().getChildNodes();
        long len = children.getLength();
        long i = len - 1L;
        while (i >= 0L) {
            nsIDOMElement element;
            nsIDOMNode node = children.item(i);
            if (node.getNodeType() == 1 && ("link".equalsIgnoreCase(node.getNodeName()) || this.isLinkReplacer(node)) && ext_val.equalsIgnoreCase((element = (nsIDOMElement)node.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}")).getAttribute("ext")) && href_val.equalsIgnoreCase(element.getAttribute("href"))) {
                return node;
            }
            --i;
        }
        return null;
    }

    private void cleanHead() {
        if (this.getHeadNode() == null) {
            return;
        }
        nsIDOMNodeList children = this.getHeadNode().getChildNodes();
        long len = children.getLength();
        long i = len - 1L;
        while (i >= 0L) {
            nsIDOMNode node = children.item(i);
            if (node.getNodeType() == 1) {
                if (this.isLinkReplacer(node)) {
                    if (!YES_STRING.equalsIgnoreCase(((nsIDOMElement)node.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}")).getAttribute("ext"))) {
                        node = this.getHeadNode().removeChild(node);
                    }
                } else if ("style".equalsIgnoreCase(node.getNodeName()) && !YES_STRING.equalsIgnoreCase(((nsIDOMElement)node.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}")).getAttribute(ATTR_VPE))) {
                    node = this.getHeadNode().removeChild(node);
                }
            }
            --i;
        }
    }

    void showDragCaret(nsIDOMNode node, int offset) {
        this.xulRunnerEditor.showDragCaret(node, (long)offset);
    }

    void hideDragCaret() {
        this.xulRunnerEditor.hideDragCaret();
    }

    private int getResizerConstrains(nsIDOMNode visualNode) {
        VpeNodeMapping nodeMapping = this.domMapping.getNodeMapping(visualNode);
        if (nodeMapping != null && nodeMapping instanceof VpeElementMapping && nodeMapping.getSourceNode() instanceof Element && nodeMapping.getVisualNode().getNodeType() == 1) {
            return ((VpeElementMapping)nodeMapping).getTemplate().getTagDescription(this.pageContext, (Element)nodeMapping.getSourceNode(), this.getVisualDocument(), (nsIDOMElement)nodeMapping.getVisualNode().queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}"), ((VpeElementMapping)nodeMapping).getData()).getResizeConstrains();
        }
        return 0;
    }

    public void resize(nsIDOMElement element, int constrains, int top, int left, int width, int height) {
        VpeElementMapping elementMapping = (VpeElementMapping)this.domMapping.getNodeMapping((nsIDOMNode)element);
        if (elementMapping != null) {
            elementMapping.getTemplate().resize(this.pageContext, (Element)elementMapping.getSourceNode(), this.getVisualDocument(), element, elementMapping.getData(), constrains, top, left, width, height);
        }
    }

    static boolean isAnonElement(nsIDOMNode visualNode) {
        if (visualNode != null && visualNode.getNodeType() == 1) {
            String attrValue = ((nsIDOMElement)visualNode.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}")).getAttribute(MOZ_ANONCLASS_ATTR);
            return attrValue != null && attrValue.length() > 0;
        }
        return false;
    }

    boolean canInnerDrag(nsIDOMElement visualDragElement) {
        VpeElementMapping elementMapping;
        VpeNodeMapping node = this.domMapping.getNodeMapping((nsIDOMNode)visualDragElement);
        if (node instanceof VpeElementMapping && (elementMapping = (VpeElementMapping)node) != null && elementMapping.getSourceNode() instanceof Element) {
            return elementMapping.getTemplate().canInnerDrag(this.pageContext, (Element)elementMapping.getSourceNode(), this.getVisualDocument(), visualDragElement, elementMapping.getData());
        }
        return false;
    }

    VpeSourceInnerDropInfo getSourceInnerDropInfo(Node sourceDragNode, VpeVisualInnerDropInfo visualDropInfo, boolean checkParentTemplates) {
        nsIDOMNode visualDropContainer = visualDropInfo.getDropContainer();
        long visualDropOffset = visualDropInfo.getDropOffset();
        Node sourceDropContainer = null;
        int sourceDropOffset = 0;
        switch (visualDropContainer.getNodeType()) {
            case 1: {
                Node sourceOffsetNode;
                nsIDOMNode visualOffsetNode = null;
                boolean afterFlag = false;
                long visualChildCount = VisualDomUtil.getChildCount(visualDropContainer);
                if (visualDropOffset < visualChildCount) {
                    visualOffsetNode = VisualDomUtil.getChildNode(visualDropContainer, visualDropOffset);
                    if (VpeVisualDomBuilder.isPseudoElement(visualOffsetNode) || VpeVisualDomBuilder.isAnonElement(visualOffsetNode)) {
                        visualOffsetNode = VpeVisualDomBuilder.getLastAppreciableVisualChild(visualDropContainer);
                        afterFlag = true;
                    }
                } else {
                    visualOffsetNode = VpeVisualDomBuilder.getLastAppreciableVisualChild(visualDropContainer);
                    boolean bl = afterFlag = visualChildCount != 0L;
                }
                if (visualOffsetNode != null && (sourceOffsetNode = this.domMapping.getSourceNode(visualOffsetNode)) != null) {
                    sourceDropContainer = sourceOffsetNode.getParentNode();
                    sourceDropOffset = ((NodeImpl)sourceOffsetNode).getIndex();
                    if (afterFlag) {
                        ++sourceDropOffset;
                    }
                }
                if (sourceDropContainer == null && (sourceDropContainer = this.domMapping.getNearSourceNode(visualDropContainer)) != null) {
                    sourceDropOffset = sourceDropContainer.getChildNodes().getLength();
                }
                if (sourceDropContainer != null) break;
                sourceDropContainer = this.domMapping.getNearSourceNode((nsIDOMNode)this.getContentArea());
                sourceDropOffset = sourceDropContainer.getChildNodes().getLength();
                break;
            }
            case 3: {
                String[] atributeNames;
                VpeNodeMapping nodeMapping = this.domMapping.getNearNodeMapping(visualDropContainer);
                sourceDropContainer = nodeMapping.getSourceNode();
                sourceDropOffset = TextUtil.sourceInnerPosition(sourceDropContainer.getNodeValue(), visualDropOffset);
                if (this.isTextEditable(visualDropContainer) && (atributeNames = ((VpeElementMapping)nodeMapping).getTemplate().getOutputAttributeNames()) != null && atributeNames.length > 0) {
                    Element sourceElement = (Element)nodeMapping.getSourceNode();
                    sourceDropContainer = sourceElement.getAttributeNode(atributeNames[0]);
                    sourceDropOffset = TextUtil.sourceInnerPosition(sourceDropContainer.getNodeValue(), visualDropOffset);
                }
                nodeMapping.getVisualNode();
            }
        }
        if (sourceDropContainer != null) {
            return this.getSourceInnerDropInfo(sourceDragNode, sourceDropContainer, sourceDropOffset, checkParentTemplates);
        }
        return new VpeSourceInnerDropInfo(null, 0, false);
    }

    VpeSourceInnerDropInfo getSourceInnerDropInfo(Node dragNode, Node container, int offset, boolean checkParentsTemplates) {
        boolean canDrop = false;
        switch (container.getNodeType()) {
            case 1: {
                VpeNodeMapping nodeMapping = this.domMapping.getNodeMapping(container);
                if (nodeMapping != null && nodeMapping instanceof VpeElementMapping) {
                    canDrop = ((VpeElementMapping)nodeMapping).getTemplate().canInnerDrop(this.pageContext, container, dragNode);
                }
                if (canDrop) break;
                if (!checkParentsTemplates) {
                    return new VpeSourceInnerDropInfo(container, offset, canDrop);
                }
                return new VpeSourceInnerDropInfo(container, offset, canDrop);
            }
            case 3: 
            case 9: {
                canDrop = true;
                break;
            }
            case 2: {
                canDrop = true;
            }
        }
        if (canDrop) {
            return new VpeSourceInnerDropInfo(container, offset, canDrop);
        }
        return new VpeSourceInnerDropInfo(null, 0, canDrop);
    }

    public void innerDrop(Node dragNode, Node container, int offset) {
        VpeNodeMapping mapping = this.domMapping.getNearNodeMapping(container);
        if (mapping != null) {
            nsIDOMNode visualDropContainer = mapping.getVisualNode();
            nsIDOMNode visualParent = visualDropContainer.getParentNode();
            VpeNodeMapping oldMapping = mapping;
            mapping = this.domMapping.getNearNodeMapping(visualParent);
            if (mapping != null && mapping instanceof VpeElementMapping) {
                ((VpeElementMapping)mapping).getTemplate().innerDrop(this.pageContext, new VpeSourceInnerDragInfo(dragNode, 0, 0), new VpeSourceInnerDropInfo(container, offset, true));
            } else if (oldMapping instanceof VpeElementMapping) {
                ((VpeElementMapping)oldMapping).getTemplate().innerDrop(this.pageContext, new VpeSourceInnerDragInfo(dragNode, 0, 0), new VpeSourceInnerDropInfo(container, offset, true));
            }
        }
    }

    void innerDrop(VpeSourceInnerDragInfo dragInfo, VpeSourceInnerDropInfo dropInfo) {
        this.dropper.drop(this.pageContext, dragInfo, dropInfo);
    }

    nsIDOMElement getNearDragElement(Element visualElement) {
        VpeElementMapping elementMapping = this.domMapping.getNearElementMapping(visualElement);
        while (elementMapping != null) {
            if (this.canInnerDrag(elementMapping.getVisualElement())) {
                return elementMapping.getVisualElement();
            }
            elementMapping = this.domMapping.getNearElementMapping(elementMapping.getVisualNode().getParentNode());
        }
        return null;
    }

    nsIDOMElement getDragElement(nsIDOMElement visualElement) {
        VpeElementMapping elementMapping = this.domMapping.getNearElementMapping((nsIDOMNode)visualElement);
        if (elementMapping != null && this.canInnerDrag(elementMapping.getVisualElement())) {
            return elementMapping.getVisualElement();
        }
        return null;
    }

    public boolean isTextEditable(nsIDOMNode visualNode) {
        nsIDOMNode parent;
        if (visualNode != null && (parent = visualNode.getParentNode()) != null && parent.getNodeType() == 1) {
            String classValue;
            nsIDOMAttr classAttr;
            nsIDOMElement element = (nsIDOMElement)parent.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
            nsIDOMAttr style = element.getAttributeNode("style");
            if (style != null) {
                String styleValue = style.getNodeValue();
                String[] items = styleValue.split(";");
                int i = 0;
                while (i < items.length) {
                    String[] item = items[i].split(":");
                    if ("-moz-user-modify".equals(item[0].trim()) && "read-only".equals(item[1].trim())) {
                        return false;
                    }
                    ++i;
                }
            }
            if ((classAttr = element.getAttributeNode("class")) != null && "__any__tag__caption".equals(classValue = classAttr.getNodeValue().trim())) {
                return false;
            }
        }
        return true;
    }

    VpeVisualInnerDropInfo getInnerDropInfo(Node sourceDropContainer, int sourceDropOffset) {
        nsIDOMNode visualDropContainer = null;
        long visualDropOffset = 0L;
        switch (sourceDropContainer.getNodeType()) {
            case 3: {
                visualDropContainer = this.domMapping.getVisualNode(sourceDropContainer);
                visualDropOffset = TextUtil.visualInnerPosition(sourceDropContainer.getNodeValue(), sourceDropOffset);
                break;
            }
            case 1: 
            case 9: {
                Node sourceChild;
                nsIDOMNode visualChild;
                NodeList sourceChildren = sourceDropContainer.getChildNodes();
                if (sourceDropOffset < sourceChildren.getLength() && (visualChild = this.domMapping.getVisualNode(sourceChild = sourceChildren.item(sourceDropOffset))) != null) {
                    visualDropContainer = visualChild.getParentNode();
                    visualDropOffset = VisualDomUtil.getOffset(visualChild);
                }
                if (visualDropContainer != null) break;
                visualDropContainer = this.domMapping.getNearVisualNode(sourceDropContainer);
                nsIDOMNode visualChild2 = VpeVisualDomBuilder.getLastAppreciableVisualChild(visualDropContainer);
                if (visualChild2 != null) {
                    visualDropOffset = VisualDomUtil.getOffset(visualChild2) + 1L;
                    break;
                }
                visualDropOffset = 0L;
                break;
            }
            case 2: {
                Element sourceElement = ((Attr)sourceDropContainer).getOwnerElement();
                VpeElementMapping elementMapping = this.domMapping.getNearElementMapping(sourceElement);
                nsIDOMText textNode = elementMapping.getTemplate().getOutputTextNode(this.pageContext, sourceElement, elementMapping.getData());
                if (textNode == null) break;
                visualDropContainer = textNode;
                visualDropOffset = TextUtil.visualInnerPosition(sourceDropContainer.getNodeValue(), sourceDropOffset);
            }
        }
        if (visualDropContainer == null) {
            return null;
        }
        return new VpeVisualInnerDropInfo(visualDropContainer, visualDropOffset, 0, 0);
    }

    protected void setTooltip(Element sourceElement, nsIDOMElement visualElement) {
        if (visualElement != null && sourceElement != null && !((IDOMElement)sourceElement).isJSPTag()) {
            if ("html".equalsIgnoreCase(sourceElement.getNodeName())) {
                return;
            }
            String titleValue = this.getTooltip(sourceElement);
            if (titleValue != null) {
                titleValue = titleValue.replaceAll("&", "&amp;");
                titleValue = titleValue.replaceAll("<", "&lt;");
                titleValue = titleValue.replaceAll(">", "&gt;");
            }
            if (titleValue != null) {
                this.setTooltip(visualElement, titleValue);
            }
        }
    }

    protected void setTooltip(nsIDOMElement visualElement, String titleValue) {
        visualElement.setAttribute("title", titleValue);
        nsIDOMNodeList children = visualElement.getChildNodes();
        long len = children.getLength();
        long i = 0L;
        while (i < len) {
            nsIDOMNode child = children.item(i);
            if (child.getNodeType() == 1) {
                this.setTooltip((nsIDOMElement)child.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}"), titleValue);
            }
            ++i;
        }
    }

    private void resetTooltip(nsIDOMElement visualElement, String titleValue) {
        visualElement.setAttribute("title", titleValue);
        nsIDOMNodeList children = visualElement.getChildNodes();
        long len = children.getLength();
        long i = 0L;
        while (i < len) {
            nsIDOMNode child = children.item(i);
            if (child.getNodeType() == 1 && this.domMapping.getNodeMapping(child) == null) {
                this.resetTooltip((nsIDOMElement)child.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}"), titleValue);
            }
            ++i;
        }
    }

    private String getTooltip(Element sourceElement) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(sourceElement.getNodeName());
        NamedNodeMap attrs = sourceElement.getAttributes();
        int len = attrs.getLength();
        int i = 0;
        while (i < len) {
            if (i == 7) {
                return buffer.append("\n\t... ").toString();
            }
            int valueLength = attrs.item(i).getNodeValue().length();
            if (valueLength > 30) {
                StringBuffer temp = new StringBuffer();
                temp.append(String.valueOf(attrs.item(i).getNodeValue().substring(0, 15)) + " ... " + attrs.item(i).getNodeValue().substring(valueLength - 15, valueLength));
                buffer.append("\n" + attrs.item(i).getNodeName() + ": " + temp);
            } else {
                buffer.append("\n" + attrs.item(i).getNodeName() + ": " + attrs.item(i).getNodeValue());
            }
            ++i;
        }
        return buffer.toString();
    }

    Rectangle getNodeBounds(nsIDOMNode visualNode) {
        return XulRunnerVpeUtils.getElementBounds((nsIDOMNode)visualNode);
    }

    static boolean canInsertAfter(int x, int y, Rectangle rect) {
        if (y > rect.y + rect.height || x > rect.x + rect.width) {
            return true;
        }
        return y >= rect.x && x > rect.x + rect.width / 2;
    }

    static nsIDOMNode getLastAppreciableVisualChild(nsIDOMNode visualParent) {
        nsIDOMNode visualLastChild = null;
        nsIDOMNodeList visualChildren = visualParent.getChildNodes();
        long len = visualChildren.getLength();
        long i = len - 1L;
        while (i >= 0L) {
            nsIDOMNode visualChild = visualChildren.item(i);
            if (!VpeVisualDomBuilder.isPseudoElement(visualChild) && !VpeVisualDomBuilder.isAnonElement(visualChild)) {
                visualLastChild = visualChild;
                break;
            }
            --i;
        }
        return visualLastChild;
    }

    void correctVisualDropPosition(VpeVisualInnerDropInfo newVisualDropInfo, VpeVisualInnerDropInfo oldVisualDropInfo) {
        nsIDOMNode oldVisualDropContainer;
        nsIDOMNode newVisualDropContainer = newVisualDropInfo.getDropContainer();
        if (newVisualDropContainer.equals(oldVisualDropContainer = oldVisualDropInfo.getDropContainer())) {
            newVisualDropInfo.setDropOffset(oldVisualDropInfo.getDropOffset());
            return;
        }
        nsIDOMNode child = oldVisualDropContainer;
        while (child != null && child.getNodeType() != 9) {
            nsIDOMNode parent = child.getParentNode();
            if (newVisualDropContainer.equals(parent)) {
                long offset = VisualDomUtil.getOffset(child);
                Rectangle rect = this.getNodeBounds(child);
                if (VpeVisualDomBuilder.canInsertAfter(oldVisualDropInfo.getMouseX(), oldVisualDropInfo.getMouseY(), rect)) {
                    ++offset;
                }
                newVisualDropInfo.setDropOffset(offset);
            }
            child = parent;
        }
    }

    public nsIDOMRange createDOMRange() {
        return this.xulRunnerEditor.createDOMRange();
    }

    public nsIDOMRange createDOMRange(nsIDOMNode selectedNode) {
        nsIDOMRange range = this.createDOMRange();
        range.selectNode(selectedNode);
        return range;
    }

    public static boolean isIncludeElement(nsIDOMElement visualElement) {
        return YES_STRING.equalsIgnoreCase(visualElement.getAttribute(INCLUDE_ELEMENT_ATTR));
    }

    public static void markIncludeElement(nsIDOMElement visualElement) {
        visualElement.setAttribute(INCLUDE_ELEMENT_ATTR, YES_STRING);
    }

    protected void setReadOnlyElement(nsIDOMElement node) {
        String style = node.getAttribute("style");
        style = VpeStyleUtil.setParameterInStyle(style, "-moz-user-modify", "read-only");
        node.setAttribute("style", style);
    }

    private void showMoveCursor(boolean show) {
        nsIDOMHTMLDocument document = (nsIDOMHTMLDocument)this.xulRunnerEditor.getDOMDocument().queryInterface("{a6cf9084-15b3-11d2-932e-00805f8add32}");
        nsIDOMElement moveStyle = document.getElementById(CURSOR_MOVE_STYLE_ID);
        if (show && moveStyle == null) {
            moveStyle = document.createElement("style");
            moveStyle.setAttribute("id", CURSOR_MOVE_STYLE_ID);
            nsIDOMText selector = document.createTextNode(CURSOR_MOVE_SELECTOR);
            moveStyle.appendChild((nsIDOMNode)selector);
            document.getBody().appendChild((nsIDOMNode)moveStyle);
        } else if (!show && moveStyle != null) {
            moveStyle.getParentNode().removeChild((nsIDOMNode)moveStyle);
        }
    }

    void setMoveCursor(nsIDOMMouseEvent mouseEvent) {
        nsIDOMElement selectedElement = this.xulRunnerEditor.getLastSelectedElement();
        if (selectedElement != null && this.canInnerDrag(selectedElement) && VpeVisualDomBuilder.inDragArea(this.getNodeBounds((nsIDOMNode)selectedElement), VisualDomUtil.getMousePoint(mouseEvent))) {
            this.showMoveCursor(true);
        } else {
            this.showMoveCursor(false);
        }
    }

    public static boolean inDragArea(Rectangle dragArea, Point mousePoint) {
        return dragArea.contains(mousePoint) && mousePoint.x < dragArea.x + 10 && mousePoint.y < dragArea.y + 10;
    }

    nsIDOMElement getDragElement(nsIDOMMouseEvent mouseEvent) {
        nsIDOMElement selectedElement = this.xulRunnerEditor.getLastSelectedElement();
        if (selectedElement != null && this.canInnerDrag(selectedElement) && VpeVisualDomBuilder.inDragArea(this.getNodeBounds((nsIDOMNode)selectedElement), VisualDomUtil.getMousePoint(mouseEvent))) {
            return selectedElement;
        }
        return null;
    }

    VpeSourceInnerDragInfo getSourceInnerDragInfo(VpeVisualInnerDragInfo visualDragInfo) {
        nsIDOMNode visualNode = visualDragInfo.getNode();
        int offset = visualDragInfo.getOffset();
        int length = visualDragInfo.getLength();
        VpeNodeMapping nodeMapping = this.domMapping.getNearNodeMapping(visualNode);
        Node sourceNode = nodeMapping.getSourceNode();
        if (sourceNode != null) {
            switch (sourceNode.getNodeType()) {
                case 3: {
                    int end = TextUtil.sourceInnerPosition(visualNode.getNodeValue(), offset + length);
                    offset = TextUtil.sourceInnerPosition(visualNode.getNodeValue(), offset);
                    length = end - offset;
                    break;
                }
                case 1: {
                    String[] atributeNames;
                    if (visualNode.getNodeType() != 3) break;
                    sourceNode = null;
                    if (!this.isTextEditable(visualNode) || (atributeNames = ((VpeElementMapping)nodeMapping).getTemplate().getOutputAttributeNames()) == null || atributeNames.length <= 0) break;
                    Element sourceElement = (Element)nodeMapping.getSourceNode();
                    sourceNode = sourceElement.getAttributeNode(atributeNames[0]);
                    int end = TextUtil.sourceInnerPosition(visualNode.getNodeValue(), offset + length);
                    offset = TextUtil.sourceInnerPosition(visualNode.getNodeValue(), offset);
                    length = end - offset;
                }
            }
        }
        return new VpeSourceInnerDragInfo(sourceNode, offset, length);
    }

    public nsIDOMText getOutputTextNode(Attr attr) {
        Element sourceElement = attr.getOwnerElement();
        VpeElementMapping elementMapping = this.domMapping.getNearElementMapping(sourceElement);
        if (elementMapping != null) {
            return elementMapping.getTemplate().getOutputTextNode(this.pageContext, sourceElement, elementMapping.getData());
        }
        return null;
    }

    nsIDOMElement getLastSelectedElement() {
        return this.xulRunnerEditor.getLastSelectedElement();
    }

    public void pushIncludeStack(VpeIncludeInfo includeInfo) {
        this.includeStack.add(includeInfo);
    }

    public VpeIncludeInfo popIncludeStack() {
        VpeIncludeInfo includeInfo = null;
        if (this.includeStack.size() > 0) {
            includeInfo = (VpeIncludeInfo)this.includeStack.remove(this.includeStack.size() - 1);
        }
        return includeInfo;
    }

    public boolean isFileInIncludeStack(IStorage file) {
        if (file == null) {
            return false;
        }
        int i = 0;
        while (i < this.includeStack.size()) {
            if (file.equals(((VpeIncludeInfo)this.includeStack.get(i)).getStorage())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isCurrentMainDocument() {
        return this.includeStack.size() <= 1;
    }

    public int getCurrentMainIncludeOffset() {
        if (this.includeStack.size() <= 1) {
            return -1;
        }
        VpeIncludeInfo info = (VpeIncludeInfo)this.includeStack.get(1);
        return ((IndexedRegion)info.getElement()).getStartOffset();
    }

    public VpeIncludeInfo getCurrentIncludeInfo() {
        if (this.includeStack.size() <= 0) {
            return null;
        }
        return (VpeIncludeInfo)this.includeStack.get(this.includeStack.size() - 1);
    }

    public VpeIncludeInfo getRootIncludeInfo() {
        if (this.includeStack.size() <= 1) {
            return null;
        }
        return (VpeIncludeInfo)this.includeStack.get(1);
    }

    @Override
    public void dispose() {
        this.clearIncludeDocuments();
        this.includeDocuments = null;
        this.cleanHead();
        this.domMapping.clear((nsIDOMNode)this.getContentArea());
        this.pageContext.dispose();
        super.dispose();
    }

    private void clearIncludeDocuments() {
        Collection<Document> documents = this.includeDocuments.values();
        for (Document document : documents) {
            VpeCreatorUtil.releaseDocumentFromRead(document);
        }
        this.includeDocuments.clear();
    }

    public VpeDnD getDnd() {
        return this.dnd;
    }

    public void setDnd(VpeDnD dnd) {
        this.dnd = dnd;
    }

    protected VpePageContext getPageContext() {
        return this.pageContext;
    }

    protected void setPageContext(VpePageContext pageContext) {
        this.pageContext = pageContext;
    }

    protected nsIDOMDocument getVisualDocument() {
        return this.visualEditor.getDomDocument();
    }

    private boolean isFacelet(Node sourceNode) {
        String sourceNodeUri;
        List<TaglibData> taglibs;
        boolean isFacelet = false;
        String sourcePrefix = sourceNode.getPrefix();
        TaglibData sourceNodeTaglib = XmlUtil.getTaglibForPrefix(sourcePrefix, taglibs = XmlUtil.getTaglibsForNode(sourceNode, this.pageContext));
        if (sourceNodeTaglib != null && VisualDomUtil.FACELETS_URI.equalsIgnoreCase(sourceNodeUri = sourceNodeTaglib.getUri())) {
            isFacelet = true;
        }
        return isFacelet;
    }

    public XulRunnerEditor getXulRunnerEditor() {
        return this.xulRunnerEditor;
    }

    public void setXulRunnerEditor(XulRunnerEditor xulRunnerEditor) {
        this.xulRunnerEditor = xulRunnerEditor;
    }

    public Map<IStorage, Document> getIncludeDocuments() {
        return this.includeDocuments;
    }

    public nsIDOMNode getHeadNode() {
        return this.visualEditor.getHeadNode();
    }

    public boolean isShowInvisibleTags() {
        return this.showInvisibleTags;
    }

    public void setShowInvisibleTags(boolean showInvisibleTags) {
        this.showInvisibleTags = showInvisibleTags;
    }

    public boolean isShowBorderForUnknownTags() {
        return this.showBorderForUnknownTags;
    }

    public void setShowBorderForUnknownTags(boolean showBorderForUnknownTags) {
        this.showBorderForUnknownTags = showBorderForUnknownTags;
    }

    public nsIDOMNode createInvisbleElementLabel(Node sourceNode) {
        nsIDOMElement span = this.getVisualDocument().createElement("span");
        span.setAttribute("style", "border: 1px dashed GREY; color: GREY; font-size: 12px;");
        nsIDOMText text = this.getVisualDocument().createTextNode(sourceNode.getNodeName());
        span.appendChild((nsIDOMNode)text);
        return span;
    }

    private static class PseudoInfo {
        private nsIDOMNode pseudoNode;
        private boolean isElements;

        private PseudoInfo() {
            this(null, false);
        }

        private PseudoInfo(nsIDOMNode pseudoNode, boolean isElements) {
            this.pseudoNode = pseudoNode;
            this.isElements = isElements;
        }
    }
}

