/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.dnd.context;

import java.util.Collection;
import java.util.Vector;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.tools.common.model.ui.editors.dnd.context.DropContext;
import org.jboss.tools.common.model.ui.editors.dnd.context.IDNDTextEditor;
import org.jboss.tools.common.model.ui.editors.dnd.context.InnerDragBuffer;
import org.jboss.tools.jst.jsp.editor.IJSPTextEditor;
import org.jboss.tools.vpe.editor.dnd.context.xpl.DragNodeCommand2;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class VpeDragAnyCommand
extends DragNodeCommand2 {
    IJSPTextEditor editor;
    DropContext dropContext;

    public VpeDragAnyCommand(IJSPTextEditor editor, Object target, float location, int operations, int operation, Collection sources, DropContext dropContext) {
        super(target, location, operations, operation, sources, null);
        this.editor = editor;
        this.dropContext = dropContext;
        this.operation = !this.canExecute() ? 0 : operation;
    }

    public boolean executeHelper(boolean testOnly) {
        boolean result = true;
        if (this.target instanceof Node) {
            boolean performBatchUpdate;
            Node targetNode = (Node)this.target;
            Node parentNode = this.getParentForDropPosition(targetNode);
            Node refChild = this.getRefChild(targetNode);
            Vector sourcesList = new Vector();
            sourcesList.addAll(this.sources);
            boolean bl = performBatchUpdate = sourcesList.size() > 5;
            if (!testOnly) {
                this.beginModelChange(targetNode, performBatchUpdate);
            }
            if (sourcesList.size() > 0) {
                result = refChild != null || !(targetNode instanceof Attr) ? this.doMove(parentNode, refChild, testOnly) : false;
            }
            if (!testOnly) {
                this.endModelChange(targetNode, performBatchUpdate);
            }
        } else {
            result = false;
        }
        return result;
    }

    public boolean doMove(Node parentNode, Node refChild, boolean testOnly) {
        if (testOnly) {
            return this.editor != null && this.editor.isEditable() && this.dropContext.getFlavor() != null;
        }
        if (InnerDragBuffer.object instanceof Node && this.editor instanceof IJSPTextEditor) {
            int offset = 0;
            if (refChild instanceof NodeImpl) {
                offset = ((NodeImpl)refChild).getIndex();
            }
            this.editor.getVPEController().drop((Node)InnerDragBuffer.object, parentNode, offset);
            InnerDragBuffer.object = null;
        } else {
            int pos = this.getDropPosition(parentNode, refChild);
            this.editor.selectAndReveal(pos, 0);
            this.dropContext.runDropCommand((IDNDTextEditor)this.editor);
        }
        return true;
    }

    private int getDropPosition(Node parentNode, Node refChild) {
        IDOMElement n;
        int i;
        IDOMNode p = (IDOMNode)parentNode;
        IDOMNode c = (IDOMNode)refChild;
        if (c != null) {
            return c.getStartOffset();
        }
        if (p instanceof IDOMElement && (i = (n = (IDOMElement)p).getStartEndOffset()) >= 0) {
            return i;
        }
        NodeList list = p.getChildNodes();
        if (list.getLength() == 0) {
            return p.getStartOffset();
        }
        i = 0;
        while (i < list.getLength()) {
            if (list.item(i) instanceof IDOMNode) {
                c = (IDOMNode)list.item(i);
                return c.getStartOffset();
            }
            ++i;
        }
        return p.getStartOffset();
    }
}

