/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.mapping;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.VpeElementMapping;
import org.jboss.tools.vpe.editor.mapping.VpeNodeMapping;
import org.jboss.tools.vpe.xulrunner.editor.XulRunnerEditor;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VpeDomMapping {
    private Map<Node, VpeNodeMapping> sourceMap = new HashMap<Node, VpeNodeMapping>();
    private Map<nsIDOMNode, VpeNodeMapping> visualMap = new HashMap<nsIDOMNode, VpeNodeMapping>();
    private VpePageContext pageContext;

    public VpeDomMapping(VpePageContext pageContext) {
        this.pageContext = pageContext;
    }

    public void mapNodes(VpeNodeMapping nodeMapping) {
        this.sourceMap.put(nodeMapping.getSourceNode(), nodeMapping);
        if (nodeMapping.getVisualNode() != null) {
            this.visualMap.put(nodeMapping.getVisualNode(), nodeMapping);
            if (nodeMapping instanceof VpeElementMapping && ((VpeElementMapping)nodeMapping).getBorder() != null) {
                this.visualMap.put((nsIDOMNode)((VpeElementMapping)nodeMapping).getBorder(), nodeMapping);
            }
        }
    }

    public void clear(nsIDOMNode except) {
        Set<Map.Entry<nsIDOMNode, VpeNodeMapping>> entrySet = this.visualMap.entrySet();
        Iterator<Map.Entry<nsIDOMNode, VpeNodeMapping>> iter = entrySet.iterator();
        while (iter.hasNext()) {
            Map.Entry<nsIDOMNode, VpeNodeMapping> entry = iter.next();
            nsIDOMNode visualNode = entry.getKey();
            if (visualNode.equals(except)) continue;
            iter.remove();
        }
        this.sourceMap.clear();
    }

    public VpeNodeMapping getNodeMapping(Node node) {
        return this.getNodeMappingAtSourceNode(node);
    }

    public VpeNodeMapping getNodeMapping(nsIDOMNode node) {
        return this.getNodeMappingAtVisualNode(node);
    }

    public VpeNodeMapping getNodeMappingAtSourceNode(Node sourceNode) {
        if (sourceNode != null) {
            return this.sourceMap.get(sourceNode);
        }
        return null;
    }

    public VpeNodeMapping getNodeMappingAtVisualNode(nsIDOMNode visualNode) {
        for (Map.Entry<nsIDOMNode, VpeNodeMapping> element : this.visualMap.entrySet()) {
            nsIDOMNode key = element.getKey();
            if (visualNode == null || !visualNode.equals(key)) continue;
            return element.getValue();
        }
        return null;
    }

    public nsIDOMNode getVisualNode(Node sourceNode) {
        VpeNodeMapping nodeMapping = this.getNodeMapping(sourceNode);
        if (nodeMapping != null) {
            return nodeMapping.getVisualNode();
        }
        return null;
    }

    public Node getSourceNode(nsIDOMNode visualNode) {
        VpeNodeMapping nodeMapping = this.getNodeMapping(visualNode);
        if (nodeMapping != null) {
            return nodeMapping.getSourceNode();
        }
        return null;
    }

    public VpeNodeMapping getNearNodeMapping(Node node) {
        return this.getNearNodeMappingAtSourceNode(node);
    }

    public VpeNodeMapping getNearNodeMapping(nsIDOMNode node) {
        return this.getNearNodeMappingAtVisualNode(node);
    }

    public VpeNodeMapping getNearNodeMappingAtSourceNode(Node sourceNode) {
        nsIDOMElement visualElement;
        nsIDOMNode nearVisualNode;
        VpeNodeMapping nodeMapping = this.getNodeMappingAtSourceNode(sourceNode);
        if (nodeMapping != null && sourceNode != null && nodeMapping != null && (nearVisualNode = nodeMapping.getVisualNode()) instanceof nsIDOMElement) {
            visualElement = (nsIDOMElement)nearVisualNode;
            visualElement.removeAttribute(XulRunnerEditor.VPEFLASHERCOLORATTRIBUTE);
        }
        while (sourceNode != null && nodeMapping == null) {
            sourceNode = sourceNode.getParentNode();
            nodeMapping = this.getNodeMappingAtSourceNode(sourceNode);
            if (sourceNode == null || nodeMapping == null || !((nearVisualNode = nodeMapping.getVisualNode()) instanceof nsIDOMElement)) continue;
            visualElement = (nsIDOMElement)nearVisualNode;
            visualElement.setAttribute(XulRunnerEditor.VPEFLASHERCOLORATTRIBUTE, "#ff0000");
        }
        return nodeMapping;
    }

    public VpeNodeMapping getNearNodeMappingAtVisualNode(nsIDOMNode visualNode) {
        VpeNodeMapping nodeMapping = this.getNodeMappingAtVisualNode(visualNode);
        while (visualNode != null && nodeMapping == null) {
            visualNode = visualNode.getParentNode();
            nodeMapping = this.getNodeMappingAtVisualNode(visualNode);
        }
        return nodeMapping;
    }

    public VpeNodeMapping getNearParentMapping(Node sourceNode) {
        VpeNodeMapping nodeMapping = null;
        if (sourceNode.getNodeType() == 1) {
            nodeMapping = this.getNearNodeMapping(sourceNode);
        } else if (sourceNode.getNodeType() == 3) {
            sourceNode = sourceNode.getParentNode();
            nodeMapping = this.getNodeMapping(sourceNode);
            while (sourceNode != null && sourceNode.getNodeType() != 9 && nodeMapping == null) {
                sourceNode = sourceNode.getParentNode();
                nodeMapping = this.getNodeMapping(sourceNode);
            }
        }
        return nodeMapping;
    }

    public VpeNodeMapping getParentMapping(Node sourceNode) {
        VpeNodeMapping nodeMapping = null;
        sourceNode = sourceNode.getParentNode();
        nodeMapping = this.getNodeMapping(sourceNode);
        while (sourceNode != null && sourceNode.getNodeType() != 9 && nodeMapping == null) {
            sourceNode = sourceNode.getParentNode();
            nodeMapping = this.getNodeMapping(sourceNode);
        }
        return nodeMapping;
    }

    public VpeElementMapping getNearElementMapping(Node node) {
        return this.getNearElementMappingAtSourceNode(node);
    }

    public VpeElementMapping getNearElementMapping(nsIDOMNode node) {
        return this.getNearElementMappingAtVisualNode(node);
    }

    public VpeElementMapping getNearElementMappingAtSourceNode(Node sourceNode) {
        VpeNodeMapping nodeMapping = this.getNearNodeMappingAtSourceNode(sourceNode);
        if (nodeMapping != null) {
            if (nodeMapping instanceof VpeElementMapping) {
                return (VpeElementMapping)nodeMapping;
            }
            return this.getNearElementMappingAtSourceNode(nodeMapping.getSourceNode().getParentNode());
        }
        return null;
    }

    public VpeElementMapping getNearElementMappingAtVisualNode(nsIDOMNode visualNode) {
        VpeNodeMapping nodeMapping = this.getNearNodeMappingAtVisualNode(visualNode);
        if (nodeMapping != null) {
            if (nodeMapping instanceof VpeElementMapping) {
                return (VpeElementMapping)nodeMapping;
            }
            return this.getNearElementMappingAtSourceNode(nodeMapping.getSourceNode().getParentNode());
        }
        return null;
    }

    public nsIDOMNode getNearVisualNode_(Node sourceNode) {
        VpeNodeMapping nodeMapping = this.getNearNodeMapping(sourceNode);
        if (nodeMapping != null) {
            return nodeMapping.getVisualNode();
        }
        return null;
    }

    public nsIDOMNode getNearVisualNode(Node sourceNode) {
        if (sourceNode == null) {
            return null;
        }
        VpeNodeMapping nodeMapping = this.getNearNodeMappingAtSourceNode(sourceNode);
        if (nodeMapping != null) {
            if (nodeMapping.getVisualNode() == null) {
                return this.getNearVisualNode(sourceNode.getParentNode());
            }
            return nodeMapping.getVisualNode();
        }
        return null;
    }

    public Node getNearSourceNode(nsIDOMNode visualNode) {
        VpeNodeMapping nodeMapping = this.getNearNodeMapping(visualNode);
        if (nodeMapping != null) {
            return nodeMapping.getSourceNode();
        }
        return null;
    }

    public nsIDOMNode remove(Node sourceNode) {
        nsIDOMNode visualNode = this.getVisualNode(sourceNode);
        this.removeImpl(sourceNode);
        return visualNode;
    }

    public void removeChildren(Node sourceNode) {
        NodeList sourceChildren = sourceNode.getChildNodes();
        if (sourceChildren != null) {
            int len = sourceChildren.getLength();
            int i = 0;
            while (i < len) {
                this.removeImpl(sourceChildren.item(i));
                ++i;
            }
        }
    }

    private VpeNodeMapping removeImpl(Node sourceNode) {
        nsIDOMNode visualNode = null;
        VpeNodeMapping nodeMapping = this.sourceMap.remove(sourceNode);
        if (nodeMapping != null) {
            visualNode = nodeMapping.getVisualNode();
            if (visualNode != null) {
                this.visualMap.remove(visualNode);
            }
            if (nodeMapping instanceof VpeElementMapping) {
                VpeElementMapping elementMapping = (VpeElementMapping)nodeMapping;
                if (elementMapping.getBorder() != null) {
                    this.visualMap.remove(elementMapping.getBorder());
                }
                elementMapping.getTemplate().beforeRemove(this.pageContext, elementMapping.getSourceNode(), elementMapping.getVisualNode(), elementMapping.getData());
            }
        }
        this.removeChildren(sourceNode);
        return nodeMapping;
    }

    public void printMapping() {
        nsIDOMNode visualNode;
        Node sourceNode;
        VpeNodeMapping nodeMapping;
        System.out.println("Source DOM Mapping ------------------------------------");
        Set<Map.Entry<Node, VpeNodeMapping>> entrySet = this.sourceMap.entrySet();
        for (Map.Entry<Node, VpeNodeMapping> entry : entrySet) {
            nodeMapping = entry.getValue();
            sourceNode = nodeMapping.getSourceNode();
            visualNode = nodeMapping.getVisualNode();
            System.out.println("sourceNode: " + sourceNode.getNodeName() + " (" + sourceNode.hashCode() + ")    visualNode: " + (visualNode != null ? String.valueOf(visualNode.getNodeName()) + " (" + visualNode.hashCode() + ")" : null));
        }
        System.out.println("Visual DOM Mapping ------------------------------------");
        entrySet = this.visualMap.entrySet();
        for (Map.Entry<Node, VpeNodeMapping> entry : entrySet) {
            nodeMapping = entry.getValue();
            sourceNode = nodeMapping.getSourceNode();
            visualNode = nodeMapping.getVisualNode();
            System.out.println("sourceNode: " + (sourceNode != null ? String.valueOf(sourceNode.getNodeName()) + " (" + sourceNode.hashCode() + ")" : null) + "    visualNode: " + visualNode.getNodeName() + " (" + visualNode.hashCode() + ")");
        }
    }

    public Map<nsIDOMNode, VpeNodeMapping> getVisualMap() {
        return this.visualMap;
    }

    public Map<Node, VpeNodeMapping> getSourceMap() {
        return this.sourceMap;
    }
}

