/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.menu;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMDescriptionBuilder;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMContentBuilder;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMContentBuilderImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMNamespaceHelper;
import org.eclipse.wst.xml.ui.internal.actions.EditDoctypeAction;
import org.eclipse.wst.xml.ui.internal.actions.NodeAction;
import org.eclipse.wst.xml.ui.internal.util.XMLCommonResources;
import org.jboss.tools.vpe.editor.menu.BaseActionManager;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public abstract class AbstractActionManager
extends BaseActionManager {
    protected Viewer viewer;

    public AbstractActionManager(IStructuredModel model, ModelQuery modelQuery, Viewer viewer) {
        super(model, modelQuery);
        this.viewer = viewer;
    }

    public abstract void reformat(Node var1, boolean var2);

    protected Action createAddAttributeAction(Element parent, CMAttributeDeclaration ad) {
        return null;
    }

    protected Action createAddCDataSectionAction(Node parent, int index) {
        return new AddNodeAction(4, parent, index);
    }

    protected Action createAddPCDataAction(Node parent, CMDataType dataType, int index) {
        AddNodeAction action = null;
        action = dataType == null ? new AddNodeAction(3, parent, index) : new AddNodeAction((CMNode)dataType, parent, index);
        return action;
    }

    protected Action createAddCommentAction(Node parent, int index) {
        return new AddNodeAction(8, parent, index);
    }

    protected Action createAddDoctypeAction(Document document, int index) {
        return new EditDoctypeAction(this.model, document, this.model.getBaseLocation(), XMLCommonResources.getInstance().getString("_UI_MENU_ADD_DTD_INFORMATION"));
    }

    protected Action createAddElementAction(Node parent, CMElementDeclaration ed, int index, int type) {
        AddNodeAction action = null;
        if (ed == null) {
            return null;
        }
        action = new AddNodeAction((CMNode)ed, parent, index, type);
        return action;
    }

    protected Action createAddProcessingInstructionAction(Node parent, int index) {
        return null;
    }

    protected Action createAddSchemaInfoAction(Element element) {
        return null;
    }

    protected Action createEditAttributeAction(Attr attr, CMAttributeDeclaration ad) {
        return null;
    }

    protected Action createEditDoctypeAction(DocumentType doctype) {
        return new EditDoctypeAction(this.model, doctype, this.model.getBaseLocation(), XMLCommonResources.getInstance().getString("_UI_MENU_EDIT_DOCTYPE"));
    }

    protected Action createEditProcessingInstructionAction(ProcessingInstruction pi) {
        return null;
    }

    protected Action createEditSchemaInfoAction(Element element) {
        return null;
    }

    protected Action createRenameAction(Node node) {
        Action result = null;
        return result;
    }

    protected Action createReplaceAction(Node parent, CMNode cmnode, int startIndex, int endIndex) {
        return new ReplaceNodeAction(parent, cmnode, startIndex, endIndex);
    }

    protected Action createDeleteAction(List selection) {
        DeleteAction deleteAction = new DeleteAction(selection);
        deleteAction.setEnabled(selection.size() > 0);
        return deleteAction;
    }

    public String getLabel(Node parent, CMNode cmnode) {
        String result = "?" + cmnode + "?";
        if (cmnode != null && (result = (String)cmnode.getProperty("description")) == null) {
            if (cmnode.getNodeType() == 7) {
                CMDescriptionBuilder descriptionBuilder = new CMDescriptionBuilder();
                result = descriptionBuilder.buildDescription(cmnode);
            } else {
                result = DOMNamespaceHelper.computeName((CMNode)cmnode, (Node)parent, null);
            }
        }
        return result;
    }

    public DOMContentBuilder createDOMContentBuilder(Document document) {
        DOMContentBuilderImpl builder = new DOMContentBuilderImpl(document);
        return builder;
    }

    public void beginNodeAction(NodeAction action) {
        this.model.beginRecording((Object)action, action.getUndoDescription());
    }

    public void endNodeAction(NodeAction action) {
        this.model.endRecording((Object)action);
    }

    public void fillContextMenuForVpe(IMenuManager menuManager, ISelection selection) {
        ArrayList selectionList = new ArrayList();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection es = (IStructuredSelection)selection;
            Iterator i = es.iterator();
            while (i.hasNext()) {
                selectionList.add(i.next());
            }
        }
        this.contributeActionsForVpe(menuManager, selectionList);
    }

    public void addContextMenuForVpe(IMenuManager menuManager, ISelection selection) {
        ArrayList selectionList = new ArrayList();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection es = (IStructuredSelection)selection;
            Iterator i = es.iterator();
            while (i.hasNext()) {
                selectionList.add(i.next());
            }
        }
        this.contributeDeleteActionForVpe(menuManager, selectionList);
    }

    public void remove(Node parent, int startIndex, int endIndex) {
        NodeList nodeList = parent.getChildNodes();
        int i = endIndex;
        while (i >= startIndex) {
            Node node = nodeList.item(i);
            if (node != null) {
                parent.removeChild(node);
            }
            --i;
        }
    }

    public void insert(Node parent, CMNode cmnode, int index, int type) {
        Document document = parent.getNodeType() == 9 ? (Document)parent : parent.getOwnerDocument();
        DOMContentBuilder builder = this.createDOMContentBuilder(document);
        builder.setBuildPolicy(12);
        builder.build(parent, cmnode);
        List list = builder.getResult();
        if (list.size() > 0 && ((Node)list.get(0)).getNodeName().equals("HTML")) {
            Node node = (Node)list.get(0);
            Node child = node.getFirstChild();
            while (child != null) {
                node.removeChild(child);
                child = node.getFirstChild();
            }
        }
        this.insertNodesAtIndex(type, parent, list, index);
    }

    public void insertNodesAtIndex(int type, Node parent, List list, int index) {
        this.insertNodesAtIndex(type, parent, list, index, true);
    }

    public void insertNodesAtIndex(int type, Node parent, List list, int index, boolean format) {
        Node nextChild;
        NodeList nodeList = parent.getChildNodes();
        if (index == -1) {
            index = nodeList.getLength();
        }
        Node refChild = index < nodeList.getLength() ? nodeList.item(index) : null;
        int prevIndex = index - 1;
        Node prevChild = prevIndex < nodeList.getLength() ? nodeList.item(prevIndex) : null;
        int nextIndex = index + 1;
        Node node = nextChild = nextIndex < nodeList.getLength() ? nodeList.item(nextIndex) : null;
        if (type == 1 && refChild != null) {
            parent.removeChild(refChild);
        } else if (this.isWhitespaceTextNode(prevChild)) {
            refChild = prevChild;
        }
        for (Node newNode : list) {
            if (type == 1 && refChild != null) {
                newNode.appendChild(refChild);
            }
            if (newNode.getNodeType() == 2) {
                Element parentElement = (Element)parent;
                parentElement.setAttributeNode((Attr)newNode);
                continue;
            }
            if (type == 1 && refChild != null) {
                parent.insertBefore(newNode, nextChild);
                continue;
            }
            if (type == 2) {
                parent.insertBefore(newNode, refChild);
                continue;
            }
            if (type == 3) {
                parent.appendChild(newNode);
                continue;
            }
            parent.insertBefore(newNode, refChild);
        }
        boolean formatDeep = false;
        for (Node newNode : list) {
            if (newNode.getNodeType() == 1) {
                formatDeep = true;
            }
            if (!format) continue;
            this.reformat(newNode, formatDeep);
        }
        this.setViewerSelection(list);
    }

    public void setViewerSelection(List list) {
        if (this.viewer != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection(list), true);
        }
    }

    public void setViewerSelection(Node node) {
        if (this.viewer != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)node), true);
        }
    }

    public Shell getWorkbenchWindowShell() {
        return XMLCommonResources.getInstance().getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public IStructuredModel getModel() {
        return this.model;
    }

    public class AddNodeAction
    extends NodeAction {
        protected String description;
        protected String undoDescription;
        protected int nodeType;
        protected CMNode cmnode;
        protected int index;
        protected Node parent;
        protected int type = 2;

        public AddNodeAction(CMNode cmnode, Node parent, int index, int type) {
            this(cmnode, parent, index);
            this.type = type;
        }

        public AddNodeAction(CMNode cmnode, Node parent, int index) {
            this.cmnode = cmnode;
            this.parent = parent;
            this.index = index;
            String text = AbstractActionManager.this.getLabel(parent, cmnode);
            this.setText(text);
            this.description = text;
            this.undoDescription = String.valueOf(XMLCommonResources.getInstance().getString("_UI_MENU_ADD")) + " " + text;
        }

        public void setAround(int type) {
            this.type = type;
        }

        public AddNodeAction(int nodeType, Node parent, int index) {
            this.nodeType = nodeType;
            this.index = index;
            this.parent = parent;
            switch (nodeType) {
                case 8: {
                    this.description = XMLCommonResources.getInstance().getString("_UI_MENU_COMMENT");
                    this.undoDescription = XMLCommonResources.getInstance().getString("_UI_MENU_ADD_COMMENT");
                    break;
                }
                case 7: {
                    this.description = XMLCommonResources.getInstance().getString("_UI_MENU_PROCESSING_INSTRUCTION");
                    this.undoDescription = XMLCommonResources.getInstance().getString("_UI_MENU_ADD_PROCESSING_INSTRUCTION");
                    break;
                }
                case 4: {
                    this.description = XMLCommonResources.getInstance().getString("_UI_MENU_CDATA_SECTION");
                    this.undoDescription = XMLCommonResources.getInstance().getString("_UI_MENU_ADD_CDATA_SECTION");
                    break;
                }
                case 3: {
                    this.description = XMLCommonResources.getInstance().getString("_UI_MENU_PCDATA");
                    this.undoDescription = XMLCommonResources.getInstance().getString("_UI_MENU_ADD_PCDATA");
                }
            }
            this.setText(this.description);
        }

        public String getUndoDescription() {
            return this.undoDescription;
        }

        public void run() {
            if (textNodeSplitter != null) {
                textNodeSplitter.nodeSplit(this.type);
            }
            AbstractActionManager.this.beginNodeAction(this);
            if (this.cmnode != null) {
                this.addNodeForCMNode();
            } else {
                this.addNodeForNodeType();
            }
            AbstractActionManager.this.endNodeAction(this);
        }

        protected void addNodeForCMNode() {
            if (this.parent != null) {
                AbstractActionManager.this.insert(this.parent, this.cmnode, this.index, this.type);
            }
        }

        protected void addNodeForNodeType() {
            Document document = this.parent.getNodeType() == 9 ? (Document)this.parent : this.parent.getOwnerDocument();
            Node newChildNode = null;
            boolean format = true;
            switch (this.nodeType) {
                case 8: {
                    newChildNode = document.createComment(XMLCommonResources.getInstance().getString("_UI_COMMENT_VALUE"));
                    break;
                }
                case 7: {
                    newChildNode = document.createProcessingInstruction(XMLCommonResources.getInstance().getString("_UI_PI_TARGET_VALUE"), XMLCommonResources.getInstance().getString("_UI_PI_DATA_VALUE"));
                    break;
                }
                case 4: {
                    newChildNode = document.createCDATASection("");
                    break;
                }
                case 3: {
                    format = false;
                    newChildNode = document.createTextNode(this.parent.getNodeName());
                }
            }
            if (newChildNode != null) {
                Vector<CDATASection> list = new Vector<CDATASection>(1);
                list.add((CDATASection)newChildNode);
                AbstractActionManager.this.insertNodesAtIndex(this.type, this.parent, list, this.index, format);
            }
        }
    }

    public class DeleteAction
    extends NodeAction {
        protected List list;

        public DeleteAction(Node node) {
            this.setText(XMLCommonResources.getInstance().getString("_UI_MENU_REMOVE"));
            this.list = new Vector();
            this.list.add(node);
        }

        public DeleteAction(List list) {
            this.setText(XMLCommonResources.getInstance().getString("_UI_MENU_REMOVE"));
            this.list = list;
        }

        public void run() {
            AbstractActionManager.this.beginNodeAction(this);
            for (Node node : this.list) {
                if (node.getNodeType() == 2) {
                    Attr attr = (Attr)node;
                    attr.getOwnerElement().removeAttributeNode(attr);
                    continue;
                }
                Node parent = node.getParentNode();
                if (parent == null) continue;
                Node previousSibling = node.getPreviousSibling();
                if (previousSibling != null && AbstractActionManager.this.isWhitespaceTextNode(previousSibling)) {
                    parent.removeChild(previousSibling);
                }
                parent.removeChild(node);
            }
            AbstractActionManager.this.endNodeAction(this);
        }

        public String getUndoDescription() {
            return XMLCommonResources.getInstance().getString("DELETE");
        }
    }

    public class ReplaceNodeAction
    extends NodeAction {
        protected Node parent;
        protected CMNode cmnode;
        protected int startIndex;
        protected int endIndex;
        protected String description;

        public ReplaceNodeAction(Node parent, CMNode cmnode, int startIndex, int endIndex) {
            this.parent = parent;
            this.cmnode = cmnode;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.setText(AbstractActionManager.this.getLabel(parent, cmnode));
        }

        public String getUndoDescription() {
            String result = XMLCommonResources.getInstance().getString("_UI_LABEL_UNDO_REPLACE_DESCRIPTION");
            result = String.valueOf(result) + " " + AbstractActionManager.this.getLabel(this.parent, this.cmnode);
            return result;
        }

        public void run() {
            AbstractActionManager.this.beginNodeAction(this);
            if (this.parent != null && this.cmnode != null) {
                AbstractActionManager.this.remove(this.parent, this.startIndex, this.endIndex);
                AbstractActionManager.this.insert(this.parent, this.cmnode, this.startIndex, 2);
            }
            AbstractActionManager.this.endNodeAction(this);
        }
    }
}

