/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.menu;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.objecteditor.ExtendedProperties;
import org.jboss.tools.common.model.ui.objecteditor.ExtendedPropertiesWizard;
import org.jboss.tools.common.model.ui.util.ModelUtilities;
import org.jboss.tools.jst.jsp.jspeditor.dnd.JSPPaletteInsertHelper;
import org.jboss.tools.vpe.VpeDebug;
import org.jboss.tools.vpe.editor.TextNodeSplitterImpl;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mapping.VpeElementMapping;
import org.jboss.tools.vpe.editor.mapping.VpeNodeMapping;
import org.jboss.tools.vpe.editor.menu.BaseActionManager;
import org.jboss.tools.vpe.editor.menu.NodeActionManager;
import org.jboss.tools.vpe.editor.menu.action.EditAttributesAction;
import org.jboss.tools.vpe.editor.menu.action.InsertAction;
import org.jboss.tools.vpe.editor.menu.action.VpeMenuListener;
import org.jboss.tools.vpe.editor.menu.action.VpeTextOperationAction;
import org.jboss.tools.vpe.editor.mozilla.MozillaEditor;
import org.jboss.tools.vpe.editor.template.VpeAnyData;
import org.jboss.tools.vpe.editor.template.VpeEditAnyDialog;
import org.jboss.tools.vpe.editor.template.VpeTemplate;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.jboss.tools.vpe.editor.util.NodesManagingUtil;
import org.jboss.tools.vpe.editor.util.SelectionUtil;
import org.jboss.tools.vpe.messages.VpeUIMessages;
import org.jboss.tools.vpe.xulrunner.browser.util.DOMTreeDumper;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class MenuCreationHelper {
    public static final String CUT_ACTION = VpeUIMessages.MenuCreationHelper_Cut;
    public static final String COPY_ACTION = JFaceResources.getString((String)"copy");
    public static final String PASTE_ACTION = VpeUIMessages.MenuCreationHelper_Paste;
    public static final String DELETE_ACTION = JFaceResources.getString((String)"Delete");
    public static final String TEST_ACTION = VpeUIMessages.MenuCreationHelper_Test;
    private VpeDomMapping domMapping = null;
    private VpePageContext pageContext = null;
    private StructuredTextEditor sourceEditor = null;
    private MozillaEditor visualEditor = null;

    public MenuCreationHelper(VpeDomMapping domMapping, VpePageContext pageContext, StructuredTextEditor sourceEditor, MozillaEditor visualEditor) {
        this.domMapping = domMapping;
        this.pageContext = pageContext;
        this.sourceEditor = sourceEditor;
        this.visualEditor = visualEditor;
    }

    public void createMenuForNode(Node node, MenuManager manager) {
        this.createMenuForNode(node, manager, false);
    }

    public void createMenuForNode(Node node, MenuManager manager, boolean topLevelFlag) {
        NodeActionManager.setTextNodeSplitter(null);
        StructuredSelection structuredSelection = null;
        if (node != null) {
            VpeElementMapping elementMapping;
            if (node.getNodeType() == 1 && (elementMapping = (VpeElementMapping)this.domMapping.getNodeMapping(node)) != null && elementMapping.getTemplate() != null) {
                Node parent;
                manager.add((IAction)new VpeAction("<" + node.getNodeName() + "> Attributes", node){

                    public void run() {
                        MenuCreationHelper.this.showProperties(this.actionNode);
                    }
                });
                if (!topLevelFlag) {
                    manager.add((IAction)new VpeAction("Select This Tag", node){

                        public void run() {
                            SelectionUtil.setSourceSelection(MenuCreationHelper.this.pageContext, this.actionNode);
                        }
                    });
                }
                if ((parent = node.getParentNode()) != null && parent.getNodeType() == 1) {
                    MenuManager menuManager = new MenuManager("Parent Tag");
                    menuManager.setParent((IContributionManager)manager);
                    manager.add((IContributionItem)menuManager);
                    this.createMenuForNode(parent, menuManager);
                }
                manager.add((IContributionItem)new Separator());
            }
            if (node.getNodeType() == 3) {
                Point range = this.sourceEditor.getTextViewer().getSelectedRange();
                TextNodeSplitterImpl splitter = new TextNodeSplitterImpl(range, (Text)node);
                NodeActionManager.setTextNodeSplitter(splitter);
            }
            structuredSelection = new StructuredSelection((Object)node);
        } else {
            structuredSelection = new StructuredSelection();
        }
        NodeActionManager actionManager = new NodeActionManager(this.sourceEditor.getModel(), null);
        if (actionManager != null) {
            actionManager.fillContextMenuForVpe((IMenuManager)manager, (ISelection)structuredSelection);
        }
        IContributionItem[] items = manager.getItems();
        boolean insertFromPalette = false;
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof MenuManager) {
                MenuManager mm = (MenuManager)items[i];
                int type = 0;
                Point region = null;
                if (NodeActionManager.INSERT_AROUND_MENU.equals(mm.getMenuText())) {
                    type = 1;
                    region = node.getNodeType() == 3 ? SelectionUtil.getSourceSelectionRange(this.sourceEditor) : NodesManagingUtil.getNodeRange(node);
                    insertFromPalette = true;
                } else if (NodeActionManager.INSERT_BEFORE_MENU.equals(mm.getMenuText())) {
                    type = 2;
                    region = new Point(NodesManagingUtil.getStartOffsetNode(node), 0);
                    insertFromPalette = true;
                } else if (NodeActionManager.INSERT_AFTER_MENU.equals(mm.getMenuText())) {
                    type = 3;
                    region = new Point(NodesManagingUtil.getEndOffsetNode(node), 0);
                    insertFromPalette = true;
                } else if (NodeActionManager.REPLACE_TAG_MENU.equals(mm.getMenuText())) {
                    type = 4;
                    region = new Point(NodesManagingUtil.getStartOffsetNode(node), NodesManagingUtil.getNodeLength(node));
                    insertFromPalette = true;
                }
                if (insertFromPalette) {
                    this.listenContextMenu(mm, region, type);
                }
            }
            ++i;
        }
        manager.add((IContributionItem)new Separator());
        if (node != null) {
            if (node.getNodeType() == 1) {
                VpeElementMapping elementMapping = (VpeElementMapping)this.domMapping.getNodeMapping(node);
                if (elementMapping != null && elementMapping.getTemplate() != null && elementMapping.getTemplate().getType() == 4) {
                    final VpeTemplate selectedTemplate = elementMapping.getTemplate();
                    manager.add((IAction)new VpeAction(NLS.bind((String)VpeUIMessages.SETUP_TEMPLATE_FOR_MENU, (Object)node.getNodeName()), node){

                        public void run() {
                            boolean isCorrectNS = MenuCreationHelper.this.pageContext.isCorrectNS(this.actionNode);
                            VpeAnyData data = null;
                            if (isCorrectNS) {
                                data = selectedTemplate.getAnyData();
                                data.setUri(MenuCreationHelper.this.pageContext.getSourceTaglibUri(this.actionNode));
                                data.setName(this.actionNode.getNodeName());
                            }
                            if ((data = MenuCreationHelper.this.editAnyData(MenuCreationHelper.this.sourceEditor, isCorrectNS, data)) != null && data.isChanged()) {
                                VpeTemplateManager.getInstance().setAnyTemplate(data);
                            }
                        }
                    });
                    manager.add((IContributionItem)new Separator());
                }
                manager.add((IAction)new VpeTextOperationAction(CUT_ACTION, ActionFactory.CUT.getId(), node, this.pageContext, this.sourceEditor));
                manager.add((IAction)new VpeTextOperationAction(COPY_ACTION, ActionFactory.COPY.getId(), node, this.pageContext, this.sourceEditor));
                manager.add((IAction)new VpeTextOperationAction(PASTE_ACTION, ActionFactory.PASTE.getId(), node, this.pageContext, this.sourceEditor));
            } else if (node.getNodeType() == 3) {
                manager.add((IAction)new Action(CUT_ACTION){

                    public void run() {
                        MenuCreationHelper.this.sourceEditor.getAction(ActionFactory.CUT.getId()).run();
                    }
                });
                manager.add((IAction)new Action(COPY_ACTION){

                    public void run() {
                        MenuCreationHelper.this.sourceEditor.getAction(ActionFactory.COPY.getId()).run();
                    }
                });
                manager.add((IAction)new Action(PASTE_ACTION){

                    public void run() {
                        MenuCreationHelper.this.sourceEditor.getAction(ActionFactory.PASTE.getId()).run();
                    }
                });
            }
            manager.add((IContributionItem)new Separator());
            if (actionManager != null && node != null) {
                structuredSelection = node.getNodeType() == 1 ? new StructuredSelection((Object)node) : null;
                actionManager.addContextMenuForVpe((IMenuManager)manager, (ISelection)structuredSelection);
            }
            if (node.getNodeType() == 1) {
                NodeList list;
                boolean stripEnable = false;
                NodeImpl impl = (NodeImpl)node;
                if (impl.isContainer() && (list = impl.getChildNodes()).getLength() > 0) {
                    Node child;
                    stripEnable = list.getLength() == 1 ? ((child = list.item(0)).getNodeType() == 3 ? !"".equals(child.getNodeValue().trim()) : true) : true;
                }
                if (stripEnable) {
                    manager.add((IAction)new VpeAction("Strip Tag", node){

                        public void run() {
                            Node parent = this.actionNode.getParentNode();
                            if (parent != null) {
                                int index = ((NodeImpl)this.actionNode).getIndex();
                                parent.removeChild(this.actionNode);
                                NodeList children = this.actionNode.getChildNodes();
                                int lengh = children.getLength();
                                int i = 0;
                                while (i < lengh) {
                                    Node child = children.item(0);
                                    this.actionNode.removeChild(child);
                                    this.insertNode(parent, child, index++);
                                    ++i;
                                }
                            }
                        }

                        private void insertNode(Node parent, Node node, int index) {
                            Node oldNode = null;
                            int childSize = parent.getChildNodes().getLength();
                            if (index <= childSize - 1) {
                                oldNode = parent.getChildNodes().item(index);
                            }
                            if (oldNode != null) {
                                parent.insertBefore(node, oldNode);
                            } else {
                                parent.appendChild(node);
                            }
                        }
                    });
                }
            }
            if (node.getNodeType() == 3) {
                manager.add((IAction)new Action(DELETE_ACTION){

                    public void run() {
                        MenuCreationHelper.this.sourceEditor.getAction(ActionFactory.DELETE.getId()).run();
                    }
                });
            }
            if (VpeDebug.VISUAL_CONTEXTMENU_DUMP_SOURCE) {
                manager.add((IAction)new Action("Dump Source"){

                    public void run() {
                        DOMTreeDumper dumper = new DOMTreeDumper(VpeDebug.VISUAL_DUMP_PRINT_HASH);
                        dumper.setIgnoredAttributes(VpeDebug.VISUAL_DUMP_IGNORED_ATTRIBUTES);
                        dumper.dumpToStream(System.out, MenuCreationHelper.this.visualEditor.getDomDocument());
                    }
                });
            }
            if (VpeDebug.VISUAL_CONTEXTMENU_DUMP_SELECTED_ELEMENT) {
                manager.add((IAction)new Action("Dump Selected Element"){

                    public void run() {
                        VpeNodeMapping nodeMapping = SelectionUtil.getNodeMappingBySourceSelection(MenuCreationHelper.this.sourceEditor, MenuCreationHelper.this.domMapping);
                        if (nodeMapping != null) {
                            DOMTreeDumper dumper = new DOMTreeDumper(VpeDebug.VISUAL_DUMP_PRINT_HASH);
                            dumper.setIgnoredAttributes(VpeDebug.VISUAL_DUMP_IGNORED_ATTRIBUTES);
                            dumper.dumpNode(nodeMapping.getVisualNode());
                        }
                    }
                });
            }
            if (VpeDebug.VISUAL_CONTEXTMENU_DUMP_MAPPING) {
                manager.add((IAction)new Action("Dump Mapping"){

                    public void run() {
                        MenuCreationHelper.this.printMapping();
                    }
                });
            }
            if (VpeDebug.VISUAL_CONTEXTMENU_TEST) {
                manager.add((IAction)new VpeAction(TEST_ACTION, node){

                    public void run() {
                        MenuCreationHelper.this.test(this.actionNode);
                    }
                });
            }
        } else {
            manager.add((IAction)new Action(PASTE_ACTION){

                public void run() {
                    MenuCreationHelper.this.sourceEditor.getAction(ActionFactory.PASTE.getId()).run();
                }
            });
        }
    }

    private void test(Node node) {
    }

    private VpeAnyData editAnyData(StructuredTextEditor sourceEditor, boolean isCorrectNS, VpeAnyData data) {
        Shell shell = sourceEditor.getEditorPart().getSite().getShell();
        if (isCorrectNS) {
            VpeEditAnyDialog editDialog = new VpeEditAnyDialog(shell, data);
            editDialog.open();
        } else {
            MessageBox message = new MessageBox(shell, 40);
            message.setMessage(VpeUIMessages.NAMESPACE_NOT_DEFINED);
            message.open();
        }
        return data;
    }

    private void showProperties(Node node) {
        ExtendedProperties p = EditAttributesAction.createExtendedProperties(node);
        if (p != null) {
            ExtendedPropertiesWizard.run((ExtendedProperties)p);
        }
    }

    private void printMapping() {
        this.domMapping.printMapping();
    }

    private void listenContextMenu(MenuManager manager, final Point region, final int type) {
        final BaseActionManager.MyMenuManager paletteMenuManager = new BaseActionManager.MyMenuManager(VpeUIMessages.FROM_PALETTE, true);
        manager.add((IContributionItem)paletteMenuManager);
        manager.addMenuListener((IMenuListener)new VpeMenuListener(paletteMenuManager){

            protected void fillContextMenu() {
                MenuCreationHelper.this.fillContextMenuFromPalette(paletteMenuManager, region, type);
            }
        });
    }

    private MenuManager fillContextMenuFromPalette(MenuManager manager, Point region, int type) {
        XModelObject model = ModelUtilities.getPreferenceModel().getByPath("%Palette%");
        XModelObject[] folders = model.getChildren();
        int i = 0;
        while (i < folders.length) {
            if (!"yes".equals(folders[i].getAttributeValue("hidden"))) {
                MenuManager mm = new MenuManager(folders[i].getAttributeValue("name"));
                manager.add((IContributionItem)mm);
                this.fillPaletteFolder(mm, region, folders[i], type);
            }
            ++i;
        }
        return manager;
    }

    private void fillPaletteFolder(MenuManager menu, Point region, XModelObject folder, int type) {
        XModelObject[] groups = folder.getChildren();
        int i = 0;
        while (i < groups.length) {
            if (!"yes".equals(groups[i].getAttributeValue("hidden"))) {
                MenuManager mm = new MenuManager(groups[i].getAttributeValue("name"));
                menu.add((IContributionItem)mm);
                this.fillPaletteGroup(mm, region, groups[i], type);
            }
            ++i;
        }
    }

    private void fillPaletteGroup(MenuManager menu, Point region, XModelObject group, int type) {
        XModelObject[] items = group.getChildren();
        int i = 0;
        while (i < items.length) {
            if (!"yes".equals(items[i].getAttributeValue("hidden"))) {
                String endText = items[i].getAttributeValue("end text");
                if (type != 1 || endText != null && !"".equals(endText)) {
                    if (type == 4) {
                        this.createReplaceAction(menu, region, items[i]);
                    } else {
                        this.createInsertAction(menu, region, items[i]);
                    }
                }
            }
            ++i;
        }
    }

    private void createReplaceAction(MenuManager menu, Point region, XModelObject item) {
        String tagName = this.getTagName(menu, region, item);
        menu.add((IAction)new InsertAction(tagName, region, item, this.pageContext, this.sourceEditor, true));
    }

    private void createInsertAction(MenuManager menu, Point region, XModelObject item) {
        String tagName = this.getTagName(menu, region, item);
        menu.add((IAction)new InsertAction(tagName, region, item, this.pageContext, this.sourceEditor));
    }

    private String getTagName(MenuManager menu, Point region, XModelObject item) {
        XModelObject parent = item.getParent();
        String uri = parent == null ? "" : parent.getAttributeValue("library uri");
        String defaultPrefix = parent == null ? "" : parent.getAttributeValue("default prefix");
        String tagName = item.getAttributeValue("name");
        String[] texts = new String[]{"<" + tagName + ">"};
        if (tagName.indexOf("taglib") < 0) {
            JSPPaletteInsertHelper.applyPrefix((String[])texts, (ITextEditor)this.sourceEditor, (String)tagName, (String)uri, (String)defaultPrefix);
        }
        tagName = texts[0];
        return tagName;
    }

    class VpeAction
    extends Action {
        public Node actionNode;

        public VpeAction(String name, Node node) {
            super(name);
            this.actionNode = node;
        }
    }
}

