/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.mozilla;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.internal.part.StatusPart;
import org.eclipse.ui.part.EditorPart;
import org.jboss.tools.jst.jsp.JspEditorPlugin;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.VpeController;
import org.jboss.tools.vpe.editor.mozilla.EditorDomEventListener;
import org.jboss.tools.vpe.editor.mozilla.EditorLoadWindowListener;
import org.jboss.tools.vpe.editor.mozilla.MozillaDomEventListener;
import org.jboss.tools.vpe.editor.mozilla.XulRunnerEditor2;
import org.jboss.tools.vpe.editor.preferences.VpeEditorPreferencesPage;
import org.jboss.tools.vpe.editor.toolbar.IVpeToolBarManager;
import org.jboss.tools.vpe.editor.toolbar.VpeDropDownMenu;
import org.jboss.tools.vpe.editor.toolbar.VpeToolBarManager;
import org.jboss.tools.vpe.editor.toolbar.format.FormatControllerManager;
import org.jboss.tools.vpe.editor.toolbar.format.TextFormattingToolBar;
import org.jboss.tools.vpe.editor.util.DocTypeUtil;
import org.jboss.tools.vpe.editor.util.FileUtil;
import org.jboss.tools.vpe.messages.VpeUIMessages;
import org.jboss.tools.vpe.resref.core.VpeResourcesDialog;
import org.jboss.tools.vpe.xulrunner.editor.XulRunnerEditor;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMEventListener;
import org.mozilla.interfaces.nsIDOMEventTarget;
import org.mozilla.interfaces.nsIDOMNamedNodeMap;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsIDOMWindow;
import org.mozilla.interfaces.nsIEditingSession;
import org.mozilla.interfaces.nsIEditor;
import org.mozilla.interfaces.nsIHTMLAbsPosEditor;
import org.mozilla.interfaces.nsIHTMLInlineTableEditor;
import org.mozilla.interfaces.nsIHTMLObjectResizer;
import org.mozilla.interfaces.nsISelectionListener;

public class MozillaEditor
extends EditorPart
implements IReusableEditor {
    protected static final File INIT_FILE = new File(VpePlugin.getDefault().getResourcePath("ve"), "init.html");
    public static final String CONTENT_AREA_ID = "__content__area__";
    public static final String ICON_PREFERENCE = "icons/preference.gif";
    public static final String ICON_PREFERENCE_DISABLED = "icons/preference_disabled.gif";
    public static final String ICON_REFRESH = "icons/refresh.gif";
    public static final String ICON_REFRESH_DISABLED = "icons/refresh_disabled.gif";
    public static final String ICON_PAGE_DESIGN_OPTIONS = "icons/point_to_css.gif";
    public static final String ICON_PAGE_DESIGN_OPTIONS_DISABLED = "icons/point_to_css_disabled.gif";
    public static final String ICON_ORIENTATION_SOURCE_LEFT = "icons/source_left.gif";
    public static final String ICON_ORIENTATION_SOURCE_TOP = "icons/source_top.gif";
    public static final String ICON_ORIENTATION_VISUAL_LEFT = "icons/visual_left.gif";
    public static final String ICON_ORIENTATION_VISUAI_TOP = "icons/visual_top.gif";
    public static final String ICON_ORIENTATION_SOURCE_LEFT_DISABLED = "icons/source_left_disabled.gif";
    public static final String ICON_SHOW_BORDER_FOR_UNKNOWN_TAGS = "icons/border.gif";
    public static final String ICON_NON_VISUAL_TAGS = "icons/non-visusal-tags.gif";
    public static final String ICON_SELECTION_BAR = "icons/selbar.gif";
    public static final String ICON_TEXT_FORMATTING = "icons/text-formatting.gif";
    public static final String ICON_BUNDLE_AS_EL = "icons/bundle-as-el.gif";
    static String SELECT_BAR = "SELECT_LBAR";
    private XulRunnerEditor xulRunnerEditor;
    private nsIDOMEventTarget documentEventTarget;
    private nsIDOMElement contentArea;
    private nsIDOMNode headNode;
    private nsIDOMEventTarget contentAreaEventTarget;
    private MozillaDomEventListener contentAreaEventListener;
    private EditorLoadWindowListener editorLoadWindowListener;
    private EditorDomEventListener editorDomEventListener;
    private IVpeToolBarManager vpeToolBarManager;
    private FormatControllerManager formatControllerManager = new FormatControllerManager();
    private VpeController controller;
    private boolean isRefreshPage = false;
    private String doctype;
    private static Map<String, String> layoutIcons = new HashMap<String, String>();
    private static Map<String, String> layoutNames;
    private static List<String> layoutValues;
    private int currentOrientationIndex = 1;
    private Action openVPEPreferencesAction;
    private Action visualRefreshAction;
    private Action showResouceDialogAction;
    private Action rotateEditorsAction;
    private Action showBorderAction;
    private Action showNonVisualTagsAction;
    private Action showSelectionBarAction;
    private Action showTextFormattingAction;
    private Action showBundleAsELAction;
    private nsIEditor editor;
    private VpeDropDownMenu dropDownMenu = null;
    private ToolBar verBar = null;

    static {
        layoutIcons.put("3", ICON_ORIENTATION_SOURCE_LEFT);
        layoutIcons.put("1", ICON_ORIENTATION_SOURCE_TOP);
        layoutIcons.put("4", ICON_ORIENTATION_VISUAL_LEFT);
        layoutIcons.put("2", ICON_ORIENTATION_VISUAI_TOP);
        layoutNames = new HashMap<String, String>();
        layoutNames.put("3", VpeUIMessages.SPLITTING_HORIZ_LEFT_SOURCE);
        layoutNames.put("1", VpeUIMessages.SPLITTING_VERT_TOP_SOURCE);
        layoutNames.put("4", VpeUIMessages.SPLITTING_HORIZ_LEFT_VISUAL);
        layoutNames.put("2", VpeUIMessages.SPLITTING_VERT_TOP_VISUAL);
        layoutValues = new ArrayList<String>();
        layoutValues.add("3");
        layoutValues.add("1");
        layoutValues.add("4");
        layoutValues.add("2");
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.setSite((IWorkbenchPartSite)site);
        super.setInput(input);
    }

    public void setInput(IEditorInput input) {
        boolean isVisualRefreshRequired = this.getEditorInput() != null && this.getEditorInput() != input && this.controller != null;
        super.setInput(input);
        if (isVisualRefreshRequired) {
            this.controller.visualRefresh();
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setController(VpeController controller) {
        this.controller = controller;
        this.formatControllerManager.setVpeController(controller);
        controller.setToolbarFormatControllerManager(this.formatControllerManager);
    }

    public ToolBar createVisualToolbar(Composite parent) {
        ILocationProvider provider;
        IPath path;
        final ToolBarManager toolBarManager = new ToolBarManager(0x800200);
        this.verBar = toolBarManager.createControl(parent);
        this.openVPEPreferencesAction = new Action(VpeUIMessages.PREFERENCES, 1){

            public void run() {
                VpeEditorPreferencesPage.openPreferenceDialog();
            }
        };
        this.openVPEPreferencesAction.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)ICON_PREFERENCE));
        this.openVPEPreferencesAction.setToolTipText(VpeUIMessages.PREFERENCES);
        toolBarManager.add((IAction)this.openVPEPreferencesAction);
        this.visualRefreshAction = new Action(VpeUIMessages.REFRESH, 1){

            public void run() {
                if (MozillaEditor.this.controller != null) {
                    MozillaEditor.this.controller.visualRefresh();
                }
            }
        };
        this.visualRefreshAction.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)ICON_REFRESH));
        this.visualRefreshAction.setToolTipText(VpeUIMessages.REFRESH);
        toolBarManager.add((IAction)this.visualRefreshAction);
        IEditorInput input = this.getEditorInput();
        IFile file = null;
        if (input instanceof IFileEditorInput) {
            file = ((IFileEditorInput)input).getFile();
        } else if (input instanceof ILocationProvider && (path = (provider = (ILocationProvider)input).getPath((Object)input)) != null) {
            file = FileUtil.getFile(input, path.lastSegment());
        }
        boolean fileExistsInWorkspace = file != null && file.exists();
        this.showResouceDialogAction = new Action(VpeUIMessages.PAGE_DESIGN_OPTIONS, 1){

            public void run() {
                ILocationProvider provider;
                IPath path;
                IEditorInput input = MozillaEditor.this.getEditorInput();
                IFile fileLocation = null;
                if (input instanceof IFileEditorInput) {
                    IFile file;
                    fileLocation = file = ((IFileEditorInput)input).getFile();
                } else if (input instanceof ILocationProvider && (path = (provider = (ILocationProvider)input).getPath((Object)input)) != null) {
                    fileLocation = path;
                }
                if (fileLocation != null) {
                    VpeResourcesDialog dialogNew = new VpeResourcesDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (Object)fileLocation);
                    dialogNew.open();
                } else {
                    VpePlugin.getDefault().logError("Could not open Vpe Resources Dialog.");
                }
            }
        };
        this.showResouceDialogAction.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)(fileExistsInWorkspace ? ICON_PAGE_DESIGN_OPTIONS : ICON_PAGE_DESIGN_OPTIONS_DISABLED)));
        if (!fileExistsInWorkspace) {
            this.showResouceDialogAction.setEnabled(false);
        }
        this.showResouceDialogAction.setToolTipText(VpeUIMessages.PAGE_DESIGN_OPTIONS);
        toolBarManager.add((IAction)this.showResouceDialogAction);
        String newOrientation = JspEditorPlugin.getDefault().getPreferenceStore().getString("Visual/Source Editors Splitting");
        this.currentOrientationIndex = layoutValues.indexOf(newOrientation);
        this.rotateEditorsAction = new Action(VpeUIMessages.VISUAL_SOURCE_EDITORS_SPLITTING, 1){

            public void run() {
                MozillaEditor mozillaEditor = MozillaEditor.this;
                mozillaEditor.currentOrientationIndex = mozillaEditor.currentOrientationIndex + 1;
                if (MozillaEditor.this.currentOrientationIndex >= layoutValues.size()) {
                    MozillaEditor mozillaEditor2 = MozillaEditor.this;
                    mozillaEditor2.currentOrientationIndex = mozillaEditor2.currentOrientationIndex % layoutValues.size();
                }
                String newOrientation = (String)layoutValues.get(MozillaEditor.this.currentOrientationIndex);
                this.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)((String)layoutIcons.get(newOrientation))));
                this.setToolTipText((String)layoutNames.get(newOrientation));
                MozillaEditor.this.getController().getPageContext().getEditPart().fillContainer(true, newOrientation);
                JspEditorPlugin.getDefault().getPreferenceStore().setValue("Visual/Source Editors Splitting", newOrientation);
            }
        };
        this.rotateEditorsAction.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)layoutIcons.get(newOrientation)));
        this.rotateEditorsAction.setToolTipText(layoutNames.get(newOrientation));
        toolBarManager.add((IAction)this.rotateEditorsAction);
        this.showBorderAction = new Action(VpeUIMessages.SHOW_BORDER_FOR_UNKNOWN_TAGS, 2){

            public void run() {
                MozillaEditor.this.getController().getVisualBuilder().setShowBorderForUnknownTags(this.isChecked());
                MozillaEditor.this.controller.visualRefresh();
                JspEditorPlugin.getDefault().getPreferenceStore().setValue("Show Border for Unknown Tags", this.isChecked());
            }
        };
        this.showBorderAction.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)ICON_SHOW_BORDER_FOR_UNKNOWN_TAGS));
        this.showBorderAction.setToolTipText(VpeUIMessages.SHOW_BORDER_FOR_UNKNOWN_TAGS);
        toolBarManager.add((IAction)this.showBorderAction);
        this.showNonVisualTagsAction = new Action(VpeUIMessages.SHOW_NON_VISUAL_TAGS, 2){

            public void run() {
                MozillaEditor.this.controller.getVisualBuilder().setShowInvisibleTags(this.isChecked());
                MozillaEditor.this.controller.visualRefresh();
                JspEditorPlugin.getDefault().getPreferenceStore().setValue("Show non-visual tags", this.isChecked());
            }
        };
        this.showNonVisualTagsAction.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)ICON_NON_VISUAL_TAGS));
        this.showNonVisualTagsAction.setToolTipText(VpeUIMessages.SHOW_NON_VISUAL_TAGS);
        toolBarManager.add((IAction)this.showNonVisualTagsAction);
        this.showSelectionBarAction = new Action(VpeUIMessages.SHOW_SELECTION_BAR, 2){

            public void run() {
                MozillaEditor.this.controller.getPageContext().getEditPart().updateSelectionBar(this.isChecked());
                JspEditorPlugin.getDefault().getPreferenceStore().setValue("Show Selection Tag Bar", this.isChecked());
            }
        };
        this.showSelectionBarAction.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)ICON_SELECTION_BAR));
        this.showSelectionBarAction.setToolTipText(VpeUIMessages.SHOW_SELECTION_BAR);
        toolBarManager.add((IAction)this.showSelectionBarAction);
        this.showTextFormattingAction = new Action(VpeUIMessages.SHOW_TEXT_FORMATTING, 2){

            public void run() {
                MozillaEditor.this.vpeToolBarManager.setToolbarVisibility(this.isChecked());
                JspEditorPlugin.getDefault().getPreferenceStore().setValue("Show Text Formatting bar", this.isChecked());
            }
        };
        this.showTextFormattingAction.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)ICON_TEXT_FORMATTING));
        this.showTextFormattingAction.setToolTipText(VpeUIMessages.SHOW_TEXT_FORMATTING);
        toolBarManager.add((IAction)this.showTextFormattingAction);
        this.showBundleAsELAction = new Action(VpeUIMessages.SHOW_BUNDLES_AS_EL, 2){

            public void run() {
                MozillaEditor.this.controller.getPageContext().getBundle().updateShowBundleUsageAsEL(this.isChecked());
                MozillaEditor.this.controller.visualRefresh();
                JspEditorPlugin.getDefault().getPreferenceStore().setValue("Show Resource Bundles Usage as EL Expressions", this.isChecked());
            }
        };
        this.showBundleAsELAction.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)ICON_BUNDLE_AS_EL));
        this.showBundleAsELAction.setToolTipText(VpeUIMessages.SHOW_BUNDLES_AS_EL);
        toolBarManager.add((IAction)this.showBundleAsELAction);
        this.updateToolbarItemsAccordingToPreferences();
        toolBarManager.update(true);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                toolBarManager.dispose();
                toolBarManager.removeAll();
                MozillaEditor.this.openVPEPreferencesAction = null;
                MozillaEditor.this.visualRefreshAction = null;
                MozillaEditor.this.showResouceDialogAction = null;
                MozillaEditor.this.rotateEditorsAction = null;
                MozillaEditor.this.showBorderAction = null;
                MozillaEditor.this.showNonVisualTagsAction = null;
                MozillaEditor.this.showSelectionBarAction = null;
                MozillaEditor.this.showTextFormattingAction = null;
                MozillaEditor.this.showBundleAsELAction = null;
            }
        });
        return this.verBar;
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 2;
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 2;
        layout.marginBottom = 0;
        parent.setLayout((Layout)layout);
        Composite cmpEdTl = new Composite(parent, 0);
        GridLayout layoutEdTl = new GridLayout(1, false);
        layoutEdTl.verticalSpacing = 0;
        layoutEdTl.marginHeight = 0;
        layoutEdTl.marginBottom = 3;
        layoutEdTl.marginWidth = 0;
        cmpEdTl.setLayout((Layout)layoutEdTl);
        cmpEdTl.setLayoutData((Object)new GridData(1808));
        if (this.verBar != null) {
            this.vpeToolBarManager = new VpeToolBarManager();
            if (this.vpeToolBarManager != null) {
                this.vpeToolBarManager.createToolBarComposite(cmpEdTl);
                this.vpeToolBarManager.addToolBar(new TextFormattingToolBar(this.formatControllerManager));
            }
        }
        Composite cmpEd = new Composite(cmpEdTl, 8);
        GridLayout layoutEd = new GridLayout(1, false);
        layoutEd.marginBottom = 0;
        layoutEd.marginHeight = 1;
        layoutEd.marginWidth = 0;
        layoutEd.marginRight = 0;
        layoutEd.marginLeft = 1;
        layoutEd.verticalSpacing = 0;
        layoutEd.horizontalSpacing = 0;
        cmpEd.setLayout((Layout)layoutEd);
        cmpEd.setLayoutData((Object)new GridData(1808));
        Color buttonDarker = parent.getDisplay().getSystemColor(18);
        cmpEd.setBackground(buttonDarker);
        try {
            this.xulRunnerEditor = new XulRunnerEditor2(cmpEd, this);
            this.xulRunnerEditor.getBrowser().addProgressListener(new ProgressListener(){

                public void changed(ProgressEvent event) {
                }

                public void completed(ProgressEvent event) {
                    MozillaEditor.this.onLoadWindow();
                    MozillaEditor.this.xulRunnerEditor.getBrowser().removeProgressListener((ProgressListener)this);
                }
            });
            this.setInitialContent();
            this.xulRunnerEditor.setLayoutData((Object)new GridData(4, 4, true, true));
        }
        catch (Throwable t) {
            this.showXulRunnerException(cmpEd, t);
        }
    }

    protected void setInitialContent() {
        String html = DocTypeUtil.prepareInitFile(INIT_FILE, this.getEditorInput());
        File tmp = null;
        Writer out = null;
        try {
            try {
                tmp = File.createTempFile("temp", ".html");
                tmp.deleteOnExit();
                out = new FileWriter(tmp);
                out.write(html);
            }
            catch (IOException e) {
                VpePlugin.getPluginLog().logError((Throwable)e);
                try {
                    try {
                        if (out != null) {
                            out.close();
                            if (tmp != null) {
                                this.xulRunnerEditor.setURL("file://" + tmp.getCanonicalPath());
                            }
                        }
                    }
                    catch (IOException e2) {
                        VpePlugin.getPluginLog().logError((Throwable)e2);
                        if (tmp != null) {
                            tmp.delete();
                        }
                    }
                }
                finally {
                    if (tmp != null) {
                        tmp.delete();
                    }
                }
            }
        }
        finally {
            block29: {
                try {
                    try {
                        if (out != null) {
                            out.close();
                            if (tmp != null) {
                                this.xulRunnerEditor.setURL("file://" + tmp.getCanonicalPath());
                            }
                        }
                    }
                    catch (IOException e) {
                        VpePlugin.getPluginLog().logError((Throwable)e);
                        if (tmp != null) {
                            tmp.delete();
                        }
                        break block29;
                    }
                }
                catch (Throwable throwable) {
                    if (tmp != null) {
                        tmp.delete();
                    }
                    throw throwable;
                }
                if (tmp != null) {
                    tmp.delete();
                }
            }
        }
    }

    protected void showXulRunnerException(Composite parent, Throwable throwable) {
        String errorMessage = MessageFormat.format(VpeUIMessages.MOZILLA_LOADING_ERROR, throwable.getMessage());
        VpePlugin.getPluginLog().logError(errorMessage, throwable);
        parent.setLayout((Layout)new GridLayout());
        Composite statusComposite = new Composite(parent, 0);
        Color bgColor = parent.getDisplay().getSystemColor(25);
        Color fgColor = parent.getDisplay().getSystemColor(24);
        parent.setBackground(bgColor);
        parent.setForeground(fgColor);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 0;
        gridData.heightHint = 0;
        statusComposite.setLayoutData((Object)gridData);
        Status displayStatus = new Status(4, "org.jboss.tools.vpe", errorMessage, throwable);
        new StatusPart(statusComposite, (IStatus)displayStatus);
        final Link link = new Link(parent, 64);
        link.setLayoutData((Object)new GridData(128));
        link.setBackground(bgColor);
        link.setText(VpeUIMessages.MOZILLA_LOADING_ERROR_LINK_TEXT);
        link.setToolTipText(VpeUIMessages.MOZILLA_LOADING_ERROR_LINK);
        link.setForeground(link.getDisplay().getSystemColor(9));
        link.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
                BusyIndicator.showWhile((Display)link.getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        URL theURL = null;
                        try {
                            theURL = new URL(VpeUIMessages.MOZILLA_LOADING_ERROR_LINK);
                        }
                        catch (MalformedURLException e) {
                            VpePlugin.reportProblem(e);
                        }
                        IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                        try {
                            support.getExternalBrowser().openURL(theURL);
                        }
                        catch (PartInitException e) {
                            VpePlugin.reportProblem((Exception)((Object)e));
                        }
                    }
                });
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    public void setFocus() {
        if (this.xulRunnerEditor != null) {
            this.xulRunnerEditor.setFocus();
        }
    }

    public void dispose() {
        if (this.vpeToolBarManager != null) {
            this.vpeToolBarManager.dispose();
            this.vpeToolBarManager = null;
        }
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
            this.dropDownMenu = null;
        }
        if (this.getController() != null) {
            this.controller.dispose();
            this.controller = null;
        }
        if (this.xulRunnerEditor != null) {
            this.xulRunnerEditor.dispose();
            this.xulRunnerEditor = null;
        }
        this.controller = null;
        this.formatControllerManager.setVpeController(null);
        this.formatControllerManager = null;
        this.headNode = null;
        this.contentArea = null;
        super.dispose();
    }

    public void setEditorLoadWindowListener(EditorLoadWindowListener listener) {
        this.editorLoadWindowListener = listener;
    }

    public void setEditorDomEventListener(EditorDomEventListener listener) {
        this.editorDomEventListener = listener;
        if (this.contentAreaEventListener != null) {
            this.contentAreaEventListener.setEditorDomEventListener(listener);
        }
    }

    public nsIDOMDocument getDomDocument() {
        return this.xulRunnerEditor.getDOMDocument();
    }

    public nsIDOMElement getContentArea() {
        return this.contentArea;
    }

    protected void setContentArea(nsIDOMElement element) {
        this.contentArea = element;
    }

    public nsIDOMNode getHeadNode() {
        return this.headNode;
    }

    public Menu getMenu() {
        return this.xulRunnerEditor.getBrowser().getMenu();
    }

    public Control getControl() {
        return this.xulRunnerEditor.getBrowser();
    }

    protected nsIDOMElement findContentArea() {
        nsIDOMElement area = null;
        nsIDOMNodeList nodeList = this.xulRunnerEditor.getDOMDocument().getElementsByTagName("body");
        long length = nodeList.getLength();
        long i = 0L;
        while (i < length) {
            nsIDOMNode node = nodeList.item(i);
            if (this.isContentArea(node)) {
                if (node.getNodeType() != 1) {
                    throw new RuntimeException("The content area node should by element node.");
                }
                area = (nsIDOMElement)node.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
                break;
            }
            ++i;
        }
        if (area == null) {
            area = this.xulRunnerEditor.getDOMDocument().createElement("body");
            this.xulRunnerEditor.getDOMDocument().getDocumentElement().appendChild((nsIDOMNode)area);
        }
        nsIDOMElement root = this.xulRunnerEditor.getDOMDocument().getDocumentElement();
        this.headNode = this.findHeadNode((nsIDOMNode)root);
        return area;
    }

    private nsIDOMNode findHeadNode(nsIDOMNode root) {
        nsIDOMNode headNode = this.findChildNode(root, "head");
        return headNode;
    }

    private nsIDOMNode findChildNode(nsIDOMNode parent, String name) {
        nsIDOMNodeList list = parent.getChildNodes();
        int i = 0;
        while ((long)i < list.getLength()) {
            nsIDOMNode node = list.item((long)i);
            if (node.getNodeName().equalsIgnoreCase(name)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    private boolean isContentArea(nsIDOMNode node) {
        nsIDOMNamedNodeMap map;
        boolean ret = false;
        if ("body".equalsIgnoreCase(node.getNodeName()) && (map = node.getAttributes()) != null) {
            long length = map.getLength();
            int i = 0;
            while ((long)i < length) {
                nsIDOMNode attr = map.item((long)i);
                boolean bl = ret = attr.getNodeType() == 2 && "id".equalsIgnoreCase(attr.getNodeName()) && CONTENT_AREA_ID.equalsIgnoreCase(attr.getNodeValue());
                if (ret) break;
                ++i;
            }
        }
        return ret;
    }

    private void onLoadWindow() {
        this.contentArea = this.findContentArea();
        this.addDomEventListeners();
        this.addSelectionListener();
        if (this.editorLoadWindowListener != null) {
            this.editorLoadWindowListener.load();
        }
    }

    protected void addDomEventListeners() {
        if (this.contentArea != null && this.getContentAreaEventListener() != null) {
            this.getContentAreaEventListener().setVisualEditor(this.xulRunnerEditor);
            this.setContentAreaEventTarget((nsIDOMEventTarget)this.contentArea.queryInterface("{1c773b30-d1cf-11d2-bd95-00805f8ae3f4}"));
            this.getContentAreaEventTarget().addEventListener("click", (nsIDOMEventListener)this.getContentAreaEventListener(), false);
            this.getContentAreaEventTarget().addEventListener("mousedown", (nsIDOMEventListener)this.getContentAreaEventListener(), false);
            this.getContentAreaEventTarget().addEventListener("mouseup", (nsIDOMEventListener)this.getContentAreaEventListener(), false);
            this.getContentAreaEventTarget().addEventListener("mousemove", (nsIDOMEventListener)this.getContentAreaEventListener(), false);
            this.getContentAreaEventTarget().addEventListener("contextmenu", (nsIDOMEventListener)this.getContentAreaEventListener(), false);
            this.getContentAreaEventTarget().addEventListener("dragdrop", (nsIDOMEventListener)this.getContentAreaEventListener(), false);
            this.getContentAreaEventTarget().addEventListener("dragenter", (nsIDOMEventListener)this.getContentAreaEventListener(), false);
            this.getContentAreaEventTarget().addEventListener("dragexit", (nsIDOMEventListener)this.getContentAreaEventListener(), false);
            this.getContentAreaEventTarget().addEventListener("draggesture", (nsIDOMEventListener)this.getContentAreaEventListener(), false);
            this.getContentAreaEventTarget().addEventListener("dragover", (nsIDOMEventListener)this.getContentAreaEventListener(), false);
            this.getContentAreaEventTarget().addEventListener("dblclick", (nsIDOMEventListener)this.getContentAreaEventListener(), false);
            this.documentEventTarget = (nsIDOMEventTarget)this.xulRunnerEditor.getDOMDocument().queryInterface("{1c773b30-d1cf-11d2-bd95-00805f8ae3f4}");
            this.documentEventTarget.addEventListener("keypress", (nsIDOMEventListener)this.getContentAreaEventListener(), false);
            this.documentEventTarget.addEventListener("scroll", (nsIDOMEventListener)this.getContentAreaEventListener(), false);
            nsIDOMWindow window = this.xulRunnerEditor.getWebBrowser().getContentDOMWindow();
            nsIDOMEventTarget eventTarget = (nsIDOMEventTarget)window.queryInterface("{1c773b30-d1cf-11d2-bd95-00805f8ae3f4}");
            eventTarget.addEventListener("MozAfterPaint", (nsIDOMEventListener)this.getContentAreaEventListener(), false);
        }
    }

    protected void removeDomEventListeners() {
        if (this.getContentAreaEventTarget() != null && this.getContentAreaEventListener() != null) {
            this.getContentAreaEventTarget().removeEventListener("click", (nsIDOMEventListener)this.getContentAreaEventListener(), false);
            this.getContentAreaEventTarget().removeEventListener("mousedown", (nsIDOMEventListener)this.getContentAreaEventListener(), false);
            this.getContentAreaEventTarget().removeEventListener("mouseup", (nsIDOMEventListener)this.getContentAreaEventListener(), false);
            this.getContentAreaEventTarget().removeEventListener("mousemove", (nsIDOMEventListener)this.getContentAreaEventListener(), false);
            this.getContentAreaEventTarget().removeEventListener("contextmenu", (nsIDOMEventListener)this.getContentAreaEventListener(), false);
            this.getContentAreaEventTarget().removeEventListener("dragdrop", (nsIDOMEventListener)this.getContentAreaEventListener(), false);
            this.getContentAreaEventTarget().removeEventListener("dragenter", (nsIDOMEventListener)this.getContentAreaEventListener(), false);
            this.getContentAreaEventTarget().removeEventListener("dragexit", (nsIDOMEventListener)this.getContentAreaEventListener(), false);
            this.getContentAreaEventTarget().removeEventListener("draggesture", (nsIDOMEventListener)this.getContentAreaEventListener(), false);
            this.getContentAreaEventTarget().removeEventListener("dragover", (nsIDOMEventListener)this.getContentAreaEventListener(), false);
            this.getContentAreaEventTarget().removeEventListener("dblclick", (nsIDOMEventListener)this.getContentAreaEventListener(), false);
            if (this.xulRunnerEditor.getDOMDocument() != null && this.documentEventTarget != null) {
                this.documentEventTarget.removeEventListener("keypress", (nsIDOMEventListener)this.getContentAreaEventListener(), false);
                this.documentEventTarget.removeEventListener("scroll", (nsIDOMEventListener)this.getContentAreaEventListener(), false);
            }
            if (this.xulRunnerEditor != null && this.xulRunnerEditor.getWebBrowser() != null) {
                nsIDOMWindow window = this.xulRunnerEditor.getWebBrowser().getContentDOMWindow();
                nsIDOMEventTarget eventTarget = (nsIDOMEventTarget)window.queryInterface("{1c773b30-d1cf-11d2-bd95-00805f8ae3f4}");
                eventTarget.removeEventListener("MozAfterPaint", (nsIDOMEventListener)this.getContentAreaEventListener(), false);
            }
            this.getContentAreaEventListener().setVisualEditor(null);
            this.getContentAreaEventListener().setEditorDomEventListener(null);
            this.setContentAreaEventTarget(null);
            this.setContentAreaEventListener(null);
            this.documentEventTarget = null;
        }
    }

    private void addSelectionListener() {
        if (this.getContentAreaEventListener() != null && this.xulRunnerEditor != null) {
            this.xulRunnerEditor.addSelectionListener((nsISelectionListener)this.getContentAreaEventListener());
        }
    }

    public void setSelectionRectangle(nsIDOMNode element, int resizerConstrains, boolean scroll) {
        if (this.getContentAreaEventListener() != null) {
            this.xulRunnerEditor.setSelectionRectangle(element, resizerConstrains, scroll);
        }
    }

    public void showResizer() {
        if (this.getContentAreaEventListener() != null) {
            this.xulRunnerEditor.showResizer();
        }
    }

    public void hideResizer() {
        if (this.getContentAreaEventListener() != null) {
            this.xulRunnerEditor.hideResizer();
        }
    }

    public XulRunnerEditor getXulRunnerEditor() {
        return this.xulRunnerEditor;
    }

    protected void setXulRunnerEditor(XulRunnerEditor xulRunnerEditor) {
        this.xulRunnerEditor = xulRunnerEditor;
    }

    public VpeController getController() {
        return this.controller;
    }

    public nsIDOMEventTarget getContentAreaEventTarget() {
        return this.contentAreaEventTarget;
    }

    public void setContentAreaEventTarget(nsIDOMEventTarget contentAreaEventTarget) {
        this.contentAreaEventTarget = contentAreaEventTarget;
    }

    public MozillaDomEventListener getContentAreaEventListener() {
        if (this.contentAreaEventListener == null) {
            this.contentAreaEventListener = new MozillaDomEventListener();
        }
        return this.contentAreaEventListener;
    }

    public void setContentAreaEventListener(MozillaDomEventListener contentAreaEventListener) {
        this.contentAreaEventListener = contentAreaEventListener;
    }

    public void onReloadWindow() {
        this.removeDomEventListeners();
        this.xulRunnerEditor.removeResizerListener();
        this.contentArea = this.findContentArea();
        this.addDomEventListeners();
        this.addSelectionListener();
        this.xulRunnerEditor.addResizerListener();
        this.controller.reinit();
    }

    public void reload() {
        this.doctype = DocTypeUtil.getDoctype(this.getEditorInput());
        this.setRefreshPage(true);
        this.setInitialContent();
    }

    public void initDesingMode() {
        this.tearDownEditor();
        this.getEditor();
    }

    public String getDoctype() {
        return this.doctype;
    }

    public boolean isRefreshPage() {
        return this.isRefreshPage;
    }

    public void setRefreshPage(boolean isRefreshPage) {
        this.isRefreshPage = isRefreshPage;
    }

    public void reinitDesignMode() {
        this.tearDownEditor();
        this.getEditor();
    }

    public void tearDownEditor() {
        if (this.editor != null) {
            nsIEditingSession iEditingSession = (nsIEditingSession)this.getXulRunnerEditor().getComponentManager().createInstanceByContractID("@mozilla.org/editor/editingsession;1", null, "{274cd32e-3675-47e1-9d8a-fc6504ded9ce}");
            nsIDOMWindow window = this.getXulRunnerEditor().getWebBrowser().getContentDOMWindow();
            iEditingSession.detachFromWindow(window);
            iEditingSession.tearDownEditorOnWindow(window);
            this.editor = null;
        }
    }

    public nsIEditor getEditor() {
        if (this.editor == null) {
            nsIEditingSession iEditingSession = (nsIEditingSession)this.getXulRunnerEditor().getComponentManager().createInstanceByContractID("@mozilla.org/editor/editingsession;1", null, "{274cd32e-3675-47e1-9d8a-fc6504ded9ce}");
            iEditingSession.makeWindowEditable(this.getXulRunnerEditor().getWebBrowser().getContentDOMWindow(), "html", true, true, true);
            iEditingSession.setupEditorOnWindow(this.getXulRunnerEditor().getWebBrowser().getContentDOMWindow());
            this.editor = iEditingSession.getEditorForWindow(this.getXulRunnerEditor().getWebBrowser().getContentDOMWindow());
            this.editor.setFlags(8L);
            nsIHTMLObjectResizer htmlObjectResizer = (nsIHTMLObjectResizer)this.editor.queryInterface("{8b396020-69d3-451f-80c1-1a96a7da25a9}");
            htmlObjectResizer.hideResizers();
            htmlObjectResizer.setObjectResizingEnabled(false);
            nsIHTMLAbsPosEditor htmlAbsPosEditor = (nsIHTMLAbsPosEditor)this.editor.queryInterface("{91375f52-20e6-4757-9835-eb04fabe5498}");
            htmlAbsPosEditor.setAbsolutePositioningEnabled(false);
            nsIHTMLInlineTableEditor inlineTableEditor = (nsIHTMLInlineTableEditor)this.editor.queryInterface("{eda2e65c-a758-451f-9b05-77cb8de74ed2}");
            inlineTableEditor.setInlineTableEditingEnabled(false);
        }
        return this.editor;
    }

    public VpeDropDownMenu getDropDownMenu() {
        return this.dropDownMenu;
    }

    public void updateToolbarItemsAccordingToPreferences() {
        String prefsOrientation = JspEditorPlugin.getDefault().getPreferenceStore().getString("Visual/Source Editors Splitting");
        int prefsOrientationIndex = layoutValues.indexOf(prefsOrientation);
        boolean prefsShowBorderForUnknownTags = JspEditorPlugin.getDefault().getPreferenceStore().getBoolean("Show Border for Unknown Tags");
        boolean prefsShowNonVisualTags = JspEditorPlugin.getDefault().getPreferenceStore().getBoolean("Show non-visual tags");
        boolean prefsShowSelectionBar = JspEditorPlugin.getDefault().getPreferenceStore().getBoolean("Show Selection Tag Bar");
        boolean prefsShowTextFormatting = JspEditorPlugin.getDefault().getPreferenceStore().getBoolean("Show Text Formatting bar");
        boolean prefsShowBundlesAsEL = JspEditorPlugin.getDefault().getPreferenceStore().getBoolean("Show Resource Bundles Usage as EL Expressions");
        if (this.showBorderAction != null) {
            this.showBorderAction.setChecked(prefsShowBorderForUnknownTags);
        }
        if (this.showNonVisualTagsAction != null) {
            this.showNonVisualTagsAction.setChecked(prefsShowNonVisualTags);
        }
        if (this.showSelectionBarAction != null) {
            this.showSelectionBarAction.setChecked(prefsShowSelectionBar);
        }
        if (this.showTextFormattingAction != null) {
            this.showTextFormattingAction.setChecked(prefsShowTextFormatting);
        }
        if (this.showBundleAsELAction != null) {
            this.showBundleAsELAction.setChecked(prefsShowBundlesAsEL);
        }
        if (this.rotateEditorsAction != null) {
            this.currentOrientationIndex = prefsOrientationIndex;
            this.rotateEditorsAction.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)layoutIcons.get(prefsOrientation)));
            this.rotateEditorsAction.setToolTipText(layoutNames.get(prefsOrientation));
        }
    }

    public void updateShowSelectionBarItem(boolean checked) {
        this.showSelectionBarAction.setChecked(checked);
    }

    public EditorDomEventListener getEditorDomEventListener() {
        return this.editorDomEventListener;
    }
}

