/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.mozilla;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jboss.tools.vpe.editor.VpeEditorPart;
import org.jboss.tools.vpe.editor.VpePreviewDomBuilder;
import org.jboss.tools.vpe.editor.VpeSourceDomBuilder;
import org.jboss.tools.vpe.editor.bundle.BundleMap;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mozilla.EditorDomEventListener;
import org.jboss.tools.vpe.editor.mozilla.EditorLoadWindowListener;
import org.jboss.tools.vpe.editor.mozilla.MozillaDomEventListener;
import org.jboss.tools.vpe.editor.mozilla.MozillaEditor;
import org.jboss.tools.vpe.editor.mozilla.PreviewDomEventListener;
import org.jboss.tools.vpe.editor.mozilla.XulRunnerPreview;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.w3c.dom.Document;

public class MozillaPreview
extends MozillaEditor {
    private EditorLoadWindowListener editorLoadWindowListener;
    private EditorDomEventListener editorDomEventListener;
    private VpeTemplateManager templateManager;
    private VpePageContext pageContext;
    private StructuredTextEditor sourceEditor;
    private VpeEditorPart editPart;
    private IDOMDocument sourceDocument;
    private PreviewDomEventListener contentAreaEventListener;

    public MozillaPreview(VpeEditorPart editPart, StructuredTextEditor sourceEditor) {
        this.setTemplateManager(VpeTemplateManager.getInstance());
        this.setSourceEditor(sourceEditor);
        this.setEditPart(editPart);
    }

    public void createPartControl(Composite parent) {
        try {
            this.setXulRunnerEditor(new XulRunnerPreview(parent, this));
            this.setInitialContent();
            this.getXulRunnerEditor().setLayoutData((Object)new GridData(4, 4, true, true));
        }
        catch (Throwable e) {
            this.showXulRunnerException(parent, e);
        }
    }

    public void setEditorLoadWindowListener(EditorLoadWindowListener listener) {
        this.editorLoadWindowListener = listener;
    }

    public void onLoadWindow() {
        this.setContentArea(this.findContentArea());
        this.addDomEventListeners();
        if (this.editorLoadWindowListener != null) {
            this.editorLoadWindowListener.load();
        }
    }

    public void showResizer() {
    }

    public void hideResizer() {
    }

    public void rebuildDom() {
        if (this.getPageContext() != null && this.getPageContext().getVisualBuilder() != null && this.getSourceDocument() != null) {
            this.getPageContext().getVisualBuilder().rebuildDom((Document)this.getSourceDocument());
        }
    }

    public void buildDom() {
        BundleMap bundle = new BundleMap();
        bundle.init(this.getSourceEditor());
        bundle.setShowBundleUsageAsEL(false);
        this.setPageContext(new VpePageContext(bundle, this.getEditPart()));
        VpeDomMapping domMapping = new VpeDomMapping(this.getPageContext());
        VpeSourceDomBuilder sourceBuilder = new VpeSourceDomBuilder(domMapping, null, this.getTemplateManager(), this.getSourceEditor(), this.getPageContext());
        VpePreviewDomBuilder visualBuilder = new VpePreviewDomBuilder(domMapping, null, this.getTemplateManager(), this, this.getPageContext());
        this.getPageContext().setSourceDomBuilder(sourceBuilder);
        this.getPageContext().setVisualDomBuilder(visualBuilder);
        IDOMModel sourceModel = (IDOMModel)this.getSourceEditor().getModel();
        this.setSourceDocument(sourceModel.getDocument());
        visualBuilder.buildDom((Document)this.getSourceDocument());
    }

    protected IDOMDocument getSourceDocument() {
        return this.sourceDocument;
    }

    protected void setSourceDocument(IDOMDocument sourceDocument) {
        this.sourceDocument = sourceDocument;
    }

    private VpePageContext getPageContext() {
        return this.pageContext;
    }

    private void setPageContext(VpePageContext pageContext) {
        this.pageContext = pageContext;
    }

    private VpeEditorPart getEditPart() {
        return this.editPart;
    }

    private void setEditPart(VpeEditorPart editPart) {
        this.editPart = editPart;
    }

    private VpeTemplateManager getTemplateManager() {
        return this.templateManager;
    }

    private void setTemplateManager(VpeTemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    private StructuredTextEditor getSourceEditor() {
        return this.sourceEditor;
    }

    private void setSourceEditor(StructuredTextEditor sourceEditor) {
        this.sourceEditor = sourceEditor;
    }

    public void dispose() {
        this.setEditorDomEventListener(null);
        this.setEditorLoadWindowListener(null);
        this.setContentAreaEventListener(null);
        if (this.pageContext != null) {
            this.pageContext.dispose();
            this.pageContext = null;
        }
        if (this.getXulRunnerEditor() != null) {
            this.getXulRunnerEditor().dispose();
            this.setXulRunnerEditor(null);
        }
        this.sourceDocument = null;
        this.sourceEditor = null;
        this.editPart = null;
    }

    public MozillaDomEventListener getContentAreaEventListener() {
        if (this.contentAreaEventListener == null) {
            this.contentAreaEventListener = new PreviewDomEventListener();
        }
        return this.contentAreaEventListener;
    }

    public void setContentAreaEventListener(MozillaDomEventListener contentAreaEventListener) {
        if (contentAreaEventListener instanceof PreviewDomEventListener) {
            this.contentAreaEventListener = (PreviewDomEventListener)contentAreaEventListener;
        }
    }
}

