/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.NodeData;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mapping.VpeElementMapping;
import org.jboss.tools.vpe.editor.mapping.VpeNodeMapping;
import org.jboss.tools.vpe.editor.selection.VpeSelectionController;
import org.jboss.tools.vpe.editor.template.ISelectionManager;
import org.jboss.tools.vpe.editor.template.VpeTemplate;
import org.jboss.tools.vpe.editor.util.NodesManagingUtil;
import org.jboss.tools.vpe.editor.util.SelectionUtil;
import org.jboss.tools.vpe.editor.util.TextUtil;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMMouseEvent;
import org.mozilla.interfaces.nsIDOMNSUIEvent;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsISelection;
import org.w3c.dom.Node;

public class SelectionManager
implements ISelectionManager {
    private VpePageContext pageContext;
    private StructuredTextEditor sourceEditor;
    private VpeSelectionController selectionController;

    public SelectionManager(VpePageContext pageContext, StructuredTextEditor sourceEditor, VpeSelectionController selectionController) {
        this.pageContext = pageContext;
        this.sourceEditor = sourceEditor;
        this.selectionController = selectionController;
    }

    public final void setSelection(nsISelection selection) {
        int length;
        int focusOffset;
        nsIDOMNode targetVisualNode;
        Node targetSourceNode;
        boolean isNodeEditable;
        nsIDOMNode selectedVisualNode = SelectionUtil.getSelectedNode(selection);
        if (selectedVisualNode == null) {
            return;
        }
        VpeNodeMapping nodeMapping = NodesManagingUtil.getNodeMapping(this.getDomMapping(), selectedVisualNode);
        if (nodeMapping == null) {
            return;
        }
        if (nodeMapping instanceof VpeElementMapping) {
            VpeElementMapping elementMapping = (VpeElementMapping)nodeMapping;
            VpeTemplate template = elementMapping.getTemplate();
            NodeData nodeData = template.getNodeData(selectedVisualNode, elementMapping.getElementData(), this.getDomMapping());
            if (nodeData != null) {
                isNodeEditable = nodeData.isEditable();
                if (nodeData.getSourceNode() != null) {
                    targetSourceNode = nodeData.getSourceNode();
                } else {
                    isNodeEditable = false;
                    targetSourceNode = elementMapping.getSourceNode();
                }
                targetVisualNode = nodeData.getVisualNode();
            } else {
                targetVisualNode = elementMapping.getVisualNode();
                targetSourceNode = elementMapping.getSourceNode();
                isNodeEditable = false;
            }
        } else {
            targetVisualNode = nodeMapping.getVisualNode();
            targetSourceNode = nodeMapping.getSourceNode();
            isNodeEditable = true;
        }
        if (targetVisualNode.getNodeType() != 3 && SelectionUtil.getLastSelectedNode(this.getPageContext()) == targetVisualNode) {
            return;
        }
        if (isNodeEditable) {
            Point sourceSelectionRange = SelectionUtil.getSourceSelectionRange(selection, targetSourceNode);
            focusOffset = sourceSelectionRange.x;
            length = sourceSelectionRange.y;
        } else {
            focusOffset = 0;
            length = NodesManagingUtil.getNodeLength(targetSourceNode);
        }
        SelectionUtil.setSourceSelection(this.getPageContext(), targetSourceNode, focusOffset, length);
        this.getPageContext().getVisualBuilder().setSelectionRectangle(targetVisualNode);
    }

    public final void setSelection(nsIDOMMouseEvent mouseEvent) {
        int selectionLength;
        int selectionOffset;
        nsIDOMNode targetVisualNode;
        Node targetSourceNode;
        boolean isNodeEditable;
        nsIDOMNode visualNode = VisualDomUtil.getTargetNode((nsIDOMEvent)mouseEvent);
        VpeNodeMapping nodeMapping = NodesManagingUtil.getNodeMapping(this.getDomMapping(), visualNode);
        if (nodeMapping == null) {
            return;
        }
        if (nodeMapping instanceof VpeElementMapping) {
            VpeElementMapping elementMapping = (VpeElementMapping)nodeMapping;
            VpeTemplate template = elementMapping.getTemplate();
            NodeData nodeData = template.getNodeData(visualNode, elementMapping.getElementData(), this.getDomMapping());
            if (nodeData != null) {
                isNodeEditable = nodeData.isEditable();
                if (nodeData.getSourceNode() != null) {
                    targetSourceNode = nodeData.getSourceNode();
                } else {
                    isNodeEditable = false;
                    targetSourceNode = elementMapping.getSourceNode();
                }
                targetVisualNode = nodeData.getVisualNode();
            } else {
                targetVisualNode = elementMapping.getVisualNode();
                targetSourceNode = elementMapping.getSourceNode();
                isNodeEditable = false;
            }
        } else {
            targetVisualNode = nodeMapping.getVisualNode();
            targetSourceNode = nodeMapping.getSourceNode();
            isNodeEditable = true;
        }
        nsIDOMNSUIEvent nsuiEvent = (nsIDOMNSUIEvent)mouseEvent.queryInterface("{a6cf90c4-15b3-11d2-932e-00805f8add32}");
        if (isNodeEditable) {
            selectionOffset = nsuiEvent.getRangeOffset();
            selectionLength = 0;
        } else {
            selectionOffset = 0;
            selectionLength = NodesManagingUtil.getNodeLength(targetSourceNode);
        }
        SelectionUtil.setSourceSelection(this.getPageContext(), targetSourceNode, selectionOffset, selectionLength);
        this.getPageContext().getVisualBuilder().setSelectionRectangle(targetVisualNode);
    }

    public final void refreshVisualSelection() {
        nsIDOMNode targetVisualNode;
        if (this.getSourceEditor().getTextViewer() == null) {
            return;
        }
        Point range = SelectionUtil.getSourceSelectionRange(this.getSourceEditor());
        if (range == null) {
            return;
        }
        int focusOffcetInSourceDocument = range.x;
        int anchorOffcetInSourceDocument = focusOffcetInSourceDocument + range.y;
        VpeNodeMapping nodeMapping = SelectionUtil.getNodeMappingBySourceSelection(this.getSourceEditor(), this.getDomMapping());
        if (nodeMapping == null) {
            return;
        }
        SelectionUtil.clearSelection(this.selectionController);
        if (nodeMapping instanceof VpeElementMapping) {
            VpeElementMapping elementMapping = (VpeElementMapping)nodeMapping;
            VpeTemplate template = elementMapping.getTemplate();
            NodeData nodeData = template.getNodeData(targetVisualNode = template.getVisualNodeBySourcePosition(elementMapping, focusOffcetInSourceDocument, anchorOffcetInSourceDocument, this.getDomMapping()), elementMapping.getElementData(), this.getDomMapping());
            if (nodeData != null) {
                this.restoreVisualCursorPosition(template, nodeData, focusOffcetInSourceDocument, anchorOffcetInSourceDocument);
            }
        } else {
            targetVisualNode = nodeMapping.getVisualNode();
        }
        this.getPageContext().getVisualBuilder().setSelectionRectangle(targetVisualNode);
    }

    private void restoreVisualCursorPosition(VpeTemplate template, NodeData nodeData, int focusOffcetInSourceDocument, int anchorOffsetrInSourceDocument) {
        nsIDOMNode visualNode = nodeData.getVisualNode();
        if (visualNode != null && visualNode.getNodeType() == 3 && nodeData.getSourceNode() != null) {
            Node targetSourceNode = nodeData.getSourceNode();
            int focusOffcetReferenceToSourceNode = focusOffcetInSourceDocument - NodesManagingUtil.getStartOffsetNode(targetSourceNode);
            int anchorOffcetReferenceToSourceNode = anchorOffsetrInSourceDocument - NodesManagingUtil.getStartOffsetNode(targetSourceNode);
            int length = visualNode.getNodeValue().length();
            NodeImpl sourceTextImpl = (NodeImpl)targetSourceNode;
            int visualNodeFocusOffcet = TextUtil.visualPosition(sourceTextImpl.getValueSource(), focusOffcetReferenceToSourceNode);
            int visualNodeAnchorOffcet = TextUtil.visualPosition(sourceTextImpl.getValueSource(), anchorOffcetReferenceToSourceNode);
            if (visualNodeFocusOffcet > length || visualNodeAnchorOffcet > length) {
                return;
            }
            nsISelection selection = this.selectionController.getSelection((short)1);
            selection.collapse(visualNode, visualNodeFocusOffcet);
            if (visualNodeAnchorOffcet != visualNodeFocusOffcet) {
                selection.extend(visualNode, visualNodeAnchorOffcet);
            }
        }
    }

    protected VpePageContext getPageContext() {
        return this.pageContext;
    }

    protected VpeDomMapping getDomMapping() {
        return this.pageContext.getDomMapping();
    }

    protected StructuredTextEditor getSourceEditor() {
        return this.sourceEditor;
    }
}

