/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractCreator;
import org.jboss.tools.vpe.editor.template.VpeAnyData;
import org.jboss.tools.vpe.editor.template.VpeAttributeCreator;
import org.jboss.tools.vpe.editor.template.VpeCreator;
import org.jboss.tools.vpe.editor.template.VpeCreatorInfo;
import org.jboss.tools.vpe.editor.template.VpeDependencyMap;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.jboss.tools.vpe.editor.template.expression.VpeExpression;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilder;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilderException;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionException;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionInfo;
import org.mozilla.interfaces.nsIDOMAttr;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VpeAnyCreator
extends VpeAbstractCreator {
    private static final String DEFAULT_TAG_FOR_DISPLAY = "div";
    static final String CLASS_TAG_BLOCK = "__any__tag__block";
    static final String CLASS_TAG_INLINE = "__any__tag__inline";
    static final String CLASS_TAG_NONE = "__any__tag__none";
    static final String CLASS_TAG_CAPTION = "__any__tag__caption";
    private VpeExpression valueExpr;
    private VpeExpression tagForDisplayExpr;
    private VpeExpression styleExpr;
    private List propertyCreators;
    private Set dependencySet;
    private String tagForDisplayStr;
    private String valueStr;
    private String styleStr;
    private boolean showIconBool;

    VpeAnyCreator(Element element, VpeDependencyMap dependencyMap, boolean caseSensitive) {
        this.build(element, dependencyMap);
    }

    private void build(Element element, VpeDependencyMap dependencyMap) {
        Attr attr;
        Attr valueAttr;
        Attr styleAttr;
        Attr tagForDisplay = element.getAttributeNode("tag-for-display");
        if (tagForDisplay != null) {
            try {
                this.tagForDisplayStr = tagForDisplay.getNodeValue();
                VpeExpressionInfo info = VpeExpressionBuilder.buildCompletedExpression(this.tagForDisplayStr, true);
                this.tagForDisplayExpr = info.getExpression();
                dependencyMap.setCreator((VpeCreator)this, info.getDependencySet());
            }
            catch (VpeExpressionBuilderException ex) {
                VpePlugin.reportProblem(ex);
            }
        }
        if ((styleAttr = element.getAttributeNode("style")) != null) {
            try {
                Attr attrBorderColor;
                Attr attrBachkgroundColor;
                Attr attrValueBackgroundColor;
                Attr attrValueColor;
                Attr attrBorder = element.getAttributeNode("border");
                StringBuffer stringBuffer = new StringBuffer();
                if (attrBorder != null) {
                    stringBuffer.append("border-width:").append(attrBorder.getNodeValue()).append(";");
                }
                if ((attrValueColor = element.getAttributeNode("value-color")) != null) {
                    stringBuffer.append("color:").append(attrValueColor.getNodeValue()).append(";");
                }
                if ((attrValueBackgroundColor = element.getAttributeNode("value-background-color")) != null) {
                    stringBuffer.append("background-color:").append(attrValueBackgroundColor.getNodeValue()).append(";");
                }
                if ((attrBachkgroundColor = element.getAttributeNode("background-color")) != null) {
                    stringBuffer.append("background-color:").append(attrBachkgroundColor.getNodeValue()).append(";");
                }
                if ((attrBorderColor = element.getAttributeNode("border-color")) != null) {
                    stringBuffer.append("border-color:").append(attrBorderColor.getNodeValue()).append(";");
                }
                this.styleStr = stringBuffer.toString().length() > 0 ? stringBuffer.toString() : styleAttr.getValue();
                VpeExpressionInfo info = VpeExpressionBuilder.buildCompletedExpression(this.styleStr, true);
                this.styleExpr = info.getExpression();
                dependencyMap.setCreator((VpeCreator)this, info.getDependencySet());
            }
            catch (VpeExpressionBuilderException e) {
                VpePlugin.reportProblem(e);
            }
        }
        if ((valueAttr = element.getAttributeNode("value")) != null) {
            try {
                this.valueStr = valueAttr.getValue();
                VpeExpressionInfo info = VpeExpressionBuilder.buildCompletedExpression(this.valueStr, true);
                this.valueExpr = info.getExpression();
                dependencyMap.setCreator((VpeCreator)this, info.getDependencySet());
            }
            catch (VpeExpressionBuilderException e) {
                VpePlugin.reportProblem(e);
            }
        }
        if (VpeTemplateManager.ATTR_ANY_PROPERTIES != null) {
            int i = 0;
            while (i < VpeTemplateManager.ATTR_ANY_PROPERTIES.length) {
                String attrName = VpeTemplateManager.ATTR_ANY_PROPERTIES[i];
                Attr attr2 = element.getAttributeNode(attrName);
                if (attr2 != null) {
                    if (this.propertyCreators == null) {
                        this.propertyCreators = new ArrayList();
                    }
                    this.propertyCreators.add(new VpeAttributeCreator(attrName, attr2.getValue(), dependencyMap, true));
                }
                ++i;
            }
        }
        if ((attr = element.getAttributeNode("title")) == null) {
            if (this.propertyCreators == null) {
                this.propertyCreators = new ArrayList();
            }
            this.propertyCreators.add(new VpeAttributeCreator("title", "{tagstring()}", dependencyMap, true));
        }
    }

    public VpeCreatorInfo create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, nsIDOMElement visualElement, Map visualNodeMap) throws VpeExpressionException {
        String tagForDisplay = this.getExprValue(pageContext, this.tagForDisplayExpr, sourceNode);
        if (tagForDisplay == null || tagForDisplay.length() == 0) {
            tagForDisplay = DEFAULT_TAG_FOR_DISPLAY;
        }
        nsIDOMElement anyElement = visualDocument.createElement(tagForDisplay);
        VpeCreatorInfo creatorInfo = new VpeCreatorInfo((nsIDOMNode)anyElement);
        if (this.showIconBool) {
            nsIDOMElement img = visualDocument.createElement("img");
            img.setAttribute("src", "any.gif");
            img.setAttribute("width", "16");
            img.setAttribute("height", "16");
            anyElement.appendChild((nsIDOMNode)img);
        }
        anyElement.setAttribute("class", CLASS_TAG_CAPTION);
        String styleString = this.getExprValue(pageContext, this.styleExpr, sourceNode);
        anyElement.setAttribute("style", styleString);
        if (this.propertyCreators != null) {
            int i = 0;
            while (i < this.propertyCreators.size()) {
                VpeCreatorInfo info;
                VpeCreator creator = (VpeCreator)this.propertyCreators.get(i);
                if (creator != null && (info = creator.create(pageContext, (Element)sourceNode, visualDocument, anyElement, visualNodeMap)) != null && info.getVisualNode() != null) {
                    nsIDOMAttr attr = (nsIDOMAttr)info.getVisualNode();
                    anyElement.setAttributeNode(attr);
                }
                ++i;
            }
        }
        String valueStr = this.getExprValue(pageContext, this.valueExpr, sourceNode);
        nsIDOMText valueNode = visualDocument.createTextNode(valueStr);
        anyElement.appendChild((nsIDOMNode)valueNode);
        creatorInfo.addDependencySet(this.dependencySet);
        return creatorInfo;
    }

    public VpeAnyData getAnyData() {
        return new VpeAnyData(this.tagForDisplayStr, this.valueStr, this.styleStr);
    }

    private String getExprValue(VpePageContext pageContext, VpeExpression expr, Node sourceNode) {
        String value;
        if (expr != null) {
            try {
                value = expr.exec(pageContext, sourceNode).stringValue();
            }
            catch (VpeExpressionException e) {
                VpeExpressionException exception = new VpeExpressionException(String.valueOf(sourceNode.toString()) + " " + expr.toString(), e);
                VpePlugin.reportProblem(exception);
                value = "";
            }
        } else {
            value = "";
        }
        return value;
    }
}

