/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractCreator;
import org.jboss.tools.vpe.editor.template.VpeAttributeCreator;
import org.jboss.tools.vpe.editor.template.VpeCreator;
import org.jboss.tools.vpe.editor.template.VpeCreatorInfo;
import org.jboss.tools.vpe.editor.template.VpeDependencyMap;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionException;
import org.mozilla.interfaces.nsIDOMAttr;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VpeCopyCreator
extends VpeAbstractCreator {
    private static String STYLE_ATTR_NAME = "style";
    private boolean caseSensitive;
    private HashSet attrSet;
    private VpeCreator[] attrs;

    VpeCopyCreator(Element copyElement, VpeDependencyMap dependencyMap, boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.build(copyElement, dependencyMap);
    }

    private void build(Element copyElement, VpeDependencyMap dependencyMap) {
        int len;
        NodeList copyChildren;
        dependencyMap.setCreator((VpeCreator)this, "@*");
        Attr attrsAttr = copyElement.getAttributeNode("attrs");
        if (attrsAttr != null) {
            this.attrSet = new HashSet();
            String attrsValue = attrsAttr.getValue();
            String[] attrsArr = attrsValue.split(",");
            int i = 0;
            while (i < attrsArr.length) {
                String attr = attrsArr[i].trim();
                if (attr.length() > 0) {
                    this.attrSet.add(this.caseSensitive ? attr : attr.toLowerCase());
                }
                ++i;
            }
        }
        if ((copyChildren = copyElement.getChildNodes()) != null && (len = copyChildren.getLength()) > 0) {
            ArrayList<VpeAttributeCreator> creatorAttrs = new ArrayList<VpeAttributeCreator>(len);
            int i = 0;
            while (i < len) {
                String attrName;
                Node innerNode = copyChildren.item(i);
                if (innerNode.getNodeType() == 1 && "vpe:attribute".equals(innerNode.getNodeName()) && (attrName = ((Element)innerNode).getAttribute("name").trim()).length() > 0) {
                    String attrValue = ((Element)innerNode).getAttribute("value").trim();
                    creatorAttrs.add(new VpeAttributeCreator(attrName, attrValue, dependencyMap, this.caseSensitive));
                }
                ++i;
            }
            if (creatorAttrs.size() > 0) {
                this.attrs = creatorAttrs.toArray(new VpeCreator[creatorAttrs.size()]);
            }
        }
    }

    public VpeCreatorInfo create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, nsIDOMElement visualElement, Map visualNodeMap) throws VpeExpressionException {
        nsIDOMElement visualNewElement = visualDocument.createElement(sourceNode.getNodeName());
        visualNodeMap.put(this, visualNewElement);
        this.addAttributes((Element)sourceNode, visualNewElement, pageContext);
        if (this.attrs != null) {
            int i = 0;
            while (i < this.attrs.length) {
                nsIDOMAttr newVisualAttribute;
                VpeCreatorInfo attributeInfo = this.attrs[i].create(pageContext, (Element)sourceNode, visualDocument, visualNewElement, visualNodeMap);
                if (attributeInfo != null && (newVisualAttribute = (nsIDOMAttr)attributeInfo.getVisualNode()) != null) {
                    visualNewElement.setAttributeNode(newVisualAttribute);
                }
                ++i;
            }
        }
        return new VpeCreatorInfo((nsIDOMNode)visualNewElement);
    }

    public void setAttribute(VpePageContext pageContext, Element sourceElement, Map visualNodeMap, String name, String value) {
        if (this.isAttribute(name)) {
            nsIDOMElement visualElement = (nsIDOMElement)visualNodeMap.get(this);
            visualElement.setAttribute(name, value);
        }
    }

    public void removeAttribute(VpePageContext pageContext, Element sourceElement, Map visualNodeMap, String name) {
        if (this.isAttribute(name)) {
            nsIDOMElement visualElement = (nsIDOMElement)visualNodeMap.get(this);
            visualElement.removeAttribute(name);
        }
    }

    public void pseudo(VpePageContext pageContext, Node sourceNode, nsIDOMNode visualNode, Map visualNodeMap) {
        visualNodeMap.put(this, visualNode);
    }

    private void addAttributes(Element sourceElement, nsIDOMElement visualElement, VpePageContext pageContext) {
        NamedNodeMap sourceAttributes = sourceElement.getAttributes();
        if (sourceAttributes == null) {
            return;
        }
        int len = sourceAttributes.getLength();
        int i = 0;
        while (i < len) {
            Attr sourceAttr = (Attr)sourceAttributes.item(i);
            String name = sourceAttr.getName();
            String value = sourceElement.getAttribute(name);
            if (this.isAttribute(name)) {
                visualElement.setAttribute(name, value);
            }
            ++i;
        }
    }

    private boolean isAttribute(String name) {
        if (this.attrSet == null) {
            return true;
        }
        return this.attrSet.contains(this.caseSensitive ? name : name.toLowerCase());
    }
}

