/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.VpeIncludeInfo;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAttributeInfo;
import org.jboss.tools.vpe.editor.util.FileUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VpeCreatorUtil {
    public static final int FACET_TYPE_NONE = 0;
    public static final int FACET_TYPE_HEADER = 1;
    public static final int FACET_TYPE_FOOTER = 2;
    public static final int FACET_TYPE_BODY = 3;
    public static final int FACET_TYPE_NAVIGATION = 4;
    public static final int FACET_TYPE_CAPTION = 5;

    public static boolean isFacet(Node node) {
        if (node != null && node.getNodeType() == 1) {
            return "facet".equals(node.getLocalName());
        }
        return false;
    }

    public static String getFacetName(Node node) {
        if (node != null && node.getNodeType() == 1) {
            return ((Element)node).getAttribute("name");
        }
        return null;
    }

    public static int getFacetType(Node node) {
        String value = VpeCreatorUtil.getFacetName(node);
        if (value != null) {
            if ("header".equals(value)) {
                return 1;
            }
            if ("footer".equals(value)) {
                return 2;
            }
            if ("body".equals(value)) {
                return 3;
            }
            if ("navigation".equals(value)) {
                return 4;
            }
            if ("caption".equals(value)) {
                return 5;
            }
        }
        return 0;
    }

    public static boolean isInclude(Node node) {
        if (node != null && node.getNodeType() == 1) {
            return node.getNodeName().indexOf("jsp:include") >= 0 || node.getNodeName().indexOf("jsp:directive.include") >= 0;
        }
        return false;
    }

    private static IDOMModel getWtpModelForRead(String fileName, VpePageContext pageContext) {
        IEditorInput input = pageContext.getEditPart().getEditorInput();
        IFile file = FileUtil.getFile(input, fileName);
        if (file != null && file.exists()) {
            try {
                return (IDOMModel)StructuredModelManager.getModelManager().getModelForRead(file);
            }
            catch (IOException ex) {
                VpePlugin.reportProblem(ex);
            }
            catch (CoreException ex) {
                VpePlugin.reportProblem((Exception)((Object)ex));
            }
        }
        return null;
    }

    public static Document getIncludeDocument(Node includeNode, VpePageContext pageContext) {
        if (VpeCreatorUtil.isInclude(includeNode)) {
            IDOMModel wtpModel;
            String pageName = ((Element)includeNode).getAttribute("page");
            if (pageName == null) {
                pageName = ((Element)includeNode).getAttribute("file");
            }
            if (pageName != null && (wtpModel = VpeCreatorUtil.getWtpModelForRead(pageName, pageContext)) != null) {
                return wtpModel.getDocument();
            }
        }
        return null;
    }

    public static void releaseDocumentFromRead(Document document) {
        IDOMModel wtpModel;
        if (document instanceof IDOMNode && (wtpModel = ((IDOMNode)document).getModel()) != null) {
            wtpModel.releaseFromRead();
        }
    }

    public static IFile getFile(String fileName, VpePageContext pageContext) {
        if (fileName == null) {
            return null;
        }
        IEditorInput input = pageContext.getEditPart().getEditorInput();
        IFile file = null;
        VpeIncludeInfo currentIncludeInfo = pageContext.getVisualBuilder().getCurrentIncludeInfo();
        if (currentIncludeInfo == null || !(currentIncludeInfo.getStorage() instanceof IFile)) {
            file = FileUtil.getFile(input, fileName);
        } else {
            IFile includedFile = (IFile)currentIncludeInfo.getStorage();
            file = FileUtil.getFile(fileName, includedFile);
        }
        if (file != null) {
            if (!file.isSynchronized(0)) {
                try {
                    file.refreshLocal(0, null);
                }
                catch (CoreException ex) {
                    VpePlugin.getPluginLog().logError((Throwable)ex);
                }
                catch (OperationCanceledException ex) {
                    VpePlugin.getPluginLog().logError((Throwable)ex);
                }
            }
            if (file.exists()) {
                return file;
            }
        }
        return null;
    }

    public static Document getDocumentForRead(IFile file) {
        IDOMModel wtpModel = null;
        try {
            wtpModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForRead(file);
            if (wtpModel != null) {
                return wtpModel.getDocument();
            }
        }
        catch (IOException e) {
            VpePlugin.getPluginLog().logError((Throwable)e);
        }
        catch (CoreException e) {
            VpePlugin.getPluginLog().logError((Throwable)e);
        }
        return null;
    }

    public static Document getDocumentForRead(String content) {
        IDOMModel wtpModel = null;
        IModelManager modelManager = StructuredModelManager.getModelManager();
        wtpModel = (IDOMModel)modelManager.createUnManagedStructuredModelFor("org.eclipse.wst.html.core.htmlsource");
        IStructuredDocument document = wtpModel.getStructuredDocument();
        document.set(content);
        if (wtpModel != null) {
            return wtpModel.getDocument();
        }
        return null;
    }

    public static int getFacetType(Node node, VpePageContext pageContext) {
        if (VpeCreatorUtil.isFacet(node)) {
            return VpeCreatorUtil.getFacetType(node);
        }
        Document document = VpeCreatorUtil.getIncludeDocument(node, pageContext);
        if (document != null) {
            try {
                NodeList list = document.getChildNodes();
                int cnt = list != null ? list.getLength() : 0;
                int i = 0;
                while (i < cnt) {
                    Node child = list.item(i);
                    int type = VpeCreatorUtil.getFacetType(child, pageContext);
                    if (type != 0) {
                        int n = type;
                        return n;
                    }
                    ++i;
                }
            }
            finally {
                VpeCreatorUtil.releaseDocumentFromRead(document);
            }
        }
        return 0;
    }

    public static void setAttributes(Element visualElement, Element sourceElement, VpeAttributeInfo[] attrsInfo) {
        if (attrsInfo != null) {
            int i = 0;
            while (i < attrsInfo.length) {
                attrsInfo[i].setAttribure(visualElement, sourceElement);
                ++i;
            }
        }
    }

    public static void setAttributes(Element visualElement, VpeAttributeInfo[] attrsInfo) {
        VpeCreatorUtil.setAttributes(visualElement, null, attrsInfo);
    }

    public static Node getTextChildNode(Node sourceElement) {
        NodeList children = sourceElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 3 && child.getNodeValue().trim().length() > 0) {
                return child;
            }
            ++i;
        }
        return null;
    }
}

