/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.jst.jsp.JspEditorPlugin;
import org.jboss.tools.jst.jsp.outline.cssdialog.CSSStyleDialog;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.Message;
import org.jboss.tools.vpe.editor.template.VpeAnyData;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilder;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilderException;
import org.jboss.tools.vpe.messages.VpeUIMessages;
import org.jboss.tools.vpe.resref.Activator;
import org.jboss.tools.vpe.resref.core.Messages;
import org.osgi.framework.Bundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;

public class VpeEditAnyDialog
extends TitleAreaDialog {
    private VpeAnyData data;
    Text tagName;
    Text tagUri;
    private Button childrenCheckbox;
    private Text txtTagForDisplay;
    private Text txtValue;
    private Text txtStyle;
    private VpeEditAnyDialogValidator templateVerifier;
    private final String DIALOG_TITLE_IMAGE_PATH = "/images/xstudio/wizards/EclipseDefault.png";

    public VpeEditAnyDialog(Shell shell, VpeAnyData data) {
        super(shell);
        this.data = data;
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        Bundle bundle = Platform.getBundle((String)"org.jboss.tools.common.model.ui");
        URL url = null;
        if (bundle != null) {
            try {
                url = FileLocator.resolve((URL)bundle.getEntry("/images/xstudio/wizards/EclipseDefault.png"));
            }
            catch (IOException e) {
                Activator.getDefault().logError(NLS.bind((String)Messages.VRD_TITLE_IMAGE_CANNOT_BE_RESOLVED, (Object)url), (Throwable)e);
            }
        }
        if (url != null) {
            ImageDescriptor image = ImageDescriptor.createFromURL(url);
            this.setTitleImage(image.createImage(null));
        }
        this.getShell().setText(VpeUIMessages.TEMPLATE);
        this.setTitle(VpeUIMessages.TAG_ATTRIBUTES);
        this.setMessage(VpeUIMessages.UNKNOWN_TAGS_DIALOG_DESCRIPTION);
        this.templateVerifier = new VpeEditAnyDialogValidator();
        Composite topComposite = (Composite)super.createDialogArea(parent);
        ((GridData)topComposite.getLayoutData()).widthHint = 300;
        final Composite composite = new Composite(topComposite, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 50;
        gridLayout.marginHeight = 20;
        gridLayout.horizontalSpacing = 5;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setBackground(parent.getBackground());
        composite.setForeground(parent.getForeground());
        composite.setFont(parent.getFont());
        Label tagNameLabel = new Label(composite, 0);
        tagNameLabel.setLayoutData((Object)new GridData(131072, 0, false, false, 1, 1));
        tagNameLabel.setText(VpeUIMessages.TAG_NAME);
        this.tagName = new Text(composite, 2048);
        this.tagName.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        String text = "";
        if (this.data != null && this.data.getName() != null) {
            text = this.data.getName();
        }
        this.tagName.setText(text);
        this.tagName.addModifyListener((ModifyListener)this.templateVerifier);
        Label tagUriLabel = new Label(composite, 0);
        tagUriLabel.setLayoutData((Object)new GridData(131072, 0, false, false, 1, 1));
        tagUriLabel.setText(VpeUIMessages.TAG_URI);
        this.tagUri = new Text(composite, 2048);
        this.tagUri.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        text = "";
        if (this.data != null && this.data.getUri() != null) {
            text = this.data.getUri();
        }
        this.tagUri.setText(text);
        this.tagUri.addModifyListener((ModifyListener)this.templateVerifier);
        Label tagForDisplayLabel = new Label(composite, 0);
        tagForDisplayLabel.setLayoutData((Object)new GridData(131072, 0, false, false, 1, 1));
        tagForDisplayLabel.setText(VpeUIMessages.TAG_FOR_DISPLAY);
        this.txtTagForDisplay = new Text(composite, 2048);
        this.txtTagForDisplay.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        text = "";
        if (this.data != null && this.data.getTagForDisplay() != null) {
            text = this.data.getTagForDisplay();
        }
        this.txtTagForDisplay.setText(text);
        this.txtTagForDisplay.addModifyListener((ModifyListener)this.templateVerifier);
        Label childrenCheckboxLabel = new Label(composite, 0);
        childrenCheckboxLabel.setLayoutData((Object)new GridData(16384, 0, false, false, 1, 1));
        childrenCheckboxLabel.setText(VpeUIMessages.CHILDREN);
        this.childrenCheckbox = new Button(composite, 32);
        this.childrenCheckbox.setLayoutData((Object)new GridData(16384, 0, true, false, 2, 1));
        this.childrenCheckbox.setSelection(this.data.isChildren());
        Label lblValue = new Label(composite, 0);
        lblValue.setLayoutData((Object)new GridData(131072, 0, false, false, 1, 1));
        lblValue.setText(VpeUIMessages.VALUE);
        this.txtValue = new Text(composite, 2048);
        this.txtValue.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        text = "";
        if (this.data != null && this.data.getValue() != null) {
            text = this.data.getValue();
        }
        this.txtValue.setText(text);
        this.txtValue.addModifyListener((ModifyListener)this.templateVerifier);
        Label lbStyle = new Label(composite, 0);
        lbStyle.setLayoutData((Object)new GridData(131072, 0, false, false, 1, 1));
        lbStyle.setText(VpeUIMessages.TAG_STYLE);
        this.txtStyle = new Text(composite, 2048);
        this.txtStyle.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        text = "";
        if (this.data != null && this.data.getStyle() != null) {
            text = this.data.getStyle();
        }
        this.txtStyle.setText(text);
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(16384, 0, false, false, 1, 1));
        button.setToolTipText(VpeUIMessages.EDIT_STYLE_TIP);
        ImageDescriptor colorDesc = JspEditorPlugin.getImageDescriptor((String)"images/cssdialog/color_large.gif");
        Image im = colorDesc.createImage();
        button.setImage(im);
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Button button = (Button)e.getSource();
                button.getImage().dispose();
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CSSStyleDialog cssDialog = new CSSStyleDialog(composite.getShell(), VpeEditAnyDialog.this.txtStyle.getText());
                if (cssDialog.open() == 0) {
                    VpeEditAnyDialog.this.txtStyle.setText(cssDialog.getStyle());
                }
            }
        });
        return composite;
    }

    public void create() {
        super.create();
        this.templateVerifier.validateAll(false);
    }

    protected void okPressed() {
        boolean isChanged = false;
        if (this.data.isChildren() != this.childrenCheckbox.getSelection() || this.isChanged(this.data, this.data.getName(), this.tagName.getText()) || this.isChanged(this.data, this.data.getUri(), this.tagUri.getText()) || this.isChanged(this.data, this.data.getTagForDisplay(), this.txtTagForDisplay.getText()) || this.isChanged(this.data, this.data.getValue(), this.txtValue.getText()) || this.isChanged(this.data, this.data.getStyle(), this.txtStyle.getText())) {
            isChanged = true;
        }
        this.data.setChanged(isChanged);
        this.data.setChildren(this.childrenCheckbox.getSelection());
        this.data.setName(this.tagName.getText().trim());
        this.data.setUri(this.tagUri.getText().trim());
        this.data.setTagForDisplay(this.txtTagForDisplay.getText().trim());
        this.data.setValue(this.txtValue.getText().trim());
        this.data.setStyle(this.txtStyle.getText());
        super.okPressed();
    }

    private boolean isChanged(VpeAnyData data, String oldValue, String newValue) {
        boolean isChanged = false;
        if (oldValue == null) {
            oldValue = "";
        }
        if (newValue == null) {
            newValue = "";
        }
        isChanged = data.isCaseSensitive() ? !oldValue.trim().equals(newValue.trim()) : !oldValue.trim().equalsIgnoreCase(newValue.trim());
        return isChanged;
    }

    public void setMessage(IMessageProvider message) {
        if (message == null) {
            this.setMessage(null, 0);
        } else {
            this.setMessage(message.getMessage(), message.getMessageType());
        }
    }

    private class VpeEditAnyDialogValidator
    implements ModifyListener {
        private Document xmlDocument = null;

        public VpeEditAnyDialogValidator() {
            try {
                this.xmlDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            }
            catch (ParserConfigurationException e) {
                VpePlugin.getPluginLog().logError((Throwable)e);
            }
        }

        private IMessageProvider validateTagName() {
            Message message = null;
            if (VpeEditAnyDialog.this.tagName.getText().indexOf(":") < 0) {
                message = new Message(MessageFormat.format(VpeUIMessages.TAG_NAME_IS_NOT_VALID, VpeEditAnyDialog.this.tagName.getText().trim()), 3);
            }
            return message;
        }

        private IMessageProvider validateTagForDisplay() {
            if (this.xmlDocument != null) {
                try {
                    this.xmlDocument.createElement(VpeEditAnyDialog.this.txtTagForDisplay.getText());
                }
                catch (DOMException e) {
                    return new Message(MessageFormat.format(VpeUIMessages.TAG_FOR_DISPLAY_IS_NOT_VALID, e.getMessage()), 3);
                }
            }
            return null;
        }

        private IMessageProvider validateValue() {
            try {
                VpeExpressionBuilder.buildCompletedExpression(VpeEditAnyDialog.this.txtValue.getText(), true);
            }
            catch (VpeExpressionBuilderException e) {
                return new Message(MessageFormat.format(VpeUIMessages.VALUE_IS_NOT_VALID, e.getMessage()), 3);
            }
            return null;
        }

        void validateAll(boolean updateMessage) {
            IMessageProvider message = null;
            IMessageProvider tagForDisplayMessage = this.validateTagForDisplay();
            IMessageProvider valueMessage = this.validateValue();
            IMessageProvider tagNameMessage = this.validateTagName();
            if (tagNameMessage != null) {
                message = tagNameMessage;
            } else if (tagForDisplayMessage != null) {
                message = tagForDisplayMessage;
            } else if (valueMessage != null) {
                message = valueMessage;
            } else {
                VpeEditAnyDialog.this.setMessage(VpeUIMessages.UNKNOWN_TAGS_DIALOG_DESCRIPTION);
            }
            Button okButton = VpeEditAnyDialog.this.getButton(0);
            if (message == null || message.getMessageType() <= 1) {
                okButton.setEnabled(true);
            } else {
                okButton.setEnabled(false);
            }
            if (updateMessage) {
                VpeEditAnyDialog.this.setMessage(message);
            }
        }

        public void modifyText(ModifyEvent e) {
            this.validateAll(true);
        }
    }
}

