/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.VpeIncludeInfo;
import org.jboss.tools.vpe.editor.VpeVisualDomBuilder;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.template.VpeCreatorUtil;
import org.jboss.tools.vpe.editor.template.expression.VpeAttributeOperand;
import org.jboss.tools.vpe.editor.template.expression.VpeExpression;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilder;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilderException;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionException;
import org.jboss.tools.vpe.editor.template.expression.VpeValue;
import org.jboss.tools.vpe.editor.util.FaceletUtil;
import org.jboss.tools.vpe.editor.util.FileUtil;
import org.jboss.tools.vpe.editor.util.NodesManagingUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VpeIncludeTemplate
extends VpeAbstractTemplate {
    private static final String ATTR_FILE = "file";
    private VpeExpression fileNameExpression;

    protected void init(Element templateElement) {
        this.modify = false;
        Attr fileAttr = templateElement.getAttributeNode(ATTR_FILE);
        if (fileAttr != null && fileAttr.getValue().trim().length() > 0) {
            try {
                this.fileNameExpression = VpeExpressionBuilder.buildCompletedExpression(fileAttr.getValue().trim(), this.caseSensitive).getExpression();
            }
            catch (VpeExpressionBuilderException e) {
                VpePlugin.reportProblem(e);
            }
        }
        this.initTemplateSections(templateElement, false, true, false, false, false);
    }

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        String fileName = null;
        if (this.fileNameExpression != null) {
            try {
                VpeValue vpeValue = this.fileNameExpression.exec(pageContext, sourceNode);
                if (vpeValue != null && vpeValue.stringValue().length() > 0) {
                    IFile templateFile;
                    IFile file;
                    fileName = vpeValue.stringValue();
                    VpeIncludeInfo info = pageContext.getVisualBuilder().getCurrentIncludeInfo();
                    if (info != null && info.getStorage() instanceof IFile && (file = FileUtil.getFile(fileName, templateFile = (IFile)info.getStorage())) != null && !pageContext.getVisualBuilder().isFileInIncludeStack((IStorage)file)) {
                        Document document = pageContext.getVisualBuilder().getIncludeDocuments().get(file);
                        if (document == null && (document = VpeCreatorUtil.getDocumentForRead(file)) != null) {
                            pageContext.getVisualBuilder().getIncludeDocuments().put((IStorage)file, document);
                        }
                        if (document != null) {
                            VpeCreationData creationData = this.createInclude(document, visualDocument);
                            creationData.setData(file);
                            pageContext.getVisualBuilder().pushIncludeStack(new VpeIncludeInfo((Element)sourceNode, (IStorage)file, document));
                            return creationData;
                        }
                    }
                }
            }
            catch (VpeExpressionException e) {
                VpeExpressionException exception = new VpeExpressionException(sourceNode.toString(), e);
                VpePlugin.reportProblem(exception);
            }
        }
        VpeCreationData creationData = this.createStub(fileName, visualDocument);
        creationData.setData(null);
        return creationData;
    }

    public void validate(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, VpeCreationData data) {
        if (data.getData() != null) {
            VpeIncludeInfo vpeIncludeInfo = pageContext.getVisualBuilder().popIncludeStack();
        }
    }

    public void beforeRemove(VpePageContext pageContext, Node sourceNode, nsIDOMNode visualNode, Object data) {
        IFile file = (IFile)data;
        if (file != null) {
            pageContext.getEditPart().getController().getIncludeList().removeIncludeModel(file);
        }
    }

    protected VpeCreationData createInclude(Document sourceDocument, nsIDOMDocument visualDocument) {
        nsIDOMElement visualNewElement = visualDocument.createElement("div");
        VpeVisualDomBuilder.markIncludeElement(visualNewElement);
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)visualNewElement);
        if (this.children) {
            VpeChildrenInfo childrenInfo = new VpeChildrenInfo(visualNewElement);
            Element root = FaceletUtil.findComponentElement(sourceDocument.getDocumentElement());
            NodeList sourceChildren = null;
            sourceChildren = root == null ? sourceDocument.getChildNodes() : root.getChildNodes();
            int len = sourceChildren.getLength();
            int i = 0;
            while (i < len) {
                childrenInfo.addSourceChild(sourceChildren.item(i));
                ++i;
            }
            creationData.addChildrenInfo(childrenInfo);
        }
        return creationData;
    }

    protected VpeCreationData createStub(String fileName, nsIDOMDocument visualDocument) {
        nsIDOMElement visualNewElement = visualDocument.createElement("div");
        visualNewElement.setAttribute("style", "background-color:#ECF3FF;cursor:pointer;padding:0 5px;margin:3px 0;font-style:italic;color:#0051DD;");
        VpeVisualDomBuilder.markIncludeElement(visualNewElement);
        if (fileName != null) {
            visualNewElement.appendChild((nsIDOMNode)visualDocument.createTextNode(fileName));
        }
        return new VpeCreationData((nsIDOMNode)visualNewElement);
    }

    public IRegion getSourceRegionForOpenOn(VpePageContext pageContext, Node sourceNode, nsIDOMNode domNode) {
        if (sourceNode != null && this.fileNameExpression != null && this.fileNameExpression instanceof VpeAttributeOperand) {
            Element sourceElement = (Element)sourceNode;
            Attr paramAttr = sourceElement.getAttributeNode(((VpeAttributeOperand)this.fileNameExpression).getAttributeName());
            return new Region(NodesManagingUtil.getStartOffsetNode(paramAttr), 0);
        }
        return null;
    }
}

