/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.util.Set;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeTemplate;
import org.jboss.tools.vpe.editor.template.VpeTemplateSet;
import org.jboss.tools.vpe.editor.template.expression.VpeExpression;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilder;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilderException;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionException;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionInfo;
import org.jboss.tools.vpe.editor.template.expression.VpeValue;
import org.w3c.dom.Node;

public class VpeTemplateConditionSet
extends VpeTemplateSet {
    private VpeExpression expression;
    private Set dependencySet;

    VpeTemplateConditionSet(String test, boolean caseSensitive) {
        this.build(test, caseSensitive);
    }

    private void build(String test, boolean caseSensitive) {
        try {
            VpeExpressionInfo info = new VpeExpressionBuilder().buildPlainExpression(test, caseSensitive);
            this.expression = info.getExpression();
            this.dependencySet = info.getDependencySet();
        }
        catch (VpeExpressionBuilderException e) {
            VpePlugin.reportProblem(e);
        }
    }

    VpeTemplate getTemplate(VpePageContext pageContext, Node sourceNode, Set ifDependencySet) {
        if (this.dependencySet != null) {
            ifDependencySet.addAll(this.dependencySet);
        }
        if (!this.test(pageContext, sourceNode)) {
            return null;
        }
        return super.getTemplate(pageContext, sourceNode, this.dependencySet);
    }

    private boolean test(VpePageContext pageContext, Node sourceNode) {
        VpeValue value;
        block4: {
            if (this.expression == null) {
                return false;
            }
            try {
                value = this.expression.exec(pageContext, sourceNode);
                if (value != null) break block4;
                return false;
            }
            catch (VpeExpressionException e) {
                VpePlugin.reportProblem(e);
                return false;
            }
        }
        return value.booleanValue();
    }
}

