/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.util.Map;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.VpeSourceDomBuilder;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractCreator;
import org.jboss.tools.vpe.editor.template.VpeCreator;
import org.jboss.tools.vpe.editor.template.VpeCreatorInfo;
import org.jboss.tools.vpe.editor.template.VpeDependencyMap;
import org.jboss.tools.vpe.editor.template.VpeOutputAttributes;
import org.jboss.tools.vpe.editor.template.expression.VpeExpression;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilder;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilderException;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionException;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionInfo;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VpeValueCreator
extends VpeAbstractCreator
implements VpeOutputAttributes {
    public static final String SIGNATURE_VPE_VALUE = ":vpe:value";
    private VpeExpression expression;
    private String outputAttrName;

    VpeValueCreator(String value, VpeDependencyMap dependencyMap, boolean caseSensitive) {
        this.build(value, dependencyMap, caseSensitive);
    }

    private void build(String value, VpeDependencyMap dependencyMap, boolean caseSensitive) {
        try {
            VpeExpressionInfo info = VpeExpressionBuilder.buildCompletedExpression(value, caseSensitive);
            this.expression = info.getExpression();
            dependencyMap.setCreator((VpeCreator)this, info.getDependencySet());
            this.outputAttrName = VpeExpressionBuilder.getOutputAttrName(value);
            if (this.outputAttrName != null) {
                dependencyMap.setCreator((VpeCreator)this, SIGNATURE_VPE_VALUE);
            }
        }
        catch (VpeExpressionBuilderException e) {
            VpePlugin.reportProblem(e);
        }
    }

    @Override
    public VpeCreatorInfo create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, nsIDOMElement visualElement, Map visualNodeMap) throws VpeExpressionException {
        String value = this.expression != null ? this.expression.exec(pageContext, sourceNode).stringValue() : "";
        nsIDOMText valueNode = visualDocument.createTextNode(value);
        visualNodeMap.put(this, valueNode);
        return new VpeCreatorInfo((nsIDOMNode)valueNode);
    }

    @Override
    public void refreshElement(VpePageContext pageContext, Element sourceElement, Map visualNodeMap) {
        this.setValue(pageContext, sourceElement, visualNodeMap);
    }

    @Override
    public void setAttribute(VpePageContext pageContext, Element sourceElement, Map visualNodeMap, String name, String value) {
        this.setValue(pageContext, sourceElement, visualNodeMap);
    }

    @Override
    public void removeAttribute(VpePageContext pageContext, Element sourceElement, Map visualNodeMap, String name) {
        this.setValue(pageContext, sourceElement, visualNodeMap);
    }

    private void setValue(VpePageContext pageContext, Element sourceElement, Map<?, ?> visualNodeMap) {
        String value;
        if (this.expression != null) {
            try {
                value = this.expression.exec(pageContext, sourceElement).stringValue();
            }
            catch (VpeExpressionException ex) {
                VpePlugin.reportProblem(ex);
                value = "";
            }
        } else {
            value = "";
        }
        nsIDOMNode valueNode = (nsIDOMNode)visualNodeMap.get(this);
        valueNode.setNodeValue(value);
    }

    @Override
    public String[] getOutputAttributes() {
        if (this.outputAttrName == null) {
            return null;
        }
        return new String[]{this.outputAttrName};
    }

    @Override
    public void setOutputAttributeValue(VpePageContext pageContext, Element sourceElement, Map visualNodeMap) {
        if (this.outputAttrName != null) {
            Node valueNode = (Node)visualNodeMap.get(this);
            sourceElement.setAttribute(this.outputAttrName, valueNode.getNodeValue());
        }
    }

    @Override
    public nsIDOMText getOutputTextNode(VpePageContext pageContext, Element sourceElement, Map visualNodeMap) {
        if (this.outputAttrName != null) {
            return (nsIDOMText)visualNodeMap.get(this);
        }
        return null;
    }

    @Override
    public boolean isEditabledAtribute(VpePageContext pageContext, Element sourceElement, Map visualNodeMap) {
        if (this.outputAttrName != null && this.expression != null) {
            String attrValue = sourceElement.getAttribute(this.outputAttrName);
            try {
                String exprValue = this.expression.exec(pageContext, sourceElement).stringValue();
                return exprValue.equals(attrValue);
            }
            catch (VpeExpressionException ex) {
                VpePlugin.reportProblem(ex);
            }
        }
        return false;
    }

    @Override
    public void setOutputAttributeSelection(VpePageContext pageContext, Element sourceElement, int offset, int length, Map visualNodeMap) {
        if (this.outputAttrName != null) {
            VpeSourceDomBuilder sourceBuilder = pageContext.getSourceBuilder();
            Attr attr = sourceElement.getAttributeNode(this.outputAttrName);
            if (attr != null) {
                if (this.isEditabledAtribute(pageContext, sourceElement, visualNodeMap)) {
                    sourceBuilder.setAttributeSelection(attr, offset, length);
                } else {
                    sourceBuilder.setAttributeSelection(attr, 0, 0);
                }
            }
        }
    }
}

