/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.util.Map;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractCreator;
import org.jboss.tools.vpe.editor.template.VpeCreator;
import org.jboss.tools.vpe.editor.template.VpeCreatorInfo;
import org.jboss.tools.vpe.editor.template.VpeDependencyMap;
import org.jboss.tools.vpe.editor.template.expression.VpeExpression;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilder;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilderException;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionException;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionInfo;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VpeVisualLinkCreator
extends VpeAbstractCreator {
    private boolean caseSensitive;
    private VpeExpression styleExpr;
    private VpeExpression classExpr;
    private VpeExpression valueExpr;
    private VpeExpression dirExpr;
    private String styleStr;
    private String classStr;
    private String valueStr;
    private String dirStr;

    VpeVisualLinkCreator(Element gridElement, VpeDependencyMap dependencyMap, boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.build(gridElement, dependencyMap);
    }

    private void build(Element element, VpeDependencyMap dependencyMap) {
        Attr valueAttr;
        Attr dirAttr;
        Attr styleAttr = element.getAttributeNode("style");
        if (styleAttr != null) {
            try {
                this.styleStr = styleAttr.getValue();
                VpeExpressionInfo info = VpeExpressionBuilder.buildCompletedExpression(this.styleStr, this.caseSensitive);
                this.styleExpr = info.getExpression();
                dependencyMap.setCreator((VpeCreator)this, info.getDependencySet());
            }
            catch (VpeExpressionBuilderException e) {
                VpePlugin.reportProblem(e);
            }
        }
        if ((dirAttr = element.getAttributeNode("dir")) != null) {
            try {
                this.dirStr = dirAttr.getValue();
                VpeExpressionInfo info = VpeExpressionBuilder.buildCompletedExpression(this.dirStr, this.caseSensitive);
                this.dirExpr = info.getExpression();
                dependencyMap.setCreator((VpeCreator)this, info.getDependencySet());
            }
            catch (VpeExpressionBuilderException e) {
                VpePlugin.reportProblem(e);
            }
        }
        Attr classAttr = element.getAttributeNode("class");
        if (styleAttr != null) {
            try {
                this.classStr = classAttr.getValue();
                VpeExpressionInfo info = VpeExpressionBuilder.buildCompletedExpression(this.classStr, this.caseSensitive);
                this.classExpr = info.getExpression();
                dependencyMap.setCreator((VpeCreator)this, info.getDependencySet());
            }
            catch (VpeExpressionBuilderException e) {
                VpePlugin.reportProblem(e);
            }
        }
        if ((valueAttr = element.getAttributeNode("value")) != null) {
            try {
                this.valueStr = valueAttr.getValue();
                VpeExpressionInfo info = VpeExpressionBuilder.buildCompletedExpression(this.valueStr, this.caseSensitive);
                this.valueExpr = info.getExpression();
                dependencyMap.setCreator((VpeCreator)this, info.getDependencySet());
            }
            catch (VpeExpressionBuilderException e) {
                VpePlugin.reportProblem(e);
            }
        }
    }

    public VpeCreatorInfo create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, nsIDOMElement visualElement, Map visualNodeMap) throws VpeExpressionException {
        String value;
        nsIDOMElement a = visualDocument.createElement("a");
        VpeCreatorInfo creatorInfo = new VpeCreatorInfo((nsIDOMNode)a);
        if (this.dirExpr != null) {
            String dir = this.dirExpr.exec(pageContext, sourceNode).stringValue();
            a.setAttribute("dir", dir);
        }
        if (this.styleExpr != null) {
            String style = this.styleExpr.exec(pageContext, sourceNode).stringValue();
            a.setAttribute("style", style);
        }
        if (this.classExpr != null) {
            String classStyle = this.classExpr.exec(pageContext, sourceNode).stringValue();
            a.setAttribute("class", classStyle);
        }
        if (this.valueExpr != null && (value = this.valueExpr.exec(pageContext, sourceNode).stringValue()) != null && value.length() > 0) {
            nsIDOMElement textContainer = VisualDomUtil.createBorderlessContainer(visualDocument);
            a.appendChild((nsIDOMNode)textContainer);
            nsIDOMText text = visualDocument.createTextNode(value);
            textContainer.appendChild((nsIDOMNode)text);
        }
        return creatorInfo;
    }

    public boolean isRecreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMNode visualNode, Object data, String name, String value) {
        return true;
    }
}

