/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import org.jboss.tools.vpe.editor.template.IZoomEventManager;
import org.jboss.tools.vpe.xulrunner.editor.XulRunnerEditor;
import org.mozilla.interfaces.nsIContentViewer;
import org.mozilla.interfaces.nsIDOMAbstractView;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMDocumentView;
import org.mozilla.interfaces.nsIDocShell;
import org.mozilla.interfaces.nsIInterfaceRequestor;
import org.mozilla.interfaces.nsIMarkupDocumentViewer;
import org.mozilla.interfaces.nsIWebNavigation;

public class ZoomEventManager
implements IZoomEventManager {
    private final float basicZoom = 1.0f;
    private final float minZoom = 0.3f;
    private final float maxZoom = 4.0f;
    private float[] availableZoomValues = new float[14];
    private int currentZoomPos = 5;
    private final float decreaseValue = 0.14f;
    private final float increaseValue = 0.375f;
    private nsIMarkupDocumentViewer documentViewer;

    public ZoomEventManager(XulRunnerEditor editor) {
        this.availableZoomValues[0] = 0.3f;
        this.availableZoomValues[13] = 4.0f;
        this.availableZoomValues[5] = 1.0f;
        int i = 1;
        while (i < 5) {
            this.availableZoomValues[i] = this.availableZoomValues[i - 1] + 0.14f;
            ++i;
        }
        i = 6;
        while (i < 13) {
            this.availableZoomValues[i] = this.availableZoomValues[i - 1] + 0.375f;
            ++i;
        }
        this.documentViewer = this.initMarkupViewer(editor);
    }

    public boolean zoomIn() {
        if (this.documentViewer != null) {
            if (this.availableZoomValues[this.currentZoomPos] == 4.0f) {
                return false;
            }
            ++this.currentZoomPos;
            this.documentViewer.setFullZoom(this.availableZoomValues[this.currentZoomPos]);
            return true;
        }
        return false;
    }

    public boolean zoomOut() {
        if (this.documentViewer != null) {
            if (this.availableZoomValues[this.currentZoomPos] == 0.3f) {
                return false;
            }
            --this.currentZoomPos;
            this.documentViewer.setFullZoom(this.availableZoomValues[this.currentZoomPos]);
            return true;
        }
        return false;
    }

    public boolean resetZoomView() {
        if (this.documentViewer != null) {
            this.currentZoomPos = 5;
            this.documentViewer.setFullZoom(this.availableZoomValues[this.currentZoomPos]);
            return true;
        }
        return false;
    }

    public boolean setCurrentZoom(float zoomValue) {
        if (this.documentViewer != null) {
            this.currentZoomPos = this.searchNearestPos(zoomValue);
            this.documentViewer.setFullZoom(this.availableZoomValues[this.currentZoomPos]);
        }
        return false;
    }

    public float getCurrentZoom() {
        return this.availableZoomValues[this.currentZoomPos];
    }

    public float getMaxZoom() {
        return 0.3f;
    }

    public float getMinZoom() {
        return 4.0f;
    }

    private int searchNearestPos(float zoomValue) {
        int i = 0;
        while (i < 5) {
            if (zoomValue < this.availableZoomValues[i] + 0.07f) {
                return i;
            }
            if (zoomValue <= this.availableZoomValues[i + 1]) {
                return i + 1;
            }
            ++i;
        }
        i = 5;
        while (i < this.availableZoomValues.length - 1) {
            if (zoomValue < this.availableZoomValues[i] + 0.1875f) {
                return i;
            }
            if (zoomValue <= this.availableZoomValues[i + 1]) {
                return i + 1;
            }
            ++i;
        }
        return this.currentZoomPos;
    }

    public float getBasicZoom() {
        return 1.0f;
    }

    public float[] getAvailableZoomValues() {
        return this.availableZoomValues;
    }

    private nsIMarkupDocumentViewer initMarkupViewer(XulRunnerEditor editor) {
        try {
            nsIDOMDocument document = editor.getDOMDocument();
            nsIDOMDocumentView documentView = (nsIDOMDocumentView)document.queryInterface("{1acdb2ba-1dd2-11b2-95bc-9542495d2569}");
            nsIDOMAbstractView abstractView = documentView.getDefaultView();
            nsIInterfaceRequestor requestor = (nsIInterfaceRequestor)abstractView.queryInterface("{033a1470-8b2a-11d3-af88-00a024ffc08c}");
            nsIWebNavigation navigation = (nsIWebNavigation)requestor.getInterface("{f5d9e7b0-d930-11d3-b057-00a024ffc08c}");
            nsIDocShell docShell = (nsIDocShell)navigation.queryInterface("{dc4daea1-b43d-406f-bd62-c2ee879192ad}");
            nsIContentViewer contentViewer = docShell.getContentViewer();
            nsIMarkupDocumentViewer markupDocumentViewer = (nsIMarkupDocumentViewer)contentViewer.queryInterface("{40b2282a-a882-4483-a634-dec468d88377}");
            return markupDocumentViewer;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }
}

