/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template.dnd;

import java.util.HashSet;
import org.jboss.tools.vpe.editor.VpeSourceInnerDragInfo;
import org.jboss.tools.vpe.editor.VpeSourceInnerDropInfo;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class VpeDnd {
    static final String TAG_DRAG = "vpe:drag";
    static final String TAG_DROP = "vpe:drop";
    static final String TAG_CONTAINER_CHILD = "vpe:container-child";
    static final String ATTRIBUTE_START_ENABLE = "start-enable";
    static final String ATTRIBUTE_CONTAINER = "container";
    static final String ATTRIBUTE_TAG_NAME = "tag-name";
    static final String STRING_YES = "yes";
    private boolean dragEnabled = false;
    private boolean isContainer = false;
    private HashSet enabledTags = null;

    public void setDndData(boolean dragEnabled, boolean isContainer) {
        this.dragEnabled = dragEnabled;
        this.isContainer = isContainer;
        this.enabledTags = null;
    }

    public void setDndData(Element node) {
        this.enabledTags = null;
        NodeList children = node.getChildNodes();
        if (children != null) {
            int len = children.getLength();
            boolean dragFlag = false;
            boolean dropFlag = false;
            int i = 0;
            while (i < len) {
                String name;
                Node innerNode = children.item(i);
                if (innerNode.getNodeType() == 1 && (name = innerNode.getNodeName()).startsWith("vpe:")) {
                    if (!dragFlag && TAG_DRAG.equals(name)) {
                        this.dragEnabled = STRING_YES.equalsIgnoreCase(((Element)innerNode).getAttribute(ATTRIBUTE_START_ENABLE));
                        dragFlag = true;
                    }
                    if (!dropFlag && TAG_DROP.equals(name)) {
                        this.isContainer = STRING_YES.equalsIgnoreCase(((Element)innerNode).getAttribute(ATTRIBUTE_CONTAINER));
                        dropFlag = true;
                        NodeList list = innerNode.getChildNodes();
                        if (list != null) {
                            int l = list.getLength();
                            if (l > 0) {
                                this.enabledTags = new HashSet();
                            }
                            int j = 0;
                            while (j < l) {
                                String tagName;
                                Node child = list.item(j);
                                if (child.getNodeType() == 1 && (tagName = child.getNodeName()).startsWith("vpe:") && TAG_CONTAINER_CHILD.equals(tagName)) {
                                    this.enabledTags.add(((Element)child).getAttribute(ATTRIBUTE_TAG_NAME).toLowerCase());
                                }
                                ++j;
                            }
                        }
                    }
                    if (dragFlag && dropFlag) break;
                }
                ++i;
            }
        }
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public boolean isDropEnabled(VpePageContext pageContext, Node container, Node node) {
        if (!pageContext.isAbsolutePosition() && this.isAncestor(container, node)) {
            return false;
        }
        if (this.isContainer) {
            if (this.enabledTags != null && this.enabledTags.size() > 0) {
                String name;
                String string = name = node.getNodeType() == 1 ? node.getLocalName().toLowerCase() : node.getNodeName();
                return this.enabledTags.contains(name);
            }
            return true;
        }
        return false;
    }

    private boolean isAncestor(Node container, Node node) {
        Node curent = container;
        while (curent != null) {
            if (curent.equals(node)) {
                return true;
            }
            curent = curent.getParentNode();
        }
        return false;
    }

    private void removeTextFromTextNode(Node node, int start, int end) {
        Node parent = node.getParentNode();
        boolean split1 = true;
        boolean split2 = true;
        String text = node.getNodeValue();
        if (start == 0) {
            split1 = false;
        }
        if (end == text.length() + 1) {
            split2 = false;
        }
        if (split1 && split2) {
            String text1 = text.substring(0, start);
            String text2 = text.substring(end, text.length());
            node.setNodeValue(String.valueOf(text1) + text2);
        } else if (split1) {
            String text1 = text.substring(0, start);
            node.setNodeValue(text1);
        } else if (split2) {
            String text1 = text.substring(end, text.length());
            node.setNodeValue(text1);
        } else {
            parent.removeChild(node);
        }
    }

    private void insertTextIntoTextNode(Node node, String text, int offset) {
        String oldText = node.getNodeValue();
        if (oldText == null) {
            return;
        }
        String newText = String.valueOf(oldText.substring(0, offset)) + text + oldText.substring(offset, oldText.length());
        node.setNodeValue(newText);
    }

    private void replaceTextInTextNode(Node node, int offset, int selStart, int selEnd) {
        if (offset >= selStart && offset <= selEnd) {
            return;
        }
        String oldText = node.getNodeValue();
        if (oldText == null) {
            return;
        }
        String selText = oldText.substring(selStart, selEnd);
        String newText = null;
        newText = offset < selStart ? String.valueOf(oldText.substring(0, offset)) + selText + oldText.substring(offset, selStart) + oldText.substring(selEnd) : String.valueOf(oldText.substring(0, selStart)) + oldText.substring(selEnd, offset) + selText + oldText.substring(offset);
        node.setNodeValue(newText);
    }

    private void insertAnyTextIntoAnyText(Node container, int offset, Node node, int start, int end) {
        String nodeText = node.getNodeValue();
        String draggedText = nodeText.substring(start, end);
        if (node == container) {
            this.replaceTextInTextNode(container, offset, start, end);
        } else {
            this.removeTextFromTextNode(node, start, end);
            this.insertTextIntoTextNode(container, draggedText, offset);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void drop(VpePageContext pageContext, VpeSourceInnerDragInfo dragInfo, VpeSourceInnerDropInfo dropInfo) {
        Node container = dropInfo.getContainer();
        int offset = dropInfo.getOffset();
        Node node = dragInfo.getNode();
        block0 : switch (node.getNodeType()) {
            case 2: 
            case 3: {
                String nodeText = node.getNodeValue();
                int beginPosition = Math.min(dragInfo.getOffset(), nodeText.length());
                int endPosition = Math.min(dragInfo.getOffset() + dragInfo.getLength(), nodeText.length());
                switch (container.getNodeType()) {
                    case 2: 
                    case 3: {
                        this.insertAnyTextIntoAnyText(container, offset, node, beginPosition, endPosition);
                        return;
                    }
                    case 1: 
                    case 9: {
                        NodeList children = container.getChildNodes();
                        int count = children.getLength();
                        Node child = null;
                        boolean insertBefore = true;
                        if (offset < count) {
                            if (offset > 0) {
                                child = children.item(offset - 1);
                                insertBefore = false;
                                if (child.getNodeType() != 3) {
                                    child = children.item(offset);
                                    insertBefore = true;
                                }
                            } else {
                                child = children.item(offset);
                            }
                        } else if (count > 0) {
                            child = children.item(count - 1);
                            insertBefore = false;
                        }
                        if (child != null && child.getNodeType() == 3) {
                            if (insertBefore) {
                                this.insertAnyTextIntoAnyText(child, 0, node, beginPosition, endPosition);
                                return;
                            }
                            this.insertAnyTextIntoAnyText(child, child.getNodeValue().length(), node, beginPosition, endPosition);
                            return;
                        }
                        this.removeTextFromTextNode(node, beginPosition, endPosition);
                        Document document = container.getNodeType() == 9 ? (Document)container : container.getOwnerDocument();
                        Text textNode = document.createTextNode(nodeText.substring(beginPosition, endPosition));
                        if (offset < count) {
                            container.insertBefore(textNode, child);
                            return;
                        }
                        container.appendChild(textNode);
                    }
                }
                return;
            }
            case 1: {
                if (this.isAncestor(container, node)) return;
                Node parent = node.getParentNode();
                switch (container.getNodeType()) {
                    case 3: {
                        Text text = (Text)container;
                        String str1 = text.getNodeValue().substring(0, offset);
                        String str2 = text.getNodeValue().substring(offset, text.getNodeValue().length());
                        Text newText = text.getOwnerDocument().createTextNode(str2);
                        text.getParentNode().insertBefore(newText, text.getNextSibling());
                        parent.removeChild(node);
                        text.getParentNode().insertBefore(node, newText);
                        text.getParentNode().removeChild(text);
                        Text oldText = text.getOwnerDocument().createTextNode(str1);
                        node.getParentNode().insertBefore(oldText, node);
                        break block0;
                    }
                    case 1: 
                    case 9: {
                        NodeList children = container.getChildNodes();
                        int count = children.getLength();
                        Node child = null;
                        if (offset < count) {
                            child = children.item(offset);
                        } else if (count > 0) {
                            child = children.item(count - 1);
                        }
                        if (node == child) return;
                        parent.removeChild(node);
                        if (offset < count) {
                            container.insertBefore(node, child);
                            break block0;
                        }
                        container.appendChild(node);
                    }
                }
            }
        }
    }
}

