/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template.expression;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jboss.tools.vpe.editor.template.expression.VpeAndOperation;
import org.jboss.tools.vpe.editor.template.expression.VpeAttributeOperand;
import org.jboss.tools.vpe.editor.template.expression.VpeCompletedExpression;
import org.jboss.tools.vpe.editor.template.expression.VpeEqualOperation;
import org.jboss.tools.vpe.editor.template.expression.VpeExpression;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilderException;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionInfo;
import org.jboss.tools.vpe.editor.template.expression.VpeFunction;
import org.jboss.tools.vpe.editor.template.expression.VpeFunctionFactory;
import org.jboss.tools.vpe.editor.template.expression.VpeOperand;
import org.jboss.tools.vpe.editor.template.expression.VpeOperation;
import org.jboss.tools.vpe.editor.template.expression.VpeOrOperation;
import org.jboss.tools.vpe.editor.template.expression.VpePlusOperation;
import org.jboss.tools.vpe.editor.template.expression.VpeStringOperand;
import org.jboss.tools.vpe.editor.template.expression.VpeTextExpression;
import org.jboss.tools.vpe.messages.VpeUIMessages;

public class VpeExpressionBuilder {
    public static final char ATTR_PREFIX = '@';
    public static final String ATTR_PREFIX_S = "@";
    public static final String SIGNATURE_ANY_ATTR = "@*";
    public static final String SIGNATURE_JSF_VALUE = "jsfvalue()";
    private static final char COMPL_EXPR_LEFT_BRACKET = '{';
    private static final char COMPL_EXPR_RIGHT_BRACKET = '}';
    private static final char OPER_BRACKET_LEFT = '(';
    private static final char OPER_BRACKET_RIGHT = ')';
    private static final char OPER_STRING = '\'';
    private static final char OPER_EQUAL = '=';
    private static final char OPER_PLUS = '+';
    private static final char OPER_OR = '|';
    private static final String OPER_AND = "and";
    private static final char FUNC_BRACKET_LEFT = '(';
    private static final char FUNC_BRACKET_RIGHT = ')';
    private static final char PARAM_SEPARATOR = ',';
    private static final char[] SEPARATORS = new char[]{'(', ')', '\'', ',', '=', '|', '+', ' ', '\t', '\n', '\r'};
    private String originalText;
    private String text;
    private boolean caseSensitive;
    private Set<String> dependencySet;

    public VpeExpressionInfo buildPlainExpression(String text, boolean caseSensitive) throws VpeExpressionBuilderException {
        if (text == null) {
            return new VpeExpressionInfo();
        }
        this.text = this.originalText = text.trim();
        if (this.end()) {
            return new VpeExpressionInfo();
        }
        this.caseSensitive = caseSensitive;
        this.dependencySet = new HashSet<String>();
        return new VpeExpressionInfo(this.build(), this.dependencySet.size() > 0 ? this.dependencySet : null);
    }

    public static VpeExpressionInfo buildCompletedExpression(String text, boolean caseSensitive) throws VpeExpressionBuilderException {
        if (text == null) {
            return new VpeExpressionInfo();
        }
        VpeExpressionBuilder builder = new VpeExpressionBuilder();
        HashSet<String> dependencySet = new HashSet<String>();
        ArrayList<VpeExpression> expressions = new ArrayList<VpeExpression>();
        int len = text.length();
        int startIndex = 0;
        while (startIndex < len) {
            int endIndex = text.indexOf(123, startIndex);
            if (endIndex < 0) {
                endIndex = len;
            }
            String subText = text.substring(startIndex, endIndex);
            startIndex = endIndex + 1;
            if (subText.length() > 0) {
                expressions.add(new VpeTextExpression(subText));
            }
            if (startIndex >= len) continue;
            endIndex = text.indexOf(125, startIndex);
            if (endIndex < 0) {
                endIndex = len;
            }
            subText = text.substring(startIndex, endIndex);
            startIndex = endIndex + 1;
            VpeExpressionInfo info = builder.buildPlainExpression(subText, caseSensitive);
            if (info.getExpression() == null) continue;
            if (info.getDependencySet() != null) {
                dependencySet.addAll(info.getDependencySet());
            }
            expressions.add(info.getExpression());
        }
        if (expressions.size() <= 0) {
            return new VpeExpressionInfo();
        }
        if (dependencySet.size() <= 0) {
            dependencySet = null;
        }
        VpeExpression expression = expressions.size() == 1 ? (VpeExpression)expressions.get(0) : new VpeCompletedExpression(expressions.toArray(new VpeExpression[expressions.size()]));
        return new VpeExpressionInfo(expression, dependencySet);
    }

    public static String attrSignature(String attrName, boolean caseSensitive) {
        return String.valueOf('@') + (caseSensitive ? attrName : attrName.toLowerCase());
    }

    private VpeOperand build() throws VpeExpressionBuilderException {
        VpeOperand topOperand = this.buildOperand();
        VpeOperation lastOperation = null;
        while (!this.end() && this.nextChar() != ')' && this.nextChar() != ',') {
            VpeOperation operation = this.buildOperation();
            topOperand = operation.intoExpression(topOperand, lastOperation);
            operation.setRightOperand(this.buildOperand());
            lastOperation = operation;
        }
        return topOperand;
    }

    private VpeOperand buildOperand() throws VpeExpressionBuilderException {
        VpeOperand operand = null;
        int startPos = this.currentPosition();
        char c = this.nextChar();
        if (c == '@') {
            operand = this.buildAttribute();
        } else if (c == '\'') {
            operand = this.buildString();
        } else if (c == '(') {
            operand = this.buildBrackets();
        } else if (this.alpha(c)) {
            int pos = this.nextSepPos();
            String name = this.getToken(pos);
            this.text = this.text.trim();
            if (this.nextChar() == '(') {
                operand = this.buildFunction(name, startPos);
            } else {
                this.undefinedName(name, startPos);
            }
        } else {
            this.undefinedCharacter(startPos);
        }
        this.text = this.text.trim();
        return operand;
    }

    private VpeOperand buildAttribute() throws VpeExpressionBuilderException {
        this.text = this.text.substring(1);
        if (!this.alpha()) {
            this.undefinedCharacter();
        }
        int pos = this.nextSepPos();
        String name = this.getToken(pos);
        this.dependencySet.add(this.attrSignature(name));
        return new VpeAttributeOperand(name, this.caseSensitive);
    }

    private VpeOperand buildString() throws VpeExpressionBuilderException {
        int startPos = this.currentPosition();
        this.text = this.text.substring(1);
        int pos = this.text.indexOf(39);
        if (pos == -1) {
            this.error("Closing apostrophe is not found", VpeUIMessages.VpeExpressionBuilder_ClosingApostropheNotFound, startPos);
        }
        VpeStringOperand operand = new VpeStringOperand(this.getToken(pos));
        this.text = this.text.substring(1);
        return operand;
    }

    private VpeOperand buildBrackets() throws VpeExpressionBuilderException {
        int startPos = this.currentPosition();
        this.text = this.text.substring(1);
        this.text = this.text.trim();
        VpeOperand operand = this.build();
        if (this.text.length() > 0 && this.text.charAt(0) == ')') {
            this.text = this.text.substring(1);
        } else {
            this.bracketNotFound(startPos);
        }
        return operand;
    }

    private VpeOperand buildFunction(String name, int namePos) throws VpeExpressionBuilderException {
        String[] signatures;
        VpeFunction function = VpeFunctionFactory.getFunction(name);
        if (function == null) {
            this.error(MessageFormat.format("Function ''{0}'' is not found", name), MessageFormat.format(VpeUIMessages.VpeExpressionBuilder_FunctionNotFound, name), namePos);
        }
        int bracketPos = this.currentPosition();
        ArrayList<VpeOperand> params = new ArrayList<VpeOperand>();
        this.text = this.text.substring(1);
        this.text = this.text.trim();
        while (!this.end() && this.nextChar() != ')') {
            VpeOperand param = null;
            if (this.nextChar() != ',') {
                param = this.build();
            }
            params.add(param);
            if (this.nextChar() != ',') continue;
            this.text = this.text.substring(1);
            this.text = this.text.trim();
        }
        if (this.nextChar() != ')') {
            this.bracketNotFound(bracketPos);
        }
        this.text = this.text.substring(1);
        if (params.size() > 0) {
            function.setParameters(params.toArray(new VpeOperand[params.size()]));
        }
        if ((signatures = function.getSignatures()) != null) {
            int i = 0;
            while (i < signatures.length) {
                this.dependencySet.add(signatures[i]);
                ++i;
            }
        }
        return function;
    }

    private VpeOperation buildOperation() throws VpeExpressionBuilderException {
        VpeOperation operation = null;
        int startPos = this.currentPosition();
        char c = this.nextChar();
        if (c == '=') {
            operation = new VpeEqualOperation();
            this.text = this.text.substring(1);
        } else if (c == '+') {
            operation = new VpePlusOperation();
            this.text = this.text.substring(1);
        } else if (c == '|') {
            operation = new VpeOrOperation();
            this.text = this.text.substring(1);
        } else if (this.text.startsWith(OPER_AND)) {
            String oldText = this.text;
            this.text = this.text.substring(OPER_AND.length());
            int pos = this.nextSepPos();
            if (this.end() || pos == 0) {
                operation = new VpeAndOperation();
            } else {
                this.text = oldText;
                this.undefinedCharacter(startPos);
            }
        } else {
            this.undefinedCharacter(startPos);
        }
        this.text = this.text.trim();
        return operation;
    }

    private String getToken(int pos) {
        String token;
        if (pos == -1) {
            token = this.text;
            this.text = "";
        } else {
            token = this.text.substring(0, pos);
            this.text = this.text.substring(pos);
        }
        return token;
    }

    private int currentPosition() {
        return this.originalText.length() - this.text.length();
    }

    private int nextSepPos() {
        int pos = this.text.indexOf(SEPARATORS[0]);
        int i = 1;
        while (i < SEPARATORS.length) {
            pos = this.minPosition(pos, SEPARATORS[i]);
            ++i;
        }
        return pos;
    }

    private int minPosition(int pos1, char c2) {
        int pos2 = this.text.indexOf(c2);
        if (pos1 == -1) {
            return pos2;
        }
        if (pos2 == -1) {
            return pos1;
        }
        return Math.min(pos1, pos2);
    }

    private boolean end() {
        return this.text.length() <= 0;
    }

    private boolean alpha(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private boolean alpha() {
        if (this.end()) {
            return false;
        }
        return this.alpha(this.text.charAt(0));
    }

    private char nextChar() {
        if (this.end()) {
            return '\u0000';
        }
        return this.text.charAt(0);
    }

    private String attrSignature(String attrName) {
        return VpeExpressionBuilder.attrSignature(attrName, this.caseSensitive);
    }

    private void error(String errorText, String localizedErrorText, int pos) throws VpeExpressionBuilderException {
        throw new VpeExpressionBuilderException(this.originalText, errorText, pos, localizedErrorText);
    }

    private void undefinedCharacter(int pos) throws VpeExpressionBuilderException {
        this.error(MessageFormat.format("Undefined character ''{0}''", Character.valueOf(this.originalText.charAt(pos))), MessageFormat.format(VpeUIMessages.VpeExpressionBuilder_UndefinedCharacter, Character.valueOf(this.originalText.charAt(pos))), pos);
    }

    private void undefinedCharacter() throws VpeExpressionBuilderException {
        this.undefinedCharacter(this.currentPosition());
    }

    private void undefinedName(String name, int pos) throws VpeExpressionBuilderException {
        this.error(MessageFormat.format("Undefined name \"{0}\"", name), MessageFormat.format(VpeUIMessages.VpeExpressionBuilder_UndefinedName, name), pos);
    }

    private void bracketNotFound(int pos) throws VpeExpressionBuilderException {
        this.error("Closing bracket is not found", VpeUIMessages.VpeExpressionBuilder_ClosingBracketNotFound, pos);
    }

    public static String getOutputAttrName(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() <= 1) {
            return null;
        }
        if (value.charAt(0) == '{') {
            if (value.charAt(value.length() - 1) == '}') {
                if ((value = value.substring(1, value.length() - 1)).length() <= 1) {
                    return null;
                }
            } else {
                return null;
            }
        }
        if (value.startsWith("jsfvalue(")) {
            if (value.charAt(value.length() - 1) == ')') {
                if ((value = value.substring(9, value.length() - 1)).length() <= 1) {
                    return null;
                }
            } else {
                return null;
            }
        }
        if (value.charAt(0) == '@') {
            return value.substring(1);
        }
        return null;
    }
}

