/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template.expression;

import java.util.HashMap;
import java.util.Map;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.template.expression.VpeFunction;
import org.jboss.tools.vpe.editor.template.expression.VpeFunctionAttrPresent;
import org.jboss.tools.vpe.editor.template.expression.VpeFunctionHasChildren;
import org.jboss.tools.vpe.editor.template.expression.VpeFunctionHasContent;
import org.jboss.tools.vpe.editor.template.expression.VpeFunctionHasInParents;
import org.jboss.tools.vpe.editor.template.expression.VpeFunctionHref;
import org.jboss.tools.vpe.editor.template.expression.VpeFunctionIif;
import org.jboss.tools.vpe.editor.template.expression.VpeFunctionJsf2Resource;
import org.jboss.tools.vpe.editor.template.expression.VpeFunctionJsfValue;
import org.jboss.tools.vpe.editor.template.expression.VpeFunctionName;
import org.jboss.tools.vpe.editor.template.expression.VpeFunctionNot;
import org.jboss.tools.vpe.editor.template.expression.VpeFunctionParentAttrValue;
import org.jboss.tools.vpe.editor.template.expression.VpeFunctionParentName;
import org.jboss.tools.vpe.editor.template.expression.VpeFunctionSrc;
import org.jboss.tools.vpe.editor.template.expression.VpeFunctionTagString;
import org.jboss.tools.vpe.editor.template.expression.VpeFunctionTagText;
import org.jboss.tools.vpe.editor.template.expression.VpeFunctionTldVersionCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VpeFunctionFactory {
    private static final String FUNC_JSF_VALUE = "jsfvalue";
    private static final String FUNC_JSF2_RESOURCE = "jsf2resource";
    private static final String FUNC_NAME = "name";
    private static final String FUNC_NOT = "not";
    private static final String FUNC_IIF = "iif";
    private static final String FUNC_SRC = "src";
    private static final String FUNC_HREF = "href";
    private static final String FUNC_PARENT_NAME = "parentname";
    private static final String FUNC_HAS_IN_PARENTS = "hasinparents";
    private static final String FUNC_TAG_STRING = "tagstring";
    private static final String FUNC_TAG_TEXT = "tagtext";
    private static final String FUNC_ATTR_PRESENT = "attrpresent";
    private static final String FUNC_PARENT_ATTR_VALUE = "parentattrvalue";
    private static final String FUNC_HAS_CHILDREN = "haschildren";
    private static final String FUNC_HAS_CONTENT = "hascontent";
    private static Map<String, Class<?>> clsMap = new HashMap();

    static VpeFunction getFunction(String name) {
        Class<?> cls = clsMap.get(name);
        if (cls == null) {
            cls = VpeFunctionFactory.createCls(name);
            if (cls != null) {
                clsMap.put(name, cls);
            } else {
                return null;
            }
        }
        try {
            return (VpeFunction)cls.newInstance();
        }
        catch (IllegalAccessException e) {
            VpePlugin.getPluginLog().logError((Throwable)e);
        }
        catch (InstantiationException e) {
            VpePlugin.getPluginLog().logError((Throwable)e);
        }
        return null;
    }

    private static Class<?> createCls(String name) {
        if (FUNC_JSF_VALUE.equals(name)) {
            return VpeFunctionJsfValue.class;
        }
        if (FUNC_JSF2_RESOURCE.equals(name)) {
            return VpeFunctionJsf2Resource.class;
        }
        if (FUNC_NAME.equals(name)) {
            return VpeFunctionName.class;
        }
        if (FUNC_NOT.equals(name)) {
            return VpeFunctionNot.class;
        }
        if (FUNC_IIF.equals(name)) {
            return VpeFunctionIif.class;
        }
        if (FUNC_SRC.equals(name)) {
            return VpeFunctionSrc.class;
        }
        if (FUNC_HREF.equals(name)) {
            return VpeFunctionHref.class;
        }
        if (FUNC_PARENT_NAME.equals(name)) {
            return VpeFunctionParentName.class;
        }
        if (FUNC_HAS_IN_PARENTS.equals(name)) {
            return VpeFunctionHasInParents.class;
        }
        if (FUNC_TAG_STRING.equals(name)) {
            return VpeFunctionTagString.class;
        }
        if (FUNC_TAG_TEXT.equals(name)) {
            return VpeFunctionTagText.class;
        }
        if (FUNC_ATTR_PRESENT.equals(name)) {
            return VpeFunctionAttrPresent.class;
        }
        if (FUNC_PARENT_ATTR_VALUE.equals(name)) {
            return VpeFunctionParentAttrValue.class;
        }
        if (FUNC_HAS_CHILDREN.equals(name)) {
            return VpeFunctionHasChildren.class;
        }
        if (FUNC_HAS_CONTENT.equals(name)) {
            return VpeFunctionHasContent.class;
        }
        if ("tld_version".equals(name)) {
            return VpeFunctionTldVersionCheck.class;
        }
        return null;
    }
}

