/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.toolbar.format;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.template.textformating.FormatAttributeData;
import org.jboss.tools.vpe.editor.template.textformating.FormatData;
import org.jboss.tools.vpe.editor.toolbar.format.FormatController;
import org.jboss.tools.vpe.editor.toolbar.format.FormatControllerManager;
import org.jboss.tools.vpe.editor.toolbar.format.css.StyleAttribute;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class AttributeFormatController
extends FormatController {
    public AttributeFormatController(FormatControllerManager manager) {
        super(manager);
    }

    protected void run(FormatData templateData) {
        FormatAttributeData[] attributeData = templateData.getFormatAttributes();
        Node node = this.manager.getCurrentSelectedNode();
        int i = 0;
        while (i < attributeData.length) {
            this.runAttribute(attributeData[i], node);
            ++i;
        }
    }

    protected abstract void setStyle(Attr var1, FormatAttributeData var2);

    protected void runAttribute(FormatAttributeData templateData, Node selectedNode) {
        Attr attribute = AttributeFormatController.getAttribute(selectedNode, templateData);
        if (attribute == null) {
            this.manager.setIgnoreSelectionChanges(true);
            attribute = AttributeFormatController.createAttribute(selectedNode, templateData);
        }
        if (attribute != null && "style".equals(templateData.getType())) {
            this.manager.setIgnoreSelectionChanges(false);
            this.setStyle(attribute, templateData);
            if (attribute.getValue().length() <= 0) {
                Element element = (Element)selectedNode;
                element.removeAttributeNode(attribute);
            }
            return;
        }
        this.manager.setIgnoreSelectionChanges(false);
    }

    public void setToolbarItemSelection() {
        FormatData data = this.manager.getCurrentFormatData();
        Node node = this.manager.getCurrentSelectedNode();
        if (data != null && node != null) {
            FormatAttributeData[] attributeData = data.getFormatAttributes();
            int i = 0;
            while (i < attributeData.length) {
                this.setAttributeToolbarItemSelection(attributeData[i], node);
                ++i;
            }
        }
    }

    protected boolean formatIsAllowable(FormatData templateData) {
        FormatAttributeData[] attributeData = templateData.getFormatAttributes();
        int i = 0;
        while (i < attributeData.length) {
            if ("style".equals(attributeData[i].getType())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void setAttributeToolbarItemSelection(FormatAttributeData templateData, Node selectedNode) {
        Attr attribute = AttributeFormatController.getAttribute(selectedNode, templateData);
        if ("style".equals(templateData.getType())) {
            boolean isStyleSet = this.isStyleSet(attribute, templateData);
            this.setToolbarItemSelection(isStyleSet);
        }
    }

    protected abstract boolean isStyleSet(Attr var1, FormatAttributeData var2);

    protected abstract void setToolbarItemSelection(boolean var1);

    protected static Attr getAttribute(Node node, FormatAttributeData data) {
        if (node instanceof Element) {
            Element element = (Element)node;
            NamedNodeMap map = element.getAttributes();
            int i = 0;
            while (i < map.getLength()) {
                Node atNode = map.item(i);
                if (atNode instanceof Attr) {
                    boolean equal;
                    Attr attribute = (Attr)atNode;
                    boolean bl = equal = data.isCaseSensitive() ? attribute.getName().equals(data.getName()) : attribute.getName().equalsIgnoreCase(data.getName());
                    if (equal) {
                        return attribute;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    protected Attr getAttributeFromSelectedNode(String attributeName, boolean ignoreCase) {
        Node node = this.getManager().getCurrentSelectedNode();
        if (node != null && node instanceof Element) {
            NamedNodeMap attributes = ((Element)node).getAttributes();
            int i = 0;
            while (i < attributes.getLength()) {
                boolean equals;
                Node attribute = attributes.item(i);
                boolean bl = equals = ignoreCase ? attribute.getNodeName().equalsIgnoreCase(attributeName) : attribute.getNodeName().equals(attributeName);
                if (equals) {
                    return (Attr)attribute;
                }
                ++i;
            }
        }
        return null;
    }

    protected Attr getStyleAttributeFromSelectedNode(boolean ignoreCase) {
        return this.getAttributeFromSelectedNode("style", ignoreCase);
    }

    protected static Attr createAttribute(Node node, FormatAttributeData data) {
        if (node instanceof Element) {
            Element element = (Element)node;
            String name = data.getName();
            if (name == null) {
                String message = "Wrong vpe template for tag " + node.getNodeName() + ". Attribute 'name' or 'type' of <vpe:formatAttribute> must be set.";
                VpePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.vpe", 0, message, (Throwable)new Exception(message)));
            }
            element.setAttribute(name, "");
            return element.getAttributeNode(name);
        }
        return null;
    }

    protected static boolean isStyleSet(String stylePropertyName, String stylePropertyValue, Attr styleAttribute) {
        if (styleAttribute == null) {
            return false;
        }
        StyleAttribute style = new StyleAttribute(styleAttribute);
        return style.isStylePropertySet(stylePropertyName, stylePropertyValue);
    }

    protected static void simpleInvertStyleProperty(String stylePropertyName, String stylePropertyValue, Attr styleAttribute) {
        if (styleAttribute == null) {
            return;
        }
        StyleAttribute style = new StyleAttribute(styleAttribute);
        style.invertStyleProperty(stylePropertyName, stylePropertyValue);
        String value = style.toString().trim();
        if (value.length() == 0) {
            styleAttribute.getOwnerElement().removeAttributeNode(styleAttribute);
        } else {
            styleAttribute.setValue(value);
        }
    }

    protected static void invertSingleStyleProperty(Attr styleAttribute, String stylePropertyName, String stylePropertyValue) {
        if (styleAttribute == null) {
            return;
        }
        StyleAttribute style = new StyleAttribute(styleAttribute);
        style.ivertSingleStyleProperty(stylePropertyName, stylePropertyValue);
        String value = style.toString().trim();
        if (value.length() == 0) {
            styleAttribute.getOwnerElement().removeAttributeNode(styleAttribute);
        } else {
            styleAttribute.setValue(value);
        }
    }

    protected static void setSingleStyleProperty(Attr styleAttribute, String stylePropertyName, String stylePropertyValue) {
        if (styleAttribute == null) {
            return;
        }
        StyleAttribute style = new StyleAttribute(styleAttribute);
        style.setSingleStyleProperty(stylePropertyName, stylePropertyValue);
        String value = style.toString().trim();
        styleAttribute.setValue(value);
    }
}

