/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.toolbar.format;

import org.eclipse.swt.widgets.Combo;
import org.jboss.tools.vpe.editor.template.textformating.FormatAttributeData;
import org.jboss.tools.vpe.editor.toolbar.format.ComboFormatController;
import org.jboss.tools.vpe.editor.toolbar.format.FormatControllerManager;
import org.jboss.tools.vpe.editor.toolbar.format.css.MultiPropertyValue;
import org.jboss.tools.vpe.editor.toolbar.format.css.StyleAttribute;
import org.jboss.tools.vpe.editor.toolbar.format.css.StyleProperty;
import org.w3c.dom.Attr;

public class FontNameFormatController
extends ComboFormatController {
    private static final String REPLACE_VALUE = "['\"]";
    private static final String EMPTY = "";
    public static String TYPE = "FontNameFormat";
    private static String STYLE_PROPERTY_NAME = "FONT-FAMILY";
    private String defaultFont = null;

    public FontNameFormatController(FormatControllerManager manager, Combo comboBlockFormat, String defaultFont) {
        super(manager, comboBlockFormat);
        this.defaultFont = defaultFont;
    }

    public String getType() {
        return TYPE;
    }

    protected void setStyle(Attr styleAttribute, FormatAttributeData templateData) {
        String value = this.createStylePropertyValue();
        if (value != null) {
            String fontName = value.replaceAll(REPLACE_VALUE, EMPTY);
            if (fontName.equalsIgnoreCase(this.defaultFont)) {
                StyleAttribute style = new StyleAttribute(styleAttribute);
                style.removeStyleProperty(STYLE_PROPERTY_NAME);
                String newStyle = style.toString().trim();
                styleAttribute.setValue(newStyle);
                return;
            }
            FontNameFormatController.setSingleStyleProperty(styleAttribute, STYLE_PROPERTY_NAME, value);
        }
    }

    private String createStylePropertyValue() {
        if (this.selectionText != null && this.selectionText.trim().length() > 0) {
            return "'" + this.selectionText.trim() + "'";
        }
        return null;
    }

    public void setToolbarItemEnabled(boolean enabled) {
        MultiPropertyValue fontPropertyValue;
        StyleAttribute styleAttribute;
        StyleProperty fontProperty;
        Attr style;
        this.comboBlockFormat.setEnabled(enabled);
        if (enabled && (style = this.getStyleAttributeFromSelectedNode(true)) != null && (fontProperty = (styleAttribute = new StyleAttribute(style)).getProperty(STYLE_PROPERTY_NAME)) != null && (fontPropertyValue = fontProperty.getPropertyValue()) != null) {
            String fontName = fontPropertyValue.getDirtyValue().trim();
            fontName = fontName.replaceAll(REPLACE_VALUE, EMPTY);
            if (this.getComboBlockFormat().getText().equalsIgnoreCase(fontName)) {
                return;
            }
            String[] items = this.getComboBlockFormat().getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].equalsIgnoreCase(fontName)) {
                    this.getComboBlockFormat().select(i);
                    return;
                }
                ++i;
            }
        }
        this.getComboBlockFormat().select(0);
    }
}

