/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.util;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.common.el.core.ELReferenceList;
import org.jboss.tools.common.el.core.GlobalELReferenceList;
import org.jboss.tools.common.resref.core.ResourceReference;
import org.jboss.tools.vpe.editor.bundle.BundleMap;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.util.IELService;
import org.jboss.tools.vpe.editor.util.Jsf2ResourceUtil;
import org.jboss.tools.vpe.editor.util.ResourceUtil;
import org.jboss.tools.vpe.editor.util.TextUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class ElService
implements IELService {
    private static final IELService INSTANCE = new ElService();
    public static final String DOLLAR_PREFIX = "${";
    private static final String SUFFIX = "}";
    public static final String SHARP_PREFIX = "#{";

    public boolean isAvailable(IFile resourceFile) {
        boolean rst = false;
        ResourceReference[] references = this.getAllResources(resourceFile);
        if (references != null && references.length > 0) {
            rst = true;
        }
        return rst;
    }

    public static synchronized IELService getInstance() {
        return INSTANCE;
    }

    private ElService() {
    }

    public String replaceEl(IFile resourceFile, String resourceString) {
        if (resourceString == null || resourceFile == null) {
            return "";
        }
        Assert.isNotNull((Object)resourceFile);
        String rst = resourceString;
        ResourceReference[] references = this.getAllResources(resourceFile);
        if (references != null && references.length > 0) {
            rst = this.replace(resourceString, references);
        }
        return rst;
    }

    private String replace(String resourceString, ResourceReference[] references) {
        ResourceReference[] sortedReferences;
        String result = resourceString;
        ResourceReference[] resourceReferenceArray = sortedReferences = this.sortReferencesByScope(references);
        int n = sortedReferences.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceReference rf = resourceReferenceArray[n2];
            String dollarEl = DOLLAR_PREFIX + rf.getLocation() + SUFFIX;
            String sharpEl = SHARP_PREFIX + rf.getLocation() + SUFFIX;
            if (resourceString.contains(dollarEl)) {
                result = result.replace(dollarEl, rf.getProperties());
            }
            if (resourceString.contains(sharpEl)) {
                result = result.replace(sharpEl, rf.getProperties());
            }
            ++n2;
        }
        return result;
    }

    private ResourceReference[] sortReferencesByScope(ResourceReference[] references) {
        ResourceReference[] sortedReferences = (ResourceReference[])references.clone();
        Arrays.sort(sortedReferences, new Comparator<ResourceReference>(){

            @Override
            public int compare(ResourceReference r1, ResourceReference r2) {
                return r1.getScope() - r2.getScope();
            }
        });
        return sortedReferences;
    }

    public boolean isELNode(VpePageContext pageContext, Node sourceNode) {
        boolean rst = false;
        if (ElService.isInCustomElementsAttributes(pageContext, sourceNode)) {
            return true;
        }
        if (pageContext.getVisualBuilder().getCurrentIncludeInfo() == null || !(pageContext.getVisualBuilder().getCurrentIncludeInfo().getStorage() instanceof IFile)) {
            return rst;
        }
        IFile file = (IFile)pageContext.getVisualBuilder().getCurrentIncludeInfo().getStorage();
        if (this.isAvailable(file) && this.isAvailableForNode(sourceNode, file) || this.isInResourcesBundle(pageContext, sourceNode)) {
            rst = true;
        } else if (Jsf2ResourceUtil.isContainJSFExternalContextPath(sourceNode)) {
            rst = true;
        }
        if (Jsf2ResourceUtil.isContainJSF2ResourceAttributes(sourceNode)) {
            rst = true;
        }
        return rst;
    }

    private static boolean isInCustomElementsAttributes(VpePageContext pageContext, Node sourceNode) {
        block6: {
            String textValue;
            block5: {
                textValue = null;
                if (sourceNode.getNodeType() != 3) break block5;
                textValue = sourceNode.getNodeValue();
                if (textValue == null) break block6;
                for (String key : pageContext.getCustomElementsAttributes().keySet()) {
                    if (!ElService.equalsExppression(textValue, key)) continue;
                    return true;
                }
                break block6;
            }
            if (sourceNode.getNodeType() == 1) {
                NamedNodeMap attributesMap = sourceNode.getAttributes();
                int i = 0;
                while (i < attributesMap.getLength()) {
                    Attr attr = (Attr)attributesMap.item(i);
                    textValue = attr.getValue();
                    if (textValue != null) {
                        for (String key : pageContext.getCustomElementsAttributes().keySet()) {
                            if (!ElService.equalsExppression(textValue, key)) continue;
                            return true;
                        }
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    public boolean isInResourcesBundle(VpePageContext pageContext, Node sourceNode) {
        boolean rst = this.findInResourcesBundle(pageContext, sourceNode);
        return rst;
    }

    private boolean findInResourcesBundle(VpePageContext pageContext, Node sourceNode) {
        boolean rst = false;
        BundleMap bundleMap = pageContext.getBundle();
        if (bundleMap != null) {
            NamedNodeMap nodeMap;
            String newValue;
            String textValue = null;
            if (sourceNode.getNodeType() == 3 && (textValue = sourceNode.getNodeValue()) != null && TextUtil.isContainsEl(textValue) && !textValue.equals(newValue = bundleMap.getBundleValue(textValue))) {
                rst = true;
            }
            if (!rst && (nodeMap = sourceNode.getAttributes()) != null && nodeMap.getLength() > 0) {
                int i = 0;
                while (i < nodeMap.getLength()) {
                    String value2;
                    Attr attr = (Attr)nodeMap.item(i);
                    String value = attr.getValue();
                    if (value != null && TextUtil.isContainsEl(value) && !(value2 = bundleMap.getBundleValue(value)).equals(value)) {
                        rst = true;
                        break;
                    }
                    ++i;
                }
            }
        }
        return rst;
    }

    private boolean isAvailableForNode(Node sourceNode, IFile resourceFile) {
        boolean rst = this.findForNode(sourceNode, resourceFile);
        return rst;
    }

    private boolean findForNode(Node sourceNode, IFile resourceFile) {
        boolean rst = false;
        ResourceReference[] references = this.getAllResources(resourceFile);
        String textValue = null;
        if (sourceNode.getNodeType() == 3 && (textValue = sourceNode.getNodeValue()) != null && this.isInReferenceResourcesList(references, textValue)) {
            return true;
        }
        NamedNodeMap nodeMap = sourceNode.getAttributes();
        if (nodeMap != null && nodeMap.getLength() > 0) {
            int i = 0;
            while (i < nodeMap.getLength()) {
                if (this.isInReferenceResourcesList(references, ((Attr)nodeMap.item(i)).getValue())) {
                    return true;
                }
                ++i;
            }
        }
        return rst;
    }

    private boolean isInReferenceResourcesList(ResourceReference[] references, String value) {
        boolean rst = false;
        ResourceReference[] resourceReferenceArray = references;
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceReference ref = resourceReferenceArray[n2];
            if (ElService.equalsExppression(value, ref.getLocation())) {
                return true;
            }
            ++n2;
        }
        return rst;
    }

    protected ResourceReference[] getAllResources(IFile resourceFile) {
        ResourceReference[] rst = null;
        IPath workspacePath = Platform.getLocation();
        ResourceReference[] gResources = GlobalELReferenceList.getInstance().getAllResources(workspacePath);
        ResourceReference[] elResources = ELReferenceList.getInstance().getAllResources(resourceFile);
        int size = gResources == null ? 0 : gResources.length;
        rst = new ResourceReference[size += elResources == null ? 0 : elResources.length];
        if (gResources != null && gResources.length > 0) {
            System.arraycopy(gResources, 0, rst, 0, gResources.length);
        }
        if (elResources != null && elResources.length > 0) {
            System.arraycopy(elResources, 0, rst, gResources == null ? 0 : gResources.length, elResources.length);
        }
        return rst;
    }

    public String replaceElAndResources(VpePageContext pageContext, String value) {
        String rst = value;
        rst = ResourceUtil.getBundleValue(pageContext, value);
        rst = this.replaceCustomAttributes(pageContext, rst);
        if (Jsf2ResourceUtil.isExternalContextPathString(value)) {
            rst = Jsf2ResourceUtil.processExternalContextPath(value);
        }
        if (Jsf2ResourceUtil.isJSF2ResourceString(rst)) {
            rst = Jsf2ResourceUtil.processCustomJSFAttributes(pageContext, rst);
        }
        if (pageContext.getVisualBuilder().getCurrentIncludeInfo() == null || !(pageContext.getVisualBuilder().getCurrentIncludeInfo().getStorage() instanceof IFile)) {
            return rst;
        }
        IFile file = (IFile)pageContext.getVisualBuilder().getCurrentIncludeInfo().getStorage();
        rst = this.replaceEl(file, rst);
        return rst;
    }

    private String replaceCustomAttributes(VpePageContext pageContext, String value) {
        String result = value;
        for (String el : pageContext.getCustomElementsAttributes().keySet()) {
            String dollarEl = DOLLAR_PREFIX + el + SUFFIX;
            String sharpEl = SHARP_PREFIX + el + SUFFIX;
            if (result.contains(dollarEl)) {
                result = result.replace(dollarEl, pageContext.getCustomElementsAttributes().get(el));
            }
            if (!result.contains(sharpEl)) continue;
            result = result.replace(sharpEl, pageContext.getCustomElementsAttributes().get(el));
        }
        return result;
    }

    private static boolean equalsExppression(String value, String expression) {
        String dollarEl = String.valueOf(String.valueOf(DOLLAR_PREFIX)) + expression + String.valueOf(SUFFIX);
        String sharpEl = String.valueOf(String.valueOf(SHARP_PREFIX)) + expression + String.valueOf(SUFFIX);
        return value.contains(dollarEl) || value.contains(sharpEl);
    }
}

