/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.util.FileUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Jsf2ResourceUtil {
    private static final Pattern resourcePatternWithSinglCoat = Pattern.compile("[#\\$]\\{\\s*resource\\s*\\[\\s*'(.*)'\\s*\\]\\s*\\}");
    private static final Pattern resourcePatternWithDoableCoat = Pattern.compile("[#\\$]\\{\\s*resource\\s*\\[\\s*\"(.*)\"\\s*\\]\\s*\\}");
    private static final Pattern jsfExternalContextPath = Pattern.compile("^\\s*(\\#|\\$)\\{facesContext.externalContext.requestContextPath\\}");

    public static boolean isContainJSFExternalContextPath(Node sourceNode) {
        boolean result = false;
        if (sourceNode.getNodeType() == 3) {
            String textValue = sourceNode.getNodeValue();
            if (textValue != null && Jsf2ResourceUtil.isExternalContextPathString(textValue)) {
                result = true;
            }
        } else {
            NamedNodeMap nodeMap = sourceNode.getAttributes();
            if (nodeMap != null && nodeMap.getLength() > 0) {
                int i = 0;
                while (i < nodeMap.getLength()) {
                    if (Jsf2ResourceUtil.isExternalContextPathString(((Attr)nodeMap.item(i)).getValue())) {
                        result = true;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    public static boolean isExternalContextPathString(String attributeValue) {
        Matcher externalContextPathMatcher = jsfExternalContextPath.matcher(attributeValue);
        boolean result = false;
        if (externalContextPathMatcher.find()) {
            result = true;
        }
        return result;
    }

    public static boolean isContainJSF2ResourceAttributes(Node sourceNode) {
        boolean result = false;
        if (sourceNode.getNodeType() == 3) {
            String textValue = sourceNode.getNodeValue();
            if (textValue != null && Jsf2ResourceUtil.isJSF2ResourceString(textValue)) {
                result = true;
            }
        } else {
            NamedNodeMap nodeMap = sourceNode.getAttributes();
            if (nodeMap != null && nodeMap.getLength() > 0) {
                int i = 0;
                while (i < nodeMap.getLength()) {
                    if (Jsf2ResourceUtil.isJSF2ResourceString(((Attr)nodeMap.item(i)).getValue())) {
                        result = true;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    public static final String processCustomJSFAttributes(VpePageContext pageContext, String value) {
        String result = null;
        Matcher singleCoatMatcher = resourcePatternWithSinglCoat.matcher(value);
        Matcher doubleCoatMatcher = resourcePatternWithDoableCoat.matcher(value);
        if (doubleCoatMatcher.find()) {
            result = FileUtil.getJSF2ResourcePath(pageContext, doubleCoatMatcher.group(1));
        } else if (singleCoatMatcher.find()) {
            result = FileUtil.getJSF2ResourcePath(pageContext, singleCoatMatcher.group(1));
        }
        return result;
    }

    public static boolean isJSF2ResourceString(String attributeValue) {
        Matcher singleCoatMatcher = resourcePatternWithSinglCoat.matcher(attributeValue);
        Matcher doubleCoatMatcher = resourcePatternWithDoableCoat.matcher(attributeValue);
        boolean result = false;
        if (doubleCoatMatcher.find() || singleCoatMatcher.find()) {
            result = true;
        }
        return result;
    }

    public static String processExternalContextPath(String value) {
        return value.replaceFirst("^\\s*(\\#|\\$)\\{facesContext.externalContext.requestContextPath\\}", "");
    }
}

