/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.util;

import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mapping.VpeNodeMapping;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NodesManagingUtil {
    private static final String VIEW_TAGNAME = "view";
    private static final String LOCALE_ATTRNAME = "locale";

    public static VpeNodeMapping getNodeMapping(VpeDomMapping domMapping, Node node) {
        return domMapping.getNearNodeMappingAtSourceNode(node);
    }

    public static VpeNodeMapping getNodeMapping(VpeDomMapping domMapping, nsIDOMNode node) {
        return domMapping.getNearNodeMappingAtVisualNode(node);
    }

    public static int getNodeLength(Node node) {
        if (node instanceof IDOMAttr && ((IDOMAttr)node).getValueSource() != null) {
            return ((IDOMAttr)node).getValueSource().length();
        }
        if (node instanceof IndexedRegion) {
            return ((IndexedRegion)node).getEndOffset() - ((IndexedRegion)node).getStartOffset();
        }
        return 0;
    }

    public static int getStartOffsetNode(Node node) {
        if (node instanceof IDOMAttr) {
            return ((IDOMAttr)node).getValueRegionStartOffset() + 1;
        }
        if (node instanceof IndexedRegion) {
            return ((IndexedRegion)node).getStartOffset();
        }
        return 0;
    }

    public static int getEndOffsetNode(Node node) {
        if (node instanceof IDOMAttr) {
            return NodesManagingUtil.getStartOffsetNode(node) + NodesManagingUtil.getNodeLength(node);
        }
        if (node instanceof IndexedRegion) {
            return ((IndexedRegion)node).getEndOffset();
        }
        return 0;
    }

    public static Point getNodeRange(Node node) {
        return new Point(NodesManagingUtil.getStartOffsetNode(node), NodesManagingUtil.getNodeLength(node));
    }

    public static boolean isNodeContainsPosition(Node node, int position) {
        return NodesManagingUtil.getStartOffsetNode(node) <= position && NodesManagingUtil.getEndOffsetNode(node) >= position;
    }

    public static String getPageLocale(VpePageContext pageContext, Node sourceNode) {
        while (sourceNode != null) {
            if (VIEW_TAGNAME.equals(sourceNode.getLocalName())) break;
            sourceNode = sourceNode.getParentNode();
        }
        if (sourceNode == null || !(sourceNode instanceof Element) || !((Element)sourceNode).hasAttribute(LOCALE_ATTRNAME)) {
            return null;
        }
        String locale = ((Element)sourceNode).getAttribute(LOCALE_ATTRNAME);
        return locale;
    }

    public static String getSourceText(VpePageContext pageContext, int startPosition, int endPosition) {
        return pageContext.getSourceBuilder().getStructuredTextViewer().getTextWidget().getText(startPosition, endPosition);
    }

    public static String getSourceText(Node node) {
        return ((IDOMNode)node).getSource();
    }
}

