/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibController;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TaglibTracker;
import org.jboss.tools.jst.web.tld.TaglibData;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.util.FileUtil;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtil {
    public static Element getDocumentElement(String xmlFileName) throws Exception {
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(xmlFileName);
            InputSource inSource = new InputSource(inStream);
            Element element = XmlUtil.getDocumentElement(inSource);
            return element;
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException e) {
                VpePlugin.getPluginLog().logError((Throwable)e);
            }
        }
    }

    public static Element getDocumentElement(InputSource is) throws Exception {
        return XmlUtil.getDocument(is).getDocumentElement();
    }

    public static Document getDocument(InputSource is) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(is);
    }

    public static void removeChildren(Node node) {
        NodeList children = node.getChildNodes();
        if (children != null) {
            int len = children.getLength();
            int i = len - 1;
            while (i >= 0) {
                node.removeChild(children.item(i));
                --i;
            }
        }
    }

    private static List<TaglibData> getTaglibsForNode(Node node) {
        ArrayList<TaglibData> taglibs = new ArrayList<TaglibData>();
        if (node == null) {
            return taglibs;
        }
        Node currentNode = node;
        do {
            NamedNodeMap attribList;
            if ((attribList = currentNode.getAttributes()) == null) continue;
            int i = 0;
            while (i < attribList.getLength()) {
                Node tmp = attribList.item(i);
                XmlUtil.processAttribute(taglibs, (Attr)tmp);
                ++i;
            }
        } while ((currentNode = currentNode.getParentNode()) != null);
        return taglibs;
    }

    public static List<TaglibData> getTaglibsForNode(Node source, VpePageContext pageContext) {
        ArrayList<TaglibData> taglibData = new ArrayList();
        IPath path = FileUtil.getInputPath(pageContext.getEditPart().getEditorInput());
        if (path != null && path.getFileExtension().equals("jsp")) {
            IDocument document = pageContext.getSourceBuilder().getStructuredTextViewer().getDocument();
            TLDCMDocumentManager tldcmDocumentManager = TaglibController.getTLDCMDocumentManager((IDocument)document);
            if (tldcmDocumentManager != null) {
                List taglibs_JSP = tldcmDocumentManager.getTaglibTrackers();
                for (TaglibTracker taglibTracker : taglibs_JSP) {
                    XmlUtil.addTaglib(taglibData, taglibTracker.getURI(), taglibTracker.getPrefix(), true);
                }
            }
        } else {
            taglibData = XmlUtil.getTaglibsForNode(source);
        }
        List<TaglibData> includeTaglibs = pageContext.getIncludeTaglibs();
        for (TaglibData includedTaglib : includeTaglibs) {
            XmlUtil.addTaglib(taglibData, includedTaglib.getUri(), includedTaglib.getPrefix(), true);
        }
        return taglibData;
    }

    public static boolean hasTaglib(Node sourceNode, VpePageContext pageContext, String sourcePrefix) {
        List<TaglibData> taglibs = XmlUtil.getTaglibsForNode(sourceNode, pageContext);
        TaglibData sourceNodeTaglib = XmlUtil.getTaglibForPrefix(sourcePrefix, taglibs);
        return sourceNodeTaglib != null;
    }

    public static String getTaglibUri(Node sourceNode, VpePageContext pageContext, String sourcePrefix) {
        List<TaglibData> taglibs = XmlUtil.getTaglibsForNode(sourceNode, pageContext);
        TaglibData sourceNodeTaglib = XmlUtil.getTaglibForPrefix(sourcePrefix, taglibs);
        return sourceNodeTaglib == null ? null : sourceNodeTaglib.getUri();
    }

    private static void processAttribute(List<TaglibData> taglibs, Attr attr) {
        String startStr = "xmlns";
        String name = attr.getName();
        if (!name.startsWith(startStr)) {
            return;
        }
        if ((name = name.substring(startStr.length())).startsWith(":")) {
            name = name.substring(1);
        }
        XmlUtil.addTaglib(taglibs, attr.getValue(), name, true);
    }

    private static void addTaglib(List<TaglibData> taglibs, String newUri, String newPrefix, boolean ns) {
        boolean bHasSame = false;
        int i = 0;
        while (i < taglibs.size()) {
            TaglibData taglib = taglibs.get(i);
            if (newPrefix.equals(taglib.getPrefix())) {
                return;
            }
            if (newUri.equals(taglib.getUri()) && newPrefix.equals(taglib.getPrefix()) && ns == taglib.isNs()) {
                bHasSame = true;
                break;
            }
            ++i;
        }
        if (!bHasSame) {
            taglibs.add(new TaglibData(taglibs.size(), newUri, newPrefix, ns));
        }
    }

    public static TaglibData getTaglibForPrefix(String prefix, List<TaglibData> taglibData) {
        for (TaglibData data : taglibData) {
            if (data.getPrefix() == null || !data.getPrefix().equalsIgnoreCase(prefix)) continue;
            return data;
        }
        return null;
    }

    public static TaglibData getTaglibForURI(String uri, List<TaglibData> taglibData) {
        for (TaglibData data : taglibData) {
            if (data.getUri() == null || !data.getUri().equalsIgnoreCase(uri)) continue;
            return data;
        }
        return null;
    }

    public static final nsIDOMNode createClone(nsIDOMNode nodeToClone) {
        nsIDOMNode result = nodeToClone.cloneNode(true);
        return result;
    }
}

