/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.wizards;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardExportResourcesPage;
import org.jboss.tools.vpe.editor.template.VpeAnyData;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.jboss.tools.vpe.messages.VpeUIMessages;
import org.jboss.tools.vpe.resref.core.ReferenceWizardPage;

public class ExportUnknownTagsTemplatesWizardPage
extends WizardExportResourcesPage {
    private static final String[] COLUMNS_NAMES = new String[]{VpeUIMessages.TemplatesTableProvider_TagName, VpeUIMessages.TemplatesTableProvider_TagForDisplay, VpeUIMessages.TemplatesTableProvider_URI, VpeUIMessages.TemplatesTableProvider_Children};
    private static final int[] COLUMNS_WIDTHS = new int[]{50, 50, 90, 40};
    private String pathString;
    private Table tagsTable;
    private List<VpeAnyData> tagsList;

    public ExportUnknownTagsTemplatesWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
        this.setTitle(VpeUIMessages.EXPORT_UNKNOWN_TAGS_PAGE_TITLE);
        this.setDescription(VpeUIMessages.EXPORT_UNKNOWN_TAGS_PAGE_DESCRIPTION);
        this.setImageDescriptor(ReferenceWizardPage.getImageDescriptor());
        this.tagsList = VpeTemplateManager.getInstance().getAnyTemplates();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite.setFont(parent.getFont());
        this.tagsTable = new Table(composite, 2048);
        TableLayout layout = new TableLayout();
        this.tagsTable.setLayout((Layout)layout);
        this.tagsTable.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.tagsTable.setHeaderVisible(true);
        this.tagsTable.setLinesVisible(true);
        int i = 0;
        while (i < COLUMNS_NAMES.length) {
            TableColumn column = new TableColumn(this.tagsTable, 0);
            column.setText(COLUMNS_NAMES[i]);
            ColumnWeightData columnLayoutData = new ColumnWeightData(COLUMNS_WIDTHS[i], true);
            layout.addColumnData((ColumnLayoutData)columnLayoutData);
            ++i;
        }
        this.updateTagsTable(true);
        final Text pathText = new Text(composite, 2048);
        pathText.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportUnknownTagsTemplatesWizardPage.this.pathString = ((Text)e.getSource()).getText();
                ExportUnknownTagsTemplatesWizardPage.this.setPageComplete(ExportUnknownTagsTemplatesWizardPage.this.isPageComplete());
            }
        });
        Button browseButton = new Button(composite, 0);
        browseButton.setText(VpeUIMessages.BROWSE_BUTTON_TEXT);
        browseButton.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 0);
                String path = dialog.open();
                if (path != null) {
                    File file = new File(path);
                    ExportUnknownTagsTemplatesWizardPage.this.pathString = file.toString();
                    pathText.setText(ExportUnknownTagsTemplatesWizardPage.this.pathString);
                }
            }
        });
        this.updateWidgetEnablements();
        this.setPageComplete(this.determinePageCompletion());
        this.setErrorMessage(null);
        this.setControl((Control)composite);
    }

    protected void createDestinationGroup(Composite parent) {
    }

    private void updateTagsTable(boolean clearTagsTable) {
        if (this.tagsTable == null || this.tagsTable.isDisposed()) {
            return;
        }
        if (clearTagsTable) {
            this.tagsTable.clearAll();
        }
        if (this.tagsList == null) {
            return;
        }
        int selectionIndex = this.tagsTable.getSelectionIndex();
        TableItem tableItem = null;
        int i = 0;
        while (i < this.tagsList.size()) {
            tableItem = this.tagsTable.getItemCount() > i ? this.tagsTable.getItem(i) : new TableItem(this.tagsTable, 2048, i);
            String[] itemColumnsData = new String[this.tagsTable.getColumnCount()];
            int j = 0;
            while (j < itemColumnsData.length) {
                itemColumnsData[j] = this.toVisualValue(this.getValueAt(i, j));
                ++j;
            }
            tableItem.setText(itemColumnsData);
            ++i;
        }
        if (selectionIndex > 0) {
            try {
                this.tagsTable.setSelection(selectionIndex);
            }
            catch (SWTException sWTException) {}
        }
    }

    public String getValueAt(int row, int column) {
        String result = "List is empty";
        if (this.tagsList != null && row >= 0 && this.tagsList.size() > 0 && row < this.tagsList.size()) {
            VpeAnyData tagItem = this.tagsList.get(row);
            switch (column) {
                case 0: {
                    result = tagItem.getName();
                    break;
                }
                case 1: {
                    result = tagItem.getTagForDisplay();
                    break;
                }
                case 2: {
                    result = tagItem.getUri();
                    break;
                }
                case 3: {
                    result = tagItem.isChildren() ? VpeUIMessages.TemplatesTableProvider_Yes : VpeUIMessages.TemplatesTableProvider_No;
                }
            }
        }
        return result;
    }

    private String toVisualValue(String v) {
        if (v == null) {
            return "";
        }
        if (v.indexOf(10) >= 0) {
            v = v.replace('\n', ' ');
        }
        if (v.indexOf(9) >= 0) {
            v = v.replace('\t', ' ');
        }
        if (v.indexOf(13) >= 0) {
            v = v.replace('\r', ' ');
        }
        return v;
    }

    public void handleEvent(Event event) {
    }

    public boolean isPageComplete() {
        boolean isPageComplete = false;
        if (this.pathString != null && !"".equalsIgnoreCase(this.pathString) && Path.ROOT.isValidPath(this.pathString)) {
            isPageComplete = true;
        }
        return isPageComplete;
    }

    public boolean finish() {
        List<VpeAnyData> templates = VpeTemplateManager.getInstance().getAnyTemplates();
        Path path = new Path(this.pathString);
        VpeTemplateManager.getInstance().setAnyTemplates(templates, (IPath)path);
        return true;
    }
}

