/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.selbar;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.Splitter;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.jboss.tools.jst.jsp.JspEditorPlugin;
import org.jboss.tools.vpe.editor.VpeController;
import org.jboss.tools.vpe.editor.selection.VpeSourceSelection;
import org.jboss.tools.vpe.editor.selection.VpeSourceSelectionBuilder;
import org.jboss.tools.vpe.editor.util.SelectionUtil;
import org.jboss.tools.vpe.messages.VpeUIMessages;
import org.jboss.tools.vpe.selbar.ImageButton;
import org.jboss.tools.vpe.selbar.NodeListener;
import org.jboss.tools.vpe.selbar.VisibilityEvent;
import org.jboss.tools.vpe.selbar.VisibilityListener;
import org.w3c.dom.Node;

public class SelectionBar
implements SelectionListener {
    private static final int SEL_ITEM_RIGHT_MARGIN = 5;
    private Splitter splitter;
    private boolean resizeListenerAdded = false;
    private VpeController vpeController = null;
    private ToolBar selBar = null;
    private FormData selBarData;
    private Menu dropDownMenu = null;
    private int itemCount = 0;
    private Composite cmpToolBar = null;
    private Composite cmpTlEmpty = null;
    private List<VisibilityListener> visibilityListeners = new ArrayList<VisibilityListener>(1);
    private boolean visible;
    private ImageButton arrowButton;
    private Node currentSelectedNode = null;
    private Node currentLastNode = null;
    private List<INodeNotifier> nodeNotifiers = new ArrayList<INodeNotifier>();
    private NodeListener nodeListener = new NodeListener(this);

    public Composite createToolBarComposite(Composite parent, boolean visible) {
        this.splitter = new Splitter(parent, 0);
        this.splitter.setLayoutData((Object)new GridData(768));
        this.cmpTlEmpty = new Composite((Composite)this.splitter, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Point point = super.computeSize(wHint, hHint, changed);
                point.y = 1;
                return point;
            }
        };
        this.cmpTlEmpty.setLayoutData((Object)new GridData(768));
        this.cmpToolBar = new Composite((Composite)this.splitter, 0);
        this.cmpToolBar.setLayout((Layout)new FormLayout());
        Image closeImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
        Listener closeListener = new Listener(){

            public void handleEvent(Event event) {
                if (SelectionBar.this.askConfirmationOnClosingSelectionBar()) {
                    MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)VpeUIMessages.CONFIRM_SELECTION_BAR_DIALOG_TITLE, (String)VpeUIMessages.CONFIRM_SELECTION_BAR_DIALOG_MESSAGE, (String)VpeUIMessages.ASK_CONFIRMATION_ON_CLOSING_SELECTION_BAR, (boolean)SelectionBar.this.askConfirmationOnClosingSelectionBar(), null, null);
                    if (dialog.getReturnCode() != 0) {
                        return;
                    }
                    SelectionBar.this.setAskConfirmationOnClosingSelectionBar(dialog.getToggleState());
                }
                SelectionBar.this.setVisible(false);
            }
        };
        ImageButton closeButton = new ImageButton(this.cmpToolBar, closeImage, VpeUIMessages.HIDE_SELECTION_BAR);
        closeButton.addSelectionListener(closeListener);
        FormData closeBarData = new FormData();
        closeBarData.right = new FormAttachment(100);
        closeBarData.top = new FormAttachment(0);
        Composite closeItemComposite = closeButton.getComposite();
        closeItemComposite.setLayoutData((Object)closeBarData);
        this.selBar = new ToolBar(this.cmpToolBar, 8651008);
        this.selBarData = new FormData();
        this.selBarData.left = new FormAttachment(0);
        this.selBarData.right = new FormAttachment((Control)closeItemComposite, 0, 16384);
        this.selBarData.top = new FormAttachment(0);
        this.selBar.setLayoutData((Object)this.selBarData);
        this.createArrowButton();
        this.cmpToolBar.layout();
        this.setVisible(visible);
        return this.splitter;
    }

    public boolean getAlwaysVisibleOption() {
        return JspEditorPlugin.getDefault().getPreferenceStore().getBoolean("Show Selection Tag Bar");
    }

    public void setAskConfirmationOnClosingSelectionBar(boolean askConfirmation) {
        JspEditorPlugin.getDefault().getPreferenceStore().setValue("Ask for confirmation when closing Selection Bar", askConfirmation);
    }

    public boolean askConfirmationOnClosingSelectionBar() {
        return JspEditorPlugin.getDefault().getPreferenceStore().getBoolean("Ask for confirmation when closing Selection Bar");
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.splitter.setVisible((Control)this.cmpToolBar, true);
            this.splitter.setVisible((Control)this.cmpTlEmpty, false);
        } else {
            this.splitter.setVisible((Control)this.cmpToolBar, false);
            this.splitter.setVisible((Control)this.cmpTlEmpty, true);
        }
        this.splitter.getParent().layout(true, true);
        this.visible = visible;
        if (this.vpeController != null) {
            this.vpeController.updateVpeToolbar();
        }
        this.fireVisibilityListeners();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void addVisibilityListener(VisibilityListener listener) {
        this.visibilityListeners.add(listener);
    }

    public void removeVisibilityListener(VisibilityListener listener) {
        this.visibilityListeners.remove(listener);
    }

    private void fireVisibilityListeners() {
        VisibilityEvent event = new VisibilityEvent(this);
        for (VisibilityListener listener : this.visibilityListeners) {
            listener.visibilityChanged(event);
        }
    }

    public void setVpeController(VpeController vpeController) {
        this.vpeController = vpeController;
    }

    public void updateNodes(boolean forceUpdate) {
        VpeSourceSelectionBuilder sourceSelectionBuilder = new VpeSourceSelectionBuilder(this.vpeController.getSourceEditor());
        VpeSourceSelection selection = sourceSelectionBuilder.getSelection();
        if (selection == null) {
            return;
        }
        Node node = selection.getStartNode();
        if (node != null && node.getNodeType() == 3) {
            node = node.getParentNode();
        }
        if (this.currentSelectedNode == node && !forceUpdate) {
            return;
        }
        boolean ancestorSelected = this.isAncestor(node, this.currentLastNode);
        if (ancestorSelected) {
            if (forceUpdate) {
                this.setSelBarItems(this.currentLastNode);
            } else {
                this.setNodeSelected(this.currentSelectedNode, false);
            }
        } else {
            this.setSelBarItems(node);
            this.currentLastNode = node;
        }
        this.setNodeSelected(node, true);
        this.currentSelectedNode = node;
    }

    private void setNodeSelected(Node node, boolean selected) {
        ToolItem item;
        ToolItem[] toolItemArray = this.selBar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            item = toolItemArray[n2];
            if (item.getData() == node) {
                item.setSelection(selected);
                return;
            }
            ++n2;
        }
        if (this.dropDownMenu == null) {
            return;
        }
        toolItemArray = this.dropDownMenu.getItems();
        n = toolItemArray.length;
        n2 = 0;
        while (n2 < n) {
            item = toolItemArray[n2];
            if (item.getData() == node) {
                item.setSelection(selected);
                return;
            }
            ++n2;
        }
    }

    private void setSelBarItems(Node node) {
        this.cmpToolBar.layout();
        this.splitter.getParent().layout(true, true);
        this.removeNodeListenerFromAllNodes();
        this.cleanToolBar(this.selBar);
        this.disposeDropDownMenu();
        int elementCounter = 0;
        while (node != null && (node.getNodeType() == 1 || node.getNodeType() == 8)) {
            this.addNodeListenerTo(node);
            if (this.dropDownMenu == null) {
                ToolItem item = new ToolItem(this.selBar, 0x800020, 1);
                item.addSelectionListener((SelectionListener)this);
                item.setData((Object)node);
                item.setText(node.getNodeName());
                if (!this.isItemShown(this.selBar.getItem(elementCounter + 1))) {
                    item.dispose();
                    this.dropDownMenu = new Menu((Control)this.selBar);
                }
            }
            if (this.dropDownMenu != null) {
                MenuItem menuItem = new MenuItem(this.dropDownMenu, 32, 0);
                menuItem.addSelectionListener((SelectionListener)this);
                menuItem.setText(node.getNodeName());
                menuItem.setData((Object)node);
            }
            ++elementCounter;
            node = node.getParentNode();
        }
        this.itemCount = elementCounter;
        this.arrowButton.setEnabled(this.dropDownMenu != null);
        if (node != null && node.getNodeType() == 9) {
            this.addNodeListenerTo(node);
        }
        if (!this.resizeListenerAdded) {
            this.cmpToolBar.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    SelectionBar.this.updateNodes(true);
                }
            });
            this.resizeListenerAdded = true;
        }
    }

    private boolean isAncestor(Node potentialAncestor, Node node) {
        if (potentialAncestor == null || node == null) {
            return false;
        }
        Node curAncestor = node;
        while ((curAncestor = curAncestor.getParentNode()) != null) {
            if (potentialAncestor != curAncestor) continue;
            return true;
        }
        return false;
    }

    private void cleanToolBar(ToolBar toolBar) {
        ToolItem[] oldItems = toolBar.getItems();
        int i = 1;
        while (i < oldItems.length) {
            oldItems[i].dispose();
            ++i;
        }
    }

    private void createArrowButton() {
        Image hoverImage = WorkbenchImages.getImage((String)"IMG_LCL_RENDERED_VIEW_MENU");
        this.arrowButton = new ImageButton((Composite)this.selBar, hoverImage, VpeUIMessages.SelectionBar_MoreNodes);
        this.arrowButton.setEnabled(false);
        this.arrowButton.addSelectionListener(new Listener(){

            public void handleEvent(Event event) {
                Rectangle bounds = SelectionBar.this.arrowButton.getButtonBounds();
                Point point = SelectionBar.this.selBar.toDisplay(bounds.x, bounds.y + bounds.height);
                SelectionBar.this.dropDownMenu.setLocation(point);
                SelectionBar.this.dropDownMenu.setVisible(true);
            }
        });
        ToolItem arrowItem = new ToolItem(this.selBar, 2, 0);
        Composite arrowButtonComposite = this.arrowButton.getComposite();
        arrowItem.setControl((Control)arrowButtonComposite);
        arrowButtonComposite.pack();
        arrowItem.setWidth(arrowButtonComposite.getSize().x);
        FormData arrowToolBarData = new FormData();
        arrowToolBarData.left = new FormAttachment(0);
        arrowToolBarData.top = new FormAttachment(0);
        arrowButtonComposite.setLayoutData((Object)arrowToolBarData);
    }

    private boolean isItemShown(ToolItem toolItem) {
        ToolBar toolBar = toolItem.getParent();
        Rectangle toolItemBounds = toolItem.getBounds();
        toolItemBounds.width += 5;
        Rectangle intersection = toolBar.getBounds().intersection(toolItemBounds);
        return intersection.equals((Object)toolItemBounds);
    }

    private void addNodeListenerTo(Node node) {
        INodeNotifier notifier;
        if (node instanceof INodeNotifier && (notifier = (INodeNotifier)node).getExistingAdapter((Object)this) == null) {
            notifier.addAdapter((INodeAdapter)this.nodeListener);
            this.nodeNotifiers.add(notifier);
        }
    }

    private void removeNodeListenerFromAllNodes() {
        for (INodeNotifier notifier : this.nodeNotifiers) {
            notifier.removeAdapter((INodeAdapter)this.nodeListener);
        }
        this.nodeNotifiers.clear();
    }

    public void dispose() {
        this.removeNodeListenerFromAllNodes();
        if (this.splitter != null) {
            this.splitter.dispose();
            this.splitter = null;
        }
        this.disposeDropDownMenu();
    }

    private void disposeDropDownMenu() {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
            this.dropDownMenu = null;
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Widget widget = e.widget;
        if (widget instanceof ToolItem) {
            ((ToolItem)widget).setSelection(true);
        } else if (widget instanceof MenuItem) {
            ((MenuItem)widget).setSelection(true);
        }
        SelectionUtil.setSourceSelection(this.vpeController.getPageContext(), (Node)widget.getData());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public String toString() {
        StringBuffer st = new StringBuffer("CountItem: ");
        st.append(this.itemCount);
        st.append(" Parent Composite: " + this.cmpToolBar.getBounds().width);
        st.append(" Bar : " + this.selBar.getBounds().width);
        return st.toString();
    }
}

