/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.jsp;

import java.util.ArrayList;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.source.ISourceViewer;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkDetector;
import org.jboss.tools.common.text.xml.contentassist.SortingCompoundContentAssistProcessor;
import org.jboss.tools.jst.jsp.ITextViewerConfiguration;

public class TextViewerConfigurationDelegate {
    ITextViewerConfiguration target;

    public TextViewerConfigurationDelegate(ITextViewerConfiguration config) {
        this.target = config;
    }

    protected IContentAssistProcessor[] getContentAssistProcessors(ISourceViewer sourceViewer, String partitionType) {
        SortingCompoundContentAssistProcessor sortingCompoundProcessor = new SortingCompoundContentAssistProcessor(sourceViewer, partitionType);
        if (sortingCompoundProcessor.supportsPartitionType(partitionType)) {
            IContentAssistProcessor[] superProcessors = this.target.getContentAssistProcessorsForPartitionType(sourceViewer, partitionType);
            if (superProcessors != null && superProcessors.length > 0) {
                int i = 0;
                while (i < superProcessors.length) {
                    sortingCompoundProcessor.addContentAssistProcessor(partitionType, superProcessors[i]);
                    ++i;
                }
            }
            return new IContentAssistProcessor[]{sortingCompoundProcessor};
        }
        return new IContentAssistProcessor[0];
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer, boolean enabled) {
        IHyperlinkDetector[] result = ITextViewerConfiguration.NO_CA_DETECTORS;
        if (enabled) {
            ArrayList<HyperlinkDetector> allDetectors = new ArrayList<HyperlinkDetector>(0);
            HyperlinkDetector extHyperlinkDetector = HyperlinkDetector.getInstance();
            if (extHyperlinkDetector != null) {
                allDetectors.add(extHyperlinkDetector);
            }
            result = allDetectors.toArray(new IHyperlinkDetector[0]);
        }
        return result;
    }
}

