/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.jsp.contentassist;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;

public class AutoContentAssistantProposal
extends CustomCompletionProposal
implements ICompletionProposalExtension6 {
    private boolean autoContentAssistant = false;
    StyledString fStyledDisplayString;
    private int fOriginalReplacementLength;

    public AutoContentAssistantProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, 0);
        this.fOriginalReplacementLength = replacementLength;
    }

    public AutoContentAssistantProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int relevance) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, relevance);
        this.fOriginalReplacementLength = replacementLength;
    }

    public AutoContentAssistantProposal(boolean autoContentAssistant, String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int relevance) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, relevance);
        this.autoContentAssistant = autoContentAssistant;
        this.fOriginalReplacementLength = replacementLength;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        super.apply(viewer, trigger, stateMask, offset);
        if (this.autoContentAssistant) {
            Point selection = this.getSelection(viewer.getDocument());
            viewer.setSelectedRange(selection.x, selection.y);
            if (viewer instanceof ITextOperationTarget) {
                ((ITextOperationTarget)viewer).doOperation(13);
            }
        }
    }

    public int getCursorPosition() {
        int cursorPosition = -1;
        int firstAttributeEndPosition = this.getReplacementString().indexOf("=");
        int openEndTagPosition = this.getReplacementString().indexOf("</");
        int closeStartAndEndTagPosition = this.getReplacementString().indexOf("/>");
        if (firstAttributeEndPosition > -1) {
            cursorPosition = firstAttributeEndPosition + 2;
        } else if (openEndTagPosition > -1) {
            cursorPosition = openEndTagPosition;
        } else if (closeStartAndEndTagPosition > -1) {
            cursorPosition = closeStartAndEndTagPosition;
        }
        return cursorPosition > -1 ? cursorPosition : super.getCursorPosition();
    }

    public String getDisplayString() {
        if (super.getDisplayString() != null) {
            return super.getDisplayString();
        }
        if (super.getReplacementString() != null) {
            this.setDisplayString(super.getReplacementString());
            return super.getDisplayString();
        }
        return "";
    }

    public void setDisplayString(String string) {
        super.setDisplayString(string);
        boolean isJavaWordPart = string.length() > 0 && Character.isJavaIdentifierPart(string.charAt(0));
        boolean hasRetType = isJavaWordPart && string.indexOf(58) > 0;
        boolean hasDeclType = isJavaWordPart && string.lastIndexOf(45) > 0;
        int p2i = string.lastIndexOf(45);
        String p1 = hasRetType && hasDeclType ? string.substring(0, p2i) : string;
        String p2 = string.substring(p1.length());
        StyledString styledString = new StyledString();
        styledString.append(p1);
        if (p2 != null && p2.length() > 0) {
            styledString.append(p2, StyledString.QUALIFIER_STYLER);
        }
        this.fStyledDisplayString = styledString;
    }

    public StyledString getStyledDisplayString() {
        if (this.fStyledDisplayString == null) {
            this.setDisplayString(super.getDisplayString());
        }
        return this.fStyledDisplayString;
    }

    public void setStyledDisplayString(StyledString text) {
        this.fStyledDisplayString = text;
        super.setDisplayString(this.fStyledDisplayString == null ? "" : this.fStyledDisplayString.getString());
    }

    private boolean isTagName(IDocument document, int offset) {
        if (!(document instanceof IStructuredDocument)) {
            return false;
        }
        int lastOffset = offset;
        IStructuredDocumentRegion sdRegion = ((IStructuredDocument)document).getRegionAtCharacterOffset(offset);
        while (sdRegion == null && lastOffset >= 0) {
            sdRegion = ((IStructuredDocument)document).getRegionAtCharacterOffset(--lastOffset);
        }
        ITextRegion region = sdRegion == null ? null : sdRegion.getRegionAtCharacterOffset(offset);
        return "XML_TAG_NAME".equals(region == null ? null : region.getType());
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        String replacementString;
        int fReplacementOffset = this.getReplacementOffset();
        if (offset < fReplacementOffset) {
            return false;
        }
        boolean validated = this.startsWith(document, offset, this.getReplacementString());
        if (!validated && this.isTagName(document, fReplacementOffset) && this.getReplacementString() != null && this.getReplacementString().indexOf(":") != -1) {
            replacementString = this.getReplacementString().substring(this.getReplacementString().indexOf(":") + 1);
            validated = this.startsWith(document, offset, replacementString);
        }
        if (!validated && this.getReplacementString() != null && this.getReplacementString().startsWith("#{")) {
            replacementString = this.getReplacementString().substring(this.getReplacementString().indexOf("#{") + 2);
            validated = this.startsWith(document, offset, replacementString);
        }
        int newLength = offset - this.getReplacementOffset();
        int delta = newLength - this.fOriginalReplacementLength;
        int newReplacementLength = delta + this.fOriginalReplacementLength;
        this.setReplacementLength(newReplacementLength);
        try {
            char firstChar = document.getChar(this.getReplacementOffset());
            if (firstChar == '\"' || firstChar == '\'') {
                this.setReplacementLength(this.getReplacementLength() + 1);
            }
        }
        catch (BadLocationException badLocationException) {}
        return validated;
    }
}

