/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.jsp.contentassist;

import java.io.Reader;
import java.io.StringReader;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocContentAccess2;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLinks;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.jst.jsp.contentassist.AutoContentAssistantProposal;

public class AutoELContentAssistantProposal
extends AutoContentAssistantProposal {
    private IJavaElement[] fJavaElements;
    private String fAdditionalProposalInfo;
    private static final long LABEL_FLAGS = JavaElementLabels.ALL_FULLY_QUALIFIED | 0x40L | 1L | 2L | 0x10L | 0x8000L | 4L | 0x200000L | 0x1000000000000L;
    private static final long LOCAL_VARIABLE_FLAGS = LABEL_FLAGS & 0xFFFFFFFFFFFEFFFFL | 0x20000L;
    private static final long TYPE_PARAMETER_FLAGS = LABEL_FLAGS | 0x400000L;

    public AutoELContentAssistantProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, IJavaElement[] elements, int relevance) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, null, relevance);
        this.fJavaElements = elements;
    }

    public String getAdditionalProposalInfo() {
        if (this.fAdditionalProposalInfo == null && this.fJavaElements != null && this.fJavaElements.length > 0) {
            this.fAdditionalProposalInfo = this.extractProposalContextInfo(this.fJavaElements);
        }
        return this.fAdditionalProposalInfo;
    }

    private String extractProposalContextInfo(IJavaElement[] elements) {
        int nResults = elements.length;
        StringBuffer buffer = new StringBuffer();
        boolean hasContents = false;
        IJavaElement element = null;
        if (nResults > 1) {
            int i = 0;
            while (i < elements.length) {
                if (elements[i] != null) {
                    if (elements[i] instanceof IMember || elements[i].getElementType() == 14 || elements[i].getElementType() == 15) {
                        buffer.append('\ufffd').append(' ').append(this.getInfoText(elements[i]));
                        hasContents = true;
                    }
                    buffer.append("<br/>");
                }
                ++i;
            }
            i = 0;
            while (i < elements.length) {
                if (elements[i] != null && (elements[i] instanceof IMember || elements[i].getElementType() == 14 || elements[i].getElementType() == 15)) {
                    buffer.append("<br/>");
                    this.addFullInfo(buffer, elements[i]);
                    hasContents = true;
                }
                ++i;
            }
        } else {
            element = elements[0];
            if (element instanceof IMember || element.getElementType() == 14 || element.getElementType() == 15) {
                this.addFullInfo(buffer, element);
                hasContents = true;
            }
        }
        if (!hasContents) {
            return null;
        }
        if (buffer.length() > 0) {
            HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, null);
            HTMLPrinter.addPageEpilog((StringBuffer)buffer);
            return buffer.toString();
        }
        return null;
    }

    private String getInfoText(IJavaElement element) {
        long flags;
        switch (element.getElementType()) {
            case 14: {
                flags = LOCAL_VARIABLE_FLAGS;
                break;
            }
            case 15: {
                flags = TYPE_PARAMETER_FLAGS;
                break;
            }
            default: {
                flags = LABEL_FLAGS;
            }
        }
        StringBuffer label = new StringBuffer(JavaElementLinks.getElementLabel((IJavaElement)element, (long)flags));
        StringBuffer buf = new StringBuffer();
        buf.append("<span style='word-wrap:break-word;'>");
        buf.append(label);
        buf.append("</span>");
        return buf.toString();
    }

    private void addFullInfo(StringBuffer buffer, IJavaElement element) {
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)this.getInfoText((IJavaElement)member));
            StringReader reader = null;
            try {
                String content = JavadocContentAccess2.getHTMLContent((IMember)member, (boolean)true);
                reader = content == null ? null : new StringReader(content);
            }
            catch (JavaModelException ex) {
                JavaPlugin.log((Throwable)ex);
            }
            if (reader != null) {
                HTMLPrinter.addParagraph((StringBuffer)buffer, (Reader)reader);
            }
        } else if (element.getElementType() == 14 || element.getElementType() == 15) {
            HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)this.getInfoText(element));
        }
    }
}

