/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.jsp.contentassist;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.wst.sse.ui.internal.util.Sorter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.jboss.tools.common.el.core.model.ELInstance;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.model.ELModel;
import org.jboss.tools.common.el.core.model.ELUtil;
import org.jboss.tools.common.el.core.parser.ELParser;
import org.jboss.tools.common.el.core.parser.ELParserUtil;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELResolver;
import org.jboss.tools.common.el.core.resolver.ELResolverFactoryManager;
import org.jboss.tools.common.text.TextProposal;
import org.jboss.tools.jst.jsp.contentassist.AbstractXMLContentAssistProcessor;
import org.jboss.tools.jst.jsp.contentassist.JspContentAssistProcessor;
import org.jboss.tools.jst.jsp.messages.JstUIMessages;
import org.jboss.tools.jst.jsp.outline.ValueHelper;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.PageProcessor;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSPDialogContentProposalProvider
implements IContentProposalProvider {
    static int EL_MODE = 0;
    static int ATTR_MODE = 1;
    int mode = EL_MODE;
    Properties context;
    String attributeName;
    String nodeName;
    int offset = 0;
    JspContentAssistProcessor processor;
    IPageContext pageContext = null;

    public void setAttrMode() {
        this.mode = ATTR_MODE;
    }

    public void setContext(Properties context) {
        this.context = context;
        this.attributeName = context.getProperty("attributeName");
        this.nodeName = context.getProperty("nodeName");
        Node node = (Node)context.get("node");
        if (node instanceof IDOMElement) {
            this.offset = ((IDOMElement)node).getStartOffset() + this.nodeName.length();
        } else if (context.get("offset") != null) {
            this.offset = (Integer)context.get("offset");
        }
        ValueHelper valueHelper = (ValueHelper)context.get("valueHelper");
        if (valueHelper == null) {
            valueHelper = new ValueHelper();
        }
        this.pageContext = (IPageContext)context.get("pageContext");
        this.processor = (JspContentAssistProcessor)((Object)context.get("processor"));
        if (this.processor == null) {
            this.processor = valueHelper.createContentAssistProcessor();
            context.put("processor", (Object)this.processor);
        }
        if (this.pageContext == null) {
            this.pageContext = valueHelper.createPageContext(this.processor, this.offset);
        }
        context.put("pageContext", this.pageContext);
        context.put("kbQuery", this.createKbQuery(KbQuery.Type.ATTRIBUTE_VALUE, "", "", this.offset, false));
    }

    public IContentProposal[] getProposals(String contents, int position) {
        if (this.mode == ATTR_MODE) {
            return this.getAttrProposals(contents, position);
        }
        return this.getELProposals(contents, position);
    }

    public IContentProposal[] getAttrProposals(String contents, int position) {
        ArrayList<IContentProposal> result = new ArrayList<IContentProposal>();
        AbstractXMLContentAssistProcessor.TextRegion p = this.getELPrefix(contents, position);
        if (p == null || !p.isELStarted()) {
            KbQuery kbQuery = this.createKbQuery(KbQuery.Type.ATTRIBUTE_VALUE, contents.substring(0, position), contents, position, false);
            TextProposal[] proposals = PageProcessor.getInstance().getProposals(kbQuery, (ELContext)this.pageContext);
            if (proposals != null) {
                TextProposal[] textProposalArray = proposals;
                int n = proposals.length;
                int n2 = 0;
                while (n2 < n) {
                    TextProposal textProposal = textProposalArray[n2];
                    String displayString = textProposal.getReplacementString();
                    int cursorPosition = textProposal.getReplacementString().length();
                    textProposal.getImage();
                    String relacementString = textProposal.getReplacementString();
                    if (textProposal.getStart() >= 0 && textProposal.getEnd() >= 0) {
                        int b = textProposal.getStart();
                        int e = textProposal.getEnd();
                        String prefix = contents.substring(0, b);
                        String tail = contents.substring(e);
                        relacementString = String.valueOf(prefix) + relacementString + tail;
                    }
                    ContentProposal proposal = new ContentProposal(relacementString, cursorPosition, displayString, displayString);
                    result.add(proposal);
                    ++n2;
                }
            }
            ContentProposal proposal = new ContentProposal(String.valueOf(contents.substring(0, position)) + "#{}" + contents.substring(position), position, "#{}", JstUIMessages.JSPDialogContentProposalProvider_NewELExpression);
            result.add(proposal);
        }
        return this.toSortedUniqueArray(result);
    }

    public IContentProposal[] getELProposals(String contents, int position) {
        ArrayList<IContentProposal> result = new ArrayList<IContentProposal>();
        AbstractXMLContentAssistProcessor.TextRegion prefix = this.getELPrefix(contents, position);
        if (prefix == null || !prefix.isELStarted()) {
            return this.toSortedUniqueArray(result);
        }
        String matchString = "#{" + prefix.getText();
        String query = matchString;
        if (query == null) {
            query = "";
        }
        String stringQuery = matchString;
        int beginChangeOffset = prefix.getStartOffset() + prefix.getOffset();
        KbQuery kbQuery = this.createKbQuery(KbQuery.Type.ATTRIBUTE_VALUE, query, stringQuery, position, true);
        TextProposal[] proposals = PageProcessor.getInstance().getProposals(kbQuery, (ELContext)this.pageContext);
        if (proposals != null) {
            TextProposal[] textProposalArray = proposals;
            int n = proposals.length;
            int n2 = 0;
            while (n2 < n) {
                TextProposal textProposal = textProposalArray[n2];
                int replacementLength = prefix.getLength();
                String displayString = String.valueOf(prefix.getText().substring(0, replacementLength)) + textProposal.getReplacementString();
                int cursorPosition = textProposal.getReplacementString().length();
                if (!prefix.isELClosed()) {
                    textProposal.setReplacementString(String.valueOf(textProposal.getReplacementString()) + "}");
                }
                textProposal.getImage();
                ContentProposal proposal = new ContentProposal(textProposal.getReplacementString(), cursorPosition, displayString, displayString);
                result.add(proposal);
                ++n2;
            }
        }
        if (prefix.isELStarted() && !prefix.isELClosed()) {
            ContentProposal proposal = new ContentProposal("}", 0, "}", JstUIMessages.JSPDialogContentProposalProvider_CloseELExpression);
            result.add(proposal);
        }
        return this.toSortedUniqueArray(result);
    }

    public IContentProposal[] makeUnique(IContentProposal[] proposals) {
        HashSet<String> present = new HashSet<String>();
        HashSet<String> info = new HashSet<String>();
        ArrayList<IContentProposal> unique = new ArrayList<IContentProposal>();
        int i = 0;
        while (proposals != null && i < proposals.length) {
            block7: {
                block8: {
                    String infoUnquoted = proposals[i].getContent();
                    if (infoUnquoted != null) {
                        if (infoUnquoted.startsWith("\"")) {
                            infoUnquoted = infoUnquoted.substring(1);
                        }
                        if (infoUnquoted.endsWith("\"")) {
                            infoUnquoted = infoUnquoted.substring(0, infoUnquoted.length() - 1);
                        }
                        infoUnquoted = infoUnquoted.trim();
                    }
                    if (present.contains(proposals[i].getLabel())) break block7;
                    present.add(proposals[i].getLabel());
                    if (infoUnquoted == null || infoUnquoted.length() <= 0) break block8;
                    if (info.contains(infoUnquoted)) break block7;
                    info.add(infoUnquoted);
                }
                unique.add(proposals[i]);
            }
            ++i;
        }
        present.clear();
        return unique.toArray(new IContentProposal[unique.size()]);
    }

    IContentProposal[] toSortedUniqueArray(List<IContentProposal> result) {
        Object[] resultArray = result.toArray(new IContentProposal[0]);
        if (resultArray.length < 2) {
            return resultArray;
        }
        Object[] sorted = this.createSorter().sort(resultArray);
        System.arraycopy(sorted, 0, resultArray, 0, sorted.length);
        resultArray = this.makeUnique((IContentProposal[])resultArray);
        return resultArray;
    }

    protected Sorter createSorter() {
        return new Sorter(){

            public boolean compare(Object proposal1, Object proposal2) {
                int pr1 = Integer.MIN_VALUE;
                int pr2 = Integer.MIN_VALUE;
                IContentProposal p1 = (IContentProposal)proposal1;
                IContentProposal p2 = (IContentProposal)proposal2;
                if (pr1 == pr2) {
                    String str2;
                    String str1 = p1.getLabel() == null ? "" : p1.getLabel();
                    String string = str2 = p2.getLabel() == null ? "" : p2.getLabel();
                    return str2.compareTo(str1) > 0;
                }
                return pr1 > pr2;
            }
        };
    }

    protected AbstractXMLContentAssistProcessor.TextRegion getELPrefix(String text, int pos) {
        int inValueOffset = pos;
        if (text.length() < inValueOffset) {
            return null;
        }
        if (inValueOffset < 0) {
            return null;
        }
        text.substring(0, inValueOffset);
        ELParser p = ELParserUtil.getJbossFactory().createParser();
        ELModel model = p.parse(text);
        ELInstance is = ELUtil.findInstance((ELModel)model, (int)inValueOffset);
        ELInvocationExpression ie = ELUtil.findExpression((ELModel)model, (int)inValueOffset);
        boolean isELStarted = model != null && is != null && (model.toString().startsWith("#{") || model.toString().startsWith("${"));
        boolean isELClosed = model != null && is != null && model.toString().endsWith("}");
        AbstractXMLContentAssistProcessor.TextRegion tr = new AbstractXMLContentAssistProcessor.TextRegion(0, ie == null ? inValueOffset : ie.getStartPosition(), ie == null ? 0 : inValueOffset - ie.getStartPosition(), ie == null ? "" : ie.getText(), isELStarted, isELClosed);
        return tr;
    }

    protected ELResolver[] getELResolvers(IResource resource) {
        ELResolverFactoryManager elrfm = ELResolverFactoryManager.getInstance();
        return elrfm.getResolvers(resource);
    }

    protected KbQuery createKbQuery(KbQuery.Type type, String query, String text, int pos, boolean addAttr) {
        KbQuery kbQuery = new KbQuery();
        String[] parentTags = this.processor.getParentTags(false);
        parentTags = this.add(parentTags, this.nodeName);
        if (addAttr) {
            parentTags = this.add(parentTags, this.attributeName);
        }
        kbQuery.setPrefix(this.getPrefix());
        kbQuery.setUri(this.processor.getUri(this.getPrefix()));
        kbQuery.setParentTags(parentTags);
        kbQuery.setParent(this.attributeName);
        kbQuery.setMask(true);
        kbQuery.setType(type);
        kbQuery.setOffset(this.offset);
        kbQuery.setValue(query);
        kbQuery.setStringQuery(query);
        return kbQuery;
    }

    private String getPrefix() {
        if (this.nodeName == null) {
            return null;
        }
        int i = this.nodeName.indexOf(58);
        return i < 0 ? null : this.nodeName.substring(0, i);
    }

    protected String[] getParentTags(JspContentAssistProcessor processor) {
        String[] result = processor.getParentTags(true);
        String[] result1 = this.add(result, this.attributeName);
        return result1;
    }

    private String[] add(String[] result, String v) {
        String[] result1 = new String[result.length + 1];
        System.arraycopy(result, 0, result1, 0, result.length);
        result1[result.length] = v;
        return result1;
    }

    class ContentProposal
    implements IContentProposal {
        String content;
        int pos;
        String description = "";
        String label;

        public ContentProposal(String content, int pos, String label, String description) {
            this.content = content;
            this.pos = pos;
            this.label = label;
            this.description = description;
        }

        public String getContent() {
            return this.content;
        }

        public int getCursorPosition() {
            return this.pos;
        }

        public String getDescription() {
            return this.description;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

