/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.jsp.jspeditor;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.jboss.tools.jst.jsp.jspeditor.JSPMultiPageEditorPart;

public class JSPMultiPageSelectionProvider
implements IPostSelectionProvider,
ISelectionProvider {
    private ListenerList listeners = new ListenerList();
    private JSPMultiPageEditorPart multiPageEditor;
    Object last = null;
    private ListenerList postListeners = new ListenerList();
    boolean isFiringSelection = false;

    public JSPMultiPageSelectionProvider(JSPMultiPageEditorPart multiPageEditor) {
        Assert.isNotNull((Object)((Object)multiPageEditor));
        this.multiPageEditor = multiPageEditor;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add((Object)listener);
        this.last = listener;
    }

    public void fireSelectionChanged(final SelectionChangedEvent event) {
        Object[] listeners = this.listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }

    public JSPMultiPageEditorPart getMultiPageEditor() {
        return this.multiPageEditor;
    }

    public ISelection getSelection() {
        ISelectionProvider selectionProvider;
        IEditorPart activeEditor = this.multiPageEditor.getActiveEditor();
        if (activeEditor != null && (selectionProvider = activeEditor.getSite().getSelectionProvider()) != null) {
            return selectionProvider.getSelection();
        }
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        if (!this.isAppropriateSelected(selection)) {
            return;
        }
        if (this.isFiringSelection) {
            return;
        }
        this.isFiringSelection = true;
        try {
            ISelectionProvider selectionProvider;
            IEditorPart activeEditor = this.multiPageEditor.getActiveEditor();
            if (activeEditor != null && (selectionProvider = activeEditor.getSite().getSelectionProvider()) != null) {
                selectionProvider.setSelection(selection);
            }
        }
        finally {
            this.isFiringSelection = false;
        }
    }

    private boolean isAppropriateSelected(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return true;
        }
        if (selection.isEmpty()) {
            return true;
        }
        Object o = ((IStructuredSelection)selection).getFirstElement();
        return o instanceof IndexedRegion;
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postListeners.add((Object)listener);
        if (this.last != null) {
            this.listeners.remove(this.last);
            this.last = null;
        }
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postListeners.remove((Object)listener);
    }

    public boolean isFiringSelection() {
        return this.isFiringSelection;
    }

    public void firePostSelectionChanged(SelectionChangedEvent event) {
        this.fireSelectionChanged(event, this.postListeners);
    }

    public void fireSelectionChanged(final SelectionChangedEvent event, ListenerList listenerList) {
        if (this.isFiringSelection) {
            return;
        }
        Object[] listeners = listenerList.getListeners();
        this.isFiringSelection = true;
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
        this.isFiringSelection = false;
    }
}

