/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.jsp.jspeditor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.jboss.tools.common.core.resources.XModelObjectEditorInput;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.editor.IModelObjectEditorInput;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.jsp.jspeditor.JSPMultiPageEditor;

class ResourceChangeListener
implements IResourceChangeListener {
    IEditorPart editorPart;
    Composite container;

    ResourceChangeListener(IEditorPart editorPart, Composite container) {
        this.editorPart = editorPart;
        this.container = container;
        IWorkspace workspace = ModelUIPlugin.getWorkspace();
        if (workspace == null) {
            return;
        }
        workspace.addResourceChangeListener((IResourceChangeListener)this);
        container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IWorkspace workspace = ModelUIPlugin.getWorkspace();
                if (workspace == null) {
                    return;
                }
                workspace.removeResourceChangeListener((IResourceChangeListener)ResourceChangeListener.this);
            }
        });
    }

    public void resourceChanged(IResourceChangeEvent event) {
        XModelObject p;
        IEditorInput ei = this.editorPart.getEditorInput();
        if (!(ei instanceof IFileEditorInput)) {
            return;
        }
        IFileEditorInput fi = (IFileEditorInput)ei;
        IFile f = fi.getFile();
        if (f == null) {
            return;
        }
        IPath path = this.getPathChange(event, f);
        if (path == null) {
            if (f != null && !f.exists()) {
                this.closeEditor();
            }
            return;
        }
        f = ModelPlugin.getWorkspace().getRoot().getFile(path);
        XModelObject xModelObject = p = f == null ? null : EclipseResourceUtil.getObjectByResource((IResource)f.getParent());
        if (p instanceof FolderImpl) {
            ((FolderImpl)p).update();
        }
        XModelObject o = EclipseResourceUtil.getObjectByResource((IResource)f);
        if (f != null && f.exists() && o != null && this.editorPart instanceof JSPMultiPageEditor) {
            final JSPMultiPageEditor e = (JSPMultiPageEditor)this.editorPart;
            if (ei instanceof XModelObjectEditorInput) {
                IModelObjectEditorInput e2 = XModelObjectEditorInput.createInstance((XModelObject)o);
                Display.getDefault().asyncExec(new Runnable((IEditorInput)e2, ei){
                    private final /* synthetic */ IEditorInput val$e2;
                    private final /* synthetic */ IEditorInput val$ei;
                    {
                        this.val$e2 = iEditorInput;
                        this.val$ei = iEditorInput2;
                    }

                    public void run() {
                        e.setInput0(this.val$e2);
                        e.updateTitle();
                        if (e.getJspEditor() instanceof AbstractTextEditor) {
                            if (e.getJspEditor() != null && e.getJspEditor().getEditorInput() != e.getEditorInput()) {
                                e.getJspEditor().setInput(this.val$e2);
                            }
                            ((XModelObjectEditorInput)this.val$ei).synchronize();
                        }
                    }
                });
            }
        }
        if (f == null || f.exists()) {
            return;
        }
        this.closeEditor();
    }

    private void closeEditor() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ResourceChangeListener.this.editorPart.getSite().getPage().closeEditor(ResourceChangeListener.this.editorPart, false);
            }
        });
    }

    private IPath getPathChange(IResourceChangeEvent event, IFile f) {
        return this.getPathChange(event.getDelta(), f.getFullPath());
    }

    private IPath getPathChange(IResourceDelta delta, IPath p) {
        if (delta == null || delta.getFullPath() == null) {
            return null;
        }
        if (!delta.getFullPath().isPrefixOf(p)) {
            return null;
        }
        if (delta != null && delta.getKind() == 4) {
            IResourceDelta[] ds = delta.getAffectedChildren();
            if (ds == null) {
                return null;
            }
            if (ds.length > 1) {
                IPath removed = null;
                IPath added = null;
                int i = 0;
                while (i < ds.length) {
                    IPath d = ds[i].getFullPath();
                    if (ds[i].getKind() == 2 && (d.equals((Object)p) || d.isPrefixOf(p))) {
                        removed = d;
                    } else if (ds[i].getKind() == 1) {
                        added = d;
                    }
                    ++i;
                }
                if (removed != null && added != null) {
                    IPath d = removed;
                    if (d.equals((Object)p)) {
                        return added;
                    }
                    if (d.isPrefixOf(p)) {
                        return added.append(p.removeFirstSegments(d.segmentCount()));
                    }
                }
            }
            int i = 0;
            while (i < ds.length) {
                IPath ps = this.getPathChange(ds[i], p);
                if (ps != null) {
                    return ps;
                }
                ++i;
            }
        }
        return null;
    }
}

