/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.jsp.jspeditor.info;

import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.taginfo.XMLTagInfoHoverProcessor;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.text.TextProposal;
import org.jboss.tools.jst.jsp.contentassist.Utils;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.jboss.tools.jst.web.kb.PageProcessor;
import org.jboss.tools.jst.web.kb.taglib.INameSpace;
import org.w3c.dom.Node;

public class FaceletTagInfoHoverProcessor
extends XMLTagInfoHoverProcessor {
    private ELContext fContext;
    private int fDocumentPosition;

    protected String computeHoverHelp(ITextViewer textViewer, int documentPosition) {
        this.fDocumentPosition = documentPosition;
        this.fContext = null;
        IFile file = this.getResource(textViewer.getDocument());
        if (file == null) {
            return null;
        }
        this.fContext = PageContextFactory.createPageContext((IFile)file);
        if (this.fContext == null) {
            return null;
        }
        return super.computeHoverHelp(textViewer, documentPosition);
    }

    protected String computeTagAttNameHelp(IDOMNode xmlnode, IDOMNode parentNode, IStructuredDocumentRegion flatNode, ITextRegion region) {
        if (this.fContext == null) {
            return null;
        }
        String tagName = Utils.getTagName((Node)xmlnode, true);
        String query = flatNode.getText(region);
        String prefix = this.getPrefix(tagName);
        String uri = this.getUri(prefix);
        String[] parentTags = Utils.getParentTags(xmlnode, true, true);
        String parent = Utils.getParent(xmlnode, true, true, true);
        KbQuery kbQuery = Utils.createKbQuery(KbQuery.Type.ATTRIBUTE_NAME, this.fDocumentPosition, query, query, prefix, uri, parentTags, parent, false);
        TextProposal[] proposals = PageProcessor.getInstance().getProposals(kbQuery, this.fContext);
        if (proposals == null) {
            return null;
        }
        TextProposal[] textProposalArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            TextProposal proposal = textProposalArray[n2];
            if (proposal != null && proposal.getContextInfo() != null && proposal.getContextInfo().trim().length() > 0) {
                return proposal.getContextInfo();
            }
            ++n2;
        }
        return null;
    }

    protected String computeTagAttValueHelp(IDOMNode xmlnode, IDOMNode parentNode, IStructuredDocumentRegion flatNode, ITextRegion region) {
        return null;
    }

    protected String computeTagNameHelp(IDOMNode xmlnode, IDOMNode parentNode, IStructuredDocumentRegion flatNode, ITextRegion region) {
        if (this.fContext == null) {
            return null;
        }
        String query = Utils.getTagName((Node)xmlnode, true);
        String prefix = this.getPrefix(query);
        String uri = this.getUri(prefix);
        String[] parentTags = Utils.getParentTags(xmlnode, false, true);
        String parent = Utils.getParent(xmlnode, false, false, true);
        KbQuery kbQuery = Utils.createKbQuery(KbQuery.Type.TAG_NAME, this.fDocumentPosition, query, "<" + query, prefix, uri, parentTags, parent, false);
        TextProposal[] proposals = PageProcessor.getInstance().getProposals(kbQuery, this.fContext);
        if (proposals == null) {
            return null;
        }
        TextProposal[] textProposalArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            TextProposal proposal = textProposalArray[n2];
            if (proposal != null && proposal.getContextInfo() != null && proposal.getContextInfo().trim().length() > 0) {
                return proposal.getContextInfo();
            }
            ++n2;
        }
        return null;
    }

    protected IFile getResource(IDocument document) {
        IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
        try {
            if (sModel != null) {
                String baseLocation = sModel.getBaseLocation();
                IPath location = new Path(baseLocation).makeAbsolute();
                IFile iFile = FileBuffers.getWorkspaceFileAtLocation((IPath)location);
                return iFile;
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
        return null;
    }

    private String getPrefix(String tagname) {
        int index;
        String prefix = null;
        int n = index = tagname == null ? -1 : tagname.indexOf(58);
        if (tagname != null && index != -1) {
            prefix = tagname.substring(0, index);
        }
        if (prefix != null) {
            return prefix;
        }
        String uri = this.getUri("");
        return uri == null ? null : "";
    }

    private String getUri(String prefix) {
        if (prefix == null || this.fContext == null) {
            return null;
        }
        if (!(this.fContext instanceof IPageContext)) {
            return null;
        }
        Map nameSpaces = ((IPageContext)this.fContext).getNameSpaces(this.fDocumentPosition);
        if (nameSpaces == null || nameSpaces.isEmpty()) {
            return null;
        }
        for (List nameSpace : nameSpaces.values()) {
            for (INameSpace n : nameSpace) {
                if (!prefix.equals(n.getPrefix())) continue;
                return n.getURI();
            }
        }
        return null;
    }
}

