/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.jsp.outline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.ui.views.properties.IPropertySourceExtension;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.properties.EnumeratedStringPropertyDescriptor;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.jst.jsp.JspEditorPlugin;
import org.jboss.tools.jst.jsp.contentassist.FaceletPageContectAssistProcessor;
import org.jboss.tools.jst.jsp.contentassist.JspContentAssistProcessor;
import org.jboss.tools.jst.jsp.editor.IVisualController;
import org.jboss.tools.jst.jsp.jspeditor.JSPMultiPageEditor;
import org.jboss.tools.jst.jsp.outline.AttributeSorter;
import org.jboss.tools.jst.jsp.outline.JSPPropertyDescriptor;
import org.jboss.tools.jst.jsp.outline.ValueHelper;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.PageProcessor;
import org.jboss.tools.jst.web.kb.taglib.IAttribute;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSPPropertySourceAdapter
implements INodeAdapter,
IPropertySource,
IPropertySourceExtension,
IPropertySource2 {
    protected static final String CATEGORY_ATTRIBUTES = XMLUIMessages.XMLPropertySourceAdapter_0;
    private static final boolean SET_EXPERT_FILTER = false;
    QueryFactory queryFactory = new QueryFactory();
    private AttributeSorter sorter = null;
    private Node fNode = null;
    private boolean fCaseSensitive = true;
    private IPropertyDescriptor[] fDescriptors = null;
    private ValueHelper valueHelper = new ValueHelper();
    IPageContext pageContext;
    JspContentAssistProcessor processor;
    int offset = 0;
    KbQuery kbQuery;
    KbQuery kbQueryAttr;
    private Set attributeNames = new HashSet();
    private Stack<Object> fValuesBeingSet = new Stack();

    public JSPPropertySourceAdapter(INodeNotifier target) {
        this.setTarget(target);
    }

    Map getWeights() {
        return this.sorter == null ? new HashMap() : this.sorter.weights;
    }

    public void setTarget(INodeNotifier target) {
        if (this.fNode == target) {
            return;
        }
        Node node = this.fNode = target instanceof Node ? (Node)target : null;
        if (this.fNode instanceof IDOMNode) {
            DocumentTypeAdapter adapter;
            Document ownerDocument = this.fNode.getOwnerDocument();
            if (ownerDocument == null && this.fNode instanceof Document) {
                ownerDocument = (Document)this.fNode;
            }
            DocumentTypeAdapter documentTypeAdapter = adapter = ownerDocument == null ? null : (DocumentTypeAdapter)((INodeNotifier)ownerDocument).getAdapterFor(DocumentTypeAdapter.class);
            if (adapter != null) {
                this.fCaseSensitive = adapter.getTagNameCase() == 0;
            }
            this.offset = ((IDOMNode)this.fNode).getStartOffset() + this.fNode.getNodeName().length();
        }
        this.processor = this.valueHelper.isFacetets() ? new FaceletPageContectAssistProcessor() : new JspContentAssistProcessor();
        this.processor.createContext(this.getTextViewer(), this.offset);
        this.pageContext = this.processor.getContext();
        this.kbQuery = this.createKbQuery(this.processor);
        this.kbQuery.setMask(true);
        this.kbQueryAttr = this.createKbQuery(this.processor);
    }

    protected ITextViewer getTextViewer() {
        IEditorPart editor = ModelUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor == null) {
            return null;
        }
        if (editor instanceof JSPMultiPageEditor) {
            JSPMultiPageEditor jsp = (JSPMultiPageEditor)editor;
            return jsp.getSourceEditor().getTextViewer();
        }
        return null;
    }

    public void setSorter(AttributeSorter sorter) {
        this.sorter = sorter;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.fNode == null) {
            if (this.fDescriptors == null || this.fDescriptors.length > 0) {
                this.fDescriptors = new IPropertyDescriptor[0];
            }
        } else if (this.fDescriptors == null || this.fDescriptors.length == 0) {
            this.attributeNamesChanged();
            this.fDescriptors = this.createPropertyDescriptors();
        } else if (this.attributeNamesChanged()) {
            this.updatePropertyDescriptors();
        }
        return this.fDescriptors;
    }

    private KbQuery getQuery(String attributeName) {
        this.kbQueryAttr.setValue(attributeName);
        this.kbQueryAttr.setStringQuery(attributeName);
        return this.kbQueryAttr;
    }

    private IPropertyDescriptor[] createPropertyDescriptors() {
        CMAttributeDeclaration attrDecl;
        if (this.sorter != null) {
            this.sorter.clear();
        }
        CMNamedNodeMap attrMap = null;
        CMElementDeclaration ed = this.getDeclaration();
        if (ed != null) {
            attrMap = ed.getAttributes();
        }
        ArrayList<IPropertyDescriptor> descriptorList = new ArrayList<IPropertyDescriptor>();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> namesLow = new ArrayList<String>();
        IPropertyDescriptor descriptor = null;
        Map<String, IAttribute> as = this.getAttributes();
        for (IAttribute d : as.values()) {
            descriptor = null;
            String attrName = d.getName();
            if (!this.fCaseSensitive ? namesLow.contains(attrName.toLowerCase()) : names.contains(attrName)) continue;
            if (attrName.indexOf(42) >= 0 || (descriptor = this.createJSPPropertyDescriptor(d, attrName, false)) == null) continue;
            names.add(attrName);
            namesLow.add(attrName.toLowerCase());
            descriptorList.add(descriptor);
        }
        NamedNodeMap attributes = this.fNode.getAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                attrDecl = null;
                Attr attr = (Attr)attributes.item(i);
                String attrName = attr.getName();
                if (!(names.contains(attrName) || !this.fCaseSensitive && namesLow.contains(attrName.toLowerCase()))) {
                    if (attrMap != null) {
                        if (this.fCaseSensitive) {
                            attrDecl = (CMAttributeDeclaration)attrMap.getNamedItem(attrName);
                        } else {
                            int j = 0;
                            while (j < attrMap.getLength()) {
                                if (!this.fCaseSensitive && attrMap.item(j).getNodeName().equalsIgnoreCase(attrName)) {
                                    attrDecl = (CMAttributeDeclaration)attrMap.item(j);
                                    break;
                                }
                                ++j;
                            }
                        }
                    }
                    if (attrDecl != null) {
                        IAttribute a;
                        descriptor = this.createPropertyDescriptor(attrDecl);
                        if (descriptor instanceof TextPropertyDescriptor && (a = as.get(attrName)) != null) {
                            descriptor = this.createJSPPropertyDescriptor(a, attr.getName(), false);
                        }
                        if (descriptor != null) {
                            names.add(attrDecl.getNodeName());
                            namesLow.add(attrDecl.getNodeName().toLowerCase());
                        }
                    } else {
                        IAttribute a;
                        String an = attrName;
                        if (an.startsWith("xmlns:")) {
                            an = "xmlns:*";
                        }
                        if ((descriptor = (a = as.get(an)) != null ? this.createJSPPropertyDescriptor(a, attr.getName(), false) : this.createDefaultPropertyDescriptor(attr.getName(), false)) != null) {
                            names.add(attr.getName());
                        }
                        namesLow.add(attr.getName().toLowerCase());
                    }
                    if (descriptor != null) {
                        descriptorList.add(descriptor);
                    }
                }
                ++i;
            }
        }
        if (attrMap != null) {
            int i = 0;
            while (i < attrMap.getLength()) {
                attrDecl = null;
                attrDecl = (CMAttributeDeclaration)attrMap.item(i);
                if (!(names.contains(attrDecl.getAttrName()) || !this.fCaseSensitive && namesLow.contains(attrDecl.getAttrName().toLowerCase()))) {
                    IAttribute a;
                    IPropertyDescriptor holdDescriptor = this.createPropertyDescriptor(attrDecl);
                    if (holdDescriptor instanceof TextPropertyDescriptor && (a = as.get(attrDecl.getAttrName())) != null) {
                        holdDescriptor = this.createJSPPropertyDescriptor(a, attrDecl.getAttrName(), false);
                    }
                    if (holdDescriptor != null) {
                        descriptorList.add(holdDescriptor);
                    }
                }
                ++i;
            }
        }
        IPropertyDescriptor[] descriptors = new IPropertyDescriptor[descriptorList.size()];
        int i = 0;
        while (i < descriptors.length) {
            descriptors[i] = (IPropertyDescriptor)descriptorList.get(i);
            ++i;
        }
        return descriptors;
    }

    protected KbQuery createKbQuery(JspContentAssistProcessor processor) {
        KbQuery kbQuery = new KbQuery();
        String[] parentTags = processor.getParentTags(false);
        parentTags = this.add(parentTags, this.fNode.getNodeName());
        kbQuery.setPrefix(this.getPrefix());
        kbQuery.setUri(processor.getUri(this.getPrefix()));
        kbQuery.setParentTags(parentTags);
        kbQuery.setParent(this.fNode.getNodeName());
        kbQuery.setMask(false);
        kbQuery.setType(KbQuery.Type.ATTRIBUTE_NAME);
        kbQuery.setOffset(this.offset);
        kbQuery.setValue("");
        kbQuery.setStringQuery("");
        return kbQuery;
    }

    private String[] add(String[] result, String v) {
        String[] result1 = new String[result.length + 1];
        System.arraycopy(result, 0, result1, 0, result.length);
        result1[result.length] = v;
        return result1;
    }

    private String getPrefix() {
        int i = this.fNode.getNodeName().indexOf(58);
        return i < 0 ? null : this.fNode.getNodeName().substring(0, i);
    }

    private String getCategory(CMAttributeDeclaration attrDecl) {
        if (attrDecl != null && attrDecl.supports("category")) {
            return (String)attrDecl.getProperty("category");
        }
        return CATEGORY_ATTRIBUTES;
    }

    private CMElementDeclaration getDeclaration() {
        ModelQuery modelQuery;
        if (this.fNode == null || this.fNode.getNodeType() != 1) {
            return null;
        }
        Document document = this.fNode.getOwnerDocument();
        ModelQuery modelQuery2 = modelQuery = document == null ? null : ModelQueryUtil.getModelQuery((Document)document);
        if (modelQuery != null) {
            return modelQuery.getCMElementDeclaration((Element)this.fNode);
        }
        return null;
    }

    private IPropertyDescriptor createJSPPropertyDescriptor(IAttribute d, String attributeName, boolean hideOnFilter) {
        if (d != null && this.sorter != null) {
            if (d.isRequired()) {
                this.sorter.setWeight(attributeName, 2);
            } else if (d.isPreferable()) {
                this.sorter.setWeight(attributeName, 1);
            } else {
                this.sorter.setWeight(attributeName, 0);
            }
        }
        Properties context = new Properties();
        context.put("node", this.fNode);
        context.setProperty("nodeName", this.fNode.getNodeName());
        context.setProperty("attributeName", attributeName);
        context.put("valueHelper", this.valueHelper);
        context.put("pageContext", this.pageContext);
        context.put("processor", (Object)this.processor);
        context.put("queryFactory", this.queryFactory);
        JSPPropertyDescriptor descriptor = new JSPPropertyDescriptor(context, attributeName, attributeName);
        descriptor.setCategory(this.getCategory(null));
        descriptor.setDescription(attributeName);
        return descriptor;
    }

    private IPropertyDescriptor createDefaultPropertyDescriptor(String attributeName, boolean hideOnFilter) {
        TextPropertyDescriptor descriptor = new TextPropertyDescriptor((Object)attributeName, attributeName);
        descriptor.setCategory(this.getCategory(null));
        descriptor.setDescription(attributeName);
        return descriptor;
    }

    boolean attributeNamesChanged() {
        HashSet<String> as = new HashSet<String>();
        NamedNodeMap attributes = this.fNode.getAttributes();
        boolean changed = false;
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                Attr attr = (Attr)attributes.item(i);
                String attrName = attr.getName();
                as.add(attrName);
                if (!this.attributeNames.contains(attrName)) {
                    changed = true;
                }
                ++i;
            }
        }
        if (!changed && this.attributeNames.size() != as.size()) {
            changed = true;
        }
        if (changed) {
            this.attributeNames = as;
        }
        return changed;
    }

    protected void updatePropertyDescriptors() {
        IAttribute a;
        int i;
        if (this.fDescriptors == null || this.fDescriptors.length == 0) {
            return;
        }
        Map<String, IAttribute> as = this.getAttributes();
        ArrayList<String> declaredNames = new ArrayList<String>();
        ArrayList<IPropertyDescriptor> descriptors = new ArrayList<IPropertyDescriptor>();
        HashSet<String> descriptorNames = new HashSet<String>();
        HashSet<String> descriptorNamesLow = new HashSet<String>();
        CMElementDeclaration ed = this.getDeclaration();
        CMNamedNodeMap attrMap = null;
        if (ed != null) {
            attrMap = ed.getAttributes();
        }
        if (attrMap != null) {
            CMAttributeDeclaration attrDecl = null;
            i = 0;
            while (i < attrMap.getLength()) {
                attrDecl = (CMAttributeDeclaration)attrMap.item(i);
                String attrName = attrDecl.getAttrName();
                if (!declaredNames.contains(attrName)) {
                    declaredNames.add(attrName);
                }
                int j = 0;
                while (j < this.fDescriptors.length) {
                    boolean sameName;
                    boolean bl = sameName = this.fCaseSensitive && this.fDescriptors[j].getId().equals(attrDecl.getNodeName()) || !this.fCaseSensitive && attrDecl.getNodeName().equals(this.fDescriptors[j].getId().toString());
                    if (sameName) {
                        String[] validValues = this.getValidValues(attrDecl);
                        if (this.fDescriptors[j] instanceof EnumeratedStringPropertyDescriptor) {
                            ((EnumeratedStringPropertyDescriptor)this.fDescriptors[j]).updateValues(validValues);
                        } else if (validValues != null && validValues.length > 0) {
                            this.fDescriptors[j] = this.createPropertyDescriptor(attrDecl);
                            if (this.fDescriptors[j] instanceof TextPropertyDescriptor && (a = as.get(attrName)) != null) {
                                this.fDescriptors[j] = this.createJSPPropertyDescriptor(a, attrDecl.getAttrName(), false);
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            int j = 0;
            while (j < this.fDescriptors.length) {
                if (!(this.fDescriptors[j] instanceof TextPropertyDescriptor)) {
                    this.fDescriptors[j] = this.createDefaultPropertyDescriptor((String)this.fDescriptors[j].getId(), false);
                }
                ++j;
            }
        }
        NamedNodeMap attributes = this.fNode.getAttributes();
        if (attributes != null) {
            i = 0;
            while (i < this.fDescriptors.length) {
                String descriptorName;
                if (this.fDescriptors[i] != null && (declaredNames.contains(descriptorName = this.fDescriptors[i].getId().toString()) || attributes.getNamedItem(descriptorName) != null) && !descriptorNames.contains(descriptorName)) {
                    descriptorNames.add(descriptorName);
                    descriptorNamesLow.add(descriptorName.toLowerCase());
                    descriptors.add(this.fDescriptors[i]);
                }
                ++i;
            }
        }
        if (attrMap != null) {
            CMAttributeDeclaration attrDecl = null;
            int i2 = 0;
            while (i2 < attrMap.getLength()) {
                attrDecl = (CMAttributeDeclaration)attrMap.item(i2);
                String attrName = attrDecl.getAttrName();
                if (this.fCaseSensitive) {
                    if (!descriptorNames.contains(attrName)) {
                        IAttribute a2;
                        IPropertyDescriptor descriptor = this.createPropertyDescriptor(attrDecl);
                        if (descriptor instanceof TextPropertyDescriptor && (a2 = as.get(attrName)) != null) {
                            descriptor = this.createJSPPropertyDescriptor(a2, attrDecl.getAttrName(), false);
                        }
                        if (descriptor != null) {
                            descriptorNames.add(attrName);
                            descriptorNamesLow.add(attrName.toLowerCase());
                            descriptors.add(descriptor);
                        }
                    }
                } else {
                    boolean exists = descriptorNamesLow.contains(attrName.toLowerCase());
                    if (!exists) {
                        descriptorNames.add(attrName);
                        descriptorNamesLow.add(attrName.toLowerCase());
                        IPropertyDescriptor descriptor = this.createPropertyDescriptor(attrDecl);
                        if (descriptor instanceof TextPropertyDescriptor && (a = as.get(attrName)) != null) {
                            descriptor = this.createJSPPropertyDescriptor(a, attrDecl.getAttrName(), false);
                        }
                        if (descriptor != null) {
                            descriptorNames.add(attrName);
                            descriptorNamesLow.add(attrName.toLowerCase());
                            descriptors.add(descriptor);
                        }
                    }
                }
                ++i2;
            }
        }
        int i3 = 0;
        while (i3 < this.fDescriptors.length) {
            String descriptorName;
            if (this.fDescriptors[i3] != null && as.get(descriptorName = this.fDescriptors[i3].getId().toString()) != null && !descriptorNames.contains(descriptorName)) {
                descriptorNames.add(descriptorName);
                descriptorNamesLow.add(descriptorName.toLowerCase());
                descriptors.add(this.fDescriptors[i3]);
            }
            ++i3;
        }
        for (IAttribute d : as.values()) {
            boolean exists;
            String attrName = d.getName();
            if (this.fCaseSensitive ? descriptorNames.contains(attrName) : (exists = descriptorNamesLow.contains(attrName.toLowerCase()))) continue;
            descriptorNames.add(attrName);
            descriptorNamesLow.add(attrName.toLowerCase());
            IPropertyDescriptor descriptor = null;
            descriptor = this.createJSPPropertyDescriptor(d, attrName, false);
            descriptors.add(descriptor);
        }
        if (attributes != null) {
            i = 0;
            while (i < attributes.getLength()) {
                Attr attr = (Attr)attributes.item(i);
                String attrName = attr.getName();
                if (this.fCaseSensitive) {
                    if (!descriptorNames.contains(attrName)) {
                        descriptorNames.add(attrName);
                        descriptorNamesLow.add(attrName.toLowerCase());
                        descriptors.add(this.createDefaultPropertyDescriptor(attrName, false));
                    }
                } else {
                    boolean exists = descriptorNamesLow.contains(attrName.toLowerCase());
                    if (!exists) {
                        descriptorNames.add(attrName);
                        descriptorNamesLow.add(attrName.toLowerCase());
                        descriptors.add(this.createDefaultPropertyDescriptor(attrName, false));
                    }
                }
                ++i;
            }
        }
        IPropertyDescriptor[] newDescriptors = new IPropertyDescriptor[descriptors.size()];
        int i4 = 0;
        while (i4 < newDescriptors.length) {
            newDescriptors[i4] = (IPropertyDescriptor)descriptors.get(i4);
            ++i4;
        }
        this.fDescriptors = newDescriptors;
    }

    public void setPropertyValue(Object nameObject, Object value) {
        if (!this.fValuesBeingSet.isEmpty() && this.fValuesBeingSet.peek() == nameObject) {
            return;
        }
        this.fValuesBeingSet.push(nameObject);
        String name = nameObject.toString();
        String valueString = null;
        if (value != null) {
            valueString = value.toString();
        }
        NamedNodeMap attrMap = this.fNode.getAttributes();
        try {
            if (attrMap != null) {
                Attr attr = (Attr)attrMap.getNamedItem(name);
                if (attr != null) {
                    if (attr.getValue() == null || !attr.getValue().equals(valueString)) {
                        if (valueString == null || valueString.length() == 0 && !this.isRequiredAttribute(attr.getName())) {
                            this.fNode.getAttributes().removeNamedItem(attr.getName());
                        } else if (attr instanceof IDOMNode) {
                            ((IDOMNode)attr).setValueSource(valueString);
                            IVisualController controller = this.valueHelper.getController();
                            if (controller != null) {
                                controller.visualRefresh();
                            }
                        } else {
                            attr.setValue(valueString);
                        }
                    }
                } else if (value != null && this.fNode.getOwnerDocument() != null) {
                    Attr newAttr = this.fNode.getOwnerDocument().createAttribute(name);
                    if (newAttr instanceof IDOMNode) {
                        ((IDOMNode)newAttr).setValueSource(valueString);
                    } else {
                        newAttr.setValue(valueString);
                    }
                    attrMap.setNamedItem(newAttr);
                }
            } else if (this.fNode instanceof Element) {
                ((Element)this.fNode).setAttribute(name, valueString);
            }
        }
        catch (DOMException e) {
            JspEditorPlugin.getPluginLog().logError((Throwable)e);
        }
        this.fValuesBeingSet.pop();
    }

    boolean isRequiredAttribute(String attributeName) {
        Map<String, IAttribute> as = this.getAttributes();
        IAttribute d = as.get(attributeName);
        if (d == null) {
            return false;
        }
        return d.isRequired();
    }

    private Map<String, IAttribute> getAttributes() {
        return PageProcessor.getInstance().getAttributesAsMap(this.kbQuery, this.pageContext);
    }

    public boolean isAdapterForType(Object type) {
        return type == IPropertySource.class;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
    }

    public Object getEditableValue() {
        return null;
    }

    public Object getPropertyValue(Object nameObject) {
        Node attribute;
        String name = nameObject.toString();
        String returnedValue = null;
        NamedNodeMap attrMap = this.fNode.getAttributes();
        if (attrMap != null && (attribute = attrMap.getNamedItem(name)) != null) {
            returnedValue = attribute instanceof IDOMNode ? ((IDOMNode)attribute).getValueSource() : attribute.getNodeValue();
        }
        if (returnedValue == null) {
            returnedValue = "";
        }
        return returnedValue;
    }

    public boolean isPropertySet(Object propertyObject) {
        String property = propertyObject.toString();
        NamedNodeMap attrMap = this.fNode.getAttributes();
        if (attrMap != null) {
            return attrMap.getNamedItem(property) != null;
        }
        return false;
    }

    public void resetPropertyValue(Object propertyObject) {
        String property = propertyObject.toString();
        CMNamedNodeMap attrDecls = null;
        CMElementDeclaration ed = this.getDeclaration();
        if (ed != null) {
            attrDecls = ed.getAttributes();
        }
        NamedNodeMap attrMap = this.fNode.getAttributes();
        if (attrDecls != null) {
            CMDataType helper;
            CMAttributeDeclaration attrDecl = (CMAttributeDeclaration)attrDecls.getNamedItem(property);
            String defValue = null;
            if (attrDecl != null && attrDecl.getAttrType() != null && (helper = attrDecl.getAttrType()).getImpliedValueKind() != 1 && helper.getImpliedValue() != null) {
                defValue = helper.getImpliedValue();
            }
            if (defValue != null && defValue.length() > 0) {
                ((Attr)attrMap.getNamedItem(property)).setValue(defValue);
            } else {
                attrMap.removeNamedItem(property);
            }
        } else {
            attrMap.removeNamedItem(property);
        }
    }

    public boolean isPropertyRemovable(Object id) {
        return true;
    }

    public void removeProperty(Object propertyObject) {
        Node attribute;
        NamedNodeMap attrMap = this.fNode.getAttributes();
        if (attrMap != null && (attribute = attrMap.getNamedItem(propertyObject.toString())) != null) {
            try {
                attrMap.removeNamedItem(propertyObject.toString());
            }
            catch (DOMException e) {
                JspEditorPlugin.getPluginLog().logError((Throwable)e);
            }
        }
    }

    public boolean isPropertyResettable(Object id) {
        CMDataType helper;
        CMAttributeDeclaration attrDecl;
        boolean resettable = false;
        String property = id.toString();
        CMNamedNodeMap attrDecls = null;
        CMElementDeclaration ed = this.getDeclaration();
        if (ed != null) {
            attrDecls = ed.getAttributes();
        }
        if (attrDecls != null && (attrDecl = (CMAttributeDeclaration)attrDecls.getNamedItem(property)) != null && attrDecl.getAttrType() != null && (helper = attrDecl.getAttrType()).getImpliedValueKind() != 1 && helper.getImpliedValue() != null) {
            resettable = true;
        }
        return resettable;
    }

    protected IPropertyDescriptor createPropertyDescriptor(CMAttributeDeclaration attrDecl) {
        IPropertyDescriptor descriptor = null;
        CMDataType attrType = attrDecl.getAttrType();
        descriptor = attrType != null ? (attrType.getEnumeratedValues() != null && attrType.getEnumeratedValues().length > 0 ? this.createEnumeratedPropertyDescriptor(attrDecl, attrType) : ((attrDecl.getUsage() == 3 || attrType.getImpliedValueKind() == 2) && attrType.getImpliedValue() != null ? this.createFixedPropertyDescriptor(attrDecl, attrType) : this.createTextPropertyDescriptor(attrDecl))) : this.createTextPropertyDescriptor(attrDecl);
        return descriptor;
    }

    private IPropertyDescriptor createTextPropertyDescriptor(CMAttributeDeclaration attrDecl) {
        return this.createTextPropertyDescriptor(attrDecl.getAttrName(), this.getCategory(attrDecl), attrDecl.getUsage());
    }

    private IPropertyDescriptor createTextPropertyDescriptor(String name, String category, int usage) {
        TextPropertyDescriptor descriptor = new TextPropertyDescriptor((Object)name, name);
        descriptor.setCategory(category);
        descriptor.setDescription(name);
        return descriptor;
    }

    private IPropertyDescriptor createEnumeratedPropertyDescriptor(CMAttributeDeclaration attrDecl, CMDataType valuesHelper) {
        EnumeratedStringPropertyDescriptor descriptor = new EnumeratedStringPropertyDescriptor((Object)attrDecl.getAttrName(), attrDecl.getAttrName(), this._getValidStrings(attrDecl, valuesHelper));
        descriptor.setCategory(this.getCategory(attrDecl));
        descriptor.setDescription(attrDecl.getAttrName());
        attrDecl.getUsage();
        return descriptor;
    }

    private IPropertyDescriptor createFixedPropertyDescriptor(CMAttributeDeclaration attrDecl, CMDataType helper) {
        EnumeratedStringPropertyDescriptor descriptor = new EnumeratedStringPropertyDescriptor((Object)attrDecl.getNodeName(), attrDecl.getNodeName(), this._getValidFixedStrings(attrDecl, helper));
        descriptor.setCategory(this.getCategory(attrDecl));
        descriptor.setDescription(attrDecl.getAttrName());
        return descriptor;
    }

    private String[] getValidValues(CMAttributeDeclaration attrDecl) {
        if (attrDecl == null) {
            return new String[0];
        }
        String[] validValues = null;
        CMDataType attrType = attrDecl.getAttrType();
        if (attrType != null) {
            validValues = this._getValidStrings(attrDecl, attrType);
        }
        if (validValues == null) {
            validValues = new String[]{};
        }
        return validValues;
    }

    private String[] _getValidStrings(CMAttributeDeclaration attrDecl, CMDataType valuesHelper) {
        String attributeName = attrDecl.getAttrName();
        ArrayList<String> values = new ArrayList<String>(1);
        boolean currentValueKnown = false;
        boolean checkIfCurrentValueIsKnown = this.fNode.getAttributes() != null && this.fNode.getAttributes().getNamedItem(attributeName) != null && this.fNode.getAttributes().getNamedItem(attributeName).getNodeValue() != null;
        String currentValue = null;
        if (checkIfCurrentValueIsKnown) {
            currentValue = this.fNode.getAttributes().getNamedItem(attributeName).getNodeValue();
        }
        if (valuesHelper.getImpliedValueKind() == 2 && valuesHelper.getImpliedValue() != null) {
            currentValueKnown = currentValue != null && valuesHelper.getImpliedValue().equals(currentValue);
            values.add(valuesHelper.getImpliedValue());
        } else {
            String[] valueStrings = null;
            Document document = this.fNode.getOwnerDocument();
            ModelQuery modelQuery = document == null ? null : ModelQueryUtil.getModelQuery((Document)document);
            valueStrings = modelQuery != null && this.fNode.getNodeType() == 1 ? modelQuery.getPossibleDataTypeValues((Element)this.fNode, (CMNode)attrDecl) : attrDecl.getAttrType().getEnumeratedValues();
            if (valueStrings != null) {
                int i = 0;
                while (i < valueStrings.length) {
                    if (checkIfCurrentValueIsKnown && valueStrings[i].equals(currentValue)) {
                        currentValueKnown = true;
                    }
                    values.add(valueStrings[i]);
                    ++i;
                }
            }
        }
        if (valuesHelper.getImpliedValueKind() != 1 && valuesHelper.getImpliedValue() != null && !values.contains(valuesHelper.getImpliedValue())) {
            values.add(valuesHelper.getImpliedValue());
        }
        if (checkIfCurrentValueIsKnown && !currentValueKnown && currentValue != null && currentValue.length() > 0) {
            values.add(currentValue);
        }
        String[] validStrings = new String[values.size()];
        validStrings = values.toArray(validStrings);
        return validStrings;
    }

    private String[] _getValidFixedStrings(CMAttributeDeclaration attrDecl, CMDataType helper) {
        boolean checkIfCurrentValueIsIncluded;
        String attributeName = attrDecl.getAttrName();
        ArrayList<String> values = new ArrayList<String>(1);
        String impliedValue = helper.getImpliedValue();
        if (impliedValue != null) {
            values.add(impliedValue);
        }
        boolean bl = checkIfCurrentValueIsIncluded = this.fNode.getAttributes() != null && this.fNode.getAttributes().getNamedItem(attributeName) != null && this.fNode.getAttributes().getNamedItem(attributeName).getNodeValue() != null;
        if (checkIfCurrentValueIsIncluded) {
            String currentValue = null;
            currentValue = this.fNode.getAttributes().getNamedItem(attributeName).getNodeValue();
            if (!currentValue.equals(impliedValue)) {
                values.add(currentValue);
            }
        }
        String[] validStrings = new String[values.size()];
        validStrings = values.toArray(validStrings);
        return validStrings;
    }

    public static interface IQueryFactory {
        public boolean isAvailable(String var1);
    }

    class QueryFactory
    implements IQueryFactory {
        QueryFactory() {
        }

        public boolean isAvailable(String attributeName) {
            if (attributeName.equals("style") || attributeName.equals("class")) {
                return true;
            }
            KbQuery query = JSPPropertySourceAdapter.this.getQuery(attributeName);
            return JSPPropertySourceAdapter.this.valueHelper.isAvailable(JSPPropertySourceAdapter.this.pageContext, query);
        }
    }
}

