/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.jsp.outline;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.wst.html.core.internal.document.ElementStyleImpl;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.jboss.tools.common.model.ui.objecteditor.ExtendedCellEditorProvider;
import org.jboss.tools.common.model.ui.objecteditor.ExtendedProperties;
import org.jboss.tools.jst.jsp.outline.AttributeSorter;
import org.jboss.tools.jst.jsp.outline.ExtendedCellEditorProviderImpl;
import org.jboss.tools.jst.jsp.outline.JSPPropertySourceAdapter;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class VpeProperties
implements ExtendedProperties {
    Node node;
    ElementStyleImpl element = null;
    JSPPropertySourceAdapter propertySource = null;
    HashMap properties = new HashMap();
    String[] names;

    public VpeProperties(Node node) {
        this.node = node;
        if (node instanceof ElementStyleImpl && node instanceof INodeNotifier) {
            this.element = (ElementStyleImpl)node;
            JSPPropertySourceAdapter adapter = new JSPPropertySourceAdapter((INodeNotifier)node);
            adapter.setSorter(new AttributeSorter());
            this.propertySource = adapter;
            IPropertyDescriptor[] ds = this.propertySource.getPropertyDescriptors();
            this.names = new String[ds.length];
            int i = 0;
            while (i < ds.length) {
                this.names[i] = ds[i].getDisplayName();
                this.properties.put(ds[i].getDisplayName(), ds[i]);
                ++i;
            }
            final Map weights = this.propertySource.getWeights();
            Comparator c = new Comparator(){

                public int compare(Object o1, Object o2) {
                    int w2;
                    String s1 = o1.toString();
                    String s2 = o2.toString();
                    int w1 = this.getWeight(s1);
                    if (w1 != (w2 = this.getWeight(s2))) {
                        return w2 - w1;
                    }
                    return s1.compareTo(s2);
                }

                int getWeight(String s) {
                    Integer in = (Integer)weights.get(s);
                    return in == null ? 0 : in;
                }
            };
            Arrays.sort(this.names, c);
        }
    }

    public String[] getAttributes() {
        if (this.propertySource != null) {
            return this.names;
        }
        NamedNodeMap map = this.node.getAttributes();
        String[] attributes = new String[map.getLength()];
        int i = 0;
        while (i < map.getLength()) {
            attributes[i] = map.item(i).getNodeName();
            ++i;
        }
        return attributes;
    }

    public String getAttributeValue(String name) {
        if (this.propertySource != null) {
            return (String)this.propertySource.getPropertyValue(name);
        }
        NamedNodeMap map = this.node.getAttributes();
        return map.getNamedItem(name).getNodeValue();
    }

    public void setAttributeValue(String name, String value) {
        if (this.propertySource != null) {
            this.propertySource.setPropertyValue(name, value);
        }
    }

    public boolean isEditableAttribute(String name) {
        return true;
    }

    public String getNodeName() {
        return this.node == null ? "" : this.node.getNodeName();
    }

    public Node getNode() {
        return this.node;
    }

    public ExtendedCellEditorProvider createCellEditorProvider() {
        return new ExtendedCellEditorProviderImpl();
    }
}

