/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.jsp.outline.cssdialog.common;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import org.eclipse.jface.dialogs.IInputValidator;
import org.jboss.tools.jst.jsp.messages.JstUIMessages;
import org.jboss.tools.jst.jsp.outline.cssdialog.common.CSSValidator;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleRule;

public class CSSSelectorValidator
extends CSSValidator
implements IInputValidator {
    private static Reference<CSSSelectorValidator> instanceCache;

    public static CSSSelectorValidator getInstance() {
        CSSSelectorValidator instance = null;
        if (instanceCache != null) {
            instance = instanceCache.get();
        }
        if (instance == null) {
            instance = new CSSSelectorValidator();
            instanceCache = new SoftReference<CSSSelectorValidator>(instance);
        }
        return instance;
    }

    private CSSSelectorValidator() {
    }

    public boolean isValidSelector(String selector) {
        this.getValidatingDocument().set(String.valueOf(selector) + "{}");
        CSSRuleList cssRules = this.getValidatingCSS().getCssRules();
        if (cssRules.getLength() != 1) {
            return false;
        }
        CSSStyleRule cssRule = (CSSStyleRule)cssRules.item(0);
        if (!selector.equals(cssRule.getSelectorText())) {
            return false;
        }
        this.cleanValidatingDocument();
        return true;
    }

    public String isValid(String value) {
        return this.isValidSelector(value) ? null : JstUIMessages.CSS_CLASS_NAME_NOT_VALID;
    }
}

