/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.jsp.outline.cssdialog.widgets;

import java.util.Arrays;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;
import org.jboss.tools.jst.jsp.messages.JstUIMessages;
import org.jboss.tools.jst.jsp.outline.cssdialog.common.Constants;
import org.jboss.tools.jst.jsp.outline.cssdialog.widgets.CSSWidget;

public final class ImageCombo
extends Composite
implements CSSWidget {
    private static final boolean gtk = "gtk".equals(SWT.getPlatform());
    private static final int X = 0;
    private static final int Y = 0;
    private static final int WIDTH = 20;
    private static final int HEIGHT = 15;
    private static final int DEPTH = 1;
    private static final int DEFAULT_SELECTION = -1;
    private boolean dontDrop;
    private int visibleItemCount;
    private Text text;
    private Table table;
    private Shell popup;
    private Button arrowButton;
    private boolean hasFocus;
    private Listener listener;
    private Listener filter;

    public ImageCombo(Composite parent, int style) {
        style = ImageCombo.checkStyle(style);
        super(parent, style);
        this.dontDrop = false;
        this.visibleItemCount = 10;
        int textStyle = 4;
        if (gtk) {
            textStyle |= 0x800;
        }
        if ((style & 8) != 0) {
            textStyle |= 8;
        }
        if ((style & 0x800000) != 0) {
            textStyle |= 0x800000;
        }
        this.text = new Text((Composite)this, textStyle);
        int arrowStyle = 1028;
        if ((style & 0x800000) != 0) {
            arrowStyle |= 0x800000;
        }
        this.arrowButton = new Button((Composite)this, arrowStyle);
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (ImageCombo.this.popup == event.widget) {
                    ImageCombo.this.popupEvent(event);
                    return;
                }
                if (ImageCombo.this.text == event.widget) {
                    ImageCombo.this.textEvent(event);
                    return;
                }
                if (ImageCombo.this.table == event.widget) {
                    ImageCombo.this.listEvent(event);
                    return;
                }
                if (ImageCombo.this.arrowButton == event.widget) {
                    ImageCombo.this.arrowEvent(event);
                    return;
                }
                if (ImageCombo.this == event.widget) {
                    ImageCombo.this.comboEvent(event);
                    return;
                }
                if (ImageCombo.this.getShell() == event.widget) {
                    ImageCombo.this.handleFocus(16);
                }
            }
        };
        this.filter = new Listener(){

            public void handleEvent(Event event) {
                Shell shell = ((Control)event.widget).getShell();
                if (shell == ImageCombo.this.getShell()) {
                    ImageCombo.this.handleFocus(16);
                }
            }
        };
        int[] comboEvents = new int[]{12, 10, 11};
        int i = 0;
        while (i < comboEvents.length) {
            this.addListener(comboEvents[i], this.listener);
            ++i;
        }
        int[] textEvents = new int[]{1, 2, 24, 3, 4, 31, 15};
        int i2 = 0;
        while (i2 < textEvents.length) {
            this.text.addListener(textEvents[i2], this.listener);
            ++i2;
        }
        int[] arrowEvents = new int[]{13, 15};
        int i3 = 0;
        while (i3 < arrowEvents.length) {
            this.arrowButton.addListener(arrowEvents[i3], this.listener);
            ++i3;
        }
        this.createPopup(-1);
    }

    static int checkStyle(int style) {
        int mask = gtk ? 0x6800008 : 0x6800808;
        return style & mask;
    }

    public void add(String string, Image image) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        TableItem newItem = new TableItem(this.table, 0);
        newItem.setText(string);
        if (image != null) {
            newItem.setImage(image);
        }
        newItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TableItem item = (TableItem)e.getSource();
                item.getImage().dispose();
            }
        });
    }

    public void add(String string, Image image, int index) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        TableItem newItem = new TableItem(this.table, 0, index);
        if (image != null) {
            newItem.setImage(image);
            newItem.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    TableItem item = (TableItem)e.getSource();
                    item.getImage().dispose();
                }
            });
        }
    }

    public void add(String string, RGB rgb) {
        Color white = new Color((Device)this.getDisplay(), Constants.RGB_WHITE);
        Color black = new Color((Device)this.getDisplay(), Constants.RGB_BLACK);
        Color color = new Color((Device)this.getDisplay(), rgb);
        Image image = new Image((Device)this.getDisplay(), 20, 15);
        GC gc = new GC((Drawable)image);
        gc.setBackground(color);
        gc.fillRectangle(0, 0, 20, 15);
        gc.setBackground(black);
        gc.drawRectangle(0, 0, 20, 15);
        gc.dispose();
        ImageData imageData = image.getImageData();
        image.dispose();
        color.dispose();
        PaletteData palette = new PaletteData(new RGB[]{Constants.RGB_BLACK, Constants.RGB_WHITE});
        ImageData maskData = new ImageData(20, 15, 1, palette);
        Image mask = new Image((Device)this.getDisplay(), maskData);
        gc = new GC((Drawable)mask);
        gc.setBackground(black);
        gc.fillRectangle(0, 0, 20, 15);
        gc.setBackground(white);
        gc.fillRectangle(0, 0, 20, 15);
        gc.dispose();
        maskData = mask.getImageData();
        mask.dispose();
        Image icon = new Image((Device)this.getDisplay(), imageData, maskData);
        color.dispose();
        black.dispose();
        white.dispose();
        this.add(string, icon);
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(24, (Listener)typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    void arrowEvent(Event event) {
        switch (event.type) {
            case 15: {
                if (gtk) {
                    this.setFocus();
                    return;
                }
                this.handleFocus(15);
                break;
            }
            case 13: {
                if (gtk) {
                    if (!this.dontDrop) {
                        this.dropDown(!this.isDropped());
                    }
                    this.dontDrop = false;
                    break;
                }
                this.dropDown(!this.isDropped());
            }
        }
    }

    void comboEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.popup != null && !this.popup.isDisposed()) {
                    this.table.removeListener(12, this.listener);
                    this.popup.dispose();
                }
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                this.popup = null;
                this.text = null;
                this.table = null;
                this.arrowButton = null;
                break;
            }
            case 10: {
                this.dropDown(false);
                break;
            }
            case 11: {
                this.internalLayout(false);
            }
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        String[] items = this.getStringsFromTable();
        int textWidth = 0;
        GC gc = new GC((Drawable)this.text);
        int spacer = gc.stringExtent((String)" ").x;
        int i = 0;
        while (i < items.length) {
            textWidth = Math.max(gc.stringExtent((String)items[i]).x, textWidth);
            ++i;
        }
        gc.dispose();
        Point textSize = this.text.computeSize(-1, -1, changed);
        Point arrowSize = this.arrowButton.computeSize(-1, -1, changed);
        Point listSize = this.table.computeSize(wHint, -1, changed);
        int borderWidth = this.getBorderWidth();
        height = Math.max(hHint, Math.max(textSize.y, arrowSize.y) + 2 * borderWidth);
        width = Math.max(wHint, Math.max(textWidth + 2 * spacer + arrowSize.x + 2 * borderWidth, listSize.x));
        return new Point(width, height);
    }

    void createPopup(int selectionIndex) {
        this.popup = new Shell(this.getShell(), 16392);
        int style = this.getStyle();
        int listStyle = 516;
        if ((style & 0x800000) != 0) {
            listStyle |= 0x800000;
        }
        if ((style & 0x4000000) != 0) {
            listStyle |= 0x4000000;
        }
        if ((style & 0x2000000) != 0) {
            listStyle |= 0x2000000;
        }
        this.table = new Table((Composite)this.popup, listStyle);
        this.table.setToolTipText(JstUIMessages.IMAGE_COMBO_TABLE_TOOL_TIP);
        int[] popupEvents = new int[]{21, 9, 27};
        int i = 0;
        while (i < popupEvents.length) {
            this.popup.addListener(popupEvents[i], this.listener);
            ++i;
        }
        int[] listEvents = new int[]{31, 8, 1, 2, 15, 12};
        int i2 = 0;
        while (i2 < listEvents.length) {
            this.table.addListener(listEvents[i2], this.listener);
            ++i2;
        }
        if (selectionIndex != -1) {
            this.table.setSelection(selectionIndex);
        }
    }

    void dropDown(boolean drop) {
        if (drop == this.isDropped()) {
            return;
        }
        if (!drop) {
            this.popup.setVisible(false);
            if (!this.isDisposed() && this.arrowButton.isFocusControl()) {
                this.text.setFocus();
            }
            return;
        }
        if (this.getShell() != this.popup.getParent()) {
            int selectionIndex = this.table.getSelectionIndex();
            this.table.removeListener(12, this.listener);
            this.popup.dispose();
            this.popup = null;
            this.table = null;
            this.createPopup(selectionIndex);
        }
        Point size = this.getSize();
        int itemCount = this.table.getItemCount();
        itemCount = itemCount == 0 ? this.visibleItemCount : Math.min(this.visibleItemCount, itemCount);
        int itemHeight = this.table.getItemHeight() * itemCount;
        Point listSize = this.table.computeSize(-1, itemHeight, false);
        this.table.setBounds(1, 1, Math.max(size.x - 2, listSize.x), listSize.y);
        int index = this.table.getSelectionIndex();
        if (index != -1) {
            this.table.setTopIndex(index);
        }
        Display display = this.getDisplay();
        Rectangle listRect = this.table.getBounds();
        Rectangle parentRect = display.map((Control)this.getParent(), null, this.getBounds());
        Point comboSize = this.getSize();
        Rectangle displayRect = this.getMonitor().getClientArea();
        int width = Math.max(comboSize.x, listRect.width + 2);
        int height = listRect.height + 2;
        int x = parentRect.x;
        int y = parentRect.y + comboSize.y;
        if (y + height > displayRect.y + displayRect.height) {
            y = parentRect.y - height;
        }
        this.popup.setBounds(x, y, width, height);
        this.popup.setVisible(true);
        this.table.setFocus();
    }

    public int getItemCount() {
        this.checkWidget();
        return this.table.getItemCount();
    }

    String[] getStringsFromTable() {
        String[] items = new String[this.table.getItems().length];
        int i = 0;
        int n = items.length;
        while (i < n) {
            items[i] = this.table.getItem(i).getText();
            ++i;
        }
        return items;
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return this.table.getSelectionIndex();
    }

    public int getStyle() {
        int style = super.getStyle();
        style &= 0xFFFFFFF7;
        if (!this.text.getEditable()) {
            style |= 8;
        }
        return style;
    }

    public String getText() {
        this.checkWidget();
        return this.text.getText();
    }

    void handleFocus(int type) {
        if (this.isDisposed()) {
            return;
        }
        switch (type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.hasFocus = true;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                shell.addListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                display.addFilter(15, this.filter);
                Event e = new Event();
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl == this.arrowButton || focusControl == this.table || focusControl == this.text) {
                    return;
                }
                this.hasFocus = false;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                Event e = new Event();
                this.notifyListeners(16, e);
            }
        }
    }

    public int indexOf(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        return Arrays.asList(this.getStringsFromTable()).indexOf(string);
    }

    boolean isDropped() {
        return this.popup.getVisible();
    }

    void internalLayout(boolean changed) {
        if (this.isDropped()) {
            this.dropDown(false);
        }
        Rectangle rect = this.getClientArea();
        int width = rect.width;
        int height = rect.height;
        Point arrowSize = this.arrowButton.computeSize(-1, height, changed);
        this.text.setBounds(0, 0, width - arrowSize.x, height);
        this.arrowButton.setBounds(width - arrowSize.x, 0, arrowSize.x, arrowSize.y);
    }

    void listEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.getShell() == this.popup.getParent()) break;
                int selectionIndex = this.table.getSelectionIndex();
                this.popup = null;
                this.table = null;
                this.createPopup(selectionIndex);
                break;
            }
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 8: {
                int index = this.table.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                this.text.setText(this.table.getItem(index).getText());
                this.table.setSelection(index);
                Event e = new Event();
                e.time = event.time;
                e.stateMask = event.stateMask;
                e.doit = event.doit;
                this.notifyListeners(13, e);
                event.doit = e.doit;
                this.dropDown(false);
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.character = event.character;
                e.keyCode = event.keyCode;
                this.notifyListeners(31, e);
                event.doit = e.doit;
                event.detail = e.detail;
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                break;
            }
            case 1: {
                Event e;
                if (event.character == '\u001b') {
                    this.dropDown(false);
                }
                if ((event.stateMask & 0x10000) != 0 && (event.keyCode == 0x1000001 || event.keyCode == 0x1000002)) {
                    this.dropDown(false);
                }
                if (event.character == '\r') {
                    this.dropDown(false);
                    e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(14, e);
                }
                if (this.isDisposed()) break;
                e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(1, e);
                int index = this.table.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                this.text.setText(this.table.getItem(index).getText());
                this.table.setSelection(index);
            }
        }
    }

    void popupEvent(Event event) {
        switch (event.type) {
            case 9: {
                Rectangle listRect = this.table.getBounds();
                Color black = this.getDisplay().getSystemColor(2);
                event.gc.setForeground(black);
                event.gc.drawRectangle(0, 0, listRect.width + 1, listRect.height + 1);
                break;
            }
            case 21: {
                event.doit = false;
                this.dropDown(false);
                break;
            }
            case 27: {
                if (gtk) {
                    Point loc = this.arrowButton.toControl(this.getDisplay().getCursorLocation());
                    Point size = this.arrowButton.getSize();
                    if (loc.x >= 0 && loc.y >= 0 && loc.x < size.x && loc.y < size.y) {
                        this.dontDrop = true;
                    }
                }
                this.dropDown(false);
            }
        }
    }

    public void redraw() {
        super.redraw();
        this.text.redraw();
        this.arrowButton.redraw();
        if (this.popup.isVisible()) {
            this.table.redraw();
        }
    }

    public void select(int index) {
        this.checkWidget();
        if (index == -1) {
            this.table.deselectAll();
            this.text.setText("");
            return;
        }
        if (index >= 0 && index < this.table.getItemCount() && index != this.getSelectionIndex()) {
            this.text.setText(this.table.getItem(index).getText());
            this.text.selectAll();
            this.table.select(index);
            this.table.showSelection();
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        return this.text.setFocus();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        int index = -1;
        int i = 0;
        int n = this.table.getItemCount();
        while (i < n) {
            if (this.table.getItem(i).getText().equals(string)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            this.table.deselectAll();
            this.text.setText(string);
            return;
        }
        this.text.setText(string);
        this.text.selectAll();
        this.table.setSelection(index);
        this.table.showSelection();
    }

    void textEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 1: {
                Event e;
                if (event.character == '\r') {
                    this.dropDown(false);
                    e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(14, e);
                }
                if (this.isDisposed()) break;
                if (event.keyCode == 0x1000001 || event.keyCode == 0x1000002) {
                    event.doit = false;
                    if ((event.stateMask & 0x10000) != 0) {
                        boolean dropped = this.isDropped();
                        this.text.selectAll();
                        if (!dropped) {
                            this.setFocus();
                        }
                        this.dropDown(!dropped);
                        break;
                    }
                    int oldIndex = this.getSelectionIndex();
                    if (event.keyCode == 0x1000001) {
                        this.select(Math.max(oldIndex - 1, 0));
                    } else {
                        this.select(Math.min(oldIndex + 1, this.getItemCount() - 1));
                    }
                    if (oldIndex != this.getSelectionIndex()) {
                        Event e2 = new Event();
                        e2.time = event.time;
                        e2.stateMask = event.stateMask;
                        this.notifyListeners(13, e2);
                    }
                    if (this.isDisposed()) break;
                }
                e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(1, e);
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                break;
            }
            case 24: {
                this.table.deselectAll();
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(24, e);
                break;
            }
            case 3: {
                if (event.button != 1) {
                    return;
                }
                if (this.text.getEditable()) {
                    return;
                }
                boolean dropped = this.isDropped();
                this.text.selectAll();
                if (!dropped) {
                    this.setFocus();
                }
                this.dropDown(!dropped);
                break;
            }
            case 4: {
                if (event.button != 1) {
                    return;
                }
                if (this.text.getEditable()) {
                    return;
                }
                this.text.selectAll();
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.character = event.character;
                e.keyCode = event.keyCode;
                this.notifyListeners(31, e);
                event.doit = e.doit;
                event.detail = e.detail;
            }
        }
    }
}

