/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.jsp.ui.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.jst.jsp.JspEditorPlugin;
import org.jboss.tools.jst.jsp.jspeditor.JSPMultiPageEditor;
import org.jboss.tools.jst.jsp.jspeditor.JSPTextEditor;
import org.jboss.tools.jst.jsp.messages.JstUIMessages;
import org.jboss.tools.jst.jsp.ui.action.JSPFormatter;

public class FormatJSPActionDelegate
implements IEditorActionDelegate {
    IAction action;
    ITextEditor targetEditor;
    TextSelection textSelection;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.action = action;
        if (targetEditor instanceof JSPMultiPageEditor) {
            targetEditor = ((JSPMultiPageEditor)((Object)targetEditor)).getJspEditor();
        }
        this.targetEditor = (ITextEditor)targetEditor;
        action.setText(JstUIMessages.FormatJSPActionDelegate_Format);
    }

    public void run(IAction action) {
        JSPTextEditor te = (JSPTextEditor)this.targetEditor;
        IDocument document = te.getTextViewer().getDocument();
        try {
            new JSPFormatter().format(document, this.textSelection);
        }
        catch (BadLocationException e) {
            JspEditorPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.textSelection = selection instanceof TextSelection ? (TextSelection)selection : null;
        action.setEnabled(this.textSelection != null && this.textSelection.getLength() > 0);
    }
}

