/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.jsp.ui.action;

import java.util.StringTokenizer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.jboss.tools.jst.jsp.ui.action.Token;

public class JSPFormatter {
    static final int ROOT = 0;
    static final int TEXT = 1;
    static final int TAG = 2;
    static final int TAG_CLOSING = 3;
    static final int JSP = 4;
    static final int COMMENT = 5;
    String text;
    StringBuffer sb = new StringBuffer();
    Token root;
    int selectionStart;
    int selectionEnd;
    int start = -1;
    int end = -1;

    public void format(IDocument document, TextSelection textSelection) throws BadLocationException {
        this.selectionStart = textSelection.getOffset();
        this.selectionEnd = this.selectionStart + textSelection.getLength();
        this.text = document.get();
        this.root = new Token(0, "", 0, this.text.length(), null);
        this.root.indent = "";
        this.root.indentLevel = -1;
        this.tokenize();
        this.doFormat(this.root.firstChild);
        document.replace(this.start, this.end - this.start, this.sb.toString());
    }

    private void tokenize() {
        int cursor = 0;
        Token current = this.root;
        Token last = null;
        while (cursor < this.text.length()) {
            int nc;
            int q;
            int nc2;
            int p = this.text.indexOf(60, cursor);
            if (p < 0) {
                last = this.createTag(1, "", cursor, this.text.length() - cursor, last);
                current.addChild(last);
                cursor = this.text.length();
                continue;
            }
            if (p > cursor) {
                last = this.createTag(1, "", cursor, p - cursor, last);
                current.addChild(last);
                cursor = p;
            }
            if (this.isStringStart(cursor, "<%")) {
                int q2 = this.text.indexOf("%>", cursor);
                nc2 = q2 < 0 ? this.text.length() : q2 + 2;
                last = this.createTag(4, "", cursor, nc2 - cursor, last);
                current.addChild(last);
                cursor = nc2;
                continue;
            }
            if (this.isStringStart(cursor, "<!--")) {
                int q3 = this.text.indexOf("-->", cursor);
                nc2 = q3 < 0 ? this.text.length() : q3 + 3;
                last = this.createTag(5, "", cursor, nc2 - cursor, last);
                current.addChild(last);
                cursor = nc2;
                continue;
            }
            if (this.isStringStart(cursor, "</")) {
                String tag = this.readTag(cursor + 2);
                q = this.text.indexOf(">", cursor);
                nc = q < 0 ? this.text.length() : q + 1;
                last = this.createTag(3, tag, cursor, nc - cursor, last);
                current = this.findParent(current, last);
                current.addChild(last);
                cursor = nc;
                continue;
            }
            String tag = this.readTag(cursor + 1);
            q = this.findTagClosingSymbol(cursor);
            nc = q < 0 ? this.text.length() : q + 1;
            last = this.createTag(2, tag, cursor, nc - cursor, last);
            if (this.isOptionallyClosed(tag)) {
                current = this.findParentForOptionallyClosedTag(current, tag);
            }
            current.addChild(last);
            cursor = nc;
            if (q <= 0 || this.text.charAt(q - 1) == '/' || !this.areChildrenAllowed(tag)) continue;
            current = last;
        }
    }

    private Token findParent(Token current, Token t) {
        Token c = current;
        while (c.kind != 0) {
            if (c.name.equals(t.name)) {
                return c.parent;
            }
            c = c.parent;
        }
        return current;
    }

    private boolean isOptionallyClosed(String name) {
        return ".body.p.dt.dd.li.ol.option.thead.tfoot.tbody.colgroup.tr.td.th.head.html.".indexOf(name.toLowerCase()) >= 0;
    }

    private Token findParentForOptionallyClosedTag(Token current, String name) {
        String n1 = name.toLowerCase();
        String n2 = current.name.toLowerCase();
        if ("p".equals(n1)) {
            if (n2.equals("p")) {
                return current.parent;
            }
        } else if ("tr".equals(n1)) {
            if (n2.equals("tr")) {
                return current.parent;
            }
            if (n2.equals("th") || n2.equals("td") || n2.equals("p")) {
                return this.findParentForOptionallyClosedTag(current.parent, name);
            }
        } else if ("td".equals(n1) || "th".equals(n1)) {
            if (n2.equals("th") || n2.equals("td")) {
                return current.parent;
            }
            if (n2.equals("p")) {
                return this.findParentForOptionallyClosedTag(current.parent, name);
            }
        }
        return current;
    }

    private boolean areChildrenAllowed(String name) {
        return ".br.area.link.img.param.hr.input.col.isindex.base.meta.".indexOf("." + name.toLowerCase() + ".") < 0;
    }

    private Token createTag(int kind, String name, int off, int length, Token previous) {
        Token t = new Token(kind, name, off, length, previous);
        int n = t.indentLength = kind == 1 ? -1 : this.computeIndentLength(off);
        if (previous != null && previous.kind == 1 && t.indentLength > 0) {
            previous.length -= t.indentLength;
            t.off -= t.indentLength;
            t.length += t.indentLength;
        }
        return t;
    }

    private boolean isStringStart(int c, String s) {
        if (this.text.length() <= c + s.length()) {
            return false;
        }
        int i = 0;
        while (i < s.length()) {
            if (this.text.charAt(c + i) != s.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String readTag(int c) {
        int k = c;
        while (k < this.text.length() && this.isNameChar(this.text.charAt(k))) {
            ++k;
        }
        return this.text.substring(c, k);
    }

    private boolean isNameChar(char ch) {
        return Character.isJavaIdentifierPart(ch) || ch == '-' || ch == ':';
    }

    private int computeIndentLength(int off) {
        --off;
        int l = 0;
        while (off >= 0) {
            char ch = this.text.charAt(off);
            if (ch == '\n' || ch == '\r') {
                return l;
            }
            if (!Character.isWhitespace(ch)) {
                return -1;
            }
            ++l;
            --off;
        }
        return off < 0 ? l : -1;
    }

    private void doFormat(Token t) {
        if (t == null) {
            return;
        }
        if (t.off < this.selectionStart || t.off + t.length > this.selectionEnd) {
            if (t.indentLength >= 0) {
                t.indent = this.text.substring(t.off, t.off + t.indentLength);
            }
        } else {
            if (this.start < 0) {
                this.start = t.off;
            }
            this.end = t.off + t.length;
            boolean hasNewLine = t.indentLength >= 0;
            boolean needNewLine = this.needNewLine(t);
            if (needNewLine) {
                this.sb.append("\n");
            }
            String line = t.indentLength > 0 ? this.text.substring(t.off + t.indentLength, t.off + t.length) : this.text.substring(t.off, t.off + t.length);
            String indent = null;
            Token s = t.prevSibling;
            int qq = 0;
            while (s != null && s.indent == null) {
                s = s.prevSibling;
            }
            if (s == null) {
                s = t;
                while (s.indent == null) {
                    s = s.parent;
                    ++qq;
                }
                if (s == this.root) {
                    --qq;
                }
            }
            indent = s.indent;
            int k = 0;
            while (k < qq) {
                indent = String.valueOf(indent) + "  ";
                ++k;
            }
            t.indent = indent;
            this.append(line, indent, hasNewLine || needNewLine);
        }
        this.doFormat(t.firstChild);
        this.doFormat(t.nextSibling);
    }

    private boolean needNewLine(Token t) {
        if (t == null) {
            return false;
        }
        if (t.previous == null && (t.parent == null || t.parent == this.root)) {
            return false;
        }
        if (t.kind == 1) {
            return false;
        }
        if (t.indentLength >= 0) {
            return false;
        }
        if ((t.kind == 2 || t.kind == 3) && this.isInline(t.name)) {
            return false;
        }
        Token p = t.previous;
        if (p == null) {
            return true;
        }
        if (p.kind != 1) {
            return p.kind != 2 && p.kind != 3 || !this.isInline(p.name);
        }
        int q = 0;
        while (q < p.length) {
            char ch = this.text.charAt(q + p.off);
            if (!Character.isWhitespace(ch)) {
                return false;
            }
            ++q;
        }
        return true;
    }

    private boolean isInline(String name) {
        return ".br.a.b.i.u.s.strong.img".indexOf("." + name.toLowerCase() + ".") >= 0;
    }

    private boolean isSpace(String line) {
        int q = 0;
        while (q < line.length()) {
            char ch = line.charAt(q);
            if (!Character.isWhitespace(ch) && ch != '\n' && ch != '\r') {
                return false;
            }
            ++q;
        }
        return true;
    }

    private void append(String line, String indent, boolean indentFirst) {
        StringTokenizer st = new StringTokenizer(line, "\r\n", true);
        boolean first = true;
        boolean doIndent = indentFirst;
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (this.isSpace(t)) {
                this.sb.append(t);
            } else {
                if (doIndent) {
                    this.sb.append(indent);
                    if (!first) {
                        this.sb.append(' ');
                    }
                    t = this.removeLeadingSpaces(t);
                }
                this.sb.append(t);
            }
            first = false;
            doIndent = true;
        }
    }

    private String removeLeadingSpaces(String line) {
        if (line.length() == 0 || !Character.isWhitespace(line.charAt(0))) {
            return line;
        }
        int i = 0;
        while (i < line.length()) {
            char ch = line.charAt(i);
            if (ch == '\r' || ch == '\n') {
                return line;
            }
            if (!Character.isWhitespace(ch)) {
                return line.substring(i);
            }
            ++i;
        }
        return "";
    }

    public int findTagClosingSymbol(int i) {
        int l = this.text.length();
        char quota = '\u0000';
        while (i < l) {
            char ch = this.text.charAt(i);
            if (quota != '\u0000') {
                if (ch == quota) {
                    quota = '\u0000';
                }
            } else if (ch == '\'' || ch == '\"') {
                quota = ch;
            } else if (ch == '>') {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

