/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.handlers;

import java.util.Properties;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.jsf.messages.JSFUIMessages;

public class ChangeContentKindHandler
extends AbstractHandler {
    static String ATT_CONTENT_KIND = "content-kind";
    public static String MESSAGE_KEY = "JSFManagedProperty_ChangeValueKind";

    public static boolean isNewValueKind(XModelObject object, String kind) {
        String objectKind = object.getAttributeValue(ATT_CONTENT_KIND);
        return objectKind != null && kind != null && !objectKind.equals(kind);
    }

    public static boolean checkChangeSignificance(XModelObject object) {
        String kind = object.getAttributeValue(ATT_CONTENT_KIND);
        if ("properties".equals(kind) && object.getChildren().length == 0) {
            return true;
        }
        if ("map-entries".equals(kind) || "list-entries".equals(kind)) {
            XModelObject c = object.getChildByPath("Entries");
            if (c == null) {
                return true;
            }
            if (c.getChildren().length == 0) {
                return true;
            }
        }
        return ChangeContentKindHandler.openConfirmation(object.getModel());
    }

    public static boolean openConfirmation(XModel model) {
        String message = WizardKeys.getMessage((String)MESSAGE_KEY);
        ServiceDialog d = model.getService();
        int q = d.showDialog(JSFUIMessages.CONFIRMATION, message, new String[]{JSFUIMessages.OK, JSFUIMessages.CANCEL}, null, 0);
        return q == 0;
    }

    public boolean isEnabled(XModelObject object) {
        return object != null && object.isObjectEditable() && ChangeContentKindHandler.isNewValueKind(object, this.action.getProperty(ATT_CONTENT_KIND));
    }

    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        if (!this.isEnabled(object)) {
            return;
        }
        if (!ChangeContentKindHandler.checkChangeSignificance(object)) {
            return;
        }
        String targetValueKind = this.action.getProperty(ATT_CONTENT_KIND);
        object.getModel().changeObjectAttribute(object, ATT_CONTENT_KIND, targetValueKind);
    }
}

