/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.handlers;

import java.util.Properties;
import org.jboss.tools.common.meta.XAdoptManager;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultRemoveHandler;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.jsf.model.JSFConstants;
import org.jboss.tools.jsf.model.JSFNavigationModel;
import org.jboss.tools.jsf.model.ReferenceGroupImpl;
import org.jboss.tools.jsf.model.ReferenceObjectImpl;
import org.jboss.tools.jsf.model.handlers.AddCaseToGroupHandler;
import org.jboss.tools.jsf.model.helpers.JSFProcessStructureHelper;
import org.jboss.tools.jst.web.model.ReferenceObject;

public class GroupAdopt
implements XAdoptManager,
JSFConstants {
    public static boolean move_case = false;

    public boolean isAdoptable(XModelObject target, XModelObject object) {
        String entity = object.getModelEntity().getName();
        if ("JSFProcessItemOutput".equals(entity)) {
            if (move_case) {
                return this.canMoveCase(target, object);
            }
            return this.canBeOutputTarget(target);
        }
        if ("JSFProcessItem".equals(entity)) {
            return this.canBeOutputTarget(target);
        }
        if ("JSFProcessGroup".equals(entity)) {
            return this.canBeOutputTarget(target);
        }
        if ("JSFNavigationRule".equals(entity) || "JSFNavigationRule20".equals(entity)) {
            return this.canBeOutputTarget(target);
        }
        if ("JSFNavigationCase".equals(entity) || "JSFNavigationCase20".equals(entity)) {
            return this.canBeOutputTarget(target);
        }
        return false;
    }

    private boolean canBeOutputTarget(XModelObject group) {
        String path = group.getAttributeValue("path");
        return path.length() != 0 && path.indexOf("*") < 0;
    }

    private boolean canMoveCase(XModelObject target, XModelObject object) {
        XModelObject case_ = null;
        case_ = object instanceof ReferenceObjectImpl ? ((ReferenceObject)object).getReference() : object;
        XModelObject rule = null;
        rule = target instanceof ReferenceGroupImpl ? ((ReferenceGroupImpl)target).getReference() : target;
        return case_ != null && rule == null || rule != case_.getParent();
    }

    public void adopt(XModelObject target, XModelObject object, Properties p) throws XModelException {
        String entity = object.getModelEntity().getName();
        if ("JSFProcessItemOutput".equals(entity)) {
            if (move_case) {
                this.moveOutput(object, target, p);
            } else {
                this.adoptOutput(object, target, p);
            }
        } else if ("JSFProcessItem".equals(entity)) {
            this.adoptItem(object, target, p);
        } else if ("JSFProcessGroup".equals(entity)) {
            this.adoptGroup(object, target, p);
        } else if ("JSFNavigationRule".equals(entity) || "JSFNavigationRule20".equals(entity)) {
            this.adoptRule(object, target, p);
        } else if ("JSFNavigationCase".equals(entity) || "JSFNavigationCase20".equals(entity)) {
            this.adoptCase(object, target, p);
        }
    }

    protected void adoptOutput(XModelObject source, XModelObject target, Properties p) throws XModelException {
        ReferenceObject i = (ReferenceObject)source;
        this.adoptCase(i.getReference(), target, p);
    }

    protected void adoptCase(XModelObject source, XModelObject target, Properties p) throws XModelException {
        source.getModel().changeObjectAttribute(source, "to-view-id", target.getAttributeValue("path"));
    }

    protected void adoptItem(XModelObject source, XModelObject target, Properties p) throws XModelException {
        ReferenceObject i = (ReferenceObject)source;
        this.adoptRule(i.getReference(), target, p);
    }

    protected void adoptRule(XModelObject source, XModelObject target, Properties p) throws XModelException {
        String path = target.getAttributeValue("path");
        String n = path;
        if (n.lastIndexOf(46) > 0) {
            n = n.substring(0, n.lastIndexOf(46));
        }
        if (n.lastIndexOf(47) >= 0) {
            n = n.substring(n.lastIndexOf(47) + 1);
        }
        String caseEntity = source.getModelEntity().getChildren()[0].getName();
        XModelObject cs = source.getModel().createModelObject(caseEntity, null);
        cs.setAttributeValue("to-view-id", path);
        cs.setAttributeValue("from-outcome", n);
        int i = 0;
        while (source.getChildByPath(cs.getPathPart()) != null) {
            cs.setAttributeValue("from-outcome", String.valueOf(n) + ++i);
        }
        DefaultCreateHandler.addCreatedObject((XModelObject)source, (XModelObject)cs, (Properties)p);
    }

    protected void adoptGroup(XModelObject source, XModelObject target, Properties p) throws XModelException {
        ReferenceGroupImpl g = (ReferenceGroupImpl)source;
        XModelObject[] os = g.getReferences();
        if (os != null && os.length > 0) {
            this.adoptRule(os[os.length - 1], target, p);
        } else {
            JSFNavigationModel nm = (JSFNavigationModel)JSFProcessStructureHelper.instance.getParentFile(target);
            String path = g.getAttributeValue("path");
            int count = nm.getRuleCount(path);
            String pp = AddCaseToGroupHandler.revalidateGroupPath(path, g.getPathPart(), count);
            XModelObject gx = g.getParent().getChildByPath(pp);
            if (gx == null || gx == g) {
                g.setAttributeValue("name", pp);
                g.setAttributeValue("persistent", "false");
            } else if (gx instanceof ReferenceGroupImpl && ((ReferenceGroupImpl)gx).getReferences().length == 0) {
                String shape = g.getAttributeValue("shape");
                g.setAttributeValue("shape", gx.getAttributeValue("shape"));
                gx.setAttributeValue("shape", shape);
                gx.setAttributeValue("persistent", "false");
            }
            this.adoptRule(nm.addRule(path), target, p);
        }
    }

    void moveOutput(XModelObject source, XModelObject target, Properties p) throws XModelException {
        ReferenceObject i = (ReferenceObject)source;
        this.moveCase(i.getReference(), target, p);
    }

    void moveCase(XModelObject source, XModelObject target, Properties p) throws XModelException {
        XModelObject rule = null;
        if (target instanceof ReferenceGroupImpl) {
            rule = ((ReferenceGroupImpl)target).getReference();
            if (rule == null) {
                JSFNavigationModel nm = (JSFNavigationModel)JSFProcessStructureHelper.instance.getParentFile(target);
                String path = target.getAttributeValue("path");
                rule = nm.addRule(path);
            }
        } else {
            rule = target;
        }
        if (rule == null || source.getParent() == rule) {
            return;
        }
        DefaultRemoveHandler.removeFromParent((XModelObject)source);
        DefaultCreateHandler.addCreatedObject((XModelObject)rule, (XModelObject)source, (Properties)p);
    }
}

