/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.handlers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.source.ISourceViewer;
import org.jboss.tools.common.meta.XAdoptManager;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.jboss.tools.jsf.model.handlers.SelectBeanSupport;
import org.jboss.tools.jsf.model.pv.JSFProjectBean;
import org.jboss.tools.jsf.web.JSFWebProject;
import org.jboss.tools.jsf.web.pattern.JSFUrlPattern;
import org.jboss.tools.jst.web.project.WebProject;
import org.jboss.tools.jst.web.tld.TaglibData;
import org.jboss.tools.jst.web.tld.VpeTaglibManager;
import org.jboss.tools.jst.web.tld.VpeTaglibManagerProvider;
import org.jboss.tools.jst.web.tld.model.TLDUtil;

public class JSPAdopt
implements XAdoptManager {
    static String PAGE_TARGET = ".FileJSP.FileHTML.FileXHTML.FacesConfig.";
    static String PAGE_ENTITY = ".FileJSP.FileXHTML.";
    static String NO_JSF_URL = "+include+jsp:include+jsp:directive.include+ui:include+ui:composition+ui:decorate+s:decorate+";
    static Map<String, String> PREFIXES = new HashMap<String, String>();

    public JSPAdopt() {
        PREFIXES.put("http://jboss.com/products/seam/taglib", "s");
        PREFIXES.put("http://java.sun.com/jsf/facelets", "ui");
    }

    public boolean isAdoptable(XModelObject target, XModelObject object) {
        if (!this.isAcceptableTarget(target)) {
            return false;
        }
        return this.isAdoptableProperty(object) || this.isAdoptablePropertyReference(object) || this.isAdoptablePage(object) || this.isAdoptableFile(object) || this.isAdoptableMapEntry(object);
    }

    public void adopt(XModelObject target, XModelObject object, Properties p) throws XModelException {
        if (this.isAdoptableProperty(object)) {
            this.adoptProperty(target, object, p);
        } else if (this.isAdoptablePropertyReference(object)) {
            this.adoptPropertyReference(target, object, p);
        } else if (this.isAdoptablePage(object)) {
            this.adoptPage(target, object, p);
        } else if (this.isAdoptableFile(object)) {
            this.adoptFile(target, object, p);
        } else if (this.isAdoptableMapEntry(object)) {
            this.adoptMapEntry(target, object, p);
        }
    }

    private boolean isAcceptableTarget(XModelObject target) {
        String entity = "." + target.getModelEntity().getName() + ".";
        return PAGE_TARGET.indexOf(entity) >= 0;
    }

    protected boolean isAdoptableProperty(XModelObject object) {
        return object.getModelEntity().getName().startsWith("JSFManagedProperty");
    }

    public void adoptProperty(XModelObject target, XModelObject object, Properties p) {
        if (p == null) {
            return;
        }
        int c = this.getPos(p);
        if (c < 0) {
            return;
        }
        String bean = object.getParent().getAttributeValue("managed-bean-name");
        String name = object.getAttributeValue("property-name");
        String start = "#{" + bean + "." + name + "}";
        p.setProperty("start text", start);
    }

    protected boolean isAdoptablePage(XModelObject object) {
        String entity = "." + object.getModelEntity().getName() + ".";
        if (PAGE_ENTITY.indexOf(entity) < 0 || !EclipseResourceUtil.hasNature((XModel)object.getModel(), (String)"org.jboss.tools.jsf.jsfnature")) {
            return false;
        }
        String path = WebProject.getInstance((XModel)object.getModel()).getPathInWebRoot(object);
        return path != null;
    }

    public void adoptPage(XModelObject target, XModelObject object, Properties p) {
        if (p == null) {
            return;
        }
        String res = WebProject.getInstance((XModel)object.getModel()).getPathInWebRoot(object);
        if (res == null) {
            return;
        }
        if (this.applyPattern(p)) {
            JSFUrlPattern pattern = JSFWebProject.getInstance(object.getModel()).getPatternLoader().getUrlPattern();
            res = pattern.getJSFUrl(res);
        }
        int pos = this.getPos(p);
        if (res.startsWith("/") && pos >= 0 && JSPAdopt.isInsideResponseRedirect(p.getProperty("text"), pos)) {
            res = res.substring(1);
        }
        p.setProperty("start text", res);
        p.setProperty("end text", "");
    }

    boolean applyPattern(Properties p) {
        if (p == null) {
            return true;
        }
        String tag = p.getProperty("context:tagName");
        if (tag == null) {
            return true;
        }
        int q = tag.indexOf(58);
        if (q >= 0) {
            String dp1;
            String dp = tag.substring(0, q);
            ISourceViewer sv = (ISourceViewer)p.get("viewer");
            String uri = JSPAdopt.getURI(sv, dp);
            if (uri != null && (dp1 = PREFIXES.get(uri)) != null && !dp1.equals(dp)) {
                tag = String.valueOf(dp1) + tag.substring(q);
            }
        }
        return NO_JSF_URL.indexOf("+" + tag + "+") < 0;
    }

    private static String getURI(ISourceViewer viewer, String prefix) {
        VpeTaglibManager tldManager = null;
        if (tldManager == null && viewer instanceof VpeTaglibManagerProvider && (tldManager = ((VpeTaglibManagerProvider)viewer).getTaglibManager()) != null) {
            List list = tldManager.getTagLibs();
            int i = 0;
            while (i < list.size()) {
                TaglibData data = (TaglibData)list.get(i);
                if (prefix.equals(data.getPrefix())) {
                    return data.getUri();
                }
                ++i;
            }
        }
        return null;
    }

    protected boolean isAdoptableFile(XModelObject object) {
        if (1 != object.getFileType()) {
            return false;
        }
        if (TLDUtil.isTaglib((XModelObject)object)) {
            return false;
        }
        IResource c = (IResource)object.getAdapter(IResource.class);
        if (c == null) {
            return false;
        }
        String webroot = WebProject.getInstance((XModel)object.getModel()).getWebRootLocation();
        if (webroot == null) {
            return false;
        }
        IPath path = c.getLocation();
        if (path == null || path.toString() == null) {
            return false;
        }
        String f = path.toString().replace('\\', '/').toLowerCase();
        webroot = webroot.replace('\\', '/').toLowerCase();
        return f.startsWith(webroot);
    }

    public void adoptFile(XModelObject target, XModelObject object, Properties p) {
        if (p == null) {
            return;
        }
        String webroot = WebProject.getInstance((XModel)object.getModel()).getWebRootLocation();
        IResource c = (IResource)object.getAdapter(IResource.class);
        String f = c.getLocation().toString().replace('\\', '/');
        String res = f.substring(webroot.length());
        p.setProperty("start text", res);
        p.setProperty("end text", "");
    }

    protected boolean isAdoptablePropertyReference(XModelObject object) {
        String entity = "." + object.getModelEntity().getName() + ".";
        return ".JSFProjectBeanProperty.JSFProjectBeanMethod.".indexOf(entity) >= 0;
    }

    public void adoptPropertyReference(XModelObject target, XModelObject object, Properties p) {
        if (p == null) {
            return;
        }
        int c = this.getPos(p);
        if (c < 0) {
            return;
        }
        String s = object.getAttributeValue("name");
        XModelObject o = object;
        while (o != null && this.isAdoptablePropertyReference(o)) {
            XModelObject[] list;
            if ((o = o.getParent()) == null) continue;
            String part = o.getAttributeValue("name");
            if (o instanceof JSFProjectBean && (list = ((JSFProjectBean)o).getBeanList()).length > 1 && (part = SelectBeanSupport.run((JSFProjectBean)o)) == null) {
                return;
            }
            s = String.valueOf(part) + "." + s;
        }
        String start = "#{" + s + "}";
        p.setProperty("start text", start);
    }

    int getPos(Properties p) {
        int c = -1;
        if (p == null) {
            return -1;
        }
        String s = p.getProperty("pos");
        if (s == null || s.trim().length() == 0) {
            return c;
        }
        try {
            c = Integer.parseInt(s.trim());
        }
        catch (NumberFormatException e) {
            JSFModelPlugin.getPluginLog().logError((Throwable)e);
        }
        return c;
    }

    public boolean isAdoptableMapEntry(XModelObject object) {
        return "JSFMapEntry".equals(object.getModelEntity().getName());
    }

    public void adoptMapEntry(XModelObject target, XModelObject object, Properties p) {
        String key = object.getAttributeValue("key");
        XModelObject g = object.getParent().getParent();
        String entity = g.getModelEntity().getName();
        String start = null;
        if ("JSFManagedBean".equals(entity) || "JSFManagedBean20".equals(entity)) {
            String bean = g.getAttributeValue("managed-bean-name");
            start = "#{" + bean + "." + key + "}";
        } else if ("JSFManagedProperty".equals(entity)) {
            XModelObject h = g.getParent();
            String bean = h.getAttributeValue("managed-bean-name");
            String property = g.getAttributeValue("property-name");
            start = "#{" + bean + "." + property + "." + key + "}";
        }
        if (start != null) {
            p.setProperty("start text", start);
        }
    }

    static boolean isInsideResponseRedirect(String text, int off) {
        if (off < 0) {
            return false;
        }
        String START = "response.sendRedirect(\"";
        String END = "\")";
        int i = 0;
        while (i < text.length() && i < off) {
            int i1 = text.indexOf(START, i);
            if (i1 < 0 || i1 + START.length() > off) {
                return false;
            }
            int i2 = text.indexOf(END, i1 + START.length());
            if (i2 < 0 || i2 >= off) {
                return true;
            }
            i = i2 + END.length();
        }
        return false;
    }
}

