/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.handlers.bean;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultRemoveHandler;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.jsf.messages.JSFUIMessages;
import org.jboss.tools.jsf.model.helpers.bean.ManagedBeanHelper;

public class DeleteManagedPropertyHandler
extends AbstractHandler {
    boolean isLight = false;

    public boolean isEnabled(XModelObject object) {
        return object != null && object.isObjectEditable();
    }

    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        boolean deleteField;
        ServiceDialog d = object.getModel().getService();
        IMember member = ManagedBeanHelper.getMember(object);
        String title = DefaultCreateHandler.title((XModelObject)object, (boolean)false);
        String message = MessageFormat.format(JSFUIMessages.DeleteManagedPropertyHandler_Delete, title);
        boolean bl = deleteField = !this.isLight && member != null;
        if (!deleteField) {
            if (d.showDialog(JSFUIMessages.DELETE, message, new String[]{JSFUIMessages.OK, JSFUIMessages.CANCEL}, null, 0) != 0) {
                return;
            }
        } else {
            p = new Properties();
            p.setProperty("message", message);
            p.setProperty("checkboxMessage", JSFUIMessages.DeleteManagedPropertyHandler_DeleteJavaProperty);
            p.put("checked", Boolean.FALSE);
            if (!d.openConfirm(p)) {
                return;
            }
            Boolean b = (Boolean)p.get("checked");
            deleteField = b != null && b != false;
        }
        DefaultRemoveHandler.removeFromParent((XModelObject)object);
        if (deleteField) {
            try {
                IMember[] ms = this.findRelevantMembers(member);
                int i = 0;
                while (i < ms.length) {
                    ms[i].delete(true, null);
                    ++i;
                }
            }
            catch (CoreException e) {
                throw new XModelException((Throwable)e);
            }
        }
    }

    private IMember[] findRelevantMembers(IMember member) throws CoreException {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(member);
        IType type = member.getDeclaringType();
        IMethod[] ms = type.getMethods();
        String n = member.getElementName();
        if (member instanceof IMethod && n.startsWith("get") && n.length() > 3) {
            n = String.valueOf(n.substring(3, 4).toLowerCase()) + n.substring(4);
        }
        String getter = "get" + n.substring(0, 1).toUpperCase() + n.substring(1);
        String setter = "set" + n.substring(0, 1).toUpperCase() + n.substring(1);
        int i = 0;
        while (i < ms.length) {
            String ni = ms[i].getElementName();
            if (ni.equals(getter) || ni.equals(setter)) {
                list.add(ms[i]);
            }
            ++i;
        }
        return list.toArray(new IMember[0]);
    }
}

