/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.handlers.refactoring;

import java.util.Properties;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.refactoring.RefactoringHelper;
import org.jboss.tools.jsf.messages.JSFUIMessages;

public class JSFPagesRefactoringChange
extends CompositeChange {
    protected String newName;
    Properties replacements;
    protected XModel model;

    public JSFPagesRefactoringChange(XModel model, String newName, Properties replacements) {
        super(JSFUIMessages.JSFPagesRefactoringChange_JSPRefactoring);
        this.model = model;
        this.newName = newName;
        this.replacements = replacements;
        this.addChanges();
    }

    public XModel getModel() {
        return this.model;
    }

    private void addChanges() {
        if (this.model == null) {
            return;
        }
        XModelObject webRoot = FileSystemsHelper.getWebRoot((XModel)this.model);
        if (webRoot == null) {
            return;
        }
        this.addChanges(webRoot.getChildren());
    }

    private void addChanges(XModelObject[] objects) {
        if (this.replacements.size() == 0) {
            return;
        }
        int i = 0;
        while (i < objects.length) {
            if (objects[i].getFileType() == 2) {
                this.addChanges(objects[i].getChildren());
            } else {
                String entity = objects[i].getModelEntity().getName();
                if ("FileJSP".equals(entity)) {
                    RefactoringHelper.addChanges((XModelObject)objects[i], (Properties)this.replacements, (CompositeChange)this);
                }
            }
            ++i;
        }
    }
}

