/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.helpers.bean;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseJavaUtil;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanHelper {
    public static Map<String, IJavaElement> getJavaProperties(IType type) throws JavaModelException {
        TreeMap<String, IJavaElement> map = new TreeMap<String, IJavaElement>();
        if (type == null || !type.exists()) {
            return map;
        }
        IField[] fs = type.getFields();
        int i = 0;
        while (i < fs.length) {
            map.put(fs[i].getElementName(), (IJavaElement)fs[i]);
            ++i;
        }
        IMethod[] ms = type.getMethods();
        int i2 = 0;
        while (i2 < ms.length) {
            String n = ms[i2].getElementName();
            if (n.startsWith("get") && n.length() >= 4 && !map.containsKey(n = BeanHelper.toPropertyName(n.substring(3)))) {
                map.put(n, (IJavaElement)ms[i2]);
            }
            ++i2;
        }
        Map<String, IJavaElement> smap = BeanHelper.getSuperTypeJavaProperties(type);
        if (smap != null) {
            map.putAll(smap);
        }
        return map;
    }

    private static String toPropertyName(String rootName) {
        return rootName.toUpperCase().equals(rootName) ? rootName : String.valueOf(rootName.substring(0, 1).toLowerCase()) + rootName.substring(1);
    }

    static Map<String, IJavaElement> getSuperTypeJavaProperties(IType type) throws JavaModelException {
        String scn = type.getSuperclassName();
        if (scn == null || scn.length() == 0 || scn.equals("java.lang.Object")) {
            return null;
        }
        String[][] rs = type.resolveType(scn);
        if (rs == null || rs.length == 0) {
            return null;
        }
        String st = rs[0][0].length() == 0 ? rs[0][1] : String.valueOf(rs[0][0]) + "." + rs[0][1];
        IJavaProject p = type.getJavaProject();
        IType stype = null;
        try {
            if (p != null) {
                stype = p.findType(st);
            }
        }
        catch (JavaModelException javaModelException) {}
        return stype == null ? null : BeanHelper.getJavaProperties(stype);
    }

    public static IJavaProject getJavaProject(XModelObject context) {
        if (context == null) {
            return null;
        }
        IResource r = EclipseResourceUtil.getResource((XModelObject)context);
        if (r == null) {
            return null;
        }
        IProject project = r.getProject();
        return EclipseResourceUtil.getJavaProject((IProject)project);
    }

    public static IMethod findGetter(IType type, String property) throws JavaModelException {
        IMethod[] ms = type.getMethods();
        int i = 0;
        while (i < ms.length) {
            String gn;
            String gn2;
            String n = ms[i].getElementName();
            if (n.startsWith("get") && n.length() > 3 && (gn2 = BeanHelper.toPropertyName(n.substring(3))).equals(property)) {
                return ms[i];
            }
            String t = EclipseJavaUtil.resolveTypeAsString((IType)type, (String)ms[i].getReturnType());
            if (n.startsWith("is") && n.length() > 2 && t != null && (t.equals("boolean") || t.equals("java.lang.Boolean")) && (gn = BeanHelper.toPropertyName(n.substring(2))).equals(property)) {
                return ms[i];
            }
            ++i;
        }
        return null;
    }

    public static IMethod findSetter(IType type, String property) throws JavaModelException {
        IMethod[] ms = type.getMethods();
        int i = 0;
        while (i < ms.length) {
            String n = ms[i].getElementName();
            if (n.startsWith("set") && n.length() >= 4 && (n = BeanHelper.toPropertyName(n.substring(3))).equals(property)) {
                return ms[i];
            }
            ++i;
        }
        return null;
    }
}

