/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.helpers.converter;

import java.util.Properties;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.jsf.messages.JSFUIMessages;
import org.jboss.tools.jsf.model.pv.JSFProjectsRoot;
import org.jboss.tools.jsf.model.pv.JSFProjectsTree;
import org.jboss.tools.jst.web.model.pv.WebProjectNode;

public class OpenRenderKitHelper {
    public String run(XModel model, String renderkitId) {
        if (model == null || renderkitId == null) {
            return null;
        }
        if (renderkitId.length() == 0) {
            return JSFUIMessages.OpenRenderKitHelper_RENDER_KIT_ID_NOT_SPECIFIED;
        }
        XModelObject c = this.findRenderKit(model, renderkitId);
        if (c == null) {
            return NLS.bind((String)JSFUIMessages.CANNOT_FIND_RENDER_KIT, (Object)renderkitId);
        }
        FindObjectHelper.findModelObject((XModelObject)c, (int)FindObjectHelper.IN_EDITOR_ONLY);
        return null;
    }

    String openClass(XModelObject c, String renderkitId) {
        String className = c.getAttributeValue("render-kit-class");
        if (className == null || className.length() == 0) {
            return NLS.bind((String)JSFUIMessages.ATTRIBUTE_RENDER_KIT_CLASS_FOR_RENDER_KIT_ISNOT_SPECIFIED, (Object)renderkitId);
        }
        XAction xaction = XActionInvoker.getAction((String)"OpenSource", (XModelObject)c);
        if (xaction != null && xaction.isEnabled(c)) {
            Properties p = new Properties();
            p.setProperty("ignoreWarning", "true");
            XActionInvoker.invoke((String)"OpenSource", (XModelObject)c, (Properties)p);
            return p.getProperty("error");
        }
        return null;
    }

    public XModelObject findRenderKit(XModel model, String renderkitId) {
        JSFProjectsRoot root = JSFProjectsTree.getProjectsRoot(model);
        if (root == null) {
            return null;
        }
        WebProjectNode n = (WebProjectNode)root.getChildByPath("Configuration");
        if (n == null) {
            return null;
        }
        XModelObject[] os = n.getTreeChildren();
        int i = 0;
        while (i < os.length) {
            XModelObject r = os[i].getChildByPath("Render Kits/" + renderkitId);
            if (r != null) {
                return r;
            }
            ++i;
        }
        return null;
    }
}

